/*
 * Decompiled with CFR 0.152.
 */
package cn.unitid.easypki.security;

import cn.unitid.easypki.security.sm3.SM3Digest;
import java.security.InvalidAlgorithmParameterException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Provider;
import java.security.Security;
import org.bouncycastle.jce.interfaces.ECPublicKey;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.math.ec.ECPoint;

public abstract class EPMessageDigest {
    private static String algoIdentifier;

    public static EPMessageDigest getInstance(String algorithmIdentifier) throws NoSuchAlgorithmException {
        int type;
        if (algorithmIdentifier == null) {
            throw new NullPointerException();
        }
        if (algorithmIdentifier.equals("1.3.14.3.2.26")) {
            type = 0;
        } else if (algorithmIdentifier.equals("1.2.840.113549.2.5")) {
            type = 1;
        } else if (algorithmIdentifier.equals("2.16.840.1.101.3.4.2.1")) {
            type = 2;
        } else if (algorithmIdentifier.equals("2.16.840.1.101.3.4.2.2")) {
            type = 3;
        } else if (algorithmIdentifier.equals("2.16.840.1.101.3.4.2.3")) {
            type = 4;
        } else if (algorithmIdentifier.equals("1.2.156.10197.1.401")) {
            type = 10;
        } else {
            throw new NoSuchAlgorithmException("algorithm " + algorithmIdentifier + " not supported");
        }
        algoIdentifier = algorithmIdentifier;
        return new MessageDigestImpl(type);
    }

    public void initPublicKey(ECPublicKey publicKey) throws InvalidAlgorithmParameterException {
        this.initPublicKey(publicKey.getQ());
    }

    public void initPublicKey(ECPoint userPublicKey) throws InvalidAlgorithmParameterException {
        if (!algoIdentifier.equals("1.2.156.10197.1.401")) {
            throw new InvalidAlgorithmParameterException("Wrong algorithm! this method only for sm3 hash");
        }
        this.engineInitUserID(userPublicKey);
    }

    public void initUserID(ECPoint userPublicKey, byte[] userID) throws InvalidAlgorithmParameterException {
        if (!algoIdentifier.equals("1.2.156.10197.1.401")) {
            throw new InvalidAlgorithmParameterException("Wrong algorithm! this method only for sm3 hash");
        }
        this.engineInitUserID(userPublicKey, userID);
    }

    public void update(byte[] input) {
        this.engineUpdate(input);
    }

    public byte[] digest() {
        return this.engineDigest();
    }

    public byte[] digest(byte[] input) {
        return this.engineDigest(input);
    }

    public void reset() {
        this.engineReset();
    }

    public String getAlgorithmIdentifier() {
        return algoIdentifier;
    }

    public String toString() {
        return "MESSAGE DIGEST " + algoIdentifier;
    }

    public abstract void engineUpdate(byte[] var1);

    public abstract void engineInitUserID(ECPoint var1);

    public abstract void engineInitUserID(ECPoint var1, byte[] var2);

    public abstract byte[] engineDigest();

    public abstract byte[] engineDigest(byte[] var1);

    public abstract void engineReset();

    private static class MessageDigestImpl
    extends EPMessageDigest {
        private final int SHA1 = 0;
        private final int MD5 = 1;
        private final int SHA256 = 2;
        private final int SHA384 = 3;
        private final int SHA512 = 4;
        private final int SM3 = 10;
        private MessageDigest rsaMessageDigest;
        private SM3Digest sm3MessageDigest;
        private int hashType;

        public MessageDigestImpl(int type) throws NoSuchAlgorithmException {
            Provider provider = Security.getProvider("BC");
            if (provider == null) {
                Security.addProvider(new BouncyCastleProvider());
            }
            this.hashType = type;
            try {
                switch (this.hashType) {
                    case 0: 
                    case 1: 
                    case 2: 
                    case 3: 
                    case 4: {
                        this.rsaMessageDigest = MessageDigest.getInstance(algoIdentifier, "BC");
                        break;
                    }
                    case 10: {
                        this.sm3MessageDigest = new SM3Digest();
                        break;
                    }
                    default: {
                        this.rsaMessageDigest = MessageDigest.getInstance("SHA1", "BC");
                        break;
                    }
                }
            }
            catch (NoSuchProviderException e) {
                e.printStackTrace();
            }
        }

        @Override
        public void engineUpdate(byte[] input) {
            if (this.hashType == 10) {
                this.sm3MessageDigest.update(input, 0, input.length);
            } else {
                this.rsaMessageDigest.update(input);
            }
        }

        @Override
        public void engineInitUserID(ECPoint userPublicKey) {
            this.sm3MessageDigest.addId(userPublicKey.getAffineXCoord().toBigInteger(), userPublicKey.getAffineYCoord().toBigInteger());
        }

        @Override
        public void engineInitUserID(ECPoint userPublicKey, byte[] userID) {
            this.sm3MessageDigest.addId(userPublicKey.getAffineXCoord().toBigInteger(), userPublicKey.getAffineYCoord().toBigInteger(), userID);
        }

        @Override
        public byte[] engineDigest() {
            if (this.hashType == 10) {
                byte[] md = new byte[32];
                this.sm3MessageDigest.doFinal(md, 0);
                return md;
            }
            return this.rsaMessageDigest.digest();
        }

        @Override
        public byte[] engineDigest(byte[] input) {
            if (this.hashType == 10) {
                byte[] md = new byte[32];
                this.sm3MessageDigest.update(input, 0, input.length);
                this.sm3MessageDigest.doFinal(md, 0);
                return md;
            }
            return this.rsaMessageDigest.digest(input);
        }

        @Override
        public void engineReset() {
            if (this.hashType == 10) {
                this.sm3MessageDigest.reset();
            } else {
                this.rsaMessageDigest.reset();
            }
        }
    }
}

