/*
 * Decompiled with CFR 0.152.
 */
package cn.unitid.easypki.pkcs7.envelope;

import cn.unitid.easypki.crypto.CipherException;
import cn.unitid.easypki.crypto.SM4SymmetricCipher;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class SM4CipherOutputStream
extends FilterOutputStream {
    private SM4SymmetricCipher sm4SymmetricCipher;
    private final byte[] oneByte = new byte[1];

    public SM4CipherOutputStream(OutputStream outputStream, SM4SymmetricCipher sm4SymmetricCipher) {
        super(outputStream);
        this.sm4SymmetricCipher = sm4SymmetricCipher;
    }

    @Override
    public void write(int b) throws IOException {
        this.oneByte[0] = (byte)b;
        this.write(this.oneByte, 0, 1);
    }

    @Override
    public void write(byte[] b) throws IOException {
        this.write(b, 0, b.length);
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        byte[] buff = new byte[len];
        System.arraycopy(b, off, buff, 0, len);
        this.sm4SymmetricCipher.update(b);
    }

    @Override
    public void flush() throws IOException {
        this.out.flush();
    }

    @Override
    public void close() throws IOException {
        IOException error;
        block6: {
            error = null;
            try {
                byte[] bytes = this.sm4SymmetricCipher.doFinal();
                if (bytes != null) {
                    this.out.write(bytes, 0, bytes.length);
                }
            }
            catch (CipherException e) {
                error = new IOException("Error closing stream: " + e);
            }
            try {
                this.flush();
                this.out.close();
            }
            catch (IOException e) {
                if (error != null) break block6;
                error = e;
            }
        }
        if (error != null) {
            throw error;
        }
    }
}

