/*
 * Decompiled with CFR 0.152.
 */
package cn.unitid.easypki.pkcs7.envelope;

import cn.unitid.easypki.pkcs7.envelope.EnvelopedDataUtil;
import java.io.IOException;
import java.io.OutputStream;
import java.security.AlgorithmParameters;
import java.security.GeneralSecurityException;
import java.security.Key;
import java.security.SecureRandom;
import javax.crypto.Cipher;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.DERNull;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.cms.CMSException;
import org.bouncycastle.jcajce.io.CipherOutputStream;
import org.bouncycastle.jcajce.util.AlgorithmParametersUtils;
import org.bouncycastle.operator.GenericKey;
import org.bouncycastle.operator.OutputEncryptor;
import org.bouncycastle.operator.jcajce.JceGenericKey;

public class EPCMSOutputEncryptor
implements OutputEncryptor {
    private Cipher cipher = null;
    private SecretKey encKey = null;
    private AlgorithmIdentifier algorithmIdentifier;

    public EPCMSOutputEncryptor(ASN1ObjectIdentifier encryptionOID, int keySize, SecureRandom random) throws CMSException {
        KeyGenerator keyGenerator = EnvelopedDataUtil.createKeyGenerator(encryptionOID);
        if (random == null) {
            random = new SecureRandom();
        }
        if (keySize < 0) {
            keyGenerator.init(random);
        } else {
            keyGenerator.init(keySize, random);
        }
        this.cipher = EnvelopedDataUtil.createCipher(encryptionOID);
        this.encKey = keyGenerator.generateKey();
        AlgorithmParameters params = EnvelopedDataUtil.generateParameters(encryptionOID, this.encKey, random);
        try {
            this.cipher.init(1, (Key)this.encKey, params, random);
        }
        catch (GeneralSecurityException e) {
            throw new CMSException("unable to initialize cipher:" + e.getMessage());
        }
        if (params == null) {
            params = this.cipher.getParameters();
        }
        try {
            this.algorithmIdentifier = params == null ? new AlgorithmIdentifier(encryptionOID, DERNull.INSTANCE) : new AlgorithmIdentifier(encryptionOID, AlgorithmParametersUtils.extractParameters(params));
        }
        catch (IOException e) {
            throw new CMSException(e.getMessage());
        }
    }

    @Override
    public AlgorithmIdentifier getAlgorithmIdentifier() {
        return this.algorithmIdentifier;
    }

    @Override
    public OutputStream getOutputStream(OutputStream outputStream) {
        return new CipherOutputStream(outputStream, this.cipher);
    }

    @Override
    public GenericKey getKey() {
        return new JceGenericKey(this.algorithmIdentifier, this.encKey);
    }
}

