/*
 * Decompiled with CFR 0.152.
 */
package cn.unitid.easypki.pkcs7;

import cn.unitid.easypki.cms.SignerInformation;
import cn.unitid.easypki.pkcs7.AuthenticatedAttributesBuilder;
import cn.unitid.easypki.security.SM2Signature;
import cn.unitid.easypki.util.CertificateConverter;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.security.PrivateKey;
import java.security.SignatureException;
import java.security.cert.CertificateEncodingException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.ASN1OutputStream;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.ASN1Set;
import org.bouncycastle.asn1.BERSet;
import org.bouncycastle.asn1.DERNull;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.DERSet;
import org.bouncycastle.asn1.cms.Attribute;
import org.bouncycastle.asn1.cms.AttributeTable;
import org.bouncycastle.asn1.cms.ContentInfo;
import org.bouncycastle.asn1.cms.IssuerAndSerialNumber;
import org.bouncycastle.asn1.cms.SignedData;
import org.bouncycastle.asn1.cms.SignerIdentifier;
import org.bouncycastle.asn1.cms.SignerInfo;
import org.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.cert.X509CertificateHolder;
import org.bouncycastle.cert.jcajce.JcaX509CertificateHolder;
import org.bouncycastle.cms.CMSException;
import org.bouncycastle.cms.CMSProcessable;
import org.bouncycastle.cms.CMSProcessableByteArray;
import org.bouncycastle.cms.CMSSignedData;
import org.bouncycastle.cms.CMSTypedData;
import org.bouncycastle.cms.SignerInformationStore;
import org.bouncycastle.jcajce.provider.asymmetric.ec.BCECPrivateKey;
import org.bouncycastle.jce.interfaces.ECPublicKey;
import org.bouncycastle.operator.ContentSigner;
import org.bouncycastle.util.Store;
import org.bouncycastle.util.encoders.Base64;

public class SM2Q7Signature {
    private X509Certificate signCert;
    private PrivateKey privateKey;
    private byte[] tobeSignedData;
    private List<X509Certificate> certChain = new ArrayList<X509Certificate>();
    private boolean useQ7Mode = true;

    public SM2Q7Signature() {
    }

    public SM2Q7Signature(boolean useQ7Mode) {
        this();
        this.useQ7Mode = useQ7Mode;
    }

    public void initSign(PrivateKey privateKey) {
        this.privateKey = privateKey;
    }

    public void addSigner(X509Certificate signCert) {
        if (signCert != null) {
            if ("RSA".equals(signCert.getPublicKey().getAlgorithm())) {
                throw new IllegalArgumentException("\u4e0d\u652f\u6301RSA\u7b97\u6cd5\u8bc1\u4e66");
            }
        } else {
            throw new NullPointerException("signCert must not be null.");
        }
        this.signCert = signCert;
        this.certChain.add(this.signCert);
    }

    public void addCertificates(List<X509Certificate> certList) {
        if (null != certList) {
            this.certChain.addAll(certList);
        }
    }

    public void update(byte[] data) {
        this.tobeSignedData = data;
    }

    public byte[] sign() throws SignatureException {
        return this.sign(true);
    }

    public byte[] sign(boolean attach) throws SignatureException {
        if (this.signCert == null || this.privateKey == null) {
            throw new NullPointerException("signer cert or private key is null");
        }
        byte[] signedData = null;
        try {
            SignerInfo signerInfo = this.buildSignerInfo();
            CMSSignedData cmsSignedData = this.buildCMSSignedData(signerInfo, attach);
            signedData = cmsSignedData.getEncoded();
        }
        catch (Exception e) {
            throw new SignatureException("sign pkcs7 failed. cause: " + e.getMessage(), e);
        }
        return signedData;
    }

    public CMSSignedData pkcs7Sign() throws SignatureException, CertificateEncodingException {
        SignerInfo signerInfo = this.buildSignerInfo();
        return this.buildCMSSignedData(signerInfo, true);
    }

    public CMSSignedData pkcs7Sign(boolean attach) throws SignatureException {
        CMSSignedData cmsSignedData;
        try {
            cmsSignedData = new CMSSignedData(this.sign(attach));
        }
        catch (CMSException e) {
            throw new SignatureException(e);
        }
        return cmsSignedData;
    }

    public CMSSignedData pkcs7Sign(ContentSigner contentSigner, boolean attach) throws SignatureException, CertificateEncodingException {
        SignerInfo signerInfo = null;
        OutputStream outputStream = null;
        ASN1OutputStream derOutputStream = null;
        try {
            SignerIdentifier sid = new SignerIdentifier(new IssuerAndSerialNumber(new JcaX509CertificateHolder(this.signCert).toASN1Structure()));
            AlgorithmIdentifier digAlgorithm = new AlgorithmIdentifier(new ASN1ObjectIdentifier("1.2.156.10197.1.401"), DERNull.INSTANCE);
            DERSet authenticatedAttributes = new DERSet(AuthenticatedAttributesBuilder.buildAuthenticatedAttributes(this.tobeSignedData, digAlgorithm));
            AlgorithmIdentifier digEncryptionAlgorithm = new AlgorithmIdentifier(new ASN1ObjectIdentifier("1.2.156.10197.1.301.1"), DERNull.INSTANCE);
            outputStream = contentSigner.getOutputStream();
            derOutputStream = ASN1OutputStream.create(outputStream);
            derOutputStream.writeObject(authenticatedAttributes);
            byte[] signature = contentSigner.getSignature();
            DEROctetString encryptedDigest = new DEROctetString(signature);
            ASN1Set unauthenticatedAttributes = null;
            signerInfo = new SignerInfo(sid, digAlgorithm, authenticatedAttributes, digEncryptionAlgorithm, (ASN1OctetString)encryptedDigest, unauthenticatedAttributes);
        }
        catch (Exception e) {
            throw new SignatureException("failed to build signer info", e);
        }
        finally {
            try {
                if (outputStream != null) {
                    outputStream.close();
                }
                if (derOutputStream != null) {
                    derOutputStream.close();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return this.buildCMSSignedData(signerInfo, attach);
    }

    public CMSSignedData buildCMSSignedData(SignerInfo signerInfo) throws SignatureException, CertificateEncodingException {
        return this.buildCMSSignedData(signerInfo, true);
    }

    public CMSSignedData buildCMSSignedData(SignerInfo signerInfo, boolean attach) throws SignatureException, CertificateEncodingException {
        return this.buildCMSSignedData(attach ? this.tobeSignedData : null, signerInfo, this.certChain);
    }

    public CMSSignedData buildCMSSignedData(byte[] data, SignerInfo signerInfo, List<X509Certificate> certList) throws SignatureException, CertificateEncodingException {
        CMSSignedData cmsSignedData = null;
        ASN1EncodableVector digestAlgos = new ASN1EncodableVector();
        ASN1EncodableVector signerInfos = new ASN1EncodableVector();
        DEROctetString octs = data == null ? null : new DEROctetString(data);
        ASN1ObjectIdentifier dataType = this.buildDataType();
        ContentInfo encInfo = new ContentInfo(dataType, octs);
        digestAlgos.add(signerInfo.getDigestAlgorithm());
        signerInfos.add(signerInfo);
        BERSet certificates = null;
        ASN1Set certCRLs = null;
        if (certList.size() != 0) {
            ASN1EncodableVector v = new ASN1EncodableVector();
            try {
                Iterator<X509Certificate> it = certList.iterator();
                while (it.hasNext()) {
                    v.add(ASN1Sequence.fromByteArray(it.next().getEncoded()));
                }
                certificates = new BERSet(v);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        SignedData sd = new SignedData(new DERSet(digestAlgos), encInfo, certificates, certCRLs, new DERSet(signerInfos));
        ASN1ObjectIdentifier contentType = this.buildContentType();
        ContentInfo contentInfo = new ContentInfo(contentType, sd);
        try {
            CMSProcessableByteArray content = new CMSProcessableByteArray(data);
            cmsSignedData = new CMSSignedData((CMSProcessable)content, contentInfo);
        }
        catch (CMSException e) {
            throw new SignatureException("pkcs7 sign failed", e);
        }
        return cmsSignedData;
    }

    private ASN1ObjectIdentifier buildContentType() {
        return this.useQ7Mode ? new ASN1ObjectIdentifier("1.2.156.10197.6.1.4.2.2") : new ASN1ObjectIdentifier("1.2.840.113549.1.7.2");
    }

    private ASN1ObjectIdentifier buildDataType() {
        return this.useQ7Mode ? new ASN1ObjectIdentifier("1.2.156.10197.6.1.4.2.1") : new ASN1ObjectIdentifier("1.2.840.113549.1.7.1");
    }

    private SignerInfo buildSignerInfo() throws SignatureException {
        SignerInfo signerInfo = null;
        try {
            SignerIdentifier sid = new SignerIdentifier(new IssuerAndSerialNumber(new JcaX509CertificateHolder(this.signCert).toASN1Structure()));
            AlgorithmIdentifier digAlgorithm = new AlgorithmIdentifier(new ASN1ObjectIdentifier("1.2.156.10197.1.401"), DERNull.INSTANCE);
            DERSet authenticatedAttributes = new DERSet(AuthenticatedAttributesBuilder.buildAuthenticatedAttributes(this.tobeSignedData, digAlgorithm));
            AlgorithmIdentifier digEncryptionAlgorithm = new AlgorithmIdentifier(new ASN1ObjectIdentifier("1.2.156.10197.1.301.1"), DERNull.INSTANCE);
            byte[] signature = null;
            SM2Signature sm2Signature = new SM2Signature();
            sm2Signature.initSign((BCECPrivateKey)this.privateKey, (ECPublicKey)this.signCert.getPublicKey());
            sm2Signature.update(authenticatedAttributes.getEncoded());
            signature = sm2Signature.sign();
            DEROctetString encryptedDigest = new DEROctetString(signature);
            ASN1Set unauthenticatedAttributes = null;
            signerInfo = new SignerInfo(sid, digAlgorithm, authenticatedAttributes, digEncryptionAlgorithm, (ASN1OctetString)encryptedDigest, unauthenticatedAttributes);
        }
        catch (Exception e) {
            throw new SignatureException("failed to build signer info", e);
        }
        return signerInfo;
    }

    public boolean verify(String pkcs7Data) throws SignatureException {
        return this.verify(pkcs7Data, true);
    }

    public boolean verify(String pkcs7Data, boolean attach) throws SignatureException {
        boolean verResult;
        ByteArrayOutputStream byteStream = null;
        try {
            byteStream = new ByteArrayOutputStream();
            if (!attach && this.tobeSignedData == null) {
                throw new SignatureException("\u975eAttach\u6a21\u5f0f\u4e0b,\u5fc5\u987b\u5148update\u5f85\u9a8c\u8bc1\u6570\u636e");
            }
            CMSSignedData sd = new CMSSignedData(Base64.decode(pkcs7Data));
            String contentTypeOID = sd.getSignedContentTypeOID();
            CMSSignedData signedData = null;
            signedData = attach ? new CMSSignedData(Base64.decode(pkcs7Data)) : new CMSSignedData((CMSProcessable)new CMSProcessableByteArray(new ASN1ObjectIdentifier("1.2.156.10197.6.1.4.2.1"), this.tobeSignedData), Base64.decode(pkcs7Data));
            CMSTypedData signedContent = signedData.getSignedContent();
            if (attach) {
                if (signedContent == null) {
                    throw new IOException("PKCS7\u7b7e\u540d\u4e2d\u6ca1\u6709\u5305\u542b\u7b7e\u540d\u6570\u636e");
                }
                signedContent.write(byteStream);
                this.tobeSignedData = byteStream.toByteArray();
            }
            Store<X509CertificateHolder> certStore = signedData.getCertificates();
            SignerInformationStore signers = signedData.getSignerInfos();
            Collection<org.bouncycastle.cms.SignerInformation> collection = signers.getSigners();
            Iterator<org.bouncycastle.cms.SignerInformation> iterator = collection.iterator();
            int verified = 0;
            while (iterator.hasNext()) {
                SignerInformation signer = SignerInformation.getInstance(iterator.next(), signedContent);
                Collection<X509CertificateHolder> certCollection = certStore.getMatches(signer.getSID());
                Iterator<X509CertificateHolder> it = certCollection.iterator();
                X509CertificateHolder cert = it.next();
                this.signCert = CertificateConverter.fromBinary(cert.toASN1Structure().getEncoded());
                byte[] signature = signer.getSignature();
                AttributeTable signedAttributes = signer.getSignedAttributes();
                byte[] signedAttributesContent = null;
                if (signedAttributes != null) {
                    signedAttributesContent = signer.getEncodedSignedAttributes();
                    Attribute messageDigestAttr = signedAttributes.get(PKCSObjectIdentifiers.pkcs_9_at_messageDigest);
                    DEROctetString messageDigestOct = (DEROctetString)messageDigestAttr.getAttrValues().getObjectAt(0);
                    byte[] messageDigest = messageDigestOct.getOctets();
                    byte[] calculatedMessageDigest = null;
                    if (!"1.2.156.10197.1.401".equals(signer.getDigestAlgorithmID().getAlgorithm().getId())) {
                        throw new SignatureException("invalid digest algorithm:" + signer.getDigestAlgorithmID().getAlgorithm().getId() + " in SM2 Q7");
                    }
                    calculatedMessageDigest = AuthenticatedAttributesBuilder.makeSM3DigestWithoutPublicKey((byte[])signedContent.getContent());
                    if (!Arrays.equals(messageDigest, calculatedMessageDigest)) {
                        boolean bl = false;
                        return bl;
                    }
                } else {
                    signedAttributesContent = this.tobeSignedData;
                }
                SM2Signature sm2Signature = new SM2Signature();
                sm2Signature.initVerify(this.signCert);
                sm2Signature.update(signedAttributesContent);
                if (!sm2Signature.verify(signature)) continue;
                ++verified;
            }
            verResult = verified == collection.size();
        }
        catch (Exception e) {
            throw new SignatureException("\u9a8c\u8bc1PKCS7\u7b7e\u540d\u5f02\u5e38. cause: " + e.getMessage(), e);
        }
        finally {
            try {
                if (byteStream != null) {
                    byteStream.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return verResult;
    }

    public X509Certificate getSignerCert() {
        return this.signCert;
    }

    public byte[] getPrimaryContent() {
        return this.tobeSignedData;
    }
}

