/*
 * Decompiled with CFR 0.152.
 */
package cn.unitid.easypki.pkcs12;

import cn.unitid.easypki.crypto.ECKeyGenerator;
import cn.unitid.easypki.provider.asymmetric.sm2.SM2BCPublicKey;
import cn.unitid.easypki.security.ec.ECDomainParametersHelper;
import cn.unitid.easypki.util.CertificateConverter;
import cn.unitid.easypki.x509.SM2X509Certificate;
import java.io.IOException;
import java.security.InvalidKeyException;
import java.security.KeyStoreException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.security.interfaces.ECPrivateKey;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.DERIA5String;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.DLTaggedObject;
import org.bouncycastle.asn1.pkcs.CertBag;
import org.bouncycastle.asn1.pkcs.ContentInfo;
import org.bouncycastle.asn1.pkcs.EncryptedPrivateKeyInfo;
import org.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import org.bouncycastle.asn1.pkcs.Pfx;
import org.bouncycastle.asn1.pkcs.PrivateKeyInfo;
import org.bouncycastle.asn1.pkcs.SafeBag;
import org.bouncycastle.cert.X509CertificateHolder;
import org.bouncycastle.jcajce.provider.asymmetric.ec.BCECPrivateKey;
import org.bouncycastle.math.ec.ECPoint;
import org.bouncycastle.operator.InputDecryptorProvider;
import org.bouncycastle.operator.bc.BcDefaultDigestProvider;
import org.bouncycastle.pkcs.PKCS12PfxPdu;
import org.bouncycastle.pkcs.PKCS12SafeBag;
import org.bouncycastle.pkcs.PKCS12SafeBagFactory;
import org.bouncycastle.pkcs.PKCS8EncryptedPrivateKeyInfo;
import org.bouncycastle.pkcs.PKCSException;
import org.bouncycastle.pkcs.bc.BcPKCS12MacCalculatorBuilderProvider;
import org.bouncycastle.pkcs.bc.BcPKCS12PBEInputDecryptorProviderBuilder;
import org.bouncycastle.util.encoders.Base64;

public class SM2KeyStore {
    private List<X509Certificate> certificateList;
    private ECPrivateKey privateKey;
    private ECPoint ecPointQ;
    private Map<ECPoint, X509Certificate> certificateMap = new HashMap<ECPoint, X509Certificate>();

    public SM2KeyStore() {
        this.certificateList = new ArrayList<X509Certificate>();
    }

    public void loadKeyStore(byte[] pfxBinary, char[] password) throws KeyStoreException {
        Pfx pfx = Pfx.getInstance(pfxBinary);
        PKCS12PfxPdu pdu = new PKCS12PfxPdu(pfx);
        BcPKCS12MacCalculatorBuilderProvider macCalcProviderBuilder = new BcPKCS12MacCalculatorBuilderProvider(BcDefaultDigestProvider.INSTANCE);
        try {
            if (!pdu.isMacValid(macCalcProviderBuilder, password)) {
                throw new Exception("invalid password!");
            }
            ContentInfo[] contentInfos = pdu.getContentInfos();
            BcPKCS12PBEInputDecryptorProviderBuilder idpBuilder = new BcPKCS12PBEInputDecryptorProviderBuilder();
            InputDecryptorProvider inputDecryptorProvider = idpBuilder.build(password);
            for (ContentInfo contentInfo : contentInfos) {
                ASN1ObjectIdentifier oid = contentInfo.getContentType();
                if (oid.equals(PKCSObjectIdentifiers.encryptedData)) {
                    this.parseCertificate(contentInfo, inputDecryptorProvider);
                    continue;
                }
                if (oid.equals(PKCSObjectIdentifiers.data)) {
                    this.privateKey = this.parsePrivateKey(contentInfo, inputDecryptorProvider);
                    continue;
                }
                System.out.println("unknown oid type: " + oid.getId());
            }
        }
        catch (Exception e) {
            throw new KeyStoreException("fail to load key store, cause:" + e.getMessage());
        }
    }

    public List<X509Certificate> getCertificateList() {
        return this.certificateList;
    }

    public ECPrivateKey getPrivateKey() {
        return this.privateKey;
    }

    public X509Certificate getX509Certificate() {
        return this.certificateMap.get(this.ecPointQ);
    }

    private void parseCertificate(ContentInfo contentInfo, InputDecryptorProvider inputDecryptorProvider) throws PKCSException, IOException, CertificateException {
        PKCS12SafeBag[] safeBags;
        X509Certificate x509Certificate = null;
        PKCS12SafeBagFactory factory = new PKCS12SafeBagFactory(contentInfo, inputDecryptorProvider);
        for (PKCS12SafeBag sfb : safeBags = factory.getSafeBags()) {
            if (!sfb.getType().equals(PKCSObjectIdentifiers.certBag)) continue;
            X509CertificateHolder certificateHolder = (X509CertificateHolder)sfb.getBagValue();
            x509Certificate = CertificateConverter.fromBinary(certificateHolder.getEncoded());
            SM2X509Certificate sm2X509Certificate = (SM2X509Certificate)x509Certificate;
            this.certificateMap.put(((SM2BCPublicKey)sm2X509Certificate.getPublicKey()).getQ(), x509Certificate);
            this.certificateList.add(x509Certificate);
        }
    }

    private ECPrivateKey parsePrivateKey(ContentInfo contentInfo, InputDecryptorProvider inputDecryptorProvider) throws PKCSException, IOException, InvalidKeyException, CertificateException {
        BCECPrivateKey privateKey = null;
        ASN1Sequence sequence = ASN1Sequence.getInstance(((ASN1OctetString)contentInfo.getContent()).getOctets());
        int size = sequence.size();
        for (int i = 0; i < size; ++i) {
            ASN1Sequence seq = ASN1Sequence.getInstance(sequence.getObjectAt(i));
            ASN1ObjectIdentifier identifier = ASN1ObjectIdentifier.getInstance(seq.getObjectAt(0));
            if (identifier.getId().equals("1.2.840.113549.1.12.10.1.1")) {
                throw new PKCSException("\u6682\u4e0d\u652f\u6301\u8be5SafeBag Type\uff1a" + identifier.getId());
            }
            if (identifier.getId().equals("1.2.840.113549.1.12.10.1.2")) {
                SafeBag sb = SafeBag.getInstance(seq);
                EncryptedPrivateKeyInfo encInfo = EncryptedPrivateKeyInfo.getInstance(sb.getBagValue());
                PKCS8EncryptedPrivateKeyInfo pkcs8EncryptedPrivateKeyInfo = new PKCS8EncryptedPrivateKeyInfo(encInfo);
                PrivateKeyInfo privateKeyInfo = pkcs8EncryptedPrivateKeyInfo.decryptPrivateKeyInfo(inputDecryptorProvider);
                privateKey = ECKeyGenerator.generate(ASN1Sequence.getInstance(privateKeyInfo.getEncoded()));
                this.ecPointQ = ECDomainParametersHelper.getECPointG().multiply(privateKey.getD());
                continue;
            }
            if (identifier.getId().equals("1.2.840.113549.1.12.10.1.3")) {
                ASN1Primitive cvString;
                DLTaggedObject taggedObject;
                String b64Certificate = null;
                CertBag certBag = CertBag.getInstance(seq);
                ASN1Sequence cvSeq = ASN1Sequence.getInstance(certBag.getCertValue());
                ASN1ObjectIdentifier certType = ASN1ObjectIdentifier.getInstance(cvSeq.getObjectAt(0));
                if (certType.getId().equals("1.2.840.113549.1.9.22.1")) {
                    taggedObject = (DLTaggedObject)DLTaggedObject.getInstance(cvSeq.getObjectAt(1));
                    cvString = (DEROctetString)DEROctetString.getInstance(taggedObject.getObject());
                    b64Certificate = Base64.toBase64String(((ASN1OctetString)cvString).getOctets());
                } else if (certType.getId().equals("1.2.840.113549.1.9.22.2")) {
                    taggedObject = (DLTaggedObject)DLTaggedObject.getInstance(cvSeq.getObjectAt(1));
                    cvString = DERIA5String.getInstance(taggedObject.getObject());
                    b64Certificate = ((DERIA5String)cvString).getString();
                } else {
                    throw new PKCSException("\u89e3\u6790\u8bc1\u4e66\u5931\u8d25\uff0c\u672a\u77e5\u7684\u8bc1\u4e66OID\uff1a" + certType);
                }
                X509Certificate x509Certificate = CertificateConverter.fromBinary(Base64.decode(b64Certificate));
                SM2X509Certificate sm2X509Certificate = (SM2X509Certificate)CertificateConverter.fromBinary(Base64.decode(b64Certificate));
                this.certificateMap.put(((SM2BCPublicKey)sm2X509Certificate.getPublicKey()).getQ(), x509Certificate);
                this.certificateList.add(x509Certificate);
                continue;
            }
            throw new PKCSException("\u6682\u4e0d\u652f\u6301\u8be5SafeBag Type\uff1a" + identifier.getId());
        }
        return privateKey;
    }
}

