/*
 * Decompiled with CFR 0.152.
 */
package cn.unitid.easypki.pkcs10;

import cn.unitid.easypki.provider.asymmetric.sm2.SM2BCPublicKey;
import cn.unitid.easypki.provider.identifier.EPAlgorithmIdentifier;
import cn.unitid.easypki.security.SM2Signature;
import java.io.OutputStream;
import java.security.InvalidKeyException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.Signature;
import java.security.SignatureException;
import java.util.List;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.ASN1Set;
import org.bouncycastle.asn1.DERBitString;
import org.bouncycastle.asn1.DERNull;
import org.bouncycastle.asn1.DERSet;
import org.bouncycastle.asn1.pkcs.Attribute;
import org.bouncycastle.asn1.pkcs.CertificationRequest;
import org.bouncycastle.asn1.pkcs.CertificationRequestInfo;
import org.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.asn1.x509.Extension;
import org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import org.bouncycastle.jcajce.provider.asymmetric.ec.BCECPublicKey;
import org.bouncycastle.jce.interfaces.ECPrivateKey;
import org.bouncycastle.jce.interfaces.ECPublicKey;
import org.bouncycastle.operator.ContentSigner;
import org.bouncycastle.pkcs.PKCS10CertificationRequest;

public class PKCS10CertificateRequestBuilder {
    public static CertificationRequestInfo buildCertificationRequestInfo(X500Name x500Name, BCECPublicKey publicKey) {
        SM2BCPublicKey sm2BCPublicKey = new SM2BCPublicKey(publicKey.getQ());
        byte[] xx = sm2BCPublicKey.getEncoded();
        SubjectPublicKeyInfo publicKeyInfo = new SubjectPublicKeyInfo(EPAlgorithmIdentifier.SM2_PUBLIC_KEY_ALGORITHM, sm2BCPublicKey.getEncoded());
        return new CertificationRequestInfo(x500Name, publicKeyInfo, null);
    }

    public static PKCS10CertificationRequest buildPKCS10CertificationRequest(X500Name x500Name, BCECPublicKey publicKey, ECPrivateKey privateKey) throws SignatureException, InvalidKeyException {
        CertificationRequestInfo requestInfo = PKCS10CertificateRequestBuilder.buildCertificationRequestInfo(x500Name, publicKey);
        return new PKCS10CertificationRequest(PKCS10CertificateRequestBuilder.buildCertificationRequest(requestInfo, publicKey, privateKey));
    }

    public static CertificationRequest buildCertificationRequest(CertificationRequestInfo requestInfo, ECPublicKey publicKey, ECPrivateKey privateKey) throws InvalidKeyException, SignatureException {
        CertificationRequest certificationRequest = null;
        try {
            SM2BCPublicKey sm2BCPublicKey = new SM2BCPublicKey(publicKey.getQ());
            SM2Signature sm2Signature = new SM2Signature();
            sm2Signature.initSign(privateKey, sm2BCPublicKey);
            sm2Signature.update(requestInfo.getEncoded());
            byte[] signature = sm2Signature.sign();
            certificationRequest = new CertificationRequest(requestInfo, EPAlgorithmIdentifier.SM3_WITH_SM2_ENCRYPTION_ALGORITHM, new DERBitString(signature));
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new SecurityException("failed to build certification request. " + e.getMessage());
        }
        return certificationRequest;
    }

    public static CertificationRequest buildCertificationRequest(X500Name x500Name, PublicKey publicKey, PrivateKey privateKey) throws InvalidKeyException, SignatureException {
        return PKCS10CertificateRequestBuilder.buildCertificationRequest(x500Name, null, publicKey, privateKey);
    }

    public static CertificationRequest buildCertificationRequest(X500Name x500Name, List<Extension> extensionRequest, PublicKey publicKey, ContentSigner contentSigner) {
        CertificationRequest certificationRequest = null;
        ASN1Set attributes = PKCS10CertificateRequestBuilder.buildExtension(extensionRequest);
        OutputStream outputStream = null;
        try {
            if ("RSA".equalsIgnoreCase(publicKey.getAlgorithm())) {
                SubjectPublicKeyInfo publicKeyInfo = SubjectPublicKeyInfo.getInstance(publicKey.getEncoded());
                CertificationRequestInfo requestInfo = new CertificationRequestInfo(x500Name, publicKeyInfo, attributes);
                outputStream = contentSigner.getOutputStream();
                outputStream.write(requestInfo.getEncoded());
                byte[] signature = contentSigner.getSignature();
                certificationRequest = new CertificationRequest(requestInfo, new AlgorithmIdentifier(new ASN1ObjectIdentifier("1.2.840.113549.1.1.5"), DERNull.INSTANCE), new DERBitString(signature));
            } else {
                SM2BCPublicKey sm2BCPublicKey = publicKey instanceof SM2BCPublicKey ? (SM2BCPublicKey)publicKey : new SM2BCPublicKey(((BCECPublicKey)publicKey).getQ());
                SubjectPublicKeyInfo publicKeyInfo = new SubjectPublicKeyInfo(EPAlgorithmIdentifier.SM2_PUBLIC_KEY_ALGORITHM, sm2BCPublicKey.getEncoded());
                CertificationRequestInfo requestInfo = new CertificationRequestInfo(x500Name, publicKeyInfo, attributes);
                outputStream = contentSigner.getOutputStream();
                outputStream.write(requestInfo.getEncoded());
                byte[] signature = contentSigner.getSignature();
                certificationRequest = new CertificationRequest(requestInfo, EPAlgorithmIdentifier.SM3_WITH_SM2_ENCRYPTION_ALGORITHM, new DERBitString(signature));
            }
        }
        catch (Exception e) {
            throw new SecurityException("failed to build certification request. " + e.getMessage());
        }
        return certificationRequest;
    }

    private static ASN1Set buildExtension(List<Extension> extensionRequest) {
        DERSet attributes = null;
        if (extensionRequest != null && extensionRequest.size() > 0) {
            ASN1Encodable[] extensions = new Extension[extensionRequest.size()];
            extensionRequest.toArray(extensions);
            Attribute extensionRequestAttribute = new Attribute(PKCSObjectIdentifiers.pkcs_9_at_extensionRequest, new DERSet(extensions));
            ASN1EncodableVector vec = new ASN1EncodableVector();
            vec.add(extensionRequestAttribute);
            attributes = new DERSet(vec);
        }
        return attributes;
    }

    public static CertificationRequest buildCertificationRequest(X500Name x500Name, List<Extension> extensionRequest, PublicKey publicKey, PrivateKey privateKey) throws InvalidKeyException, SignatureException {
        CertificationRequest certificationRequest = null;
        ASN1Set attributes = PKCS10CertificateRequestBuilder.buildExtension(extensionRequest);
        try {
            if ("RSA".equals(publicKey.getAlgorithm())) {
                SubjectPublicKeyInfo publicKeyInfo = SubjectPublicKeyInfo.getInstance(publicKey.getEncoded());
                CertificationRequestInfo requestInfo = new CertificationRequestInfo(x500Name, publicKeyInfo, attributes);
                Signature signer = Signature.getInstance("SHA1WITHRSA");
                signer.initSign(privateKey);
                signer.update(requestInfo.getEncoded());
                byte[] signature = signer.sign();
                certificationRequest = new CertificationRequest(requestInfo, new AlgorithmIdentifier(new ASN1ObjectIdentifier("1.2.840.113549.1.1.5"), DERNull.INSTANCE), new DERBitString(signature));
            } else {
                SM2BCPublicKey sm2BCPublicKey = new SM2BCPublicKey(((BCECPublicKey)publicKey).getQ());
                SubjectPublicKeyInfo publicKeyInfo = new SubjectPublicKeyInfo(EPAlgorithmIdentifier.SM2_PUBLIC_KEY_ALGORITHM, sm2BCPublicKey.getEncoded());
                CertificationRequestInfo requestInfo = new CertificationRequestInfo(x500Name, publicKeyInfo, attributes);
                SM2Signature sm2Signature = new SM2Signature();
                sm2Signature.initSign((ECPrivateKey)privateKey, sm2BCPublicKey);
                sm2Signature.update(requestInfo.getEncoded());
                byte[] signature = sm2Signature.sign();
                certificationRequest = new CertificationRequest(requestInfo, EPAlgorithmIdentifier.SM3_WITH_SM2_ENCRYPTION_ALGORITHM, new DERBitString(signature));
            }
        }
        catch (Exception e) {
            throw new SecurityException("failed to build certification request. " + e.getMessage());
        }
        return certificationRequest;
    }

    public static PKCS10CertificationRequest buildPKCS10CertificationRequest(X500Name x500Name, PublicKey publicKey, PrivateKey privateKey) throws InvalidKeyException, SignatureException {
        return new PKCS10CertificationRequest(PKCS10CertificateRequestBuilder.buildCertificationRequest(x500Name, publicKey, privateKey));
    }
}

