/*
 * Decompiled with CFR 0.152.
 */
package cn.unitid.easypki.operator;

import cn.unitid.easypki.provider.identifier.EPAlgorithmIdentifier;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.security.PrivateKey;
import java.security.Signature;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.operator.ContentSigner;

public class RSAPrivateKeyContentSigner
implements ContentSigner {
    private AlgorithmIdentifier algorithm = new AlgorithmIdentifier(new ASN1ObjectIdentifier("1.2.840.113549.1.1.1"));
    private boolean isAlgorithmReset = false;
    private PrivateKey privateKey;
    private ByteArrayOutputStream outputStream = null;
    private String signatureAlgorithm = "SHA256withRSA";

    public RSAPrivateKeyContentSigner(PrivateKey privateKey, String algorithm) {
        this.privateKey = privateKey;
        this.outputStream = new ByteArrayOutputStream();
        if (null != algorithm) {
            this.signatureAlgorithm = algorithm;
            this.isAlgorithmReset = true;
        }
    }

    public RSAPrivateKeyContentSigner(PrivateKey privateKey) {
        this.privateKey = privateKey;
        this.outputStream = new ByteArrayOutputStream();
    }

    private RSAPrivateKeyContentSigner() {
    }

    @Override
    public AlgorithmIdentifier getAlgorithmIdentifier() {
        if (this.isAlgorithmReset) {
            if ("sha256WithRSA".equalsIgnoreCase(this.signatureAlgorithm) || "1.2.840.113549.1.1.11".equals(this.signatureAlgorithm)) {
                this.algorithm = EPAlgorithmIdentifier.SHA256_WITH_RSA_ENCRYPTION_ALGORITHM;
            } else if ("sha1WithRSA".equalsIgnoreCase(this.signatureAlgorithm) || "1.2.840.113549.1.1.5".equalsIgnoreCase(this.signatureAlgorithm)) {
                this.algorithm = EPAlgorithmIdentifier.SHA1_WITH_RSA_ENCRYPTION_ALGORITHM;
            } else {
                throw new IllegalArgumentException("\u9519\u8bef\u7684\u7b7e\u540d\u7b97\u6cd5\uff01");
            }
        }
        return this.algorithm;
    }

    @Override
    public OutputStream getOutputStream() {
        return this.outputStream;
    }

    @Override
    public byte[] getSignature() {
        byte[] signature = null;
        byte[] data = this.outputStream.toByteArray();
        try {
            Signature rsaSignature = Signature.getInstance(this.signatureAlgorithm);
            rsaSignature.initSign(this.privateKey);
            rsaSignature.update(data);
            signature = rsaSignature.sign();
        }
        catch (Exception e) {
            throw new SecurityException(e.getMessage(), e);
        }
        return signature;
    }
}

