/*
 * Decompiled with CFR 0.152.
 */
package cn.unitid.easypki.asn1.sm2.application;

import cn.unitid.easypki.asn1.sm2.application.SM2Cipher;
import cn.unitid.easypki.asn1.sm2.application.SM2PublicKey;
import java.io.IOException;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.security.GeneralSecurityException;
import java.security.NoSuchAlgorithmException;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.DERBitString;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;

public class SM2EnvelopedKey
implements ASN1Encodable {
    private final AlgorithmIdentifier SM4_ALGORITHM = new AlgorithmIdentifier(new ASN1ObjectIdentifier("1.2.156.10197.1.104"));
    private final AlgorithmIdentifier SM1_ALGORITHM = new AlgorithmIdentifier(new ASN1ObjectIdentifier("1.2.156.10197.1.102"));
    private AlgorithmIdentifier symAlgoID = null;
    private SM2Cipher symEncryptedKey;
    private SM2PublicKey sm2PublicKey;
    private DERBitString sm2EncryptedPrivateKey;

    private SM2EnvelopedKey(ASN1Sequence sequence) throws IOException {
        this.symAlgoID = AlgorithmIdentifier.getInstance(sequence.getObjectAt(0));
        this.symEncryptedKey = SM2Cipher.getInstance(sequence.getObjectAt(1));
        this.sm2PublicKey = new SM2PublicKey(DERBitString.getInstance(sequence.getObjectAt(2)).getOctets());
        this.sm2EncryptedPrivateKey = DERBitString.getInstance(sequence.getObjectAt(3));
    }

    public static SM2EnvelopedKey getInstance(Object sm2EnvelopedKey) throws IOException, GeneralSecurityException {
        ASN1Sequence ekSequence = null;
        if (sm2EnvelopedKey instanceof ASN1Sequence) {
            ekSequence = (ASN1Sequence)sm2EnvelopedKey;
            return new SM2EnvelopedKey(ekSequence);
        }
        if (sm2EnvelopedKey instanceof byte[]) {
            byte[] sm2EnvelopedKeyBinary = (byte[])sm2EnvelopedKey;
            try {
                ekSequence = ASN1Sequence.getInstance(sm2EnvelopedKeyBinary);
                return new SM2EnvelopedKey(ekSequence);
            }
            catch (Exception e) {
                return new SM2EnvelopedKey(sm2EnvelopedKeyBinary);
            }
        }
        throw new GeneralSecurityException("\u4e0d\u652f\u6301\u7684\u6570\u636e\u5bf9\u8c61\uff1a" + sm2EnvelopedKey.getClass().getName());
    }

    public void t() {
        int VERSION_LEN = 4;
        int SYMMALGID_LEN = 4;
        int BITS_LEN = 4;
        int ENCRYPTEDPRIVATEKEY_LEN = 64;
        int ECPUBLICKEYBLOB_LEN = 132;
        byte[] verison = new byte[]{1, 0, 0, 0};
        byte[] symmAlgId = new byte[]{1, 4, 0, 0};
        byte[] c1Bits = new byte[]{1, 0, 0, 0};
        byte[] encryptedPrivateKey = new byte[64];
        byte[] publicKeyBlob = new byte[132];
    }

    public SM2EnvelopedKey(byte[] netOneSM2EnvelopedKey) throws NoSuchAlgorithmException {
        int VERSION_LEN = 4;
        int SYMMALGID_LEN = 4;
        int BITS_LEN = 4;
        int ECPUBLICKEYBLOB_LEN = 132;
        int ENCRYPTEDPRIVATEKEY_LEN = 64;
        byte[] byteSymmAlgID = new byte[4];
        System.arraycopy(netOneSM2EnvelopedKey, 4, byteSymmAlgID, 0, 4);
        int symmAlgID = ByteBuffer.wrap(byteSymmAlgID).order(ByteOrder.LITTLE_ENDIAN).getInt();
        if (symmAlgID == 1025) {
            this.symAlgoID = this.SM4_ALGORITHM;
        } else if (symmAlgID == 257) {
            this.symAlgoID = this.SM1_ALGORITHM;
        } else {
            throw new NoSuchAlgorithmException("No such algorithm in JCEE: Algo ID=" + symmAlgID);
        }
        byte[] byteBits = new byte[4];
        System.arraycopy(netOneSM2EnvelopedKey, 8, byteBits, 0, 4);
        int bits = ByteBuffer.wrap(byteBits).order(ByteOrder.LITTLE_ENDIAN).getInt();
        byte[] encryptedPrivateKey = new byte[64];
        System.arraycopy(netOneSM2EnvelopedKey, 12, encryptedPrivateKey, 0, 64);
        this.sm2EncryptedPrivateKey = this.buildSM2EncryptedPrivateKey(encryptedPrivateKey, bits);
        byte[] byteECPublicKeyBlob = new byte[132];
        System.arraycopy(netOneSM2EnvelopedKey, 76, byteECPublicKeyBlob, 0, 132);
        this.sm2PublicKey = this.buildSM2PublicKey(byteECPublicKeyBlob);
        byte[] byteECCipherBlob = new byte[netOneSM2EnvelopedKey.length - 4 - 4 - 4 - 64 - 132];
        System.arraycopy(netOneSM2EnvelopedKey, netOneSM2EnvelopedKey.length - byteECCipherBlob.length, byteECCipherBlob, 0, byteECCipherBlob.length);
        this.symEncryptedKey = this.buildSM2Cipher(byteECCipherBlob);
    }

    public AlgorithmIdentifier getSymAlgoID() {
        return this.symAlgoID;
    }

    public SM2Cipher getSymEncryptedKey() {
        return this.symEncryptedKey;
    }

    public SM2PublicKey getSM2PublicKey() {
        return this.sm2PublicKey;
    }

    public DERBitString getSM2EncryptedPrivateKey() {
        return this.sm2EncryptedPrivateKey;
    }

    @Override
    public ASN1Primitive toASN1Primitive() {
        ASN1EncodableVector v = new ASN1EncodableVector();
        v.add(this.symAlgoID);
        v.add(this.symEncryptedKey);
        v.add(this.sm2PublicKey);
        v.add(this.sm2EncryptedPrivateKey);
        return new DERSequence(v);
    }

    private SM2PublicKey buildSM2PublicKey(byte[] byteECPublicKeyBlob) {
        byte[] publicKey = new byte[65];
        publicKey[0] = 4;
        int standardByteLen = 64;
        byte[] byteBitLen = new byte[4];
        System.arraycopy(byteECPublicKeyBlob, 0, byteBitLen, 0, 4);
        int bitLen = ByteBuffer.wrap(byteBitLen).order(ByteOrder.LITTLE_ENDIAN).getInt();
        int byteLen = bitLen / 8;
        System.arraycopy(byteECPublicKeyBlob, 4 + (64 - byteLen), publicKey, 1, byteLen);
        System.arraycopy(byteECPublicKeyBlob, 68 + (64 - byteLen), publicKey, 1 + byteLen, byteLen);
        return new SM2PublicKey(publicKey);
    }

    private DERBitString buildSM2EncryptedPrivateKey(byte[] encryptedPrivateKey, int bitLen) {
        if (encryptedPrivateKey.length == 32) {
            return new DERBitString(encryptedPrivateKey);
        }
        int byteLen = bitLen / 8;
        byte[] privateKey = new byte[byteLen];
        System.arraycopy(encryptedPrivateKey, encryptedPrivateKey.length - byteLen, privateKey, 0, byteLen);
        return new DERBitString(privateKey);
    }

    private SM2Cipher buildSM2Cipher(byte[] ecCipherBlob) {
        byte[] xCoordinate = new byte[64];
        System.arraycopy(ecCipherBlob, 0, xCoordinate, 0, 64);
        byte[] yCoordinate = new byte[64];
        System.arraycopy(ecCipherBlob, 64, yCoordinate, 0, 64);
        byte[] hash = new byte[32];
        System.arraycopy(ecCipherBlob, 128, hash, 0, 32);
        byte[] byteCipherLen = new byte[4];
        System.arraycopy(ecCipherBlob, 160, byteCipherLen, 0, 4);
        int cipherLen = ByteBuffer.wrap(byteCipherLen).order(ByteOrder.LITTLE_ENDIAN).getInt();
        byte[] cipher = new byte[cipherLen];
        System.arraycopy(ecCipherBlob, 164, cipher, 0, cipherLen);
        return new SM2Cipher(new BigInteger(1, xCoordinate), new BigInteger(1, yCoordinate), hash, cipher);
    }
}

