/*
 * Decompiled with CFR 0.152.
 */
package cn.unitid.easypki.asn1.sm2.application;

import java.io.IOException;
import java.math.BigInteger;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1Integer;
import org.bouncycastle.asn1.ASN1Object;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.DERSequence;

public class SM2Cipher
extends ASN1Object {
    private ASN1Integer xCoordinate;
    private ASN1Integer yCoordinate;
    private DEROctetString hash;
    private DEROctetString cipherText;

    public SM2Cipher(BigInteger x, BigInteger y, byte[] hash, byte[] cipherText) {
        this.xCoordinate = new ASN1Integer(x);
        this.yCoordinate = new ASN1Integer(y);
        this.hash = new DEROctetString(hash);
        this.cipherText = new DEROctetString(cipherText);
    }

    private SM2Cipher(ASN1Sequence sequence) {
        this.xCoordinate = ASN1Integer.getInstance(sequence.getObjectAt(0));
        this.yCoordinate = ASN1Integer.getInstance(sequence.getObjectAt(1));
        this.hash = (DEROctetString)DEROctetString.getInstance(sequence.getObjectAt(2));
        this.cipherText = (DEROctetString)DEROctetString.getInstance(sequence.getObjectAt(3));
    }

    public static SM2Cipher getInstance(Object object) throws IOException {
        SM2Cipher instance = null;
        if (object instanceof SM2Cipher) {
            instance = (SM2Cipher)object;
        } else if (object instanceof ASN1Sequence) {
            instance = new SM2Cipher(ASN1Sequence.getInstance(object));
        } else if (object instanceof byte[]) {
            instance = new SM2Cipher(ASN1Sequence.getInstance(ASN1Sequence.fromByteArray((byte[])object)));
        }
        return instance;
    }

    public ASN1Integer getXCoordinate() {
        return this.xCoordinate;
    }

    public ASN1Integer getYCoordinate() {
        return this.yCoordinate;
    }

    public DEROctetString getHash() {
        return this.hash;
    }

    public DEROctetString getCipherText() {
        return this.cipherText;
    }

    @Override
    public ASN1Primitive toASN1Primitive() {
        ASN1EncodableVector v = new ASN1EncodableVector();
        v.add(this.xCoordinate);
        v.add(this.yCoordinate);
        v.add(this.hash);
        v.add(this.cipherText);
        return new DERSequence(v);
    }
}

