/*
 * Decompiled with CFR 0.152.
 */
package cn.unitid.cip.sdk.utils.okhttp;

import cn.unitid.cip.sdk.utils.okhttp.StringUtils;
import cn.unitid.cip.sdk.utils.okhttp.TrustAllManager;
import cn.unitid.cip.sdk.utils.okhttp.WebUtils;
import cn.unitid.okhttp3.ConnectionPool;
import cn.unitid.okhttp3.ConnectionSpec;
import cn.unitid.okhttp3.EventListener;
import cn.unitid.okhttp3.FormBody;
import cn.unitid.okhttp3.Headers;
import cn.unitid.okhttp3.MediaType;
import cn.unitid.okhttp3.MultipartBody;
import cn.unitid.okhttp3.OkHttpClient;
import cn.unitid.okhttp3.Protocol;
import cn.unitid.okhttp3.Request;
import cn.unitid.okhttp3.RequestBody;
import cn.unitid.okhttp3.Response;
import cn.unitid.okhttp3.internal.tls.NoopHostnameVerifier;
import cn.unitid.okhttp3.internal.tls.OkHostnameVerifier;
import java.io.File;
import java.io.IOException;
import java.net.Proxy;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.security.Provider;
import java.security.SecureRandom;
import java.security.Security;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;

public class GmOkHttpUtils {
    private final OkHttpClient httpClient;

    private GmOkHttpUtils(OkHttpClient httpClient) {
        this.httpClient = httpClient;
    }

    public static GmOkHttpUtils getDefaultOkHttpUtils() throws Exception {
        return GmOkHttpUtils.create(null, null, 5000, 15000, 15000, false, 10, 120L, null, null);
    }

    public static GmOkHttpUtils create(int connectTimeout, int readTimeout, int writeTimeout) throws Exception {
        return GmOkHttpUtils.create(null, null, connectTimeout, readTimeout, writeTimeout, false, 10, 120L, null, null);
    }

    public static GmOkHttpUtils create(int connectTimeout, int readTimeout, int writeTimeout, boolean hostnameVerifier, int maxIdleConnections, long keepAliveDuration, EventListener eventListener, Proxy proxy) throws Exception {
        return GmOkHttpUtils.create(null, null, connectTimeout, readTimeout, writeTimeout, hostnameVerifier, maxIdleConnections, keepAliveDuration, eventListener, proxy);
    }

    public static GmOkHttpUtils create(KeyStore keyStore, String password, int connectTimeout, int readTimeout, int writeTimeout, boolean hostnameVerifier, int maxIdleConnections, long keepAliveDuration, EventListener eventListener, Proxy proxy) throws Exception {
        Security.insertProviderAt((Provider)Class.forName("cn.unitid.gmssl.jce.provider.GMJCE").newInstance(), 1);
        Security.insertProviderAt((Provider)Class.forName("cn.unitid.gmssl.jsse.provider.GMJSSE").newInstance(), 2);
        ConnectionPool connectionPool = new ConnectionPool(maxIdleConnections, keepAliveDuration, TimeUnit.SECONDS);
        OkHttpClient.Builder builder = GmOkHttpUtils.builder(keyStore, password, connectTimeout, readTimeout, writeTimeout, hostnameVerifier, connectionPool, proxy);
        if (eventListener != null) {
            builder.eventListener(eventListener);
        }
        return new GmOkHttpUtils(builder.build());
    }

    public void destroy() {
        if (this.httpClient != null && this.httpClient.connectionPool() != null) {
            this.httpClient.connectionPool().evictAll();
        }
    }

    public static OkHttpClient.Builder builder(KeyStore keyStore, String password, int connectTimeout, int readTimeout, int writeTimeout, boolean hostnameVerifier, ConnectionPool connectionPool, Proxy proxy) throws GeneralSecurityException {
        SSLSocketFactory socketFactory = GmOkHttpUtils.createSocketFactory(keyStore, password != null ? password.toCharArray() : null);
        OkHttpClient.Builder builder = new OkHttpClient.Builder();
        ConnectionSpec spec = new ConnectionSpec.Builder(ConnectionSpec.MODERN_TLS).tlsVersions("GMSSLv1.1").supportsTlsExtensions(true).cipherSuites("ECC_SM4_SM3").build();
        return builder.connectionSpecs(Arrays.asList(ConnectionSpec.CLEARTEXT, spec)).connectionPool(connectionPool).connectTimeout(connectTimeout, TimeUnit.MILLISECONDS).writeTimeout(writeTimeout, TimeUnit.MILLISECONDS).readTimeout(readTimeout, TimeUnit.MILLISECONDS).protocols(Collections.singletonList(Protocol.HTTP_1_1)).proxy(proxy == null ? Proxy.NO_PROXY : proxy).sslSocketFactory(socketFactory, new TrustAllManager()).hostnameVerifier(hostnameVerifier ? OkHostnameVerifier.INSTANCE : NoopHostnameVerifier.INSTANCE);
    }

    private static SSLSocketFactory createSocketFactory(KeyStore kepair, char[] pwd) throws GeneralSecurityException {
        TrustManager[] trusts = new TrustAllManager[]{new TrustAllManager()};
        KeyManager[] kms = null;
        if (kepair != null) {
            KeyManagerFactory kmf = KeyManagerFactory.getInstance("SunX509");
            kmf.init(kepair, pwd);
            kms = kmf.getKeyManagers();
        }
        SSLContext ctx = SSLContext.getInstance("GMSSLv1.1", "GMJSSE");
        SecureRandom secureRandom = new SecureRandom();
        ctx.init(kms, trusts, secureRandom);
        ctx.getServerSessionContext().setSessionCacheSize(8192);
        ctx.getServerSessionContext().setSessionTimeout(86400);
        SSLSocketFactory factory = ctx.getSocketFactory();
        return factory;
    }

    public Response get(String url) throws IOException {
        return this.get(url, null, null);
    }

    public Response get(String url, Map<String, String> paramMap) throws IOException {
        return this.get(url, paramMap, null);
    }

    public Response get(String url, Map<String, String> paramMap, Map<String, String> customHeaders) throws IOException {
        Headers.Builder builder = new Headers.Builder();
        ((Map)Optional.ofNullable(customHeaders).orElse(new HashMap())).entrySet().stream().forEach(entry -> builder.add((String)entry.getKey(), (String)entry.getValue()));
        Headers headers = builder.build();
        String reqUrl = url;
        if (paramMap != null && paramMap.size() > 0) {
            String queryString = WebUtils.buildQuery(paramMap, "UTF-8");
            reqUrl = reqUrl + "&" + queryString;
        }
        Request request = new Request.Builder().url(reqUrl).headers(headers).get().build();
        Response response = this.httpClient.newCall(request).execute();
        return response;
    }

    public Response delete(String url) throws IOException {
        return this.delete(url, null, null);
    }

    public Response delete(String url, Map<String, String> paramMap) throws IOException {
        return this.delete(url, paramMap, null);
    }

    public Response delete(String url, Map<String, String> paramMap, Map<String, String> customHeaders) throws IOException {
        Headers.Builder builder = new Headers.Builder();
        ((Map)Optional.ofNullable(customHeaders).orElse(new HashMap())).entrySet().stream().forEach(entry -> builder.add((String)entry.getKey(), (String)entry.getValue()));
        Headers headers = builder.build();
        String reqUrl = url;
        if (paramMap != null && paramMap.size() > 0) {
            String queryString = WebUtils.buildQuery(paramMap, "UTF-8");
            reqUrl = reqUrl + "?" + queryString;
        }
        Request request = new Request.Builder().url(reqUrl).headers(headers).delete().build();
        Response response = this.httpClient.newCall(request).execute();
        return response;
    }

    public Response post(String url, Map<String, String> paramMap, Map<String, String> reqBodyMap, Map<String, String> customHeaders) throws IOException {
        return this.post(url, paramMap, reqBodyMap, null, null, customHeaders);
    }

    public Response post(String url, Map<String, String> paramMap, Map<String, String> reqBodyMap, String fileField, File file, Map<String, String> customHeaders) throws IOException {
        Object reqBody;
        Headers.Builder builder = new Headers.Builder();
        ((Map)Optional.ofNullable(customHeaders).orElse(new HashMap())).entrySet().stream().forEach(entry -> builder.add((String)entry.getKey(), (String)entry.getValue()));
        Headers headers = builder.build();
        String reqUrl = url;
        if (paramMap != null && paramMap.size() > 0) {
            String queryString = WebUtils.buildQuery(paramMap, "UTF-8");
            reqUrl = reqUrl + "&" + queryString;
        }
        RequestBody body = null;
        if (StringUtils.isBlank(fileField) || file == null) {
            reqBody = new FormBody.Builder();
            if (reqBodyMap != null && reqBodyMap.size() > 0) {
                ((Map)Optional.ofNullable(paramMap).orElse(new HashMap())).entrySet().stream().forEach(arg_0 -> GmOkHttpUtils.lambda$post$3((FormBody.Builder)reqBody, arg_0));
            }
            body = ((FormBody.Builder)reqBody).build();
        } else {
            reqBody = new MultipartBody.Builder();
            ((MultipartBody.Builder)reqBody).setType(MultipartBody.FORM);
            if (reqBodyMap != null && reqBodyMap.size() > 0) {
                ((Map)Optional.ofNullable(reqBodyMap).orElse(new HashMap())).entrySet().stream().forEach(arg_0 -> GmOkHttpUtils.lambda$post$4((MultipartBody.Builder)reqBody, arg_0));
            }
            ((MultipartBody.Builder)reqBody).addFormDataPart("file", file.getName(), RequestBody.create(MediaType.parse("application/octet-stream"), file));
            body = ((MultipartBody.Builder)reqBody).build();
        }
        Request request = new Request.Builder().url(reqUrl).headers(headers).post(body).build();
        Response response = this.httpClient.newCall(request).execute();
        return response;
    }

    public Response post(String url, Map<String, String> paramMap, String contentType, Object rawContent, Map<String, String> customHeaders) throws IOException {
        Headers.Builder builder = new Headers.Builder();
        ((Map)Optional.ofNullable(customHeaders).orElse(new HashMap())).entrySet().stream().forEach(entry -> builder.add((String)entry.getKey(), (String)entry.getValue()));
        Headers headers = builder.build();
        String reqUrl = url;
        if (paramMap != null && paramMap.size() > 0) {
            String queryString = WebUtils.buildQuery(paramMap, "UTF-8");
            reqUrl = reqUrl + "?" + queryString;
        }
        RequestBody body = null;
        if (rawContent instanceof String) {
            body = RequestBody.create(MediaType.parse(contentType), (String)rawContent);
        } else if (rawContent instanceof byte[]) {
            body = RequestBody.create(MediaType.parse(contentType), (byte[])rawContent);
        } else if (rawContent instanceof File) {
            body = RequestBody.create(MediaType.parse(contentType), (File)rawContent);
        } else {
            throw new IllegalArgumentException("\u4e0d\u652f\u6301\u7684\u53c2\u6570\u7c7b\u578b\uff1a" + rawContent.getClass().toString());
        }
        Request request = new Request.Builder().url(reqUrl).headers(headers).post(body).build();
        Response response = this.httpClient.newCall(request).execute();
        return response;
    }

    public Response put(String url, Map<String, String> paramMap, Map<String, String> customHeaders) throws IOException {
        return this.put(url, paramMap, null, null, customHeaders);
    }

    public Response put(String url, Map<String, String> paramMap, Map<String, String> reqBodyMap, String fileField, File file, Map<String, String> customHeaders) throws IOException {
        Object reqBody;
        Headers.Builder builder = new Headers.Builder();
        ((Map)Optional.ofNullable(customHeaders).orElse(new HashMap())).entrySet().stream().forEach(entry -> builder.add((String)entry.getKey(), (String)entry.getValue()));
        Headers headers = builder.build();
        String reqUrl = url;
        if (paramMap != null && paramMap.size() > 0) {
            String queryString = WebUtils.buildQuery(paramMap, "UTF-8");
            reqUrl = reqUrl + "?" + queryString;
        }
        RequestBody body = null;
        if (StringUtils.isBlank(fileField) || file == null) {
            reqBody = new FormBody.Builder();
            if (reqBodyMap != null && reqBodyMap.size() > 0) {
                ((Map)Optional.ofNullable(reqBodyMap).orElse(new HashMap())).entrySet().stream().forEach(arg_0 -> GmOkHttpUtils.lambda$put$7((FormBody.Builder)reqBody, arg_0));
            }
            body = ((FormBody.Builder)reqBody).build();
        } else {
            reqBody = new MultipartBody.Builder();
            ((MultipartBody.Builder)reqBody).setType(MultipartBody.FORM);
            if (reqBodyMap != null && reqBodyMap.size() > 0) {
                ((Map)Optional.ofNullable(reqBodyMap).orElse(new HashMap())).entrySet().stream().forEach(arg_0 -> GmOkHttpUtils.lambda$put$8((MultipartBody.Builder)reqBody, arg_0));
            }
            ((MultipartBody.Builder)reqBody).addFormDataPart("file", file.getName(), RequestBody.create(MediaType.parse("application/octet-stream"), file));
            body = ((MultipartBody.Builder)reqBody).build();
        }
        Request request = new Request.Builder().url(reqUrl).headers(headers).put(body).build();
        Response response = this.httpClient.newCall(request).execute();
        return response;
    }

    public Response put(String url, Map<String, String> paramMap, String contentType, Object rawContent, Map<String, String> customHeaders) throws IOException {
        Headers.Builder builder = new Headers.Builder();
        ((Map)Optional.ofNullable(customHeaders).orElse(new HashMap())).entrySet().stream().forEach(entry -> builder.add((String)entry.getKey(), (String)entry.getValue()));
        Headers headers = builder.build();
        String reqUrl = url;
        if (paramMap != null && paramMap.size() > 0) {
            String queryString = WebUtils.buildQuery(paramMap, "UTF-8");
            reqUrl = reqUrl + "?" + queryString;
        }
        RequestBody body = null;
        if (rawContent instanceof String) {
            body = RequestBody.create(MediaType.parse(contentType), (String)rawContent);
        } else if (rawContent instanceof byte[]) {
            body = RequestBody.create(MediaType.parse(contentType), (byte[])rawContent);
        } else if (rawContent instanceof File) {
            body = RequestBody.create(MediaType.parse(contentType), (File)rawContent);
        } else {
            throw new IllegalArgumentException("\u4e0d\u652f\u6301\u7684\u53c2\u6570\u7c7b\u578b\uff1a" + rawContent.getClass().toString());
        }
        Request request = new Request.Builder().url(reqUrl).headers(headers).put(body).build();
        Response response = this.httpClient.newCall(request).execute();
        return response;
    }

    private static /* synthetic */ void lambda$put$8(MultipartBody.Builder reqBody, Map.Entry entry) {
        reqBody.addFormDataPart((String)entry.getKey(), (String)entry.getValue());
    }

    private static /* synthetic */ void lambda$put$7(FormBody.Builder reqBody, Map.Entry entry) {
        reqBody.addEncoded((String)entry.getKey(), (String)entry.getValue());
    }

    private static /* synthetic */ void lambda$post$4(MultipartBody.Builder reqBody, Map.Entry entry) {
        reqBody.addFormDataPart((String)entry.getKey(), (String)entry.getValue());
    }

    private static /* synthetic */ void lambda$post$3(FormBody.Builder reqBody, Map.Entry entry) {
        reqBody.addEncoded((String)entry.getKey(), (String)entry.getValue());
    }
}

