/*
 * Decompiled with CFR 0.152.
 */
package cn.unitid.cip.sdk.request.sop.cip;

import cn.unitid.cip.sdk.ApiRuleException;
import cn.unitid.cip.sdk.BaseApiRequest;
import cn.unitid.cip.sdk.internal.util.ApiHashMap;
import cn.unitid.cip.sdk.internal.util.RequestCheckUtils;
import cn.unitid.cip.sdk.response.sop.cip.SymmetricDecryptResponse;
import java.util.Map;
import org.apache.commons.codec.binary.Hex;

public class SymmetricDecryptRequest
extends BaseApiRequest<SymmetricDecryptResponse> {
    private Integer cipIndex;
    private byte[] data;

    @Override
    public String getApiMethodName() {
        return "symmetric.decrypt";
    }

    @Override
    public String getApiModel() {
        return "cip";
    }

    @Override
    public Map<String, String> getTextParams() {
        ApiHashMap txtParams = new ApiHashMap();
        txtParams.put("cipIndex", (Object)this.cipIndex);
        txtParams.put("data", Hex.encodeHexString(this.data));
        return txtParams;
    }

    @Override
    public Class<SymmetricDecryptResponse> getResponseClass() {
        return SymmetricDecryptResponse.class;
    }

    @Override
    public void check() throws ApiRuleException {
        RequestCheckUtils.checkNotEmpty(this.cipIndex, "cipIndex");
        RequestCheckUtils.checkNotEmpty(Hex.encodeHexString(this.data), "data");
    }

    @Override
    public String getExecuteMethod() {
        return "POST";
    }

    public Integer getCipIndex() {
        return this.cipIndex;
    }

    public void setCipIndex(Integer cipIndex) {
        this.cipIndex = cipIndex;
    }

    public byte[] getData() {
        return this.data;
    }

    public void setData(byte[] data) {
        this.data = data;
    }
}

