/*
 * Decompiled with CFR 0.152.
 */
package cn.unitid.cip.sdk.request.sop.cip;

import cn.unitid.cip.sdk.ApiRuleException;
import cn.unitid.cip.sdk.BaseApiRequest;
import cn.unitid.cip.sdk.internal.util.ApiHashMap;
import cn.unitid.cip.sdk.internal.util.RequestCheckUtils;
import cn.unitid.cip.sdk.request.sop.cip.HmacAlgorithmEnum;
import cn.unitid.cip.sdk.response.sop.cip.ApiByteCipEncryptHMACAlgorithmResponse;
import java.util.Map;
import org.apache.commons.codec.binary.Hex;

public class ApiByteCipEncryptHMACAlgorithmRequest
extends BaseApiRequest<ApiByteCipEncryptHMACAlgorithmResponse> {
    private Integer cipIndex;
    private byte[] macData;
    private HmacAlgorithmEnum hmacAlgorithm;

    @Override
    public String getApiMethodName() {
        return "gen.hmac";
    }

    @Override
    public String getApiModel() {
        return "cip";
    }

    @Override
    public Map<String, String> getTextParams() {
        ApiHashMap txtParams = new ApiHashMap();
        txtParams.put("cipIndex", (Object)this.cipIndex);
        txtParams.put("macData", Hex.encodeHexString(this.macData));
        txtParams.put("hmacAlgorithm", (Object)this.hmacAlgorithm);
        return txtParams;
    }

    @Override
    public Class<ApiByteCipEncryptHMACAlgorithmResponse> getResponseClass() {
        return ApiByteCipEncryptHMACAlgorithmResponse.class;
    }

    @Override
    public void check() throws ApiRuleException {
        RequestCheckUtils.checkNotEmpty(this.cipIndex, "cipIndex");
        RequestCheckUtils.checkNotEmpty(Hex.encodeHexString(this.macData), "data");
    }

    @Override
    public String getExecuteMethod() {
        return "POST";
    }

    public Integer getCipIndex() {
        return this.cipIndex;
    }

    public void setCipIndex(Integer cipIndex) {
        this.cipIndex = cipIndex;
    }

    public byte[] getMacData() {
        return this.macData;
    }

    public void setMacData(byte[] macData) {
        this.macData = macData;
    }

    public HmacAlgorithmEnum getHmacAlgorithm() {
        return this.hmacAlgorithm;
    }

    public void setHmacAlgorithm(HmacAlgorithmEnum hmacAlgorithm) {
        this.hmacAlgorithm = hmacAlgorithm;
    }
}

