/*
 * Decompiled with CFR 0.152.
 */
package cn.unitid.cip.sdk;

import cn.unitid.cip.sdk.ApiClient;
import cn.unitid.cip.sdk.ApiException;
import cn.unitid.cip.sdk.ApiParser;
import cn.unitid.cip.sdk.ApiRequest;
import cn.unitid.cip.sdk.ApiResponse;
import cn.unitid.cip.sdk.ApiRuleException;
import cn.unitid.cip.sdk.ApiUploadRequest;
import cn.unitid.cip.sdk.FileItem;
import cn.unitid.cip.sdk.internal.parser.json.ObjectJsonParser;
import cn.unitid.cip.sdk.internal.parser.xml.ObjectXmlParser;
import cn.unitid.cip.sdk.internal.util.ApiHashMap;
import cn.unitid.cip.sdk.internal.util.ApiLogger;
import cn.unitid.cip.sdk.internal.util.ApiUtils;
import cn.unitid.cip.sdk.internal.util.RandomStringUtils;
import cn.unitid.cip.sdk.internal.util.RequestParametersHolder;
import cn.unitid.cip.sdk.internal.util.StringUtils;
import cn.unitid.cip.sdk.internal.util.WebUtils;
import cn.unitid.cip.sdk.utils.AesUtils;
import cn.unitid.cip.sdk.utils.SM4Utils;
import cn.unitid.cip.sdk.utils.okhttp.GmOkHttpUtils;
import cn.unitid.okhttp3.Response;
import cn.unitid.okhttp3.ResponseBody;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.CopyOnWriteArrayList;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DefaultApiClient
implements ApiClient {
    protected String serverUrl;
    protected Integer regainTime = 3;
    protected List<String> serverUrlList;
    protected List<String> disServerUrlList;
    protected String appKey;
    protected String appSecret;
    protected String format = "json";
    protected String signMethod = "HMAC-SHA256";
    private static final Log log = LogFactory.getLog("apiClient");
    protected int connectTimeout = 15000;
    protected int readTimeout = 60000;
    protected boolean needCheckRequest = true;
    protected boolean needEnableParser = true;
    protected boolean useSimplifyJson = false;
    protected boolean useGzipEncoding = false;
    private String originalHttpHost = null;
    protected String encMethod = "AES";
    protected boolean encryptionEnable = false;

    public DefaultApiClient(String serverUrl, String appKey, String appSecret) {
        this.appKey = appKey;
        this.appSecret = appSecret;
        this.serverUrl = serverUrl;
    }

    public DefaultApiClient(String serverUrl, String appKey, String appSecret, String format) {
        this(serverUrl, appKey, appSecret);
        this.format = format;
    }

    public DefaultApiClient(String serverUrl, String appKey, String appSecret, String format, int connectTimeout, int readTimeout) {
        this(serverUrl, appKey, appSecret, format);
        this.connectTimeout = connectTimeout;
        this.readTimeout = readTimeout;
    }

    public DefaultApiClient(String serverUrl, String appKey, String appSecret, String format, int connectTimeout, int readTimeout, String signMethod) {
        this(serverUrl, appKey, appSecret, format, connectTimeout, readTimeout);
        this.signMethod = signMethod;
    }

    public DefaultApiClient(String serverUrl, String appKey, String appSecret, String encMethod, Boolean encryptionEnable) {
        this.encMethod = encMethod;
        this.encryptionEnable = encryptionEnable;
        this.appKey = appKey;
        this.appSecret = appSecret;
        this.serverUrl = serverUrl;
    }

    public DefaultApiClient(List<String> serverUrlList, String appKey, String appSecret) throws ApiException {
        this.setServerUrl(serverUrlList, appKey, appSecret);
    }

    public DefaultApiClient(List<String> serverUrlList, String appKey, String appSecret, String encMethod, boolean encryptionEnable) throws ApiException {
        this.encMethod = encMethod;
        this.encryptionEnable = encryptionEnable;
        this.setServerUrl(serverUrlList, appKey, appSecret);
    }

    @Override
    public <T extends ApiResponse> T execute(ApiRequest<T> request) throws Exception {
        T t = null;
        if (org.apache.commons.lang3.StringUtils.isNotBlank(this.serverUrl)) {
            t = this._execute(request, this.serverUrl);
            return t;
        }
        if (null != this.serverUrlList) {
            String myServerUrl = null;
            try {
                if (this.serverUrlList.size() <= 0) {
                    throw new ApiException("\u65e0\u53ef\u7528\u5730\u5740");
                }
                myServerUrl = this.getRandomUrl(this.serverUrlList);
                String executeServerUrl = "https://" + myServerUrl + "/rest/cip/kitty/%s/sop";
                t = this._execute(request, executeServerUrl);
            }
            catch (ApiException e1) {
                throw new ApiException(e1.getMessage());
            }
            catch (Exception e2) {
                this.serverUrlList.remove(myServerUrl);
                this.disServerUrlList.add(myServerUrl);
                this.regainMyServerUrl();
                myServerUrl = this.getRandomUrl(this.serverUrlList);
                Boolean check = this.healthCheck(myServerUrl);
                if (check.booleanValue()) {
                    try {
                        String executeServerUrl = "https://" + myServerUrl + "/rest/cip/kitty/%s/sop";
                        t = this._execute(request, executeServerUrl);
                    }
                    catch (Exception e3) {
                        throw new ApiException(e3.getMessage());
                    }
                }
                throw new ApiException("\u672c\u6b21\u8bf7\u6c42\u65e0\u6cd5\u83b7\u53d6\u5230\u53ef\u7528\u5730\u5740");
            }
        }
        return t;
    }

    private void setServerUrl(List<String> serverUrlList, String appKey, String appSecret) throws ApiException {
        if (serverUrlList.size() == 0) {
            throw new ApiException("\u65e0\u6cd5\u83b7\u53d6\u5230\u53ef\u7528\u5730\u5740");
        }
        this.appKey = appKey;
        this.appSecret = appSecret;
        this.serverUrlList = new CopyOnWriteArrayList<String>();
        this.disServerUrlList = new CopyOnWriteArrayList<String>();
        this.getAllServerUrl(serverUrlList);
        this.regainMyServerUrl();
    }

    private void getAllServerUrl(List<String> serverUrlList) throws ApiException {
        if (null == serverUrlList || serverUrlList.size() == 0) {
            throw new ApiException("\u4f20\u5165\u7684\u670d\u52a1\u5730\u5740\u96c6\u5408\u4e3a\u7a7a");
        }
        for (String myServerUrl : serverUrlList) {
            Boolean check = this.healthCheck(myServerUrl);
            if (check.booleanValue()) {
                this.serverUrlList.add(myServerUrl);
                continue;
            }
            this.disServerUrlList.add(myServerUrl);
        }
        if (this.serverUrlList.size() == 0) {
            throw new ApiException("\u65e0\u6cd5\u83b7\u53d6\u5230\u53ef\u7528\u5730\u5740");
        }
    }

    private void regainMyServerUrl() {
        if (this.disServerUrlList != null && this.disServerUrlList.size() > 0) {
            new Thread(){

                @Override
                public void run() {
                    try {
                        Thread.sleep(60000 * DefaultApiClient.this.regainTime);
                        for (String disServerUrl : DefaultApiClient.this.disServerUrlList) {
                            Boolean check = DefaultApiClient.this.healthCheck(disServerUrl);
                            if (!check.booleanValue()) continue;
                            DefaultApiClient.this.disServerUrlList.remove(disServerUrl);
                            DefaultApiClient.this.serverUrlList.add(disServerUrl);
                        }
                        if (DefaultApiClient.this.disServerUrlList.size() > 0) {
                            DefaultApiClient.this.regainMyServerUrl();
                        }
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                }
            }.start();
        }
    }

    private String getRandomUrl(List<String> listUrl) throws ApiException {
        if (listUrl.size() <= 0) {
            throw new ApiException("\u65e0\u53ef\u7528\u5730\u5740");
        }
        Random random = new Random();
        int pos = random.nextInt(listUrl.size());
        String myServerUrl = listUrl.get(pos);
        return myServerUrl;
    }

    public Boolean healthCheck(String serverUrl) {
        block6: {
            try {
                GmOkHttpUtils okHttpUtils = GmOkHttpUtils.getDefaultOkHttpUtils();
                Response response = okHttpUtils.get("https://" + serverUrl + "/actuator/health");
                okHttpUtils.destroy();
                if (response.isSuccessful()) {
                    ResponseBody body = response.body();
                    String bodyString = body.string();
                    JSONObject jsonObject = JSONObject.parseObject(bodyString);
                    if (null != jsonObject) {
                        String status = (String)jsonObject.get("status");
                        if (org.apache.commons.lang3.StringUtils.equals("DOWN", status)) {
                            return Boolean.FALSE;
                        }
                        if (org.apache.commons.lang3.StringUtils.equals("UP", status)) {
                            return Boolean.TRUE;
                        }
                    }
                    break block6;
                }
                return Boolean.FALSE;
            }
            catch (Exception e) {
                return Boolean.FALSE;
            }
        }
        return Boolean.FALSE;
    }

    private <T extends ApiResponse> T _execute(ApiRequest<T> request, String serverUrl) throws Exception {
        long start = System.currentTimeMillis();
        ApiParser<T> parser = null;
        if (this.needEnableParser) {
            parser = "xml".equals(this.format) ? new ObjectXmlParser<T>(request.getResponseClass()) : new ObjectJsonParser<T>(request.getResponseClass(), this.useSimplifyJson);
        }
        if (this.needCheckRequest) {
            try {
                request.check();
            }
            catch (ApiRuleException e) {
                ApiResponse localResponse = null;
                try {
                    localResponse = (ApiResponse)request.getResponseClass().newInstance();
                }
                catch (Exception xe) {
                    throw new ApiException("\u7cfb\u7edf\u5f02\u5e38\uff1a" + xe.getMessage(), xe);
                }
                localResponse.setErrorCode(e.getErrCode());
                localResponse.setMsg(e.getErrMsg());
                return (T)localResponse;
            }
        }
        RequestParametersHolder requestHolder = new RequestParametersHolder();
        ApiHashMap appParams = new ApiHashMap((Map<? extends String, ? extends String>)request.getTextParams());
        requestHolder.setApplicationParams(appParams);
        ApiHashMap protocalMustParams = new ApiHashMap();
        protocalMustParams.put("method", request.getApiMethodName());
        protocalMustParams.put("version", "1");
        protocalMustParams.put("appKey", this.appKey);
        protocalMustParams.put("encMethod", this.encMethod);
        protocalMustParams.put("encryptionEnable", String.valueOf(this.encryptionEnable));
        Long timestamp = request.getTimestamp();
        if (timestamp == null) {
            timestamp = System.currentTimeMillis();
        }
        protocalMustParams.put("timestamp", (Object)timestamp);
        protocalMustParams.put("nonce", RandomStringUtils.randomAlphanumeric(10));
        request.getHeaderMap().put("x-request-id", RandomStringUtils.randomAlphanumeric(10));
        requestHolder.setProtocalMustParams(protocalMustParams);
        ApiHashMap protocalOptParams = new ApiHashMap();
        protocalOptParams.put("format", this.format);
        protocalOptParams.put("signMethod", this.signMethod);
        protocalOptParams.put("signVersion", "1.0");
        if (this.useSimplifyJson) {
            protocalOptParams.put("simplify", Boolean.TRUE.toString());
        }
        requestHolder.setProtocalOptParams(protocalOptParams);
        try {
            if (this.encryptionEnable) {
                ApiHashMap newApplicationParams = requestHolder.getApplicationParams();
                newApplicationParams.forEach((key, value) -> {
                    block4: {
                        try {
                            if ("AES".equals(this.encMethod)) {
                                newApplicationParams.put((String)key, AesUtils.encrypt(value, AesUtils.generateKey(this.appSecret)));
                                break block4;
                            }
                            if ("SM4".equals(this.encMethod)) {
                                newApplicationParams.put((String)key, SM4Utils.encrypt(value, AesUtils.generateKey(this.appSecret)));
                                break block4;
                            }
                            throw new ApiException("\u4e0d\u652f\u6301\u7684\u52a0\u5bc6\u7c7b\u578b");
                        }
                        catch (Exception e) {
                            throw new RuntimeException(e);
                        }
                    }
                });
                requestHolder.setApplicationParams(newApplicationParams);
            }
            protocalMustParams.put("sign", ApiUtils.signTopRequest(requestHolder, this.appSecret, this.signMethod));
            String realServerUrl = this.getServerUrl(serverUrl, request.getApiMethodName(), request.getApiModel(), appParams);
            String sysMustQuery = WebUtils.buildQuery(requestHolder.getProtocalMustParams(), "UTF-8");
            String sysOptQuery = WebUtils.buildQuery(requestHolder.getProtocalOptParams(), "UTF-8");
            String fullUrl = WebUtils.buildRequestUrl(realServerUrl, sysMustQuery, sysOptQuery);
            String rsp = null;
            if (this.useGzipEncoding) {
                request.getHeaderMap().put("Accept-Encoding", "gzip");
            }
            if (request instanceof ApiUploadRequest) {
                ApiUploadRequest uRequest = (ApiUploadRequest)request;
                Map<String, FileItem> fileParams = ApiUtils.cleanupMap(uRequest.getFileParams());
                Map<String, List<FileItem>> fileListParams = ApiUtils.cleanupMap(uRequest.getFileListParams());
                if (fileParams != null) {
                    rsp = WebUtils.doPost(fullUrl, (Map<String, String>)appParams, fileParams, "UTF-8", this.connectTimeout, this.readTimeout, request.getHeaderMap());
                }
                if (fileListParams != null) {
                    rsp = WebUtils._doPostWithFileList(fullUrl, appParams, fileListParams, "UTF-8", this.connectTimeout, this.readTimeout, request.getHeaderMap());
                }
            } else {
                rsp = "GET".equalsIgnoreCase(request.getExecuteMethod()) ? WebUtils.doGet(fullUrl, appParams, "UTF-8", this.connectTimeout, this.readTimeout, request.getHeaderMap()) : WebUtils.doPost(fullUrl, (Map<String, String>)appParams, "UTF-8", this.connectTimeout, this.readTimeout, request.getHeaderMap(), null);
            }
            requestHolder.setResponseBody(rsp);
        }
        catch (IOException e) {
            ApiLogger.logApiError(this.appKey, request.getApiMethodName(), serverUrl, requestHolder.getAllParams(), System.currentTimeMillis() - start, e.toString());
            throw new IOException(e.getMessage());
        }
        ApiResponse tRsp = null;
        if (this.needEnableParser) {
            Object data;
            JSONObject jsonObject;
            String responseBody = requestHolder.getResponseBody();
            if (this.encryptionEnable && (jsonObject = JSON.parseObject(responseBody)).containsKey("data") && null != (data = jsonObject.get("data"))) {
                String dataStr = JSON.toJSONString(data);
                JSONObject dataObject = JSON.parseObject(dataStr);
                dataObject.forEach((key, value) -> {
                    try {
                        if ("AES".equals(this.encMethod)) {
                            dataObject.put((String)key, (Object)AesUtils.decrypt(value.toString(), AesUtils.generateKey(this.appSecret)));
                        } else {
                            dataObject.put((String)key, (Object)SM4Utils.decrypt(value.toString(), AesUtils.generateKey(this.appSecret)));
                        }
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                });
                jsonObject.put("data", (Object)dataObject);
                responseBody = JSON.toJSONString(jsonObject);
            }
            tRsp = (ApiResponse)parser.parse(responseBody);
            tRsp.setBody(responseBody);
        } else {
            try {
                tRsp = (ApiResponse)request.getResponseClass().newInstance();
                tRsp.setBody(requestHolder.getResponseBody());
            }
            catch (Exception e) {
                throw new ApiException("\u7cfb\u7edf\u5f02\u5e38\uff1a" + e.getMessage(), e);
            }
        }
        tRsp.setParams(appParams);
        if (!tRsp.isSuccess()) {
            ApiLogger.logApiError(this.appKey, request.getApiMethodName(), serverUrl, requestHolder.getAllParams(), System.currentTimeMillis() - start, tRsp.getBody());
        }
        return (T)tRsp;
    }

    public String getServerUrl(String serverUrl, String apiName, String apiModel, ApiHashMap appParams) {
        String normLink = apiName.replace(".", "-");
        if (!StringUtils.isEmpty(serverUrl) && serverUrl.contains("%s")) {
            return String.format(serverUrl, apiModel) + "/" + normLink;
        }
        return serverUrl + "/" + normLink;
    }

    protected String getSdkVersion() {
        return "openapi-sdk-java-20211119";
    }

    public void setNeedCheckRequest(boolean needCheckRequest) {
        this.needCheckRequest = needCheckRequest;
    }

    public void setNeedEnableParser(boolean needEnableParser) {
        this.needEnableParser = needEnableParser;
    }

    public void setUseSimplifyJson(boolean useSimplifyJson) {
        this.useSimplifyJson = useSimplifyJson;
    }

    public void setNeedEnableLogger(boolean needEnableLogger) {
        ApiLogger.setNeedEnableLogger(needEnableLogger);
    }

    public void setIgnoreSSLCheck(boolean ignore) {
        WebUtils.setIgnoreSSLCheck(ignore);
    }

    public void setUseGzipEncoding(boolean useGzipEncoding) {
        this.useGzipEncoding = useGzipEncoding;
    }

    public void setConnectTimeout(int connectTimeout) {
        this.connectTimeout = connectTimeout;
    }

    public void setReadTimeout(int readTimeout) {
        this.readTimeout = readTimeout;
    }

    public void resetServerUrl(String serverUrl) {
        this.serverUrl = serverUrl;
    }

    public String getRequestUrl() {
        return this.serverUrl;
    }

    public String getAppKey() {
        return this.appKey;
    }
}

