/*
 * Decompiled with CFR 0.152.
 */
package cfca.ch.qos.logback.access.filter;

import cfca.ch.qos.logback.access.filter.StatisticalView;
import cfca.ch.qos.logback.access.filter.StatisticalViewImpl;
import cfca.ch.qos.logback.core.filter.Filter;
import cfca.ch.qos.logback.core.spi.FilterReply;
import java.lang.management.ManagementFactory;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import javax.management.StandardMBean;

public class CountingFilter
extends Filter {
    long total = 0L;
    final StatisticalViewImpl accessStatsImpl = new StatisticalViewImpl(this);
    String domain = "cfca.ch.qos.logback.access";

    public FilterReply decide(Object event) {
        ++this.total;
        this.accessStatsImpl.update();
        return FilterReply.NEUTRAL;
    }

    public long getTotal() {
        return this.total;
    }

    @Override
    public void start() {
        MBeanServer mbs = ManagementFactory.getPlatformMBeanServer();
        try {
            ObjectName on = new ObjectName(String.valueOf(this.domain) + ":Name=" + this.getName());
            StandardMBean mbean = new StandardMBean(this.accessStatsImpl, StatisticalView.class);
            if (mbs.isRegistered(on)) {
                mbs.unregisterMBean(on);
            }
            mbs.registerMBean(mbean, on);
            super.start();
        }
        catch (Exception e) {
            this.addError("Failed to create mbean", e);
        }
    }

    @Override
    public void stop() {
        super.stop();
        try {
            MBeanServer mbs = ManagementFactory.getPlatformMBeanServer();
            ObjectName on = new ObjectName("totp:Filter=1");
            mbs.unregisterMBean(on);
        }
        catch (Exception e) {
            this.addError("Failed to unregister mbean", e);
        }
    }

    public String getDomain() {
        return this.domain;
    }

    public void setDomain(String domain) {
        this.domain = domain;
    }
}

