/*
 * Decompiled with CFR 0.152.
 */
package cfca.sadk.util;

import cfca.sadk.algorithm.common.Mechanism;
import cfca.sadk.algorithm.common.PKIException;
import cfca.sadk.algorithm.sm2.SM3Digest;
import cfca.sadk.algorithm.util.SymmetricHelper;
import cfca.sadk.org.bouncycastle.util.encoders.Hex;
import cfca.sadk.util.Base64;
import java.io.InputStream;
import java.io.OutputStream;

final class SM4Helper {
    private SM4Helper() {
    }

    static final boolean encrypt(byte[] k16Bytes, byte[] iv16Bytes, InputStream inputStream, OutputStream outputStream) throws PKIException {
        return SM4Helper.SM4CBCEncrypt(true, k16Bytes, iv16Bytes, inputStream, outputStream);
    }

    static final boolean decrypt(byte[] k16Bytes, byte[] iv16Bytes, InputStream inputStream, OutputStream outputStream) throws PKIException {
        return SM4Helper.SM4CBCEncrypt(false, k16Bytes, iv16Bytes, inputStream, outputStream);
    }

    static final byte[] encrypt(byte[] k16Bytes, byte[] iv16Bytes, byte[] data) throws PKIException {
        byte[] encryptData = SM4Helper.SM4CBCEncrypt(true, k16Bytes, iv16Bytes, data);
        try {
            return Base64.encode(encryptData);
        }
        catch (Exception e) {
            throw new PKIException("SM4CBCEncrypt/Decrypt encryptData encodedBase54 failed!", e);
        }
    }

    static final byte[] decrypt(byte[] k16Bytes, byte[] iv16Bytes, byte[] base64EncryptData) throws PKIException {
        byte[] encryptData;
        try {
            encryptData = Base64.decode(base64EncryptData);
        }
        catch (Exception e) {
            throw new PKIException("SM4CBCEncrypt/Decrypt encryptData decodedBase54 failed!", e);
        }
        return SM4Helper.SM4CBCEncrypt(false, k16Bytes, iv16Bytes, encryptData);
    }

    private static final boolean SM4CBCEncrypt(boolean forEncryption, byte[] k16Bytes, byte[] iv16Bytes, InputStream inputStream, OutputStream outputStream) throws PKIException {
        SM4Helper.check(k16Bytes, iv16Bytes);
        if (inputStream == null) {
            throw new PKIException("SM4CBCEncrypt/Decrypt inputStream required not null!");
        }
        if (outputStream == null) {
            throw new PKIException("SM4CBCEncrypt/Decrypt outputStream required not null!");
        }
        Mechanism mechanism = new Mechanism("SM4/CBC/PKCS7Padding", iv16Bytes);
        boolean passed = forEncryption ? SymmetricHelper.fileEncrypt(false, mechanism, k16Bytes, inputStream, outputStream) : SymmetricHelper.fileDecrypt(false, mechanism, k16Bytes, inputStream, outputStream);
        return passed;
    }

    private static final byte[] SM4CBCEncrypt(boolean forEncryption, byte[] k16Bytes, byte[] iv16Bytes, byte[] data) throws PKIException {
        SM4Helper.check(k16Bytes, iv16Bytes);
        if (data == null) {
            throw new PKIException("SM4CBCEncrypt/Decrypt data required not null!");
        }
        Mechanism mechanism = new Mechanism("SM4/CBC/PKCS7Padding", iv16Bytes);
        byte[] outBytes = forEncryption ? SymmetricHelper.dataEncrypt(false, mechanism, k16Bytes, data) : SymmetricHelper.dataDecrypt(false, mechanism, k16Bytes, data);
        return outBytes;
    }

    private static void check(byte[] k16Bytes, byte[] iv16Bytes) throws PKIException {
        if (k16Bytes == null || k16Bytes.length != 16) {
            throw new PKIException("SM4CBCEncrypt/Decrypt k16Bytes required 16 bytes!");
        }
        if (iv16Bytes == null || iv16Bytes.length != 16) {
            throw new PKIException("SM4CBCEncrypt/Decrypt iv16Bytes required 16 bytes!");
        }
    }

    static final class IvSM4Key {
        final byte[] iv16Bytes;
        final byte[] k16Bytes;

        IvSM4Key(String password) throws PKIException {
            byte[] k16Bytes;
            byte[] iv16Bytes;
            if (password == null) {
                throw new PKIException("SM4PBEKDF password required not null!");
            }
            try {
                byte[] src = password.getBytes("UTF8");
                byte[] hash = IvSM4Key.SM3KDF(src);
                iv16Bytes = new byte[16];
                k16Bytes = new byte[16];
                System.arraycopy(hash, 0, iv16Bytes, 0, 16);
                System.arraycopy(hash, 16, k16Bytes, 0, 16);
            }
            catch (Exception e) {
                throw new PKIException("SM4PBEKDF failed", e);
            }
            this.iv16Bytes = iv16Bytes;
            this.k16Bytes = k16Bytes;
        }

        IvSM4Key(byte[] iv16Bytes, byte[] k16Bytes) throws PKIException {
            if (iv16Bytes == null || iv16Bytes.length != 16) {
                throw new PKIException("IvSM4Key required iv16Bytes length=16");
            }
            if (k16Bytes == null || k16Bytes.length != 16) {
                throw new PKIException("IvSM4Key required k16Bytes length=16");
            }
            this.iv16Bytes = iv16Bytes;
            this.k16Bytes = k16Bytes;
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append("IvSM4Key [iv16Bytes=");
            builder.append(Hex.toHexString(this.iv16Bytes));
            builder.append(", k16Bytes=");
            builder.append(Hex.toHexString(this.k16Bytes));
            builder.append("]");
            return builder.toString();
        }

        static final byte[] SM3KDF(byte[] data) throws PKIException {
            if (data == null) {
                throw new PKIException("SM3KDF data required not null!");
            }
            byte[] ct = new byte[]{0, 0, 0, 1};
            SM3Digest sm3 = new SM3Digest();
            sm3.update(data, 0, data.length);
            sm3.update(ct, 0, ct.length);
            byte[] hash = new byte[32];
            sm3.doFinal(hash, 0);
            return hash;
        }
    }
}

