/*
 * Decompiled with CFR 0.152.
 */
package cfca.sadk.test.softLink.perf;

import cfca.sadk.algorithm.common.PKIException;
import cfca.sadk.test.softLink.perf.TestFrame;
import cfca.sadk.util.CertUtil;
import cfca.sadk.util.EnvelopeUtil;
import cfca.sadk.util.KeyUtil;
import cfca.sadk.util.Signature;
import cfca.sadk.x509.certificate.X509Cert;
import java.io.FileInputStream;
import java.io.UnsupportedEncodingException;

public class TestRSA2048P7Detach
extends TestFrame {
    void init() throws Exception {
        String cmbcCertPath = "TestData/rsa/boca.cer";
        String sm2Path = "TestData/rsa/0001.pfx";
        String sm2Pass = "123123";
        this.priKey = KeyUtil.getPrivateKeyFromPFX("TestData/rsa/0001.pfx", "123123");
        this.cert = new X509Cert(new FileInputStream("TestData/rsa/boca.cer"));
        this.cert = CertUtil.getCertFromPFX("TestData/rsa/0001.pfx", "123123");
        this.certs = new X509Cert[]{this.cert};
    }

    final String signedMessage(byte[] message) throws UnsupportedEncodingException, PKIException {
        return new String(new Signature().p7SignMessageDetach("sha256WithRSAEncryption", message, this.priKey, this.cert, this.session));
    }

    final String envelopedMessage(byte[] signedData) throws UnsupportedEncodingException, PKIException {
        return new String(EnvelopeUtil.envelopeMessage(signedData, "DESede/CBC/PKCS7Padding", this.certs, this.session), "UTF8");
    }

    final String openEnvelopedMessage(byte[] encryptedData) throws UnsupportedEncodingException, PKIException {
        return new String(EnvelopeUtil.openEvelopedMessage(encryptedData, this.priKey, this.cert, this.session), "UTF8");
    }

    final boolean verifiedMessage(byte[] message, byte[] signature) throws UnsupportedEncodingException, PKIException {
        return new Signature().p7VerifyMessageDetach(message, signature, this.session);
    }

    String getTestName() {
        return "P7Detach: RSA2048";
    }

    public static void main(String[] args) throws Exception {
        TestFrame.runTest(new TestRSA2048P7Detach(), true, args);
    }
}

