/*
 * Decompiled with CFR 0.152.
 */
package cfca.sadk.test.softLink.perf;

import cfca.sadk.algorithm.common.Mechanism;
import cfca.sadk.algorithm.sm2.SM2PublicKey;
import cfca.sadk.test.TestExt;
import cfca.sadk.util.CertUtil;
import cfca.sadk.util.HashUtil;
import java.math.BigInteger;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;

public final class SM3PerfTest {
    static final String sm2FileText = "MIIDfAIBATBHBgoqgRzPVQYBBAIBBgcqgRzPVQFoBDDYQoRRu6L+lmHg0SOynJgW0OzlRPkNcY0Js9nnKMnl/4ahDJu0DA72iFLsTdIYftYwggMsBgoqgRzPVQYBBAIBBIIDHDCCAxgwggK9oAMCAQICBTABAnExMAwGCCqBHM9VAYN1BQAwKzELMAkGA1UEBhMCQ04xHDAaBgNVBAoME0NGQ0EgU00yIFRFU1QgT0NBMjEwHhcNMTUwNDAxMDI0NzI4WhcNMTYwNDAxMDI0NzI4WjB0MQswCQYDVQQGEwJDTjENMAsGA1UECgwEQ01CQzESMBAGA1UECwwJQ01CQ19EQ01TMRUwEwYDVQQLDAxJbmRpdmlkdWFsLTExKzApBgNVBAMMIjAzMDVAMDk0NTkxNDM2MTc5MjY0M0B1c2VyMTE1ODI1QDEwWTATBgcqhkjOPQIBBggqgRzPVQGCLQNCAARD8XhkCu3ngLY6ojk6nWfPEAqd6vcttD92gaaOGcKfAtKRwtfxkdw5Z6EZ/T4CkrsZVkKQqFnC4J3h3g8UjeJMo4IBgTCCAX0wHwYDVR0jBBgwFoAU4n62ELuU6xXmrtEVCv/o16BXOZ0wSAYDVR0gBEEwPzA9BghggRyG7yoCAjAxMC8GCCsGAQUFBwIBFiNodHRwOi8vd3d3LmNmY2EuY29tLmNuL3VzL3VzLTEzLmh0bTCBzgYDVR0fBIHGMIHDMIGToIGQoIGNhoGKbGRhcDovLzIxMC43NC40MS4xNjE6Mzg5L2NuPWNybDI1LE9VPVNNMixPVT1DUkwsTz1DRkNBIFNNMiBURVNUIE9DQTIxLEM9Q04/Y2VydGlmaWNhdGVSZXZvY2F0aW9uTGlzdD9iYXNlP29iamVjdGNsYXNzPWNSTERpc3RyaWJ1dGlvblBvaW50MCugKaAnhiVodHRwOi8vMjEwLjc0LjQxLjg3L0NSTC9TTTIvY3JsMjUuY3JsMAsGA1UdDwQEAwID6DAdBgNVHQ4EFgQUVnCnXmNxFTBEckbZvMae92RwPaAwEwYDVR0lBAwwCgYIKwYBBQUHAwIwDAYIKoEcz1UBg3UFAANHADBEAiA7UhQYFiRFVmM6qBQP6VdYf2Itd8/qqcJgajy1cKIc1AIgIbHXJ5jQG2OxMZKKMbGxnpVkbQPzS6o6oMmEiQH3s1Y=";
    static final String sm2FilePass = "123123";
    static long maxTime = 0L;
    static long num = 0L;

    public static void main(String[] args) throws Exception {
        long allTime;
        TestExt.err("Commands: <numThread> <seconds> <dataLength> <1|2|4|8|16> <delay> [-jni]");
        final SM2PublicKey publicKey = (SM2PublicKey)CertUtil.getCertFromSM2(sm2FileText.getBytes()).getPublicKey();
        long numThread = args.length > 0 ? (long)Integer.parseInt(args[0]) : 64L;
        long seconds = args.length > 1 ? (long)Integer.parseInt(args[1]) : 30L;
        long dataLength = args.length > 2 ? (long)Integer.parseInt(args[2]) : 4096L;
        long operations = args.length > 3 ? (long)Integer.parseInt(args[3]) : 1L;
        final long delay = (long)(args.length > 4 ? Integer.parseInt(args[4]) : 5000) * 1000000L;
        boolean jniFlag = false;
        for (int i = 0; i < args.length; ++i) {
            if (!"-jni".equals(args[i])) continue;
            jniFlag = true;
            break;
        }
        final boolean testHashsha1 = (1L & operations) == 1L;
        final boolean testHashsha256 = (2L & operations) == 2L;
        final boolean testHashsha512 = (4L & operations) == 4L;
        final boolean testHashsm3 = (8L & operations) == 8L;
        final boolean testHashsm3ZExt = (operations & 0x10L) == 16L;
        char[] values = new char[(int)dataLength];
        for (int i = 0; i < values.length; ++i) {
            values[i] = 97;
        }
        final boolean jniCall = jniFlag;
        final String message = new String(values);
        Thread[] testThreads = new Thread[(int)numThread];
        for (int i = 0; i < testThreads.length; ++i) {
            testThreads[i] = new Thread(new Runnable(){

                public void run() {
                    byte[] sourceData = message.getBytes();
                    while (true) {
                        try {
                            while (true) {
                                long timer5;
                                long max;
                                long timer0 = System.nanoTime();
                                if (testHashsha1) {
                                    if (jniCall) {
                                        HashUtil.RSAHashMessageByJNI(sourceData, new Mechanism("SHA-1"), false);
                                    } else {
                                        HashUtil.RSAHashMessageByBC(sourceData, new Mechanism("SHA-1"), false);
                                    }
                                }
                                long timer1 = System.nanoTime();
                                if (testHashsha256) {
                                    if (jniCall) {
                                        HashUtil.RSAHashMessageByJNI(sourceData, new Mechanism("SHA-256"), false);
                                    } else {
                                        HashUtil.RSAHashMessageByBC(sourceData, new Mechanism("SHA-256"), false);
                                    }
                                }
                                long timer2 = System.nanoTime();
                                if (testHashsha512) {
                                    if (jniCall) {
                                        HashUtil.RSAHashMessageByJNI(sourceData, new Mechanism("SHA-512"), false);
                                    } else {
                                        HashUtil.RSAHashMessageByBC(sourceData, new Mechanism("SHA-512"), false);
                                    }
                                }
                                long timer3 = System.nanoTime();
                                if (testHashsm3) {
                                    if (jniCall) {
                                        HashUtil.SM2HashMessageByJNIWithoutZValue(sourceData);
                                    } else {
                                        HashUtil.SM2HashMessageByBCWithoutZValue(sourceData);
                                    }
                                }
                                long timer4 = System.nanoTime();
                                if (testHashsm3ZExt) {
                                    if (jniCall) {
                                        HashUtil.SM2HashMessageByJNIWithZValue(null, sourceData, publicKey.getPubX(), publicKey.getPubY());
                                    } else {
                                        HashUtil.SM2HashMessageByBCWithZValue(null, sourceData, publicKey.getPubX_Int(), publicKey.getPubY_Int());
                                    }
                                }
                                if ((max = (timer5 = System.nanoTime()) - timer0) > maxTime) {
                                    maxTime = max;
                                }
                                if (max > delay) {
                                    StringBuilder message2 = new StringBuilder();
                                    message2.append(new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(new Date()));
                                    message2.append(" maxTime=").append(max);
                                    message2.append("(");
                                    message2.append(", T1SHA1=").append(timer1 - timer0);
                                    message2.append(", T2SHA256=").append(timer2 - timer1);
                                    message2.append(", T3SHA512=").append(timer3 - timer2);
                                    message2.append(", T4SM3=").append(timer4 - timer3);
                                    message2.append(", T5SM3ZExt=").append(timer5 - timer4);
                                    message2.append(")").append("nanosesondes");
                                    TestExt.err(message2);
                                }
                                ++num;
                            }
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                            continue;
                        }
                        break;
                    }
                }
            });
            testThreads[i].setDaemon(true);
        }
        long sTime = System.currentTimeMillis();
        long xTime = System.currentTimeMillis();
        for (int i = 0; i < testThreads.length; ++i) {
            testThreads[i].start();
        }
        long yTime = System.currentTimeMillis();
        long allCounter = 0L;
        long avgCounter = 0L;
        long avgTime = 0L;
        do {
            Thread.sleep(5000L);
            avgCounter = num;
            yTime = System.currentTimeMillis();
            avgTime = yTime - xTime;
            xTime = System.currentTimeMillis();
            num = 0L;
            allTime = System.currentTimeMillis() - sTime;
            long avg = 1000L * avgCounter / avgTime;
            long all = 1000L * (allCounter += avgCounter) / allTime;
            StringBuilder text = new StringBuilder();
            text.append(new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(new Date()));
            text.append(" commands=").append(Arrays.asList(args));
            text.append(", numThread=").append(numThread);
            text.append(", seconds=").append(seconds);
            text.append(", dataLength=").append(dataLength);
            text.append(", operations=").append(operations);
            text.append(", maxTime=").append(maxTime);
            text.append(", AVG-TPS=").append(avg);
            text.append("(").append(avgCounter);
            text.append(",").append(avgTime);
            text.append(")");
            text.append(", ALL-TPS=").append(all);
            text.append("(").append(allCounter);
            text.append(",").append(allTime);
            text.append(")");
            TestExt.err(text);
        } while (allTime <= seconds * 1000L);
        TestExt.err("Finished");
    }

    static final BigInteger testRSA(byte[] data, BigInteger n, BigInteger e, BigInteger d) {
        BigInteger x = new BigInteger(1, data);
        BigInteger y = x.modPow(e, n);
        BigInteger z = y.modPow(d, n);
        return z;
    }
}

