/*
 * Decompiled with CFR 0.152.
 */
package cfca.sadk.test.softLink.perf;

import cfca.sadk.algorithm.sm2.SM2PublicKey;
import cfca.sadk.lib.crypto.JCrypto;
import cfca.sadk.lib.crypto.Session;
import cfca.sadk.test.TestExt;
import cfca.sadk.util.Base64;
import cfca.sadk.util.CertUtil;
import cfca.sadk.util.EnvelopeUtil;
import cfca.sadk.util.KeyUtil;
import cfca.sadk.util.Signature;
import cfca.sadk.x509.certificate.X509Cert;
import java.math.BigInteger;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.interfaces.RSAPublicKey;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;

public final class SM2PerfTest {
    static final String sm2FileText = "MIIDfAIBATBHBgoqgRzPVQYBBAIBBgcqgRzPVQFoBDDYQoRRu6L+lmHg0SOynJgW0OzlRPkNcY0Js9nnKMnl/4ahDJu0DA72iFLsTdIYftYwggMsBgoqgRzPVQYBBAIBBIIDHDCCAxgwggK9oAMCAQICBTABAnExMAwGCCqBHM9VAYN1BQAwKzELMAkGA1UEBhMCQ04xHDAaBgNVBAoME0NGQ0EgU00yIFRFU1QgT0NBMjEwHhcNMTUwNDAxMDI0NzI4WhcNMTYwNDAxMDI0NzI4WjB0MQswCQYDVQQGEwJDTjENMAsGA1UECgwEQ01CQzESMBAGA1UECwwJQ01CQ19EQ01TMRUwEwYDVQQLDAxJbmRpdmlkdWFsLTExKzApBgNVBAMMIjAzMDVAMDk0NTkxNDM2MTc5MjY0M0B1c2VyMTE1ODI1QDEwWTATBgcqhkjOPQIBBggqgRzPVQGCLQNCAARD8XhkCu3ngLY6ojk6nWfPEAqd6vcttD92gaaOGcKfAtKRwtfxkdw5Z6EZ/T4CkrsZVkKQqFnC4J3h3g8UjeJMo4IBgTCCAX0wHwYDVR0jBBgwFoAU4n62ELuU6xXmrtEVCv/o16BXOZ0wSAYDVR0gBEEwPzA9BghggRyG7yoCAjAxMC8GCCsGAQUFBwIBFiNodHRwOi8vd3d3LmNmY2EuY29tLmNuL3VzL3VzLTEzLmh0bTCBzgYDVR0fBIHGMIHDMIGToIGQoIGNhoGKbGRhcDovLzIxMC43NC40MS4xNjE6Mzg5L2NuPWNybDI1LE9VPVNNMixPVT1DUkwsTz1DRkNBIFNNMiBURVNUIE9DQTIxLEM9Q04/Y2VydGlmaWNhdGVSZXZvY2F0aW9uTGlzdD9iYXNlP29iamVjdGNsYXNzPWNSTERpc3RyaWJ1dGlvblBvaW50MCugKaAnhiVodHRwOi8vMjEwLjc0LjQxLjg3L0NSTC9TTTIvY3JsMjUuY3JsMAsGA1UdDwQEAwID6DAdBgNVHQ4EFgQUVnCnXmNxFTBEckbZvMae92RwPaAwEwYDVR0lBAwwCgYIKwYBBQUHAwIwDAYIKoEcz1UBg3UFAANHADBEAiA7UhQYFiRFVmM6qBQP6VdYf2Itd8/qqcJgajy1cKIc1AIgIbHXJ5jQG2OxMZKKMbGxnpVkbQPzS6o6oMmEiQH3s1Y=";
    static final String sm2FilePass = "123123";
    static final String p12FileText1024 = "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";
    static final String p12FileText2048 = "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";
    static final String p12FilePassword = "123123";
    static long maxTime = 0L;
    static long num = 0L;

    public static void main(String[] args) throws Exception {
        long allTime;
        BigInteger d;
        BigInteger e;
        BigInteger n;
        int bitLength;
        String symmetricAlgorithm;
        String signAlg;
        PublicKey pubKey;
        PrivateKey priKey;
        X509Cert recvcert;
        TestExt.err("[1. Sign 2. Encrypt 4. Decrypt  8. Verify]Commands: <numThread> <seconds> <dataLength> <1|2|4|8> <delay> [-jni] [-rsa1024|rsa2048]");
        boolean jniFlag = false;
        int keyType = 0;
        for (int i = 0; i < args.length; ++i) {
            if ("-jni".equals(args[i])) {
                jniFlag = true;
            }
            if ("-rsa1024".equals(args[i])) {
                keyType = 1;
            }
            if (!"-rsa2048".equals(args[i])) continue;
            keyType = 2;
        }
        String message = "{\businName\":\"\u5145\u503c\",\"businCode\":\"301\",\"otherAcc\":\"6212261211006727590\",\"secuNo\":\"3001\",\"secuAcc\":\"1818005612\",\"currType\":\"156\",\"chgFlag\":\"0\",\"balance\":\"3.00\",\"bankNo\":\"01\",\"p2pResp\":{\"sysDate\":\"20160329\",\"sysTime\":\"091615\",\"serialNo\":\"59520160329054193871\",\"businCode\":\"301\",\"businName\":\"\u5145\u503c\",\"chgFlag\":\"0\",\"secuAcc\":\"1818005612\",\"bankNo\":\"01\",\"otherAcc\":\"6212261211006727590\",\"amt\":\"3.00\",\"currType\":\"156\",\"balance\":\"3.00\",\"cashBala\":\"3.00\",\"vol\":\"0.00\",\"updFlag\":\"0\",\"bindFlag\":\"3\",\"secuOrderId\":\"53701201603291740064860544974381\",\"secuFundAcc\":\"9595101095386001\",\"transOutput\":{\"orderId\":\"53701201603291740064860544974381\",\"secuNo\":\"3001\",\"fundAcc\":\"9595101095386001\",\"transCode\":\"CNP_N000002\",\"outputTime\":\"20160329091615\",\"type\":\"S\"}},\"cashBala\":\"3.00\",\"vol\":\"0.00\",\"sysDate\":\"20160329\",\"retMsg\":\"\u53d8\u52a8\u901a\u77e5\u8bf7\u6c42\u6210\u529f\",\"updFlag\":\"0\",\"notifyUrl\":\"http://www.ypjys.com:50081/accChangeNotify.action\",\"orderId\":\"53701201603291740064860544974381\",\"bindFlag\":\"3\",\"fundAcc\":\"9595101095386001\",\"transInput\":{\"orderId\":\"53701201603291740064860544974381\",\"secuNo\":\"3001\",\"fundAcc\":\"9595101095386001\"},\"bankId\":\"CMBC\",\"sysTime\":\"091615\",\"notifyFlag\":\"1\",\"serialNo\":\"59520160329054193871\",\"amt\":\"3.00\",\"retCode\":\"0000\",\"logSerial\":\"84314439\",\"exSerial\":\"53701201603291740064860544974381\",\"retProduct\":\"Type=S&Code=AAAAAAA\"}";
        if (keyType == 1) {
            recvcert = CertUtil.getCertFromPFX(p12FileText1024.getBytes(), "123123");
            priKey = KeyUtil.getPrivateKeyFromPFX(p12FileText1024.getBytes(), "123123");
            pubKey = recvcert.getPublicKey();
            signAlg = "sha256WithRSAEncryption";
            symmetricAlgorithm = "DESede/CBC/PKCS7Padding";
            bitLength = ((RSAPublicKey)pubKey).getModulus().bitLength();
        } else if (keyType == 2) {
            recvcert = CertUtil.getCertFromPFX(p12FileText2048.getBytes(), "123123");
            priKey = KeyUtil.getPrivateKeyFromPFX(p12FileText2048.getBytes(), "123123");
            pubKey = recvcert.getPublicKey();
            signAlg = "sha256WithRSAEncryption";
            symmetricAlgorithm = "DESede/CBC/PKCS7Padding";
            bitLength = ((RSAPublicKey)pubKey).getModulus().bitLength();
        } else {
            recvcert = CertUtil.getCertFromSM2(sm2FileText.getBytes());
            priKey = KeyUtil.getPrivateKeyFromSM2(sm2FileText.getBytes(), "123123");
            pubKey = recvcert.getPublicKey();
            signAlg = "sm3WithSM2Encryption";
            symmetricAlgorithm = "SM4/CBC/PKCS7Padding";
            bitLength = ((SM2PublicKey)pubKey).getPubX_Int().bitLength();
        }
        final X509Cert[] recvcerts = new X509Cert[]{recvcert};
        int numThread = args.length > 0 ? Integer.parseInt(args[0]) : 64;
        int seconds = args.length > 1 ? Integer.parseInt(args[1]) : 30;
        int dataLength = args.length > 2 ? Integer.parseInt(args[2]) : message.length();
        int operations = args.length > 3 ? Integer.parseInt(args[3]) : 15;
        final int delay = args.length > 4 ? Integer.parseInt(args[4]) : 4000;
        final boolean testSign = (1 & operations) == 1;
        final boolean testEncrypt = (2 & operations) == 2;
        final boolean testDecrypt = (4 & operations) == 4;
        final boolean testVerify = (8 & operations) == 8;
        final boolean testRSA1 = (operations & 0x10) == 16;
        final boolean testRSA2 = (operations & 0x20) == 32;
        final String deviceName = jniFlag ? "JNISOFT_LIB" : "JSOFT_LIB";
        JCrypto.getInstance().initialize(deviceName, null);
        final Session session = JCrypto.getInstance().openSession(deviceName);
        if (dataLength != message.length()) {
            char[] values = new char[dataLength];
            for (int i = 0; i < values.length; ++i) {
                values[i] = 97;
            }
            message = new String(values);
        }
        if (testRSA1) {
            n = new BigInteger("82bef41f7926ca51c992c0c20b11fe862f3216df23307b825cd3b316a4b6706e69ac2196517776157127a732075054d3d37d33f15ea251ebc85c51d55c5ebc83ea91b51a8465356891516dd1895a01c124bbd4de2343dec2a8b79e572ba6d1edaa4b8a4d143346c23ef3727468dba8125495815516fc4f4563bffa75d8481f5b", 16);
            e = new BigInteger("10001", 16);
            d = new BigInteger("57ad906e6ec3599801523d9ba2eadd41c4f2952dec1e3e254cf4d6bb4f97dccbde67855a95a543f5db1d195d4e544b9e85cc07824cd11398c793497988692b876067541e34eccfbeeba431e2652fdd59cb055b9c322d7c84191bd4702494b8e321c3a03cae230dcd4210d3cbb0b42f6e30f9b09020489fd57490e7bc10fa2c81", 16);
        } else {
            n = new BigInteger("eff9c88984fee2904e11a67a9bf626f7671e272fe7115d333c2e456299402e18f7fd73c0f93d9a1b6ea3122e116de31d94885bc3b3a10d7c14b444f09bf11f48ecaeae9b4a64253df8345edf08afe7d1dd6a116c9ba468c17218b56fc143a9098ff0caa9ae3d62b988204b0b5dacc8b04622630cafc35845124afea36fffb27ed0a14f125878a007e3b49203b5d78e15356c33fbf2216401d9aedad33b007e157ab0fe84b307e35d7375d96c8bb88df7522f3dced8570a36067a6928fd47cf3084aa53f1527e9b90d0db9af4a8ac58f1bc28d7bb22e57460a04ecd8033e7adb5b68e834eb8078adf4f1e8517304df8d7c9d487d8c9102db95dffd0820e5bfb41", 16);
            e = new BigInteger("10001", 16);
            d = new BigInteger("2ccfca00d412fc9fd1d43df03b5b75df5124325121a6fe6e68d883206c59adc1ffdd16567cb46228a93a4e54c7f06b2ec4e3c9aefbc6214c8059415e64e05be5343d5261b13c8e2fca3f8d4fbcc18c5a862c1e60d79795f039ac1f8564e38b973b87cd706e170c6e74db02e8766fa372374688947fe5cc7fe97093a8556bbc1ad1aaa28992155463461df46c975e32b0a0850334bc18bd74d730bef6b5a4aa80f55a1990bfbb7a857970d910a0a7f1c6ac0f2e386df6f0ea64e3bb458ab382a80c6b6a94f09737ae7e930a372657f3c79b5631ce31bd604f3c87348d769177aa9bfe2580beb003347b575a5144ed62df7239e24cb67dc0fa8dcf63892ce5ada1", 16);
        }
        if (testRSA1 || testRSA2) {
            TestExt.err("nLength: " + n.bitLength());
            TestExt.err("eLength: " + e.bitLength());
            TestExt.err("dLength: " + d.bitLength());
        }
        final byte[] data = new byte[128];
        if (testRSA1 || testRSA2) {
            for (int i = 0; i < data.length; ++i) {
                data[i] = 97;
            }
            data[0] = 0;
        }
        Signature signatureUtil2 = new Signature();
        final byte[] base64SignedData = signatureUtil2.p1SignMessage(signAlg, message.getBytes(), priKey, session);
        final byte[] base64EnvelopeMessage = testSign && testEncrypt || testDecrypt && testVerify ? EnvelopeUtil.envelopeMessage(Base64.decode(base64SignedData), symmetricAlgorithm, recvcerts, session) : EnvelopeUtil.envelopeMessage(message.getBytes(), symmetricAlgorithm, recvcerts, session);
        final String sourceText = message;
        Thread[] testThreads = new Thread[numThread];
        for (int i = 0; i < testThreads.length; ++i) {
            testThreads[i] = new Thread(new Runnable(){

                public void run() {
                    Signature util = new Signature();
                    byte[] sourceData = sourceText.getBytes();
                    if (testRSA1 || testRSA2) {
                        sourceData[0] = 0;
                    }
                    byte[] signedData = testSign || testVerify ? base64SignedData : sourceData;
                    byte[] base64EnvelopedData = base64EnvelopeMessage;
                    while (true) {
                        try {
                            while (true) {
                                long timer0 = System.currentTimeMillis();
                                if (testSign) {
                                    signedData = util.p1SignMessage(signAlg, sourceData, priKey, session);
                                }
                                long timer1 = System.currentTimeMillis();
                                if (testEncrypt) {
                                    if (testSign) {
                                        signedData = Base64.decode(signedData);
                                        timer1 = System.currentTimeMillis();
                                    }
                                    base64EnvelopedData = EnvelopeUtil.envelopeMessage(signedData, symmetricAlgorithm, recvcerts, session);
                                }
                                long timer2 = System.currentTimeMillis();
                                if (testDecrypt) {
                                    signedData = EnvelopeUtil.openEvelopedMessage(base64EnvelopedData, priKey, recvcert, session);
                                }
                                long timer3 = System.currentTimeMillis();
                                if (testVerify) {
                                    boolean verifyResult;
                                    if (testDecrypt) {
                                        signedData = Base64.encode(signedData);
                                        timer3 = System.currentTimeMillis();
                                    }
                                    if (!(verifyResult = util.p1VerifyMessage(signAlg, sourceData, signedData, pubKey, session))) {
                                        TestExt.err("Failure");
                                    }
                                }
                                long timer4 = System.currentTimeMillis();
                                if (testRSA1 || testRSA2) {
                                    SM2PerfTest.testRSA(data, n, e, d);
                                }
                                long timer5 = System.currentTimeMillis();
                                long max = timer4 - timer0;
                                if (max > maxTime) {
                                    maxTime = max;
                                }
                                if (max > (long)delay) {
                                    StringBuilder message = new StringBuilder();
                                    message.append(new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(new Date()));
                                    message.append(" maxTime=").append(max);
                                    message.append("(");
                                    message.append(", T1Sign=").append(timer1 - timer0);
                                    message.append(", T2Encrypt=").append(timer2 - timer1);
                                    message.append(", T3Decrypt=").append(timer3 - timer2);
                                    message.append(", T4Verify=").append(timer4 - timer3);
                                    message.append(", T5RSA=").append(timer5 - timer4);
                                    message.append(", deviceName=").append(deviceName);
                                    message.append(")");
                                    TestExt.err(message);
                                }
                                ++num;
                            }
                        }
                        catch (Exception e2) {
                            e2.printStackTrace();
                            continue;
                        }
                        break;
                    }
                }
            });
            testThreads[i].setDaemon(true);
        }
        long sTime = System.currentTimeMillis();
        long xTime = System.currentTimeMillis();
        for (int i = 0; i < testThreads.length; ++i) {
            testThreads[i].start();
        }
        long yTime = System.currentTimeMillis();
        long allCounter = 0L;
        long avgCounter = 0L;
        long avgTime = 0L;
        do {
            Thread.sleep(5000L);
            avgCounter = num;
            yTime = System.currentTimeMillis();
            avgTime = yTime - xTime;
            xTime = System.currentTimeMillis();
            num = 0L;
            allTime = System.currentTimeMillis() - sTime;
            long avg = 1000L * avgCounter / avgTime;
            long all = 1000L * (allCounter += avgCounter) / allTime;
            StringBuilder text = new StringBuilder();
            text.append(new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(new Date()));
            text.append(" commands=").append(Arrays.asList(args));
            text.append(", numThread=").append(numThread);
            text.append(", seconds=").append(seconds);
            text.append(", dataLength=").append(dataLength);
            text.append(", operations=").append(operations);
            text.append(", maxTime=").append(maxTime);
            text.append(", AVG-TPS=").append(avg);
            text.append("(").append(avgCounter);
            text.append(",").append(avgTime);
            text.append(")");
            text.append(", ALL-TPS=").append(all);
            text.append("(").append(allCounter);
            text.append(",").append(allTime);
            text.append(")");
            text.append(", keyType=").append(pubKey.getAlgorithm());
            text.append(", bitLength=").append(bitLength);
            text.append(", deviceName=").append(deviceName);
            TestExt.err(text);
        } while (allTime <= (long)(seconds * 1000));
        TestExt.err("Finished");
    }

    static final BigInteger testRSA(byte[] data, BigInteger n, BigInteger e, BigInteger d) {
        BigInteger x = new BigInteger(1, data);
        BigInteger y = x.modPow(e, n);
        BigInteger z = y.modPow(d, n);
        return z;
    }
}

