/*
 * Decompiled with CFR 0.152.
 */
package cfca.sadk.test.cardLink.perf;

import cfca.sadk.algorithm.common.CBCParam;
import cfca.sadk.algorithm.common.Mechanism;
import cfca.sadk.lib.crypto.JCrypto;
import cfca.sadk.lib.crypto.card.CardLib;
import cfca.sadk.test.TestExt;
import cfca.sadk.test.cardLink.perf.RPTThread;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import javax.crypto.spec.SecretKeySpec;

public final class SM4PerfTestJava {
    public static void main(String[] args) throws Exception {
        int i;
        TestExt.err("[1. Sign 2. Encrypt 4. Decrypt  8. Verify]Commands: <numThread> <seconds> <dataLength> <1|2|4|8> <delay>");
        int numThread = args.length > 0 ? Integer.parseInt(args[0]) : 64;
        int seconds = args.length > 1 ? Integer.parseInt(args[1]) : 600000;
        int dataLength = args.length > 2 ? Integer.parseInt(args[2]) : 48;
        int operations = args.length > 3 ? Integer.parseInt(args[3]) : 2;
        final int delay = args.length > 4 ? Integer.parseInt(args[4]) : 4000;
        String deviceName = "JCARD_LIB";
        JCrypto.getInstance().initialize("JCARD_LIB", "config/card-cfca.ini");
        final CardLib session = new CardLib("config/card-cfca.ini");
        final boolean testSM4Encrypt = (1 & operations) == 1;
        final boolean testSM4Decrypt = (2 & operations) == 2;
        final byte[] data = new byte[dataLength];
        for (int i2 = 0; i2 < dataLength; ++i2) {
            data[i2] = (byte)i2;
        }
        final SecretKeySpec key = new SecretKeySpec("12345678abcd90be".getBytes(), "SM4");
        final Mechanism mechanism = new Mechanism("SM4/CBC/PKCS7Padding", new CBCParam("abcdefgh12345678".getBytes()));
        final byte[] encryptData = session.encrypt(mechanism, key, data);
        byte[] decryptData = session.decrypt(mechanism, key, encryptData);
        TestExt.err(Arrays.equals(decryptData, data));
        final RPTThread reportThread = new RPTThread(numThread, args, seconds, dataLength, operations);
        Thread[] testThreads = new Thread[numThread];
        for (i = 0; i < testThreads.length; ++i) {
            testThreads[i] = new Thread(new Runnable(){

                public void run() {
                    byte[] encryptBytes = encryptData;
                    byte[] decryptBytes = null;
                    while (true) {
                        try {
                            while (true) {
                                long timer2;
                                long max;
                                long timer0 = System.currentTimeMillis();
                                if (testSM4Encrypt) {
                                    encryptBytes = session.encrypt(mechanism, key, data);
                                }
                                long timer1 = System.currentTimeMillis();
                                if (testSM4Decrypt && !Arrays.equals(decryptBytes = session.decrypt(mechanism, key, encryptBytes), data)) {
                                    ++reportThread.failure;
                                }
                                if ((max = (timer2 = System.currentTimeMillis()) - timer0) > reportThread.maxTime) {
                                    reportThread.maxTime = max;
                                }
                                if (max > (long)delay) {
                                    StringBuilder message = new StringBuilder();
                                    message.append(new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(new Date()));
                                    message.append(" maxTime=").append(max);
                                    message.append("(");
                                    message.append(",SM4Encrypt=").append(timer1 - timer0);
                                    message.append(",SM4Encrypt=").append(timer2 - timer1);
                                    message.append(",SM4Failure=").append(reportThread.failure);
                                    message.append(")");
                                    TestExt.err(message);
                                }
                                ++reportThread.num;
                            }
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                            continue;
                        }
                        break;
                    }
                }
            });
            testThreads[i].setDaemon(true);
        }
        for (i = 0; i < testThreads.length; ++i) {
            testThreads[i].start();
        }
        reportThread.run();
    }
}

