/*
 * Decompiled with CFR 0.152.
 */
package cfca.sadk.test.cardLink.perf;

import cfca.sadk.algorithm.common.GenKeyAttribute;
import cfca.sadk.algorithm.common.Mechanism;
import cfca.sadk.lib.crypto.JCrypto;
import cfca.sadk.lib.crypto.Session;
import cfca.sadk.lib.crypto.bcsoft.BCSoftLib;
import cfca.sadk.system.FileHelper;
import cfca.sadk.test.TestExt;
import cfca.sadk.test.cardLink.perf.RPTThread;
import cfca.sadk.util.EnvelopeUtil;
import cfca.sadk.util.Signature;
import cfca.sadk.x509.certificate.X509Cert;
import java.security.KeyPair;
import java.security.PrivateKey;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.Random;

public final class SM2PerfTestCardP7AttachRandom {
    public static void main(String[] args) throws Exception {
        int i;
        TestExt.err("[1. Sign 2. Encrypt 4. Decrypt  8. Verify]Commands: <numThread> <seconds> <dataLength> <1|2|4|8> <delay>");
        int numThread = args.length > 0 ? Integer.parseInt(args[0]) : 64;
        int seconds = args.length > 1 ? Integer.parseInt(args[1]) : 600000;
        int dataLength = args.length > 2 ? Integer.parseInt(args[2]) : 1024;
        int operations = args.length > 3 ? Integer.parseInt(args[3]) : 15;
        final int delay = args.length > 4 ? Integer.parseInt(args[4]) : 4000;
        final boolean testSign = (1 & operations) == 1;
        final boolean testEncrypt = (2 & operations) == 2;
        final boolean testDecrypt = (4 & operations) == 4;
        final boolean testVerify = (8 & operations) == 8;
        final byte[] data = new byte[dataLength];
        for (int i2 = 0; i2 < dataLength; ++i2) {
            data[i2] = (byte)i2;
        }
        String deviceName = "JCARD_LIB";
        JCrypto.getInstance().initialize("JCARD_LIB", "config/card-cfca.ini");
        final Session session = JCrypto.getInstance().openSession("JCARD_LIB");
        KeyPair signKeypair = session.generateKeyPair(new Mechanism("SM2", new GenKeyAttribute(false, 1)), 0);
        final X509Cert signCert = TestExt.buildX509CertGenerator(signKeypair.getPrivate(), signKeypair.getPublic(), session);
        final PrivateKey signPrivateKey = signKeypair.getPrivate();
        String signAlg = "sm3WithSM2Encryption";
        final Signature signatureUtil = new Signature();
        KeyPair encxKeypair = session.generateKeyPair(new Mechanism("SM2", new GenKeyAttribute(false, 1, 1)), 0);
        final PrivateKey encxPrivateKey = encxKeypair.getPrivate();
        String symmetricAlgorithm = "SM4/CBC/PKCS7Padding";
        final X509Cert recipient = TestExt.buildX509CertGenerator(signKeypair.getPrivate(), encxKeypair.getPublic(), session);
        final X509Cert[] receivers = new X509Cert[]{recipient};
        if ((operations & 0x1F) == 31) {
            byte[] base64EnvelopeMessage = null;
            byte[] decryptData = null;
            base64EnvelopeMessage = EnvelopeUtil.envelopeMessage(data, "SM4/CBC/PKCS7Padding", receivers, session);
            decryptData = EnvelopeUtil.openEvelopedMessage(base64EnvelopeMessage, encxPrivateKey, recipient, session);
            TestExt.err("Envelope: " + Arrays.equals(decryptData, data));
            base64EnvelopeMessage = EnvelopeUtil.envelopeMessage(data, "SM4/CBC/PKCS7Padding", receivers, new BCSoftLib());
            decryptData = EnvelopeUtil.openEvelopedMessage(base64EnvelopeMessage, encxPrivateKey, recipient, session);
            TestExt.err("Envelope: " + Arrays.equals(decryptData, data));
            base64EnvelopeMessage = EnvelopeUtil.envelopeMessage(data, "SM4/CBC/PKCS7Padding", receivers, session);
            decryptData = EnvelopeUtil.openEvelopedMessage(base64EnvelopeMessage, encxPrivateKey, recipient, session);
            TestExt.err("Envelope: " + Arrays.equals(decryptData, data));
            String sourceFilePath = "/tmp/data.dat";
            String outEncryptFilePath = "/tmp/data.env";
            String outDecryptFilePath = "/tmp/data.dev";
            FileHelper.write("/tmp/data.dat", data);
            EnvelopeUtil.envelopeFile("/tmp/data.dat", "/tmp/data.env", "SM4/CBC/PKCS7Padding", receivers, session);
            EnvelopeUtil.openEnvelopedFile("/tmp/data.env", "/tmp/data.dev", encxPrivateKey, recipient, session);
            decryptData = FileHelper.read("/tmp/data.dev");
            TestExt.err("Envelope: " + Arrays.equals(decryptData, data));
            FileHelper.write("/tmp/data.dat", data);
            EnvelopeUtil.envelopeFile("/tmp/data.dat", "/tmp/data.env", "SM4/CBC/PKCS7Padding", receivers, new BCSoftLib());
            EnvelopeUtil.openEnvelopedFile("/tmp/data.env", "/tmp/data.dev", encxPrivateKey, recipient, session);
            decryptData = FileHelper.read("/tmp/data.dev");
            TestExt.err("Envelope: " + Arrays.equals(decryptData, data));
        }
        final byte[] base64P7SignedData = signatureUtil.p7SignMessageAttach("sm3WithSM2Encryption", data, signPrivateKey, signCert, session);
        final byte[] base64EnvelopeMessage = EnvelopeUtil.envelopeMessage(data, "SM4/CBC/PKCS7Padding", receivers, session);
        boolean verifyResult = false;
        byte[] base64P7SignedBytes = base64P7SignedData;
        byte[] base64EnvelopeBytes = base64EnvelopeMessage;
        byte[] decryptData = null;
        Random random = new Random();
        random.nextBytes(data);
        base64P7SignedBytes = signatureUtil.p7SignMessageAttach("sm3WithSM2Encryption", data, signPrivateKey, signCert, session);
        base64EnvelopeBytes = EnvelopeUtil.envelopeMessage(data, "SM4/CBC/PKCS7Padding", receivers, session);
        decryptData = EnvelopeUtil.openEvelopedMessage(base64EnvelopeBytes, encxPrivateKey, recipient, session);
        final RPTThread reportThread = new RPTThread(numThread, args, seconds, dataLength, operations);
        if (!Arrays.equals(decryptData, data)) {
            ++reportThread.failure;
        }
        if (!(verifyResult = signatureUtil.p7VerifyMessageAttach(base64P7SignedBytes, session))) {
            ++reportThread.failure;
        }
        Thread[] testThreads = new Thread[numThread];
        for (i = 0; i < testThreads.length; ++i) {
            testThreads[i] = new Thread(new Runnable(){

                public void run() {
                    boolean verifyResult = false;
                    byte[] base64P7SignedBytes = (byte[])base64P7SignedData.clone();
                    byte[] base64EnvelopeBytes = (byte[])base64EnvelopeMessage.clone();
                    byte[] decryptData = null;
                    byte[] sourceData = (byte[])data.clone();
                    Random random = new Random();
                    while (true) {
                        try {
                            while (true) {
                                long timer4;
                                long max;
                                long timer0 = System.currentTimeMillis();
                                if (testSign) {
                                    random.nextBytes(sourceData);
                                    base64P7SignedBytes = signatureUtil.p7SignMessageAttach("sm3WithSM2Encryption", sourceData, signPrivateKey, signCert, session);
                                }
                                long timer1 = System.currentTimeMillis();
                                if (testEncrypt) {
                                    base64EnvelopeBytes = EnvelopeUtil.envelopeMessage(sourceData, "SM4/CBC/PKCS7Padding", receivers, session);
                                }
                                long timer2 = System.currentTimeMillis();
                                if (testDecrypt && !Arrays.equals(decryptData = EnvelopeUtil.openEvelopedMessage(base64EnvelopeBytes, encxPrivateKey, recipient, session), sourceData)) {
                                    ++reportThread.failure;
                                }
                                long timer3 = System.currentTimeMillis();
                                if (testVerify && !(verifyResult = signatureUtil.p7VerifyMessageAttach(base64P7SignedBytes, session))) {
                                    ++reportThread.failure;
                                }
                                if ((max = (timer4 = System.currentTimeMillis()) - timer0) > reportThread.maxTime) {
                                    reportThread.maxTime = max;
                                }
                                if (max > (long)delay) {
                                    StringBuilder message = new StringBuilder();
                                    message.append(new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(new Date()));
                                    message.append(" maxTime=").append(max);
                                    message.append("(");
                                    message.append(", T1Sign=").append(timer1 - timer0);
                                    message.append(", T2Encrypt=").append(timer2 - timer1);
                                    message.append(", T3Decrypt=").append(timer3 - timer2);
                                    message.append(", T4Verify=").append(timer4 - timer3);
                                    message.append(", TxFailure=").append(reportThread.failure);
                                    message.append(")");
                                    TestExt.err(message);
                                }
                                ++reportThread.num;
                            }
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                            continue;
                        }
                        break;
                    }
                }
            });
            testThreads[i].setDaemon(true);
        }
        for (i = 0; i < testThreads.length; ++i) {
            testThreads[i].start();
        }
        reportThread.run();
    }
}

