/*
 * Decompiled with CFR 0.152.
 */
package cfca.sadk.test.cardLink.bind.perf;

import cfca.sadk.algorithm.common.Mechanism;
import cfca.sadk.algorithm.sm2.SM2PublicKey;
import cfca.sadk.lib.crypto.Session;
import cfca.sadk.lib.crypto.jni.JNISoftLib;
import cfca.sadk.org.bouncycastle.jcajce.provider.asymmetric.sm.SM2Params;
import cfca.sadk.test.TestExt;
import cfca.sadk.test.cardLink.bind.perf.OperationParams;
import cfca.sadk.test.cardLink.bind.perf.RPTThread;
import cfca.sadk.util.HashUtil;
import java.security.KeyPair;

public final class TestCardSM3 {
    public static void main(String[] args) throws Exception {
        int i;
        final OperationParams params = new OperationParams(args);
        final RPTThread report = new RPTThread(params.numThread, args, params.seconds, params.dataLength, params.operations);
        report.setDaemon(true);
        report.start();
        final byte[] data = params.data;
        Session session = params.session;
        KeyPair keypair = session.generateKeyPair(new Mechanism("SM2"), 256);
        final SM2PublicKey publicKey = (SM2PublicKey)keypair.getPublic();
        final byte[] userId = SM2Params.getDefaultuserid();
        final boolean jniFlag = session instanceof JNISoftLib;
        Thread[] testThreads = new Thread[params.numThread];
        for (i = 0; i < testThreads.length; ++i) {
            testThreads[i] = new Thread(new Runnable(){

                public void run() {
                    while (true) {
                        try {
                            while (true) {
                                if (params.testSign) {
                                    if (jniFlag) {
                                        HashUtil.SM2HashMessageByJNIWithoutZValue(data);
                                    } else {
                                        HashUtil.SM2HashMessageByBCWithoutZValue(data);
                                    }
                                }
                                if (params.testEncrypt) {
                                    if (jniFlag) {
                                        HashUtil.SM2HashMessageByJNIWithZValue(userId, data, publicKey.getPubX(), publicKey.getPubY());
                                    } else {
                                        HashUtil.SM2HashMessageByBCWithZValue(userId, data, publicKey.getPubX_Int(), publicKey.getPubYByInt());
                                    }
                                }
                                report.records.incrementAndGet();
                                ++report.allNumb;
                            }
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                            continue;
                        }
                        break;
                    }
                }
            });
            testThreads[i].setDaemon(true);
        }
        for (i = 0; i < testThreads.length; ++i) {
            testThreads[i].start();
        }
        Thread.sleep(5000 + params.seconds * 1000);
        TestExt.err(String.format("@Finished: proc=%-3d,bind=%-3d,all=%d", params.process, params.binding, report.allNumb));
    }
}

