/*
 * Decompiled with CFR 0.152.
 */
package cfca.sadk.test.cardLink.bind.perf;

import cfca.sadk.test.TestExt;
import cfca.sadk.test.cardLink.bind.perf.Conf;
import cfca.sadk.test.cardLink.bind.perf.OperationParams;
import cfca.sadk.test.cardLink.bind.perf.RPTThread;
import cfca.sadk.test.cardLink.bind.perf.SM2KTest;
import cfca.sadk.util.Base64;
import cryptokit.jni.JNIP11;

public final class TestCardJNISM2NoneInitExt {
    static final int CKM_SM2_WITH_Z = 1;
    static final int CKM_SM2_SIGN_VERIFY = 65538;
    static final int CKM_SM2_EXTERNAL_VERIFY = 65548;
    static final int CKM_SM2_EXTERNAL_ENCRYPT = 65549;

    public static void main(String[] args) throws Exception {
        int i;
        final OperationParams params = new OperationParams(args);
        final RPTThread report = new RPTThread(params.numThread, args, params.seconds, params.dataLength, params.operations);
        report.setDaemon(true);
        report.start();
        byte[] data = params.data;
        Conf conf = new Conf("config/card-cfca.ini");
        final JNIP11 jni = new JNIP11();
        jni.loadLib(conf.p11LibPath);
        jni.init();
        byte[] password = conf.p11Password.getBytes("UTF8");
        int[] tokens = new int[16];
        int tokenNum = jni.getTokenList(tokens);
        for (int i2 = 0; i2 < tokenNum; ++i2) {
            jni.getTokenInfo(tokens[i2]);
        }
        final int token = conf.cardToken;
        long sessionHandleG = jni.openSession(token);
        jni.login(sessionHandleG, (int)jni.CKU_USER, password, password.length);
        jni.getCKIDList(sessionHandleG);
        byte[] pubXY = Base64.decode("Q/F4ZArt54C2OqI5Op1nzxAKner3LbQ/doGmjhnCnwLSkcLX8ZHcOWehGf0+ApK7GVZCkKhZwuCd4d4PFI3iTA==");
        byte[] hashValue = Base64.decode("jfAhbn6vtPgRR3qdjJXKOi3PLSuDIBgoRp6Ij5p7Al0=");
        final byte[] signValue = Base64.decode("2fpVLVz4fhKSpF+WKz9hOQyqt0kNWS3Sya+o8vKbGTSG2ni1IloIHsBP/83btO+bbORUCVcDvYKLRG3rKPGlsw==");
        final byte[] sourceExternaDataV = SM2KTest.buildExternalData(hashValue, pubXY);
        jni.verifyInit(sessionHandleG, 0L, 65548, 1);
        jni.verify(sessionHandleG, sourceExternaDataV, signValue);
        final byte[] sourceExternaDataE = SM2KTest.buildExternalData(data, pubXY);
        final byte[] encryptData = new byte[96 + data.length];
        jni.encryptInit(sessionHandleG, 0L, 65549);
        jni.encryptMsg(sessionHandleG, sourceExternaDataE, encryptData);
        Thread[] testThreads = new Thread[params.numThread];
        for (i = 0; i < testThreads.length; ++i) {
            testThreads[i] = new Thread(new Runnable(){

                public void run() {
                    long sessionHandle;
                    try {
                        sessionHandle = jni.openSession(token);
                        if (params.testEncrypt) {
                            jni.encryptInit(sessionHandle, 0L, 65549);
                        }
                        if (params.testVerify) {
                            jni.verifyInit(sessionHandle, 0L, 65548, 1);
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        return;
                    }
                    while (true) {
                        try {
                            while (true) {
                                int returnValue;
                                if (params.testEncrypt) {
                                    jni.encryptMsg(sessionHandle, sourceExternaDataE, encryptData);
                                }
                                if (params.testVerify && (returnValue = jni.verify(sessionHandle, sourceExternaDataV, signValue)) != 0) {
                                    ++report.failure;
                                }
                                report.records.incrementAndGet();
                                ++report.allNumb;
                            }
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                            continue;
                        }
                        break;
                    }
                }
            });
            testThreads[i].setDaemon(true);
        }
        for (i = 0; i < testThreads.length; ++i) {
            testThreads[i].start();
        }
        Thread.sleep(5000 + params.seconds * 1000);
        TestExt.err(String.format("@Finished: proc=%-3d,bind=%-3d,all=%d", params.process, params.binding, report.allNumb));
    }
}

