/*
 * Decompiled with CFR 0.152.
 */
package cfca.sadk.test.cardLink.bind.perf;

import cfca.sadk.algorithm.common.GenKeyAttribute;
import cfca.sadk.algorithm.common.Mechanism;
import cfca.sadk.lib.crypto.Session;
import cfca.sadk.org.bouncycastle.jce.provider.BouncyCastleProvider;
import cfca.sadk.test.TestExt;
import cfca.sadk.test.cardLink.bind.perf.OperationParams;
import cfca.sadk.test.cardLink.bind.perf.RPTThread;
import cfca.sadk.util.Signature;
import java.security.KeyPair;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.Security;

public final class TestCardECCP1Detach {
    public static void main(String[] args) throws Exception {
        int i;
        Security.addProvider(new BouncyCastleProvider());
        final OperationParams params = new OperationParams(args);
        final RPTThread report = new RPTThread(params.numThread, args, params.seconds, params.dataLength, params.operations);
        report.setDaemon(true);
        report.start();
        final byte[] data = params.data;
        final Session session = params.session;
        KeyPair signKeypair = session.generateKeyPair(new Mechanism("sha256WithECDSAEncryption", new GenKeyAttribute(false, 51)), 0);
        final PrivateKey signPrivateKey = signKeypair.getPrivate();
        final PublicKey signPublicKey = signKeypair.getPublic();
        String signAlg = "sha256WithECDSAEncryption";
        final Signature signatureUtil = new Signature();
        final byte[] base64SignedData = signatureUtil.p1SignMessage("sha256WithECDSAEncryption", data, signPrivateKey, session);
        Thread[] testThreads = new Thread[params.numThread];
        for (i = 0; i < testThreads.length; ++i) {
            testThreads[i] = new Thread(new Runnable(){

                public void run() {
                    boolean verifyResult = false;
                    byte[] base64SignedBytes = base64SignedData;
                    while (true) {
                        try {
                            while (true) {
                                if (params.testSign) {
                                    signatureUtil.p1SignMessage("sha256WithECDSAEncryption", data, signPrivateKey, session);
                                }
                                if (params.testVerify && !(verifyResult = signatureUtil.p1VerifyMessage("sha256WithECDSAEncryption", data, base64SignedBytes, signPublicKey, session))) {
                                    ++report.failure;
                                }
                                report.records.incrementAndGet();
                                ++report.allNumb;
                            }
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                            continue;
                        }
                        break;
                    }
                }
            });
            testThreads[i].setDaemon(true);
        }
        for (i = 0; i < testThreads.length; ++i) {
            testThreads[i].start();
        }
        Thread.sleep(5000 + params.seconds * 1000);
        TestExt.err(String.format("@Finished: proc=%-3d,bind=%-3d,all=%d", params.process, params.binding, report.allNumb));
    }
}

