/*
 * Decompiled with CFR 0.152.
 */
package cfca.sadk.test.cardLink.bind.perf;

import cfca.sadk.test.TestExt;
import cfca.sadk.test.cardLink.bind.perf.CPUThread;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.Formatter;
import java.util.concurrent.atomic.AtomicLong;

public final class RPTThread
extends Thread {
    long maxTime = 0L;
    final AtomicLong records = new AtomicLong(0L);
    long allNumb = 0L;
    int failure = 0;
    final int numThread;
    final String[] args;
    final long seconds;
    final int dataLength;
    final int operations;
    final CPUThread CPUThread;

    public RPTThread(int numThread, String[] args, long seconds, int dataLength, int operations) {
        this.numThread = numThread;
        this.args = args;
        this.seconds = seconds;
        this.dataLength = dataLength;
        this.operations = operations;
        this.CPUThread = new CPUThread();
        this.CPUThread.setDaemon(true);
        this.CPUThread.start();
    }

    public void run() {
        String timeText = System.getenv("bind.time");
        String procText = System.getenv("bind.proc");
        String coreText = System.getenv("bind.core");
        long runtime = timeText == null || timeText.equals("null") ? -1L : (long)Integer.parseInt(timeText);
        long process = procText == null || procText.equals("null") ? -1L : (long)Integer.parseInt(procText);
        long binding = coreText == null || coreText.equals("null") ? -1L : (long)Integer.parseInt(coreText);
        long nanoTime = 1000000000L;
        long maxRunNanoseconds = (5L + (runtime > 0L ? runtime : this.seconds)) * 1000000000L;
        long avgRunNanoseconds = 0L;
        long avgNumb = 0L;
        TestExt.err(String.format("@Running: proc=%-3d,bind=%-3d,runtime=%d", process, binding, runtime));
        long sTime = System.nanoTime();
        long yTime = System.nanoTime();
        long xTime = System.nanoTime();
        while (true) {
            try {
                long hasRunNanoseconds;
                do {
                    Thread.sleep(5000L);
                    avgNumb = this.records.get();
                    yTime = System.nanoTime();
                    avgRunNanoseconds = yTime - xTime;
                    xTime = System.nanoTime();
                    this.records.set(0L);
                    hasRunNanoseconds = System.nanoTime() - sTime;
                    long avgPerf = 1000000000L * avgNumb / avgRunNanoseconds;
                    long allPerf = 1000000000L * this.allNumb / hasRunNanoseconds;
                    String date = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.S").format(new Date());
                    Formatter formatter = new Formatter();
                    formatter.format("@Agerage: ", new Object[0]);
                    formatter.format("proc=%-3d,", process);
                    formatter.format("bind=%-3d,", binding);
                    formatter.format("tps-avg=%-7d@<<<%12d/%-6d>>>,", avgPerf, avgNumb, avgRunNanoseconds / 1000000000L);
                    formatter.format("tps-all=%-7d@<<<%12d/%-6d>>>,", allPerf, this.allNumb, hasRunNanoseconds / 1000000000L);
                    formatter.format("date=%s,", date);
                    formatter.format("hasRunNanoseconds=%d,", hasRunNanoseconds);
                    formatter.format("maxRunNanoseconds=%d,", maxRunNanoseconds);
                    formatter.format("commands=%s,", Arrays.asList(this.args));
                    formatter.format("numThread=%d,", this.numThread);
                    formatter.format("seconds=%d,", this.seconds);
                    formatter.format("dataLength=%d,", this.dataLength);
                    formatter.format("operations=%d,", this.operations);
                    formatter.format("maxTime=%d,", this.maxTime);
                    formatter.format("failure=%d,", this.failure);
                    formatter.format("cpuInfo=%s", this.CPUThread.cpuInfo);
                    TestExt.println(formatter);
                } while (hasRunNanoseconds <= maxRunNanoseconds);
                TestExt.err(String.format("@Finished: proc=%-3d,bind=%-3d,runtime=%d", process, binding, runtime));
                System.exit(-1);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
                continue;
            }
            break;
        }
    }
}

