/*
 * Decompiled with CFR 0.152.
 */
package cfca.sadk.test.cardLink.bind.perf;

import cfca.sadk.algorithm.common.PKIException;
import cfca.sadk.lib.crypto.JCrypto;
import cfca.sadk.lib.crypto.Session;
import cfca.sadk.lib.crypto.card.CardLibParams;
import cfca.sadk.lib.crypto.card.c200.SM2CardInfo;
import cfca.sadk.test.TestExt;
import cfca.sadk.test.cardLink.bind.perf.TestCardConf;
import java.util.Formatter;

public final class OperationParams {
    final long runtime;
    final long process;
    final long binding;
    final int numThread;
    final int seconds;
    final int dataLength;
    final int operations;
    final boolean testSign;
    final boolean testEncrypt;
    final boolean testDecrypt;
    final boolean testVerify;
    final byte[] data;
    final Session session;

    OperationParams(String[] args) throws PKIException {
        String timeText = System.getenv("bind.time");
        String procText = System.getenv("bind.proc");
        String coreText = System.getenv("bind.core");
        this.runtime = timeText == null || timeText.equals("null") ? -1L : (long)Integer.parseInt(timeText);
        this.process = procText == null || procText.equals("null") ? -1L : (long)Integer.parseInt(procText);
        this.binding = coreText == null || coreText.equals("null") ? -1L : (long)Integer.parseInt(coreText);
        this.numThread = args.length > 0 ? Integer.parseInt(args[0]) : 64;
        int seconds = args.length > 1 ? Integer.parseInt(args[1]) : 60;
        this.dataLength = args.length > 2 ? Integer.parseInt(args[2]) : 1024;
        this.operations = args.length > 3 ? Integer.parseInt(args[3]) : 1;
        this.seconds = this.runtime > 0L ? (int)this.runtime : seconds;
        this.testSign = (1 & this.operations) == 1;
        this.testEncrypt = (2 & this.operations) == 2;
        this.testDecrypt = (4 & this.operations) == 4;
        this.testVerify = (8 & this.operations) == 8;
        this.data = new byte[this.dataLength];
        for (int i = 0; i < this.dataLength; ++i) {
            this.data[i] = (byte)i;
        }
        long sessionType = 0L;
        boolean shutdownLog = false;
        for (int i = 4; i < args.length; ++i) {
            if (args[i].startsWith("sessionType=")) {
                int num = Integer.parseInt(args[i].substring("sessionType=".length(), args[i].length()));
                long l = sessionType = (long)num > sessionType ? (long)num : sessionType;
            }
            if (!args[i].startsWith("shutdownLog")) continue;
            shutdownLog = args[i].startsWith("shutdownLog");
        }
        this.session = this.session((int)sessionType);
        if (!shutdownLog) {
            Formatter builder = new Formatter();
            builder.format("\nTestCommands>>>>>>>commands: <numThread> <seconds> <dataLength> <operations>  [sessionType=<0|1|10|11>]", new Object[0]);
            builder.format("\nTestCommands>>>>>>>commands: 64 30 1024 1", new Object[0]);
            builder.format("\nTestCommands>>>>>>>commands: 64 30 1024 2", new Object[0]);
            builder.format("\nTestCommands>>>>>>>commands: 64 30 1024 4", new Object[0]);
            builder.format("\nTestCommands>>>>>>>commands: 64 30 1024 8", new Object[0]);
            builder.format("\nTestCommands>>>>>>>commands: 64 30 1024 1 sessionType=10 ", new Object[0]);
            builder.format("\nTestParameters>>>>>>>", new Object[0]);
            builder.format("\nTestParameters>>>>>>>Running", new Object[0]);
            builder.format("\n%20s: %s", "runtime", this.runtime);
            builder.format("\n%20s: %s", "process", this.process);
            builder.format("\n%20s: %s", "binding", this.binding);
            builder.format("\n%20s: %s", "numThread", this.numThread);
            builder.format("\n%20s: %s", "dataLength", this.dataLength);
            builder.format("\n%20s: %s (1=sign; 2=encrypt; 4=decrypt; 8=verify)", "operations", this.operations);
            builder.format("\n%20s: %s", "seconds", this.seconds);
            builder.format("\n%20s: %s", "testSign", this.testSign);
            builder.format("\n%20s: %s", "testEncrypt", this.testEncrypt);
            builder.format("\n%20s: %s", "testDecrypt", this.testDecrypt);
            builder.format("\n%20s: %s", "testVerify", this.testVerify);
            builder.format("\n%20s: %s (0=CardLib; 1=HardLib; 10=JavaLib; 11=jniLib)", "sessionType", sessionType);
            builder.format("\n%20s: %s", "session", this.session);
            builder.format("\nTestParameters<<<<<<Finished", new Object[0]);
            builder.format("\nTestParameters<<<<<<", new Object[0]);
            TestExt.err(builder.toString());
            builder.close();
        }
    }

    final Session session(int sessionType) throws PKIException {
        String deviceName;
        switch (sessionType) {
            case 0: {
                deviceName = "JCARD_LIB";
                break;
            }
            case 1: {
                deviceName = "JHARD_LIB";
                break;
            }
            case 10: {
                deviceName = "JSOFT_LIB";
                break;
            }
            case 11: {
                deviceName = "JNISOFT_LIB";
                break;
            }
            default: {
                deviceName = "JCARD_LIB";
            }
        }
        if (sessionType == 1) {
            JCrypto.getInstance().initialize(deviceName, null);
        } else {
            String iniPath = "config/card-cfca.ini";
            TestCardConf conf = new TestCardConf("config/card-cfca.ini");
            SM2CardInfo sm2CardInitParams = conf.getSM2CardInfo();
            CardLibParams param = new CardLibParams("config/card-cfca.ini", sm2CardInitParams, null);
            JCrypto.getInstance().initialize(deviceName, param);
        }
        Session session = JCrypto.getInstance().openSession(deviceName);
        return session;
    }
}

