/*
 * Decompiled with CFR 0.152.
 */
package cfca.sadk.test.cardLink.bind.perf;

import cfca.sadk.algorithm.common.PKCSObjectIdentifiers;
import cfca.sadk.algorithm.util.SymmetricHelper;
import cfca.sadk.algorithm.util.SymmetricParams;
import cfca.sadk.asn1.parser.ASN1Parser;
import cfca.sadk.lib.crypto.Session;
import cfca.sadk.lib.crypto.card.CardLib;
import cfca.sadk.lib.crypto.jni.JNISoftLib;
import cfca.sadk.org.bouncycastle.asn1.ASN1EncodableVector;
import cfca.sadk.org.bouncycastle.asn1.ASN1Set;
import cfca.sadk.org.bouncycastle.asn1.BEROctetString;
import cfca.sadk.org.bouncycastle.asn1.DERNull;
import cfca.sadk.org.bouncycastle.asn1.DEROctetString;
import cfca.sadk.org.bouncycastle.asn1.DERSet;
import cfca.sadk.org.bouncycastle.asn1.cms.ContentInfo;
import cfca.sadk.org.bouncycastle.asn1.cms.EncryptedContentInfo;
import cfca.sadk.org.bouncycastle.asn1.cms.EnvelopedData;
import cfca.sadk.org.bouncycastle.asn1.cms.KeyTransRecipientInfo;
import cfca.sadk.org.bouncycastle.asn1.cms.RecipientIdentifier;
import cfca.sadk.org.bouncycastle.asn1.cms.RecipientInfo;
import cfca.sadk.org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import cfca.sadk.org.bouncycastle.cms.CMSEnvelopedData;
import cfca.sadk.util.Base64;
import cfca.sadk.x509.certificate.X509Cert;

final class Envelope {
    Envelope() {
    }

    public static final byte[] envelopeMessage(byte[] sourceData, String symmetricAlgorithm, X509Cert[] receiverCerts, Session session) throws Exception {
        SymmetricParams symmetricParams = SymmetricParams.generateSecretKey(symmetricAlgorithm);
        ASN1EncodableVector recipientInfos = new ASN1EncodableVector();
        for (int i = 0; i < receiverCerts.length; ++i) {
            recipientInfos.add(Envelope.toRecipientInfo(receiverCerts[i], symmetricParams.symmetricKey, session, 0));
        }
        boolean useJNI = false;
        if (session != null) {
            useJNI = session instanceof JNISoftLib || session instanceof CardLib;
        }
        byte[] encryptedData = SymmetricHelper.dataEncrypt(useJNI, symmetricParams.mechanism, symmetricParams.symmetricKey, sourceData);
        BEROctetString encryptedOctet = new BEROctetString(encryptedData);
        AlgorithmIdentifier algId = symmetricParams.algorithmId;
        EncryptedContentInfo encryptedContentInfo = new EncryptedContentInfo(PKCSObjectIdentifiers.sm2Data, algId, encryptedOctet);
        EnvelopedData envData = new EnvelopedData(null, (ASN1Set)new DERSet(recipientInfos), encryptedContentInfo, ASN1Set.getInstance(null));
        ContentInfo contentInfo = new ContentInfo(PKCSObjectIdentifiers.sm2EnvelopedData, envData);
        byte[] envelopeMessage = ASN1Parser.parseDERObj2Bytes(new CMSEnvelopedData(contentInfo).toASN1Structure());
        return Base64.encode(envelopeMessage);
    }

    private static RecipientInfo toRecipientInfo(X509Cert cert, byte[] symmetricKey, Session session, int recipientPolicy) throws Exception {
        byte[] encryptedKey = new byte[138];
        DEROctetString encKey = new DEROctetString(encryptedKey);
        AlgorithmIdentifier keyEncAlg = new AlgorithmIdentifier(PKCSObjectIdentifiers.SM2_pubKey_encrypt, DERNull.INSTANCE);
        RecipientIdentifier recipientIdentifier = cert.generateRecipientIdentifier(recipientPolicy);
        KeyTransRecipientInfo ktr = new KeyTransRecipientInfo(recipientIdentifier, keyEncAlg, encKey);
        return new RecipientInfo(ktr);
    }
}

