/*
 * Decompiled with CFR 0.152.
 */
package cfca.sadk.test.cardLink.bind.perf;

import cfca.sadk.algorithm.common.PKIException;
import java.io.File;
import java.io.FileInputStream;
import java.util.Properties;

final class Conf {
    final String p11LibPath;
    final String p11Password;
    final int cardToken;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    Conf(String cardIniPath) throws Exception {
        File path = null;
        if (cardIniPath == null) {
            File config = new File("config/card-cfca.ini");
            if (config.exists() && config.isFile()) {
                path = config;
            } else {
                config = new File("/etc/card-cfca.ini");
                if (!config.exists() || !config.isFile()) throw new Exception("CardConf<<<<<<Failure: invalid cardIniPath");
                path = config;
            }
        } else {
            path = new File(cardIniPath);
            if (!path.exists() || path.isDirectory()) {
                throw new Exception("CardConf<<<<<<Failure: invalid cardIniPath=" + cardIniPath);
            }
        }
        Properties properties = new Properties();
        properties.load(new FileInputStream(path));
        this.p11LibPath = properties.getProperty("cfca.sm2card.p11LibPath", "/lib64/libpkcs11_for_c200.so");
        this.p11Password = properties.getProperty("cfca.sm2card.p11Password", "abcd1234");
        this.cardToken = this.integerFrom(properties, "cfca.sm2card.cardToken", 1);
    }

    private final int integerFrom(Properties properties, String key, int defValue) throws PKIException {
        int value = defValue;
        try {
            value = Integer.decode(properties.getProperty(key, Integer.toString(defValue)));
        }
        catch (Exception e) {
            throw new PKIException("CardConf<<<<<<Load  " + key + " failure: " + e.getMessage(), e);
        }
        return value;
    }
}

