/*
 * Decompiled with CFR 0.152.
 */
package cfca.sadk.test;

import cfca.sadk.algorithm.common.Mechanism;
import cfca.sadk.lib.crypto.Session;
import cfca.sadk.lib.crypto.bcsoft.BCSoftLib;
import cfca.sadk.org.bouncycastle.asn1.ASN1Object;
import cfca.sadk.org.bouncycastle.asn1.oiw.OIWObjectIdentifiers;
import cfca.sadk.org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import cfca.sadk.org.bouncycastle.asn1.x509.Extension;
import cfca.sadk.org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import cfca.sadk.org.bouncycastle.cert.X509ExtensionUtils;
import cfca.sadk.org.bouncycastle.crypto.digests.SHA1Digest;
import cfca.sadk.org.bouncycastle.operator.DigestCalculator;
import cfca.sadk.x509.certificate.X509Cert;
import cfca.sadk.x509.certificate.X509CertGenerator;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.math.BigInteger;
import java.security.Key;
import java.security.KeyPair;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.interfaces.RSAPublicKey;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Formatter;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class TestExt {
    private TestExt() {
    }

    public static void main(String[] args) throws Exception {
        Session session = BCSoftLib.INSTANCE();
        KeyPair keypair = session.generateKeyPair(new Mechanism("SM2"), 256);
        PrivateKey privateKey = keypair.getPrivate();
        X509Cert recvCert = TestExt.buildX509CertGenerator(privateKey, keypair.getPublic(), session);
        System.err.println(recvCert);
        keypair = session.generateKeyPair(new Mechanism("RSA"), 2048);
        privateKey = keypair.getPrivate();
        recvCert = TestExt.buildX509CertGenerator(privateKey, keypair.getPublic(), session);
        System.err.println(recvCert);
    }

    public static final X509Cert buildX509CertGenerator(PrivateKey signKey, PublicKey publicKey, Session session) throws Exception {
        return TestExt.buildX509CertGenerator(signKey, publicKey, session, true);
    }

    public static final X509Cert buildX509CertGenerator(PrivateKey signKey, PublicKey publicKey, Session session, boolean addKeyIdentifier) throws Exception {
        ASN1Object subjectKeyIdentifier;
        String DN1 = "CN = QA,O = CFCA, C = CN";
        String DN2 = "CN = QA,O = CFCA, C = CN";
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss");
        Date notBefore = formatter.parse("2010/12/18 12:34:56");
        Date notAfter = formatter.parse("2030/12/31 12:34:56");
        X509CertGenerator gen = new X509CertGenerator();
        gen.setIssuer("CN = QA,O = CFCA, C = CN");
        gen.setNotBefore(notBefore);
        gen.setNotAfter(notAfter);
        gen.setPublicKey(publicKey);
        gen.setSerialNumber(new BigInteger("1"));
        if (publicKey instanceof RSAPublicKey) {
            gen.setSignatureAlg("sha256WithRSAEncryption");
        } else {
            gen.setSignatureAlg("sm3WithSM2Encryption");
        }
        gen.setSubject("CN = QA,O = CFCA, C = CN");
        if (addKeyIdentifier) {
            X509ExtensionUtils extFact = new X509ExtensionUtils(new SHA1DigestCalculator());
            gen.addExtension(new Extension(Extension.authorityKeyIdentifier, false, extFact.createAuthorityKeyIdentifier(SubjectPublicKeyInfo.getInstance(publicKey.getEncoded())).getEncoded()));
            gen.addExtension(new Extension(Extension.subjectKeyIdentifier, false, extFact.createSubjectKeyIdentifier(SubjectPublicKeyInfo.getInstance(publicKey.getEncoded())).getEncoded()));
            subjectKeyIdentifier = extFact.createSubjectKeyIdentifier(SubjectPublicKeyInfo.getInstance(publicKey.getEncoded()));
        } else {
            subjectKeyIdentifier = null;
        }
        byte[] certBytes = gen.generateX509Cert(signKey, session);
        X509Cert cert = new X509Cert(certBytes);
        if (subjectKeyIdentifier != null && !subjectKeyIdentifier.equals(cert.getSubjectKeyIdentifier())) {
            System.err.println("subjectKeyIdentifier: failure");
        }
        return cert;
    }

    public static final void println(Formatter message) {
        System.out.println(message);
    }

    public static void println(String message) {
        System.out.println(message);
    }

    public static void println() {
        System.out.println();
    }

    public static void println(long message) {
        System.out.println(message);
    }

    public static final void err(StringBuilder message) {
        System.err.println(message);
    }

    public static final void err(Formatter message) {
        System.err.println(message);
    }

    public static void err(String message) {
        System.err.println(message);
    }

    public static void err() {
        System.err.println();
    }

    public static void err(long message) {
        System.err.println(message);
    }

    public static void err(List<String> message) {
        System.err.println(message);
    }

    public static void err(boolean message) {
        System.err.println(message);
    }

    public static void err(Key message) {
        System.err.println(message);
    }

    private static class SHA1DigestCalculator
    implements DigestCalculator {
        private ByteArrayOutputStream bOut = new ByteArrayOutputStream();

        private SHA1DigestCalculator() {
        }

        public AlgorithmIdentifier getAlgorithmIdentifier() {
            return new AlgorithmIdentifier(OIWObjectIdentifiers.idSHA1);
        }

        public OutputStream getOutputStream() {
            return this.bOut;
        }

        public byte[] getDigest() {
            byte[] bytes = this.bOut.toByteArray();
            this.bOut.reset();
            SHA1Digest sha1 = new SHA1Digest();
            sha1.update(bytes, 0, bytes.length);
            byte[] digest = new byte[sha1.getDigestSize()];
            sha1.doFinal(digest, 0);
            return digest;
        }
    }
}

