/*
 * Decompiled with CFR 0.152.
 */
package cfca.sadk.system;

import cfca.ch.qos.logback.classic.LoggerContext;
import cfca.ch.qos.logback.classic.joran.JoranConfigurator;
import cfca.ch.qos.logback.core.Context;
import cfca.org.slf4j.ILoggerFactory;
import cfca.org.slf4j.Logger;
import cfca.org.slf4j.LoggerFactory;
import cfca.sadk.algorithm.common.CBCParam;
import cfca.sadk.algorithm.common.GenKeyAttribute;
import cfca.sadk.algorithm.common.Mechanism;
import cfca.sadk.algorithm.sm2.SM2PrivateKey;
import cfca.sadk.algorithm.sm2.SM2PublicKey;
import cfca.sadk.lib.crypto.Session;
import cfca.sadk.lib.crypto.card.SM2Key;
import cfca.sadk.lib.crypto.card.c200.ECCCardPrivateKey;
import cfca.sadk.lib.crypto.card.c200.ECCCardPublicKey;
import cfca.sadk.lib.crypto.card.c200.SM2CardKey;
import cfca.sadk.lib.crypto.card.c200.SM2CardPrivateKey;
import cfca.sadk.lib.crypto.card.c200.SM2CardPublicKey;
import cfca.sadk.org.bouncycastle.asn1.ASN1Encodable;
import cfca.sadk.org.bouncycastle.asn1.ASN1Primitive;
import cfca.sadk.org.bouncycastle.asn1.util.ASN1Dump;
import cfca.sadk.org.bouncycastle.util.encoders.Hex;
import cfca.sadk.system.CompatibleConfig;
import cfca.sadk.x509.certificate.X509Cert;
import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigInteger;
import java.net.URL;
import java.security.Key;
import java.security.KeyPair;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.interfaces.RSAPrivateKey;

public final class SADKDebugger {
    static final Logger logger = LoggerFactory.getLogger(SADKDebugger.class);
    static final int dumpLength = 10240;
    private static volatile SADKDebugger singleton;

    private SADKDebugger() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static SADKDebugger setDebugger() {
        boolean loadFlag = CompatibleConfig.LOGKACK_AUTOLOAD_SETTING;
        if (!loadFlag || singleton != null) return singleton;
        Class<SADKDebugger> clazz = SADKDebugger.class;
        synchronized (SADKDebugger.class) {
            if (singleton != null) return singleton;
            SADKDebugger debugger = new SADKDebugger();
            try {
                debugger.loadLoggerResource();
            }
            catch (Exception e) {
                logger.error("loadLoggerResource Failure", (Throwable)e);
                e.printStackTrace();
            }
            catch (Throwable e) {
                logger.error("loadLoggerResource Failure", e);
                e.printStackTrace();
            }
            finally {
                singleton = debugger;
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return singleton;
        }
    }

    private final void loadLoggerResource() {
        String logbackFile = "logback-cfca-sadk.xml";
        StringBuffer buffer = new StringBuffer();
        buffer.append("\nLoading logback-cfca-sadk.xml Running:");
        buffer.append("\n 1. From AbsolutePath /etc/logback-cfca-sadk.xml");
        buffer.append("\n 2. From RelativePath config/logback-cfca-sadk.xml");
        buffer.append("\n 3. From jarFIle  *.jar/logback-cfca-sadk.xml");
        logger.info(buffer.toString());
        try {
            ILoggerFactory loggerFactory = LoggerFactory.getILoggerFactory();
            LoggerContext lc = (LoggerContext)loggerFactory;
            JoranConfigurator configurator = new JoranConfigurator();
            configurator.setContext((Context)lc);
            lc.reset();
            String message = null;
            File file = new File("/etc/logback-cfca-sadk.xml");
            if (file.exists() && file.isFile()) {
                message = "Loading logback-cfca-sadk.xml from AbsolutePath[have]: " + file.getAbsolutePath();
                logger.info(message);
                configurator.doConfigure(file);
                logger.info("Loading logback-cfca-sadk.xml Finished: " + file.getAbsolutePath());
                return;
            }
            message = "Loading logback-cfca-sadk.xml from AbsolutePath[none]: " + file.getAbsolutePath();
            logger.info(message);
            file = new File("config/logback-cfca-sadk.xml");
            if (file.exists() && file.isFile()) {
                message = "Loading logback-cfca-sadk.xml from RelativePath[have]: " + file.getAbsolutePath();
                logger.info(message);
                configurator.doConfigure(file);
                logger.info("Loading logback-cfca-sadk.xml Finished: " + file.getAbsolutePath());
                return;
            }
            message = "Loading logback-cfca-sadk.xml from AbsolutePath[none]: " + file.getAbsolutePath();
            logger.info(message);
            message = "Loading logback-cfca-sadk.xml from  *.jar/logback-cfca-sadk.xml";
            logger.info(message);
            URL url = SADKDebugger.class.getClassLoader().getResource("logback-cfca-sadk.xml");
            if (url != null) {
                message = "Loading logback-cfca-sadk.xml from jarFile: " + url;
                logger.info(message);
                configurator.doConfigure(url);
                logger.info("Loading logback-cfca-sadk.xml Finished: " + url);
                return;
            }
            message = "Loading logback-cfca-sadk.xml from jarFile[none]: " + url;
            logger.info(message);
            buffer = new StringBuffer();
            buffer.append("\nLoading logback-cfca-sadk.xml Failure: ");
            buffer.append("\n 1. From AbsolutePath /etc/logback-cfca-sadk.xml");
            buffer.append("\n 2. From RelativePath config/logback-cfca-sadk.xml");
            buffer.append("\n 3. From jarFIle  *.jar/logback-cfca-sadk.xml");
            logger.error(buffer.toString());
        }
        catch (Exception e) {
            logger.error("loadLoggerResource logback-cfca.xm Failure", (Throwable)e);
            e.printStackTrace();
        }
        catch (Throwable e) {
            logger.error("loadLoggerResource logback-cfca.xm Failure", e);
            e.printStackTrace();
        }
    }

    public static final String dump(BigInteger value) {
        String message = null;
        message = value == null ? "none" : "[hex]" + value.toString(16);
        return message;
    }

    public static final String dump(Session session) {
        String message = null;
        message = session == null ? "none" : "[session]" + session.getClass().getName();
        return message;
    }

    public static final String dump(InputStream stream) {
        String message = null;
        message = stream == null ? "none" : "[stream]" + stream.getClass().getName();
        return message;
    }

    public static final String dump(OutputStream stream) {
        String message = null;
        message = stream == null ? "none" : "[stream]" + stream.getClass().getName();
        return message;
    }

    public static final String dump(Mechanism mechanism) {
        String message = null;
        try {
            if (mechanism == null) {
                message = "none";
            } else {
                message = mechanism.getMechanismType();
                Object param = mechanism.getParam();
                if (param != null && param instanceof CBCParam) {
                    byte[] iv = ((CBCParam)param).getIv();
                    message = message + " iv=" + (iv == null ? "none" : "[hex]" + Hex.toHexString(iv));
                }
            }
        }
        catch (Exception e) {
            message = "FailureMechanism";
        }
        return message;
    }

    public static final String dump(String text) {
        String message = null;
        message = text == null ? "none" : text;
        return message;
    }

    public static final StringBuffer dump(PublicKey publicKey) {
        StringBuffer message = new StringBuffer();
        try {
            if (publicKey == null) {
                message.append("none");
            } else {
                message.append(publicKey);
                message.append("\n PublicKeyEncoding: [hex]" + Hex.toHexString(publicKey.getEncoded()));
            }
        }
        catch (Exception e) {
            message.append("FailurePublicKey");
        }
        return message;
    }

    public static final String dump(PrivateKey pirvateKey) {
        String message = null;
        try {
            if (pirvateKey == null) {
                message = "none";
            } else if (pirvateKey instanceof RSAPrivateKey) {
                BigInteger modulus = ((RSAPrivateKey)pirvateKey).getModulus();
                String modulusText = modulus == null ? "" : modulus.toString(16);
                message = pirvateKey.getAlgorithm() + ":  modulus= " + modulusText;
            } else if (pirvateKey instanceof SM2PrivateKey) {
                SM2PublicKey pubKey = ((SM2PrivateKey)pirvateKey).getSM2PublicKey();
                BigInteger pubx = pubKey.getPubX_Int();
                BigInteger puby = pubKey.getPubY_Int();
                message = pirvateKey.getAlgorithm() + ":  pubx =" + pubx.toString(16) + " puby =" + puby.toString(16);
            } else {
                message = pirvateKey.getAlgorithm() + ":  hidden";
            }
        }
        catch (Exception e) {
            message = "FailurePrivateKey";
        }
        return message;
    }

    public static final StringBuffer dump(KeyPair keypair) {
        StringBuffer message = new StringBuffer();
        try {
            if (keypair == null) {
                message.append("none");
            } else {
                message.append("\n PrivateKey: " + keypair.getPrivate().getAlgorithm() + ": hidden ");
                message.append("\n PublicKeyEncoding: [hex]" + Hex.toHexString(keypair.getPublic().getEncoded()));
                message.append(keypair.getPublic());
            }
        }
        catch (Exception e) {
            message.append("FailureMechanism");
        }
        return message;
    }

    public static final String dump(Key key) {
        String message = null;
        try {
            message = key == null ? "none" : (key instanceof PrivateKey ? key.getAlgorithm() + ": hidden " : key.getAlgorithm() + "[hex]" + Hex.toHexString(key.getEncoded()));
        }
        catch (Exception e) {
            message = "FailureKey";
        }
        return message;
    }

    public static final String dump(CBCParam param) {
        String message = null;
        try {
            message = param == null ? "none" : (param.getIv() == null ? "null" : "[hex]" + Hex.toHexString(param.getIv()));
        }
        catch (Exception e) {
            message = "FailureCBCParam";
        }
        return message;
    }

    public static final String dump(ASN1Encodable obj) {
        String message = null;
        try {
            message = obj == null ? "none" : ASN1Dump.dumpAsString(obj, true);
        }
        catch (Exception e) {
            message = "FailureASN1Encodable";
        }
        return message;
    }

    public static final String dump(ASN1Primitive obj) {
        String message = null;
        try {
            message = obj == null ? "none" : ASN1Dump.dumpAsString(obj, true);
        }
        catch (Exception e) {
            message = "FailureASN1Primitive";
        }
        return message;
    }

    public static final String dump(X509Cert cert) {
        String message = null;
        try {
            message = cert == null ? "none" : cert.toString();
        }
        catch (Exception e) {
            message = "FailureX509Cert";
        }
        return message;
    }

    public static final String dump(X509Cert[] certs) {
        String message = null;
        try {
            if (certs == null || certs.length == 0) {
                message = "none";
            } else {
                StringBuffer buffer = new StringBuffer();
                for (int i = 0; i < certs.length; ++i) {
                    buffer.append(certs[i]);
                }
                message = buffer.toString();
            }
        }
        catch (Exception e) {
            message = "FailureX509Cert";
        }
        return message;
    }

    public static final String dump(byte[] data) {
        String message = null;
        try {
            message = data == null ? "none" : (data.length > 10240 ? "more than 10K" : "[hex]" + Hex.toHexString(data));
        }
        catch (Exception e) {
            message = "FailureData";
        }
        return message;
    }

    public static final String dumpBase64(byte[] data) {
        String message = null;
        try {
            message = data == null ? "none" : (data.length > 10240 ? "more than 10K" : "[base64]" + new String(data));
        }
        catch (Exception e) {
            message = "FailureData";
        }
        return message;
    }

    public static String dump(SM2Key cardKey) {
        String message = null;
        try {
            message = cardKey == null ? "none" : (cardKey.getDefaultZ() == null ? "noneZ" : Hex.toHexString(cardKey.getDefaultZ()));
        }
        catch (Exception e) {
            message = "failureSM2CardKey";
        }
        return message;
    }

    public static String dump(SM2CardKey cardKey) {
        String message = null;
        try {
            message = cardKey == null ? "none" : cardKey.toString();
        }
        catch (Exception e) {
            message = "failureSM2CardKey";
        }
        return message;
    }

    public static String dump(SM2CardPrivateKey cardKey) {
        String message = null;
        try {
            message = cardKey == null ? "none" : cardKey.toString();
        }
        catch (Exception e) {
            message = "failureSM2CardPrivateKey";
        }
        return message;
    }

    public static String dump(SM2CardPublicKey cardKey) {
        String message = null;
        try {
            message = cardKey == null ? "none" : cardKey.toString();
        }
        catch (Exception e) {
            message = "failureSM2CardPublicKey";
        }
        return message;
    }

    public static String dump(ECCCardPrivateKey cardKey) {
        String message = null;
        try {
            message = cardKey == null ? "none" : cardKey.toString();
        }
        catch (Exception e) {
            message = "failureECCCardPrivateKey";
        }
        return message;
    }

    public static String dump(ECCCardPublicKey cardKey) {
        String message = null;
        try {
            message = cardKey == null ? "none" : cardKey.toString();
        }
        catch (Exception e) {
            message = "failureECCCardPublicKey";
        }
        return message;
    }

    public static String dump(GenKeyAttribute genKeyAttribute) {
        String message = null;
        try {
            message = genKeyAttribute == null ? "none" : genKeyAttribute.toString();
        }
        catch (Exception e) {
            message = "failureGenKeyAttribute";
        }
        return message;
    }

    public static final StringBuffer dump(SM2PublicKey publicKey) {
        StringBuffer message = new StringBuffer();
        try {
            if (publicKey == null) {
                message.append("none");
            } else {
                message.append(publicKey);
                message.append("\n PublicKeyEncoding: [hex]" + Hex.toHexString(publicKey.getEncoded()));
            }
        }
        catch (Exception e) {
            message.append("FailurePublicKey");
        }
        return message;
    }

    public static final String dump(SM2PrivateKey pirvateKey) {
        String message = null;
        try {
            message = pirvateKey == null ? "none" : pirvateKey.getAlgorithm() + ": hidden";
        }
        catch (Exception e) {
            message = "FailurePrivateKey";
        }
        return message;
    }
}

