/*
 * Decompiled with CFR 0.152.
 */
package cfca.sadk.system;

import cfca.org.slf4j.Logger;
import cfca.sadk.algorithm.common.PKIException;
import cfca.sadk.system.CompatibleConfig;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public final class FileHelper {
    public static final int BIGGEST_FILE_SIZE = CompatibleConfig.FILEANDBUFFER_BIGGEST_FILE_MAXSIZE;
    private static final int BUFFSIZE = 65536;

    private FileHelper() {
    }

    public static final void deleteFile(String fileName) {
        if (fileName != null) {
            try {
                File file = new File(fileName);
                if (file.exists()) {
                    file.delete();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static final void write(String filePath, byte[] data) throws IOException {
        if (filePath == null) {
            throw new IllegalArgumentException("Illegal Argument: filePath");
        }
        if (data == null) {
            throw new IllegalArgumentException("Illegal Argument: data");
        }
        FileOutputStream fos = null;
        try {
            File file = new File(filePath);
            if (!file.getParentFile().exists()) {
                file.getParentFile().mkdirs();
            }
            if (!file.exists()) {
                file.createNewFile();
            }
            fos = new FileOutputStream(file);
            fos.write(data, 0, data.length);
            fos.flush();
        }
        catch (IOException e) {
            throw e;
        }
        finally {
            if (fos != null) {
                try {
                    fos.close();
                }
                catch (Exception e) {}
            }
        }
    }

    public static final byte[] read(String filePath) throws IOException {
        if (filePath == null) {
            throw new IllegalArgumentException("Illegal Argument: filePath");
        }
        FileInputStream crls = null;
        try {
            int rLength;
            crls = new FileInputStream(filePath);
            byte[] out = new byte[crls.available()];
            byte[] buffer = new byte[65536];
            int offset = 0;
            while ((rLength = crls.read(buffer, 0, buffer.length)) != -1) {
                System.arraycopy(buffer, 0, out, offset, rLength);
                offset += rLength;
            }
            byte[] byArray = out;
            return byArray;
        }
        catch (IOException e) {
            throw e;
        }
        finally {
            if (crls != null) {
                try {
                    crls.close();
                }
                catch (Exception e) {}
            }
        }
    }

    public static void writeBytesToFile(byte[] sourceData, OutputStream os) throws IOException {
        if (os != null) {
            os.write(sourceData);
        }
    }

    public static void writeBytesToFile(byte[] data, int offSet, int len, OutputStream os) throws IOException {
        if (os != null) {
            os.write(data, offSet, len);
        }
    }

    public static byte[] getBytesFromFile(InputStream inputStream) throws IOException {
        byte[] keyhex = null;
        int len = inputStream.available();
        if (len > BIGGEST_FILE_SIZE) {
            throw new IOException("file is too big!");
        }
        keyhex = new byte[len];
        inputStream.read(keyhex);
        return keyhex;
    }

    public static final byte[] read(InputStream in) throws IOException {
        if (in == null) {
            throw new IllegalArgumentException("Illegal Argument: in");
        }
        int sLength = in.available();
        if (sLength < 0) {
            throw new IllegalArgumentException("Illegal Stream: available<0");
        }
        byte[] out = new byte[sLength];
        if (sLength > 0) {
            int rLength;
            byte[] buffer = new byte[65536];
            int offset = 0;
            while ((rLength = in.read(buffer, 0, buffer.length)) != -1) {
                System.arraycopy(buffer, 0, out, offset, rLength);
                offset += rLength;
            }
        }
        return out;
    }

    public static final void closedStream(InputStream inputStream, Logger logger, String message) {
        block3: {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (Exception e) {
                    if (logger == null || !logger.isErrorEnabled()) break block3;
                    logger.error(message, (Throwable)e);
                }
            }
        }
    }

    public static final void closedStream(OutputStream outputStream, Logger logger, String message) {
        block3: {
            if (outputStream != null) {
                try {
                    outputStream.close();
                }
                catch (Exception e) {
                    if (logger == null || !logger.isErrorEnabled()) break block3;
                    logger.error(message, (Throwable)e);
                }
            }
        }
    }

    public static final void closedStreamE(InputStream inputStream, Logger logger, String message) throws PKIException {
        if (inputStream != null) {
            try {
                inputStream.close();
            }
            catch (Exception e) {
                if (logger != null && logger.isErrorEnabled()) {
                    logger.error(message, (Throwable)e);
                }
                throw new PKIException(message, e);
            }
        }
    }

    public static final void closedStreamE(OutputStream outputStream, Logger logger, String message) throws PKIException {
        if (outputStream != null) {
            try {
                outputStream.close();
            }
            catch (Exception e) {
                if (logger != null && logger.isErrorEnabled()) {
                    logger.error(message, (Throwable)e);
                }
                throw new PKIException(message, e);
            }
        }
    }
}

