/*
 * Decompiled with CFR 0.152.
 */
package cfca.sadk.org.bouncycastle.util.encoders;

import cfca.org.slf4j.Logger;
import cfca.org.slf4j.LoggerFactory;
import cfca.sadk.org.bouncycastle.util.Strings;
import cfca.sadk.org.bouncycastle.util.encoders.Base64Encoder;
import cfca.sadk.org.bouncycastle.util.encoders.DecoderException;
import cfca.sadk.org.bouncycastle.util.encoders.EncoderException;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class Base64Kit {
    static final Logger logger = LoggerFactory.getLogger(Base64Kit.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String toBase64String(byte[] data) {
        if (logger.isTraceEnabled()) {
            logger.trace("toBase64String>>>>>>Running: length=" + (data == null ? 0 : data.length));
        }
        try {
            String base64Text = null;
            base64Text = data == null ? null : Base64Kit.toBase64String(data, 0, data.length);
            String string = base64Text;
            return string;
        }
        finally {
            logger.trace("toBase64String<<<<<<Finished");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String toBase64String(byte[] data, int off, int length) {
        if (logger.isTraceEnabled()) {
            logger.trace("toBase64String>>>>>>Running: length=" + (data == null ? 0 : data.length) + ": " + length);
        }
        try {
            byte[] encoded = Base64Kit.encode(data, off, length);
            String string = Strings.fromByteArray(encoded);
            return string;
        }
        finally {
            logger.trace("toBase64String<<<<<<Finished");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] encode(byte[] data) {
        if (logger.isTraceEnabled()) {
            logger.trace("encode>>>>>>Running: length=" + (data == null ? 0 : data.length));
        }
        try {
            byte[] base64Bytes = null;
            base64Bytes = data == null ? null : Base64Kit.encode(data, 0, data.length);
            byte[] byArray = base64Bytes;
            return byArray;
        }
        finally {
            logger.trace("encode<<<<<<Finished");
        }
    }

    public static byte[] encode(byte[] data, int off, int length) {
        if (logger.isTraceEnabled()) {
            logger.trace("encode>>>>>>Running: length=" + (data == null ? 0 : data.length) + ":" + length);
        }
        try {
            int len = (length + 2) / 3 * 4;
            ByteArrayOutputStream bOut = new ByteArrayOutputStream(len);
            Base64Encoder encoder = new Base64Encoder();
            encoder.encode(data, off, length, bOut);
            byte[] byArray = bOut.toByteArray();
            return byArray;
        }
        catch (Exception e) {
            throw new EncoderException("exception encoding base64 string: " + e.getMessage(), e);
        }
        finally {
            logger.trace("encode<<<<<<Finished");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int encode(byte[] data, OutputStream out) throws IOException {
        if (logger.isTraceEnabled()) {
            logger.trace("encode>>>>>>Running: length=" + (data == null ? 0 : data.length));
        }
        try {
            int length = 0;
            if (data == null) {
                length = 0;
            } else {
                Base64Encoder encoder = new Base64Encoder();
                length = encoder.encode(data, 0, data.length, out);
            }
            int n = length;
            return n;
        }
        finally {
            logger.trace("encode<<<<<<Finished");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int encode(byte[] data, int off, int length, OutputStream out) throws IOException {
        if (logger.isTraceEnabled()) {
            logger.trace("encode>>>>>>Running: length=" + (data == null ? 0 : data.length) + ":" + length);
        }
        try {
            Base64Encoder encoder = new Base64Encoder();
            int n = encoder.encode(data, off, length, out);
            return n;
        }
        finally {
            logger.trace("encode<<<<<<Finished");
        }
    }

    public static byte[] decode(byte[] data) {
        if (logger.isTraceEnabled()) {
            logger.trace("decode>>>>>>Running: length=" + (data == null ? 0 : data.length));
        }
        try {
            byte[] decodeBytes = null;
            if (data == null) {
                decodeBytes = null;
            } else {
                int len = data.length / 4 * 3;
                ByteArrayOutputStream bOut = new ByteArrayOutputStream(len);
                Base64Encoder encoder = new Base64Encoder();
                encoder.decode(data, 0, data.length, bOut);
                decodeBytes = bOut.toByteArray();
            }
            byte[] byArray = decodeBytes;
            return byArray;
        }
        catch (Exception e) {
            throw new DecoderException("unable to decode base64 data: " + e.getMessage(), e);
        }
        finally {
            logger.trace("decode<<<<<<Finished");
        }
    }

    public static byte[] decode(String data) {
        if (logger.isTraceEnabled()) {
            logger.trace("decode>>>>>>Running: length=" + (data == null ? 0 : data.length()));
        }
        try {
            byte[] returnBytes = null;
            if (data != null) {
                int len = data.length() / 4 * 3;
                ByteArrayOutputStream bOut = new ByteArrayOutputStream(len);
                Base64Encoder encoder = new Base64Encoder();
                encoder.decode(data, bOut);
                returnBytes = bOut.toByteArray();
            } else {
                returnBytes = new byte[]{};
            }
            byte[] byArray = returnBytes;
            return byArray;
        }
        catch (Exception e) {
            throw new DecoderException("unable to decode base64 string: " + e.getMessage(), e);
        }
        finally {
            logger.trace("decode<<<<<<Finished");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int decode(String data, OutputStream out) throws IOException {
        if (logger.isTraceEnabled()) {
            logger.trace("decode>>>>>>Running: length=" + (data == null ? 0 : data.length()));
        }
        try {
            int returnLength = 0;
            if (data != null && out != null) {
                Base64Encoder encoder = new Base64Encoder();
                returnLength = encoder.decode(data, out);
            }
            int n = returnLength;
            return n;
        }
        finally {
            logger.trace("decode<<<<<<Finished");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isBase64Compatability(byte[] data) {
        if (logger.isTraceEnabled()) {
            logger.trace("isBase64Compatability>>>>>>Running: length=" + (data == null ? 0 : data.length));
        }
        try {
            Base64Encoder encoder = new Base64Encoder();
            boolean bl = encoder.isBase64Compatability(data);
            return bl;
        }
        finally {
            logger.trace("isBase64Compatability<<<<<<Finished");
        }
    }
}

