/*
 * Decompiled with CFR 0.152.
 */
package cfca.sadk.org.bouncycastle.asn1.pkcs;

import cfca.org.slf4j.Logger;
import cfca.org.slf4j.LoggerFactory;
import cfca.sadk.org.bouncycastle.asn1.ASN1OctetString;
import cfca.sadk.org.bouncycastle.asn1.ASN1Set;
import cfca.sadk.org.bouncycastle.asn1.DEROctetString;
import cfca.sadk.org.bouncycastle.asn1.cms.CMSAttributes;
import cfca.sadk.org.bouncycastle.asn1.pkcs.Attribute;
import java.util.Enumeration;

public class AuthenticatedAttributesUtil {
    static final Logger logger = LoggerFactory.getLogger(AuthenticatedAttributesUtil.class);

    public static byte[] getMessageDigest(ASN1Set authAttributes) {
        byte[] hashValue;
        block4: {
            hashValue = null;
            if (authAttributes != null) {
                try {
                    Enumeration authAttrEnumer = authAttributes.getObjects();
                    while (authAttrEnumer.hasMoreElements()) {
                        Attribute attribute = Attribute.getInstance(authAttrEnumer.nextElement());
                        if (!CMSAttributes.messageDigest.equals(attribute.getAttrType())) continue;
                        ASN1Set values = attribute.getAttrValues();
                        ASN1OctetString hash = DEROctetString.getInstance(values.getObjectAt(0));
                        hashValue = hash.getOctets();
                        break;
                    }
                }
                catch (Exception e) {
                    if (!logger.isErrorEnabled()) break block4;
                    logger.error("getMessageDigest failure with exception: " + e.getMessage(), (Throwable)e);
                }
            }
        }
        return hashValue;
    }
}

