/*
 * Decompiled with CFR 0.152.
 */
package cfca.sadk.lib.crypto.jni;

import cfca.org.slf4j.Logger;
import cfca.org.slf4j.LoggerFactory;
import cfca.sadk.algorithm.common.Mechanism;
import cfca.sadk.algorithm.common.PKIException;
import cfca.sadk.algorithm.sm2.SM2PrivateKey;
import cfca.sadk.algorithm.sm2.SM2PublicKey;
import cfca.sadk.algorithm.util.BigIntegerUtil;
import cfca.sadk.algorithm.util.PKCS8ToPKCS1Util;
import cfca.sadk.algorithm.util.SymmetricHelper;
import cfca.sadk.lib.crypto.BaseLib;
import cfca.sadk.lib.crypto.Session;
import cfca.sadk.lib.crypto.bcsoft.BCSoftLib;
import cfca.sadk.lib.crypto.card.dummy.DummySM2Card;
import cfca.sadk.lib.crypto.jni.JNIDigest;
import cfca.sadk.lib.crypto.jni.JNIRSA;
import cfca.sadk.lib.crypto.jni.JNISM2;
import cfca.sadk.lib.crypto.jni.PKCS1Encoding;
import cfca.sadk.org.bouncycastle.asn1.sm2.ASN1SM2Cipher;
import cfca.sadk.signature.rsa.RSAPackageUtil;
import cfca.sadk.signature.sm2.SM2PackageUtil;
import cfca.sadk.system.CompatibleConfig;
import cfca.sadk.system.SADKDebugger;
import cfca.sadk.util.HashUtil;
import java.io.InputStream;
import java.security.Key;
import java.security.KeyPair;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.interfaces.RSAPrivateKey;
import java.security.interfaces.RSAPublicKey;

public final class JNISoftLib
extends BaseLib {
    protected static final Logger logger = LoggerFactory.getLogger(JNISoftLib.class);
    private static volatile Session singleton;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final Session INSTANCE() {
        if (singleton != null) return singleton;
        Class<JNISoftLib> clazz = JNISoftLib.class;
        synchronized (JNISoftLib.class) {
            if (singleton != null) return singleton;
            singleton = new JNISoftLib();
            // ** MonitorExit[var0] (shouldn't be in output)
            return singleton;
        }
    }

    protected final KeyPair SM2GenerateKeyPair() throws PKIException {
        if (logger.isDebugEnabled()) {
            logger.debug("SM2GenerateKeyPair>>>>>>Running");
        }
        try {
            KeyPair keypair = DummySM2Card.dummy.generateKeyPair(true, 0, 0);
            if (logger.isDebugEnabled()) {
                logger.debug("SM2GenerateKeyPair<<<<<<Finished: keypair=" + SADKDebugger.dump(keypair));
            }
            return keypair;
        }
        catch (Exception e) {
            if (logger.isErrorEnabled()) {
                logger.error("SM2GenerateKeyPair<<<<<<operation failure: " + e.getMessage(), (Throwable)e);
            }
            throw new PKIException("SM2GenerateKeyPair<<<<<<operation failure: " + e.getMessage(), e);
        }
        catch (Throwable e) {
            if (logger.isErrorEnabled()) {
                logger.error("SM2GenerateKeyPair<<<<<<operation failure: " + e.getMessage(), e);
            }
            throw new PKIException("SM2GenerateKeyPair<<<<<<operation failure: " + e.getMessage(), e);
        }
    }

    protected final KeyPair RSAGenerateKeyPair(int bitLength) throws PKIException {
        if (logger.isDebugEnabled()) {
            logger.debug("RSAGenerateKeyPair::>>>>>>Running: bitLength=" + bitLength);
        }
        try {
            KeyPair keypair = JNIRSA.RSAGenerateKeyPair(bitLength);
            if (logger.isDebugEnabled()) {
                logger.debug("RSAGenerateKeyPair::<<<<<<Finished: keypair=" + SADKDebugger.dump(keypair));
            }
            return keypair;
        }
        catch (Exception e) {
            if (logger.isErrorEnabled()) {
                logger.error("RSAGenerateKeyPair::<<<<<<Failure", (Throwable)e);
            }
            throw new PKIException("RSAGenerateKeyPair failure with exception: " + e.getMessage(), e);
        }
        catch (Throwable e) {
            if (logger.isErrorEnabled()) {
                logger.error("RSAGenerateKeyPair::<<<<<<Failure", e);
            }
            throw new PKIException("RSAGenerateKeyPair failure with throwable: " + e.getMessage(), e);
        }
    }

    protected final byte[] SM2EncryptMessage(SM2PublicKey sm2PublicKey, byte[] message) throws PKIException {
        if (logger.isDebugEnabled()) {
            StringBuffer buffer = new StringBuffer();
            buffer.append("SM2EncryptMessage::>>>>>>Running");
            buffer.append("\n sm2PublicKey: ");
            buffer.append(SADKDebugger.dump(sm2PublicKey));
            buffer.append("\n message: ");
            buffer.append(SADKDebugger.dump(message));
            logger.debug(buffer.toString());
        }
        try {
            byte[] encryptedData = new byte[message.length + 96];
            byte[] pubX = BigIntegerUtil.asUnsigned32ByteArray(sm2PublicKey.getPubXByInt());
            byte[] pubY = BigIntegerUtil.asUnsigned32ByteArray(sm2PublicKey.getPubYByInt());
            JNISM2.encrypt(message, pubX, pubY, encryptedData);
            ASN1SM2Cipher asn1 = new ASN1SM2Cipher(encryptedData, 16);
            byte[] encryptData = asn1.getEncryptedBytes(CompatibleConfig.SM2OutputFormatEncryptedBytes);
            if (logger.isDebugEnabled()) {
                logger.debug("SM2EncryptMessage::<<<<<<Finished: encryptData=" + SADKDebugger.dump(encryptData));
            }
            return encryptData;
        }
        catch (Exception e) {
            if (logger.isErrorEnabled()) {
                logger.error("SM2EncryptMessage::<<<<<<Failure", (Throwable)e);
            }
            throw new PKIException("SM2EncryptMessage failure with exception: " + e.getMessage(), e);
        }
        catch (Throwable e) {
            if (logger.isErrorEnabled()) {
                logger.error("SM2EncryptMessage::<<<<<<Failure", e);
            }
            throw new PKIException("SM2EncryptMessage failure with throwable: " + e.getMessage(), e);
        }
    }

    protected final byte[] SM2DecryptMessage(SM2PrivateKey sm2PrivateKey, byte[] encryptData) throws PKIException {
        if (logger.isDebugEnabled()) {
            StringBuffer buffer = new StringBuffer();
            buffer.append("SM2DecryptMessage::>>>>>>Running");
            buffer.append("\n sm2PrivateKey: ");
            buffer.append(SADKDebugger.dump(sm2PrivateKey));
            buffer.append("\n encryptData: ");
            buffer.append(SADKDebugger.dump(encryptData));
            logger.debug(buffer.toString());
        }
        try {
            byte[] dBytes = BigIntegerUtil.asUnsigned32ByteArray(sm2PrivateKey.getDByInt());
            byte[] decryptedBytes = this.SM2DecryptMessage(dBytes, encryptData, 1);
            if (decryptedBytes == null) {
                decryptedBytes = this.SM2DecryptMessage(dBytes, encryptData, 4);
            }
            if (decryptedBytes == null) {
                decryptedBytes = this.SM2DecryptMessage(dBytes, encryptData);
            }
            if (decryptedBytes == null) {
                throw new PKIException("SM2DecryptMessage failure!!!decryptedBytes return null");
            }
            return decryptedBytes;
        }
        catch (Exception e) {
            if (logger.isErrorEnabled()) {
                logger.error("SM2DecryptMessage::<<<<<<Failure", (Throwable)e);
            }
            throw new PKIException("SM2DecryptMessage failure with exception: " + e.getMessage(), e);
        }
        catch (Throwable e) {
            if (logger.isErrorEnabled()) {
                logger.error("SM2DecryptMessage::<<<<<<Failure", e);
            }
            throw new PKIException("SM2DecryptMessage failure with throwable: " + e.getMessage(), e);
        }
    }

    private final byte[] SM2DecryptMessage(byte[] dBytes, byte[] encryptData, int encryptedType) {
        byte[] encryptedBytes = null;
        try {
            ASN1SM2Cipher asn1 = new ASN1SM2Cipher(encryptData, encryptedType);
            encryptedBytes = asn1.getEncryptedBytes(16);
            return this.SM2DecryptMessage(dBytes, encryptedBytes);
        }
        catch (Exception e) {
            encryptedBytes = null;
            return encryptedBytes;
        }
    }

    private final byte[] SM2DecryptMessage(byte[] dBytes, byte[] encryptedBytes) throws Exception {
        byte[] decryptedBytes = null;
        if (encryptedBytes != null) {
            byte[] plainText = new byte[encryptedBytes.length - 96];
            JNISM2.decrypt(encryptedBytes, dBytes, plainText);
            decryptedBytes = plainText;
        }
        return decryptedBytes;
    }

    protected final byte[] SM2SignHash(SM2PrivateKey sm2PrivateKey, byte[] hashValue) throws PKIException {
        if (logger.isDebugEnabled()) {
            StringBuffer buffer = new StringBuffer();
            buffer.append("SM2SignHash::>>>>>>Running");
            buffer.append("\n sm2PrivateKey: ");
            buffer.append(SADKDebugger.dump(sm2PrivateKey));
            buffer.append("\n hashValue: ");
            buffer.append(SADKDebugger.dump(hashValue));
            logger.debug(buffer.toString());
        }
        try {
            byte[] signValue = SM2PackageUtil.encryptByJNI(hashValue, sm2PrivateKey.dBigInteger());
            if (logger.isDebugEnabled()) {
                logger.debug("SM2SignHash::<<<<<<Finished: signValue=" + SADKDebugger.dump(signValue));
            }
            return signValue;
        }
        catch (Exception e) {
            if (logger.isErrorEnabled()) {
                logger.error("SM2SignHash::<<<<<<Failure", (Throwable)e);
            }
            throw new PKIException("SM2SignHash failure with exception: " + e.getMessage(), e);
        }
        catch (Throwable e) {
            if (logger.isErrorEnabled()) {
                logger.error("SM2SignHash::<<<<<<Failure", e);
            }
            throw new PKIException("SM2SignHash failure with throwable: " + e.getMessage(), e);
        }
    }

    protected final boolean SM2VerifyHash(SM2PublicKey sm2PublicKey, byte[] hashValue, byte[] signValue) throws PKIException {
        if (logger.isDebugEnabled()) {
            StringBuffer buffer = new StringBuffer();
            buffer.append("SM2VerifyHash::>>>>>>Running");
            buffer.append("\n sm2PublicKey: ");
            buffer.append(SADKDebugger.dump(sm2PublicKey));
            buffer.append("\n hashValue: ");
            buffer.append(SADKDebugger.dump(hashValue));
            buffer.append("\n signValue: ");
            buffer.append(SADKDebugger.dump(signValue));
            logger.debug(buffer.toString());
        }
        try {
            boolean verifyResult = SM2PackageUtil.verifyByJNI(hashValue, signValue, sm2PublicKey.getPubX(), sm2PublicKey.getPubY());
            if (logger.isDebugEnabled()) {
                logger.debug("SM2VerifyHash::<<<<<<Finished: verifyResult=" + verifyResult);
            }
            return verifyResult;
        }
        catch (Exception e) {
            if (logger.isErrorEnabled()) {
                logger.error("SM2VerifyHash::<<<<<<Failure", (Throwable)e);
            }
            throw new PKIException("SM2VerifyHash failure with exception: " + e.getMessage(), e);
        }
        catch (Throwable e) {
            if (logger.isErrorEnabled()) {
                logger.error("SM2VerifyHash::<<<<<<Failure", e);
            }
            throw new PKIException("SM2VerifyHash failure with throwable: " + e.getMessage(), e);
        }
    }

    protected final byte[] SM2HashMessage(SM2PublicKey sm2PubKey, byte[] message, boolean withZ) throws PKIException {
        if (logger.isDebugEnabled()) {
            StringBuffer buffer = new StringBuffer();
            buffer.append("SM2HashMessage::>>>>>>Running");
            buffer.append("\n sm2PublicKey: ");
            buffer.append(SADKDebugger.dump(sm2PubKey));
            buffer.append("\n message: ");
            buffer.append(SADKDebugger.dump(message));
            buffer.append("\n withZ: " + withZ);
            logger.debug(buffer.toString());
        }
        try {
            byte[] hashValue = new byte[32];
            JNIDigest sm3Hash = new JNIDigest(922);
            if (withZ) {
                sm3Hash.update(sm2PubKey.getDefaultZ());
            }
            sm3Hash.update(message);
            sm3Hash.doFinal(hashValue, 0);
            if (logger.isDebugEnabled()) {
                logger.debug("SM2HashMessage::<<<<<<Finished: hashValue=" + SADKDebugger.dump(hashValue));
            }
            return hashValue;
        }
        catch (Exception e) {
            if (logger.isErrorEnabled()) {
                logger.error("SM2HashMessage::<<<<<<Failure", (Throwable)e);
            }
            throw new PKIException("SM2HashMessage failure with exception: " + e.getMessage(), e);
        }
        catch (Throwable e) {
            if (logger.isErrorEnabled()) {
                logger.error("SM2HashMessage::<<<<<<Failure", e);
            }
            throw new PKIException("SM2HashMessage failure with throwable: " + e.getMessage(), e);
        }
    }

    protected final byte[] SM2HashFile(SM2PublicKey sm2PubKey, InputStream stream, boolean withZ) throws PKIException {
        if (logger.isDebugEnabled()) {
            StringBuffer buffer = new StringBuffer();
            buffer.append("SM2HashFile::>>>>>>Running");
            buffer.append("\n sm2PublicKey: ");
            buffer.append(SADKDebugger.dump(sm2PubKey));
            buffer.append("\n stream: ");
            buffer.append(SADKDebugger.dump(stream));
            buffer.append("\n withZ: " + withZ);
            logger.debug(buffer.toString());
        }
        try {
            byte[] hashValue = new byte[32];
            byte[] buffer = new byte[65536];
            JNIDigest engine = new JNIDigest(922);
            if (withZ) {
                engine.update(sm2PubKey.getDefaultZ());
            }
            int rLength = 0;
            byte[] data = null;
            while ((rLength = stream.read(buffer, 0, buffer.length)) != -1) {
                if (rLength < buffer.length) {
                    data = new byte[rLength];
                    System.arraycopy(buffer, 0, data, 0, data.length);
                } else {
                    data = buffer;
                }
                engine.update(data);
            }
            engine.doFinal(hashValue, 0);
            if (logger.isDebugEnabled()) {
                logger.debug("SM2HashFile::<<<<<<Finished: hashValue=" + SADKDebugger.dump(hashValue));
            }
            return hashValue;
        }
        catch (Exception e) {
            if (logger.isErrorEnabled()) {
                logger.error("SM2HashFile::<<<<<<Failure", (Throwable)e);
            }
            throw new PKIException("SM2HashFile failure with exception: " + e.getMessage(), e);
        }
        catch (Throwable e) {
            if (logger.isErrorEnabled()) {
                logger.error("SM2HashFile::<<<<<<Failure", e);
            }
            throw new PKIException("SM2HashFile failure with throwable: " + e.getMessage(), e);
        }
    }

    protected final byte[] RSAEncryptMessage(PublicKey publicKey, byte[] message) throws PKIException {
        if (logger.isDebugEnabled()) {
            StringBuffer buffer = new StringBuffer();
            buffer.append("RSAEncryptMessage::>>>>>>Running");
            buffer.append("\n publicKey: ");
            buffer.append(SADKDebugger.dump(publicKey));
            buffer.append("\n message: ");
            buffer.append(SADKDebugger.dump(message));
            logger.debug(buffer.toString());
        }
        try {
            if (message == null) {
                throw new Exception("the source data is null,can not encrypt!!!");
            }
            RSAPublicKey pubKey = (RSAPublicKey)publicKey;
            byte[] pkcs1PubKey = PKCS8ToPKCS1Util.RSAP8ToP1PubKey(pubKey);
            byte[] input = PKCS1Encoding.addPKCS1Padding(message, pubKey);
            int bitLen = pubKey.getModulus().bitLength();
            int blockLen = (bitLen + 7) / 8;
            byte[] encryptData = new byte[blockLen];
            JNIRSA.dowithPublicKey(input, pkcs1PubKey, encryptData);
            if (logger.isDebugEnabled()) {
                logger.debug("RSAEncryptMessage::<<<<<<Finished: encryptData=" + SADKDebugger.dump(encryptData));
            }
            return encryptData;
        }
        catch (Exception e) {
            if (logger.isErrorEnabled()) {
                logger.error("RSAEncryptMessage::<<<<<<Failure", (Throwable)e);
            }
            throw new PKIException("RSAEncryptMessage failure with exception: " + e.getMessage(), e);
        }
        catch (Throwable e) {
            if (logger.isErrorEnabled()) {
                logger.error("RSAEncryptMessage::<<<<<<Failure", e);
            }
            throw new PKIException("RSAEncryptMessage failure with throwable: " + e.getMessage(), e);
        }
    }

    protected final byte[] RSADecryptMessage(PrivateKey privateKey, byte[] encryptData) throws PKIException {
        if (logger.isDebugEnabled()) {
            StringBuffer buffer = new StringBuffer();
            buffer.append("RSADecryptMessage::>>>>>>Running");
            buffer.append("\n PrivateKey: ");
            buffer.append(SADKDebugger.dump(privateKey));
            buffer.append("\n encryptData: ");
            buffer.append(SADKDebugger.dump(encryptData));
            logger.debug(buffer.toString());
        }
        try {
            if (encryptData == null) {
                throw new Exception("the encrypt data is null,can not decrypt!!!");
            }
            RSAPrivateKey priKey = (RSAPrivateKey)privateKey;
            byte[] pkcs1PriKey = PKCS8ToPKCS1Util.RSAP8ToP1PriKey(priKey);
            int bitLen = priKey.getModulus().bitLength();
            int blockLen = (bitLen + 7) / 8;
            byte[] paddingData = new byte[blockLen];
            JNIRSA.dowithPrivateKey(encryptData, pkcs1PriKey, paddingData);
            byte[] decryptData = PKCS1Encoding.delPKCS1Padding(paddingData);
            if (logger.isDebugEnabled()) {
                logger.debug("RSADecryptMessage::<<<<<<Finished: decryptData=" + SADKDebugger.dump(decryptData));
            }
            return decryptData;
        }
        catch (Exception e) {
            if (logger.isErrorEnabled()) {
                logger.error("RSADecryptMessage::<<<<<<Failure", (Throwable)e);
            }
            throw new PKIException("RSADecryptMessage failure with exception: " + e.getMessage(), e);
        }
        catch (Throwable e) {
            if (logger.isErrorEnabled()) {
                logger.error("RSADecryptMessage::<<<<<<Failure", e);
            }
            throw new PKIException("RSADecryptMessage failure with throwable: " + e.getMessage(), e);
        }
    }

    protected final byte[] RSASignHash(PrivateKey privateKey, byte[] hashWithAlgorithm) throws PKIException {
        if (logger.isDebugEnabled()) {
            StringBuffer buffer = new StringBuffer();
            buffer.append("RSASignHash::>>>>>>Running");
            buffer.append("\n PrivateKey: ");
            buffer.append(SADKDebugger.dump(privateKey));
            buffer.append("\n hashWithAlgorithm: ");
            buffer.append(SADKDebugger.dump(hashWithAlgorithm));
            logger.debug(buffer.toString());
        }
        try {
            byte[] signValue = RSAPackageUtil.encryptByJNI(hashWithAlgorithm, privateKey);
            if (logger.isDebugEnabled()) {
                logger.debug("RSASignHash::<<<<<<Finished: signValue=" + SADKDebugger.dump(signValue));
            }
            return signValue;
        }
        catch (Exception e) {
            if (logger.isErrorEnabled()) {
                logger.error("RSASignHash::<<<<<<Failure", (Throwable)e);
            }
            throw new PKIException("RSASignHash failure with exception: " + e.getMessage(), e);
        }
        catch (Throwable e) {
            if (logger.isErrorEnabled()) {
                logger.error("RSASignHash::<<<<<<Failure", e);
            }
            throw new PKIException("RSASignHash failure with throwable: " + e.getMessage(), e);
        }
    }

    protected final boolean RSAVerifyHash(PublicKey publicKey, byte[] hashWithAlgorithm, byte[] signValue) throws PKIException {
        if (logger.isDebugEnabled()) {
            StringBuffer buffer = new StringBuffer();
            buffer.append("RSAVerifyHash::>>>>>>Running");
            buffer.append("\n publicKey: ");
            buffer.append(SADKDebugger.dump(publicKey));
            buffer.append("\n hashWithAlgorithm: ");
            buffer.append(SADKDebugger.dump(hashWithAlgorithm));
            buffer.append("\n signValue: ");
            buffer.append(SADKDebugger.dump(signValue));
            logger.debug(buffer.toString());
        }
        try {
            byte[] decryptedBytes = RSAPackageUtil.decryptByJNI(signValue, publicKey);
            boolean verifyResult = RSAPackageUtil.isRSAHashEqual(decryptedBytes, hashWithAlgorithm);
            if (logger.isDebugEnabled()) {
                logger.debug("RSAVerifyHash::<<<<<<Finished: verifyResult=" + verifyResult);
            }
            return verifyResult;
        }
        catch (Exception e) {
            if (logger.isErrorEnabled()) {
                logger.error("RSAVerifyHash::<<<<<<Failure", (Throwable)e);
            }
            throw new PKIException("RSAVerifyHash failure with exception: " + e.getMessage(), e);
        }
        catch (Throwable e) {
            if (logger.isErrorEnabled()) {
                logger.error("RSAVerifyHash::<<<<<<Failure", e);
            }
            throw new PKIException("RSAVerifyHash failure with throwable: " + e.getMessage(), e);
        }
    }

    protected final byte[] RSAHashMessage(Mechanism mechanism, byte[] message) throws PKIException {
        return this.RSAHashMessage(mechanism, message, true);
    }

    protected byte[] RSAHashMessage(Mechanism mechanism, byte[] message, boolean isDerEncoding) throws PKIException {
        if (logger.isDebugEnabled()) {
            StringBuffer buffer = new StringBuffer();
            buffer.append("RSAHashMessage::>>>>>>Running");
            buffer.append("\n mechanism: ");
            buffer.append(SADKDebugger.dump(mechanism));
            buffer.append("\n message: ");
            buffer.append(SADKDebugger.dump(message));
            logger.debug(buffer.toString());
        }
        try {
            byte[] hashWithAlgorithm = HashUtil.RSAHashMessageByJNI(message, mechanism, isDerEncoding);
            if (logger.isDebugEnabled()) {
                logger.debug("RSAHashMessage::<<<<<<Finished: hashWithAlgorithm=" + SADKDebugger.dump(hashWithAlgorithm));
            }
            return hashWithAlgorithm;
        }
        catch (Exception e) {
            if (logger.isErrorEnabled()) {
                logger.error("RSAHashMessage::<<<<<<Failure", (Throwable)e);
            }
            throw new PKIException("RSAHashMessage failure with exception: " + e.getMessage(), e);
        }
        catch (Throwable e) {
            if (logger.isErrorEnabled()) {
                logger.error("RSAHashMessage::<<<<<<Failure", e);
            }
            throw new PKIException("RSAHashMessage failure with throwable: " + e.getMessage(), e);
        }
    }

    protected final byte[] RSAHashFile(Mechanism mechanism, InputStream stream) throws PKIException {
        return this.RSAHashFile(mechanism, stream, true);
    }

    protected final byte[] RSAHashFile(Mechanism mechanism, InputStream stream, boolean isDerEncoding) throws PKIException {
        if (logger.isDebugEnabled()) {
            StringBuffer buffer = new StringBuffer();
            buffer.append("RSAHashFile::>>>>>>Running");
            buffer.append("\n mechanism: ");
            buffer.append(SADKDebugger.dump(mechanism));
            buffer.append("\n stream: ");
            buffer.append(SADKDebugger.dump(stream));
            logger.debug(buffer.toString());
        }
        try {
            byte[] hashWithAlgorithm = HashUtil.RSAHashFileByJNI(stream, mechanism, true);
            if (logger.isDebugEnabled()) {
                logger.debug("RSAHashFile::<<<<<<Finished: hashWithAlgorithm=" + SADKDebugger.dump(hashWithAlgorithm));
            }
            return hashWithAlgorithm;
        }
        catch (Exception e) {
            if (logger.isErrorEnabled()) {
                logger.error("RSAHashFile::<<<<<<Failure", (Throwable)e);
            }
            throw new PKIException("RSAHashFile failure with exception: " + e.getMessage(), e);
        }
        catch (Throwable e) {
            if (logger.isErrorEnabled()) {
                logger.error("RSAHashFile::<<<<<<Failure", e);
            }
            throw new PKIException("RSAHashFile failure with throwable: " + e.getMessage(), e);
        }
    }

    protected final byte[] SM4EncryptMessage(Mechanism mechanism, Key key, byte[] message) throws PKIException {
        if (logger.isDebugEnabled()) {
            StringBuffer buffer = new StringBuffer();
            buffer.append("SM4EncryptMessage::>>>>>>Running");
            buffer.append("\n mechanism: ");
            buffer.append(SADKDebugger.dump(mechanism));
            buffer.append("\n key: ");
            buffer.append(SADKDebugger.dump(key));
            buffer.append("\n message: ");
            buffer.append(SADKDebugger.dump(message));
            logger.debug(buffer.toString());
        }
        try {
            byte[] encryptData = SymmetricHelper.dataEncrypt(true, mechanism, key.getEncoded(), message);
            if (logger.isDebugEnabled()) {
                logger.debug("SM4EncryptMessage::<<<<<<Finished: encryptData=" + SADKDebugger.dump(encryptData));
            }
            return encryptData;
        }
        catch (Exception e) {
            if (logger.isErrorEnabled()) {
                logger.error("SM4EncryptMessage::<<<<<<Failure", (Throwable)e);
            }
            throw new PKIException("SM4EncryptMessage failure with exception: " + e.getMessage(), e);
        }
        catch (Throwable e) {
            if (logger.isErrorEnabled()) {
                logger.error("SM4EncryptMessage::<<<<<<Failure", e);
            }
            throw new PKIException("SM4EncryptMessage failure with throwable: " + e.getMessage(), e);
        }
    }

    protected final byte[] SM4DecryptMessage(Mechanism mechanism, Key key, byte[] encryptData) throws PKIException {
        if (logger.isDebugEnabled()) {
            StringBuffer buffer = new StringBuffer();
            buffer.append("SM4DecryptMessage::>>>>>>Running");
            buffer.append("\n mechanism: ");
            buffer.append(SADKDebugger.dump(mechanism));
            buffer.append("\n key: ");
            buffer.append(SADKDebugger.dump(key));
            buffer.append("\n encryptData: ");
            buffer.append(SADKDebugger.dump(encryptData));
            logger.debug(buffer.toString());
        }
        try {
            byte[] decryptData = SymmetricHelper.dataDecrypt(true, mechanism, key.getEncoded(), encryptData);
            if (logger.isDebugEnabled()) {
                logger.debug("SM4DecryptMessage::<<<<<<Finished: decryptData=" + SADKDebugger.dump(decryptData));
            }
            return decryptData;
        }
        catch (Exception e) {
            if (logger.isErrorEnabled()) {
                logger.error("SM4DecryptMessage::<<<<<<Failure", (Throwable)e);
            }
            throw new PKIException("SM4DecryptMessage failure with exception: " + e.getMessage(), e);
        }
        catch (Throwable e) {
            if (logger.isErrorEnabled()) {
                logger.error("SM4DecryptMessage::<<<<<<Failure", e);
            }
            throw new PKIException("SM4DecryptMessage failure with throwable: " + e.getMessage(), e);
        }
    }

    protected final byte[] RC4EncryptMessage(Mechanism mechanism, Key key, byte[] message) throws PKIException {
        if (logger.isDebugEnabled()) {
            StringBuffer buffer = new StringBuffer();
            buffer.append("RC4EncryptMessage::>>>>>>Running");
            buffer.append("\n mechanism: ");
            buffer.append(SADKDebugger.dump(mechanism));
            buffer.append("\n key: ");
            buffer.append(SADKDebugger.dump(key));
            buffer.append("\n message: ");
            buffer.append(SADKDebugger.dump(message));
            logger.debug(buffer.toString());
        }
        try {
            byte[] encryptData = SymmetricHelper.dataEncrypt(true, mechanism, key.getEncoded(), message);
            if (logger.isDebugEnabled()) {
                logger.debug("RC4EncryptMessage::<<<<<<Finished: encryptData=" + SADKDebugger.dump(encryptData));
            }
            return encryptData;
        }
        catch (Exception e) {
            if (logger.isErrorEnabled()) {
                logger.error("RC4EncryptMessage::<<<<<<Failure", (Throwable)e);
            }
            throw new PKIException("RC4EncryptMessage failure with exception: " + e.getMessage(), e);
        }
        catch (Throwable e) {
            if (logger.isErrorEnabled()) {
                logger.error("RC4EncryptMessage::<<<<<<Failure", e);
            }
            throw new PKIException("RC4EncryptMessage failure with throwable: " + e.getMessage(), e);
        }
    }

    protected final byte[] RC4DecryptMessage(Mechanism mechanism, Key key, byte[] encryptData) throws PKIException {
        if (logger.isDebugEnabled()) {
            StringBuffer buffer = new StringBuffer();
            buffer.append("RC4DecryptMessage::>>>>>>Running");
            buffer.append("\n mechanism: ");
            buffer.append(SADKDebugger.dump(mechanism));
            buffer.append("\n key: ");
            buffer.append(SADKDebugger.dump(key));
            buffer.append("\n encryptData: ");
            buffer.append(SADKDebugger.dump(encryptData));
            logger.debug(buffer.toString());
        }
        try {
            byte[] decryptData = SymmetricHelper.dataDecrypt(true, mechanism, key.getEncoded(), encryptData);
            if (logger.isDebugEnabled()) {
                logger.debug("RC4DecryptMessage::<<<<<<Finished: decryptData=" + SADKDebugger.dump(decryptData));
            }
            return decryptData;
        }
        catch (Exception e) {
            if (logger.isErrorEnabled()) {
                logger.error("RC4DecryptMessage::<<<<<<Failure", (Throwable)e);
            }
            throw new PKIException("RC4DecryptMessage failure with exception: " + e.getMessage(), e);
        }
        catch (Throwable e) {
            if (logger.isErrorEnabled()) {
                logger.error("RC4DecryptMessage::<<<<<<Failure", e);
            }
            throw new PKIException("RC4DecryptMessage failure with throwable: " + e.getMessage(), e);
        }
    }

    protected final byte[] DESedeEncryptMessage(Mechanism mechanism, Key key, byte[] message) throws PKIException {
        if (logger.isDebugEnabled()) {
            StringBuffer buffer = new StringBuffer();
            buffer.append("DESedeEncryptMessage::>>>>>>Running");
            buffer.append("\n mechanism: ");
            buffer.append(SADKDebugger.dump(mechanism));
            buffer.append("\n key: ");
            buffer.append(SADKDebugger.dump(key));
            buffer.append("\n message: ");
            buffer.append(SADKDebugger.dump(message));
            logger.debug(buffer.toString());
        }
        try {
            byte[] encryptData = SymmetricHelper.dataEncrypt(true, mechanism, key.getEncoded(), message);
            if (logger.isDebugEnabled()) {
                logger.debug("DESedeEncryptMessage::<<<<<<Finished: encryptData=" + SADKDebugger.dump(encryptData));
            }
            return encryptData;
        }
        catch (Exception e) {
            if (logger.isErrorEnabled()) {
                logger.error("DESedeEncryptMessage::<<<<<<Failure", (Throwable)e);
            }
            throw new PKIException("DESedeEncryptMessage failure with exception: " + e.getMessage(), e);
        }
        catch (Throwable e) {
            if (logger.isErrorEnabled()) {
                logger.error("DESedeEncryptMessage::<<<<<<Failure", e);
            }
            throw new PKIException("DESedeEncryptMessage failure with throwable: " + e.getMessage(), e);
        }
    }

    protected final byte[] DESedeDecryptMessage(Mechanism mechanism, Key key, byte[] encryptData) throws PKIException {
        if (logger.isDebugEnabled()) {
            StringBuffer buffer = new StringBuffer();
            buffer.append("DESedeDecryptMessage::>>>>>>Running");
            buffer.append("\n mechanism: ");
            buffer.append(SADKDebugger.dump(mechanism));
            buffer.append("\n key: ");
            buffer.append(SADKDebugger.dump(key));
            buffer.append("\n encryptData: ");
            buffer.append(SADKDebugger.dump(encryptData));
            logger.debug(buffer.toString());
        }
        try {
            byte[] decryptData = SymmetricHelper.dataDecrypt(true, mechanism, key.getEncoded(), encryptData);
            if (logger.isDebugEnabled()) {
                logger.debug("DESedeDecryptMessage::<<<<<<Finished: decryptData=" + SADKDebugger.dump(decryptData));
            }
            return decryptData;
        }
        catch (Exception e) {
            if (logger.isErrorEnabled()) {
                logger.error("DESedeDecryptMessage::<<<<<<Failure", (Throwable)e);
            }
            throw new PKIException("DESedeDecryptMessage failure with exception: " + e.getMessage(), e);
        }
        catch (Throwable e) {
            if (logger.isErrorEnabled()) {
                logger.error("DESedeDecryptMessage::<<<<<<Failure", e);
            }
            throw new PKIException("DESedeDecryptMessage failure with throwable: " + e.getMessage(), e);
        }
    }

    protected final void SM2HashFile(SM2PublicKey sm2PubKey, boolean supportedWithoutZ, InputStream stream, byte[] hashWithZ, byte[] hashWithoutZ) throws PKIException {
        Object buffer;
        if (logger.isDebugEnabled()) {
            buffer = new StringBuffer();
            ((StringBuffer)buffer).append("SM2HashFile::>>>>>>Running");
            ((StringBuffer)buffer).append("\n sm2PubKey: ");
            ((StringBuffer)buffer).append(SADKDebugger.dump(sm2PubKey));
            ((StringBuffer)buffer).append("\n supportedWithoutZ: " + supportedWithoutZ);
            ((StringBuffer)buffer).append("\n stream: ");
            ((StringBuffer)buffer).append(SADKDebugger.dump(stream));
            logger.debug(((StringBuffer)buffer).toString());
        }
        try {
            buffer = new byte[65536];
            JNIDigest engineWithZ = new JNIDigest(922);
            engineWithZ.update(sm2PubKey.getDefaultZ());
            JNIDigest engineWithoutZ = null;
            if (supportedWithoutZ) {
                engineWithoutZ = new JNIDigest(922);
            }
            int rLength = 0;
            Object data = null;
            while ((rLength = stream.read((byte[])buffer, 0, ((Object)buffer).length)) != -1) {
                if (rLength < ((Object)buffer).length) {
                    data = new byte[rLength];
                    System.arraycopy(buffer, 0, data, 0, ((Object)data).length);
                } else {
                    data = buffer;
                }
                engineWithZ.update((byte[])data);
                if (!supportedWithoutZ) continue;
                engineWithoutZ.update((byte[])data);
            }
            engineWithZ.doFinal(hashWithZ, 0);
            if (logger.isDebugEnabled()) {
                logger.debug("SM2HashFile::<<<<<<Finished: hashWithZ=" + SADKDebugger.dump(hashWithZ));
            }
            if (supportedWithoutZ) {
                engineWithoutZ.doFinal(hashWithoutZ, 0);
                if (logger.isDebugEnabled()) {
                    logger.debug("SM2HashFile::<<<<<<Finished: hashWithoutZ=" + SADKDebugger.dump(hashWithoutZ));
                }
            }
        }
        catch (Exception e) {
            if (logger.isErrorEnabled()) {
                logger.error("SM2HashFile::<<<<<<Failure", (Throwable)e);
            }
            throw new PKIException("SM2HashFile failure with exception: " + e.getMessage(), e);
        }
        catch (Throwable e) {
            if (logger.isErrorEnabled()) {
                logger.error("SM2HashFile::<<<<<<Failure", e);
            }
            throw new PKIException("SM2HashFile failure with throwable: " + e.getMessage(), e);
        }
    }

    protected byte[] AESEncryptMessage(Mechanism mechanism, Key key, byte[] message) throws PKIException {
        if (logger.isDebugEnabled()) {
            StringBuffer buffer = new StringBuffer();
            buffer.append("AESEncryptMessage::>>>>>>Running");
            buffer.append("\n mechanism: ");
            buffer.append(SADKDebugger.dump(mechanism));
            buffer.append("\n key: ");
            buffer.append(SADKDebugger.dump(key));
            buffer.append("\n message: ");
            buffer.append(SADKDebugger.dump(message));
            logger.debug(buffer.toString());
        }
        try {
            byte[] encryptData = SymmetricHelper.dataEncrypt(false, mechanism, key.getEncoded(), message);
            if (logger.isDebugEnabled()) {
                logger.debug("AESEncryptMessage::<<<<<<Finished: encryptData=" + SADKDebugger.dump(encryptData));
            }
            return encryptData;
        }
        catch (Exception e) {
            if (logger.isErrorEnabled()) {
                logger.error("AESEncryptMessage::<<<<<<Failure", (Throwable)e);
            }
            throw new PKIException("AESEncryptMessage failure with exception: " + e.getMessage(), e);
        }
        catch (Throwable e) {
            if (logger.isErrorEnabled()) {
                logger.error("AESEncryptMessage::<<<<<<Failure", e);
            }
            throw new PKIException("AESEncryptMessage failure with throwable: " + e.getMessage(), e);
        }
    }

    protected byte[] AESDecryptMessage(Mechanism mechanism, Key key, byte[] encryptData) throws PKIException {
        if (logger.isDebugEnabled()) {
            StringBuffer buffer = new StringBuffer();
            buffer.append("AESDecryptMessage::>>>>>>Running");
            buffer.append("\n mechanism: ");
            buffer.append(SADKDebugger.dump(mechanism));
            buffer.append("\n key: ");
            buffer.append(SADKDebugger.dump(key));
            buffer.append("\n encryptData: ");
            buffer.append(SADKDebugger.dump(encryptData));
            logger.debug(buffer.toString());
        }
        try {
            byte[] decryptData = SymmetricHelper.dataDecrypt(false, mechanism, key.getEncoded(), encryptData);
            if (logger.isDebugEnabled()) {
                logger.debug("AESDecryptMessage::<<<<<<Finished: decryptData=" + SADKDebugger.dump(decryptData));
            }
            return decryptData;
        }
        catch (Exception e) {
            if (logger.isErrorEnabled()) {
                logger.error("AESDecryptMessage::<<<<<<Failure", (Throwable)e);
            }
            throw new PKIException("AESDecryptMessage failure with exception: " + e.getMessage(), e);
        }
        catch (Throwable e) {
            if (logger.isErrorEnabled()) {
                logger.error("AESDecryptMessage::<<<<<<Failure", e);
            }
            throw new PKIException("AESDecryptMessage failure with throwable: " + e.getMessage(), e);
        }
    }

    protected byte[] ECDSASignHash(PrivateKey privateKey, byte[] hashWithoutAlgorithm, Mechanism mechanism) throws PKIException {
        return BCSoftLib.INSTANCE().signByHash(mechanism, privateKey, hashWithoutAlgorithm);
    }

    protected boolean ECDSAVerifyHash(PublicKey publicKey, byte[] hashWithoutAlgorithm, byte[] signValue, Mechanism mechanism) throws PKIException {
        return BCSoftLib.INSTANCE().verifyByHash(mechanism, publicKey, hashWithoutAlgorithm, signValue);
    }

    protected KeyPair ECCGenerateKeyPair(Mechanism mechanism) throws PKIException {
        return BCSoftLib.INSTANCE().generateKeyPair(mechanism, 256);
    }

    public PublicKey exportEncPublicKey() throws Exception {
        throw new PKIException("exportEncPublicKey failure: JNISoftLib not supported!");
    }

    public boolean importSM2KeyPair(byte[] encryptKeyData, int CKID) throws Exception {
        throw new PKIException("exportEncPublicKey failure: JNISoftLib not supported!");
    }

    protected byte[] ECCEncryptMessage(PublicKey publicKey, byte[] message) throws PKIException {
        return BCSoftLib.INSTANCE().encrypt(new Mechanism("ECC"), publicKey, message);
    }

    protected byte[] ECCDecryptMessage(PrivateKey privateKey, byte[] encryptData) throws PKIException {
        return BCSoftLib.INSTANCE().decrypt(new Mechanism("ECC"), privateKey, encryptData);
    }
}

