/*
 * Decompiled with CFR 0.152.
 */
package cfca.sadk.lib.crypto.jni;

import cfca.sadk.algorithm.common.PKIException;
import java.security.KeyPair;
import java.security.KeyPairGenerator;

public class JNIRSA {
    public static boolean dowithPrivateKey(byte[] input, byte[] privateKey, byte[] output) throws Exception {
        return cryptokit.jni.JNIRSA.dowithPrivateKey((byte[])input, (byte[])privateKey, (byte[])output);
    }

    public static boolean dowithPublicKey(byte[] input, byte[] publicKey, byte[] output) throws Exception {
        return cryptokit.jni.JNIRSA.dowithPublicKey((byte[])input, (byte[])publicKey, (byte[])output);
    }

    public static final KeyPair RSAGenerateKeyPair(int bitLength) throws Exception {
        try {
            KeyPairGenerator keyPairGen = null;
            try {
                keyPairGen = KeyPairGenerator.getInstance("RSA");
            }
            catch (Exception e) {
                throw new SecurityException("RSAGenerateKeyPair failure with exception: " + e.getMessage(), e);
            }
            if (bitLength < 0 || bitLength > 4096 || bitLength % 512 != 0) {
                throw new SecurityException("RSAGenerateKeyPair failure with invalid bitLength=" + bitLength);
            }
            try {
                keyPairGen.initialize(bitLength);
                KeyPair keypair = keyPairGen.generateKeyPair();
                return keypair;
            }
            catch (Exception e) {
                throw new SecurityException("RSAGenerateKeyPair failure with exception: " + e.getMessage(), e);
            }
        }
        catch (SecurityException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new PKIException("RSAGenerateKeyPair failure with throwable: " + e.getMessage(), e);
        }
    }
}

