/*
 * Decompiled with CFR 0.152.
 */
package cfca.sadk.lib.crypto.card.dummy;

import cfca.org.slf4j.Logger;
import cfca.org.slf4j.LoggerFactory;
import cfca.sadk.algorithm.common.PKIException;
import cfca.sadk.algorithm.sm2.SM2PrivateKey;
import cfca.sadk.algorithm.sm2.SM2PublicKey;
import cfca.sadk.lib.crypto.card.CardException;
import cfca.sadk.lib.crypto.card.CardOperationException;
import cfca.sadk.lib.crypto.card.CardParameterException;
import cfca.sadk.lib.crypto.card.ISM2Card;
import cfca.sadk.lib.crypto.jni.JNISM2;
import cfca.sadk.org.bouncycastle.crypto.params.ECDomainParameters;
import cfca.sadk.org.bouncycastle.crypto.params.ECPrivateKeyParameters;
import cfca.sadk.org.bouncycastle.crypto.params.ECPublicKeyParameters;
import cfca.sadk.org.bouncycastle.jcajce.provider.asymmetric.sm.SM2Params;
import cfca.sadk.org.bouncycastle.math.ec.ECPoint;
import cfca.sadk.system.SADKDebugger;
import java.math.BigInteger;
import java.security.KeyPair;
import java.security.PrivateKey;
import java.security.PublicKey;

public final class DummySM2Card
implements ISM2Card {
    static final Logger logger = LoggerFactory.getLogger(DummySM2Card.class);
    public static final DummySM2Card dummy = new DummySM2Card();

    public void initLib(Object param) throws CardException {
    }

    public KeyPair generateKeyPair(boolean isExport, int keyIndex, int keyUsage) throws CardException {
        if (logger.isDebugEnabled()) {
            logger.debug(String.format("SM2GenerateKeyPair>>>>>>Running: isExport=%s,keyIndex=%s,keyUsage=%s", isExport, keyIndex, keyUsage));
        }
        try {
            byte[] dBytes = new byte[32];
            byte[] xBytes = new byte[32];
            byte[] yBytes = new byte[32];
            for (int i = 0; i < 6; ++i) {
                boolean operationResult = JNISM2.generateKeypair(dBytes, xBytes, yBytes);
                if (!operationResult) {
                    if (logger.isErrorEnabled()) {
                        logger.error("SM2GenerateKeyPair<<<<<<operation failure: operationResult=" + operationResult);
                    }
                    throw new CardOperationException("SM2GenerateKeyPair<<<<<<operation failure: operationResult=" + operationResult);
                }
                if (dBytes[0] != 0 && xBytes[0] != 0 && yBytes[0] != 0) continue;
            }
            ECDomainParameters spec = SM2Params.sm2DomainParameters;
            ECPoint pubPoint = spec.getCurve().createPoint(new BigInteger(1, xBytes), new BigInteger(1, yBytes));
            ECPublicKeyParameters pubParams = new ECPublicKeyParameters(pubPoint, spec);
            SM2PublicKey pubKey = new SM2PublicKey(pubParams);
            SM2PrivateKey priKey = new SM2PrivateKey(new ECPrivateKeyParameters(new BigInteger(1, dBytes), spec), pubParams);
            KeyPair keypair = new KeyPair(pubKey, priKey);
            if (logger.isDebugEnabled()) {
                logger.debug("SM2GenerateKeyPair<<<<<<Finished: keypair=" + SADKDebugger.dump(keypair));
            }
            return keypair;
        }
        catch (PKIException e) {
            if (logger.isErrorEnabled()) {
                logger.error("SM2GenerateKeyPair<<<<<<Failure", (Throwable)e);
            }
            throw new CardException("SM2GenerateKeyPair failure: " + e.getMessage(), e);
        }
        catch (Throwable e) {
            if (logger.isErrorEnabled()) {
                logger.error("SM2GenerateKeyPair<<<<<<Failure", e);
            }
            throw new CardException("SM2GenerateKeyPair failure: " + e.getMessage(), e);
        }
    }

    public byte[] signByHash(PrivateKey privateKey, byte[] sm3HashValue) throws CardException {
        boolean operationResult;
        if (logger.isDebugEnabled()) {
            StringBuffer buffer = new StringBuffer();
            buffer.append("SM2SignByHash>>>>>>Running");
            buffer.append("\n privateKey: ");
            buffer.append(SADKDebugger.dump(privateKey));
            buffer.append("\n sm3HashValue: ");
            buffer.append(SADKDebugger.dump(sm3HashValue));
            logger.debug(buffer.toString());
        }
        if (sm3HashValue == null || sm3HashValue.length == 0) {
            throw new CardParameterException("SM2SignByHash<<<<<<missing hashValue");
        }
        if (sm3HashValue.length != 32) {
            throw new CardParameterException("SM2SignByHash<<<<<<invalid hashValue: " + SADKDebugger.dump(sm3HashValue));
        }
        SM2PrivateKey cardKey = DummySM2Card.convertPrivateKey(privateKey);
        byte[] signData = new byte[64];
        byte[] rBytes = new byte[32];
        byte[] sBytes = new byte[32];
        try {
            operationResult = JNISM2.sign(sm3HashValue, cardKey.getDByBytes(), rBytes, sBytes);
        }
        catch (Exception e) {
            if (logger.isErrorEnabled()) {
                logger.error("SM2SignByHash<<<<<<operation failure", (Throwable)e);
            }
            throw new CardOperationException("SM2SignByHash<<<<<<operation failure", e);
        }
        catch (Throwable e) {
            if (logger.isErrorEnabled()) {
                logger.error("SM2SignByHash<<<<<<operation failure", e);
            }
            throw new CardOperationException("SM2SignByHash<<<<<<operation failure", e);
        }
        if (!operationResult) {
            if (logger.isDebugEnabled()) {
                logger.debug("SM2SignByHash<<<<<<operation failure: operationResult=" + operationResult);
            }
            throw new CardOperationException("SM2SignByHash<<<<<<operation failure: operationResult=" + operationResult);
        }
        System.arraycopy(rBytes, 0, signData, 0, 32);
        System.arraycopy(sBytes, 0, signData, 32, 32);
        if (logger.isDebugEnabled()) {
            logger.debug("SM2SignByHash<<<<<<Finished: signData=" + SADKDebugger.dump(signData));
        }
        return signData;
    }

    public boolean verifyByHash(PublicKey publicKey, byte[] sm3HashValue, byte[] signData) throws CardException {
        boolean operationResult;
        if (logger.isDebugEnabled()) {
            StringBuffer buffer = new StringBuffer();
            buffer.append("SM2VerifyByHash>>>>>>Running");
            buffer.append("\n publicKey: ");
            buffer.append(SADKDebugger.dump(publicKey));
            buffer.append("\n sm3HashValue: ");
            buffer.append(SADKDebugger.dump(sm3HashValue));
            buffer.append("\n signData: ");
            buffer.append(SADKDebugger.dump(signData));
            logger.debug(buffer.toString());
        }
        if (sm3HashValue == null || sm3HashValue.length == 0) {
            throw new CardParameterException("missing hashValue");
        }
        if (sm3HashValue.length != 32) {
            throw new CardParameterException("SM2VerifyByHash<<<<<<invalid hashValue: " + SADKDebugger.dump(sm3HashValue));
        }
        if (signData == null || signData.length == 0) {
            throw new CardParameterException("SM2VerifyByHash<<<<<<missing signData");
        }
        if (signData.length != 64) {
            throw new CardParameterException("SM2VerifyByHash<<<<<<invalid signData: " + SADKDebugger.dump(signData));
        }
        SM2PublicKey cardKey = this.convertPublicKey(publicKey);
        try {
            byte[] rBytes = new byte[32];
            byte[] sBytes = new byte[32];
            System.arraycopy(signData, 0, rBytes, 0, 32);
            System.arraycopy(signData, 32, sBytes, 0, 32);
            operationResult = JNISM2.verify(rBytes, sBytes, cardKey.getPubXByBytes(), cardKey.getPubYByBytes(), sm3HashValue);
        }
        catch (Exception e) {
            if (logger.isErrorEnabled()) {
                logger.error("SM2VerifyByHash<<<<<<Failure: operation failure", (Throwable)e);
            }
            throw new CardOperationException("SM2VerifyByHash<<<<<<Failure: operation failure", e);
        }
        catch (Throwable e) {
            if (logger.isErrorEnabled()) {
                logger.error("SM2VerifyByHash<<<<<<Failure: operation failure", e);
            }
            throw new CardOperationException("SM2VerifyByHash<<<<<<Failure: operation failure", e);
        }
        if (!operationResult) {
            if (logger.isDebugEnabled()) {
                logger.debug("SM2VerifyByHash<<<<<<Failure: operationResult=" + operationResult);
            }
            throw new CardException("SM2VerifyByHash<<<<<<Failure: operationResult=" + operationResult);
        }
        if (logger.isDebugEnabled()) {
            logger.debug("SM2VerifyByHash<<<<<<Finished: verifyResult=" + operationResult);
        }
        return operationResult;
    }

    public byte[] encrypt(PublicKey publicKey, byte[] sourceData) throws CardException {
        boolean operationResult;
        if (logger.isDebugEnabled()) {
            StringBuffer buffer = new StringBuffer();
            buffer.append("SM2Encrypt>>>>>>Running");
            buffer.append("\n publicKey: ");
            buffer.append(SADKDebugger.dump(publicKey));
            buffer.append("\n sourceData: ");
            buffer.append(SADKDebugger.dump(sourceData));
            logger.debug(buffer.toString());
        }
        if (sourceData == null || sourceData.length == 0) {
            throw new CardParameterException("SM2Encrypt<<<<<<missing sourceData");
        }
        SM2PublicKey cardKey = this.convertPublicKey(publicKey);
        byte[] jniEncryptData = new byte[sourceData.length + 96];
        try {
            operationResult = JNISM2.encrypt(sourceData, cardKey.getPubXByBytes(), cardKey.getPubYByBytes(), jniEncryptData);
        }
        catch (Exception e) {
            if (logger.isErrorEnabled()) {
                logger.error("SM2Encrypt<<<<<<Failure: operation failure", (Throwable)e);
            }
            throw new CardOperationException("SM2Encrypt<<<<<<Failure: operation failure", e);
        }
        catch (Throwable e) {
            if (logger.isErrorEnabled()) {
                logger.error("SM2Encrypt<<<<<<Failure: operation failure", e);
            }
            throw new CardOperationException("SM2Encrypt<<<<<<Failure: operation failure", e);
        }
        if (!operationResult) {
            if (logger.isDebugEnabled()) {
                logger.debug("SM2Encrypt<<<<<<Failure: operationResult=" + operationResult);
            }
            throw new CardException("SM2Encrypt<<<<<<Failure: operationResult=" + operationResult);
        }
        if (logger.isDebugEnabled()) {
            logger.debug("SM2Encrypt<<<<<<Finished: jniEncryptData=" + SADKDebugger.dump(jniEncryptData));
        }
        byte[] sm2EncryptData = this.convertRAWC1C2C3ToRAWC1C3C2(jniEncryptData);
        if (logger.isDebugEnabled()) {
            logger.debug("SM2Encrypt<<<<<<Finished: sm2EncryptData=" + SADKDebugger.dump(sm2EncryptData));
        }
        return sm2EncryptData;
    }

    public byte[] decrypt(PrivateKey privateKey, byte[] sm2EncryptData) throws CardException {
        boolean operationResult;
        if (logger.isDebugEnabled()) {
            StringBuffer buffer = new StringBuffer();
            buffer.append("SM2Decrypt>>>>>>Running");
            buffer.append("\n privateKey: ");
            buffer.append(SADKDebugger.dump(privateKey));
            buffer.append("\n sm2EncryptData: ");
            buffer.append(SADKDebugger.dump(sm2EncryptData));
            logger.debug(buffer.toString());
        }
        if (sm2EncryptData == null || sm2EncryptData.length == 0) {
            throw new CardParameterException("SM2Decrypt<<<<<<missing sm2EncryptData");
        }
        if (sm2EncryptData.length < 96) {
            throw new CardParameterException("SM2Decrypt<<<<<<small sm2EncryptData");
        }
        if (logger.isDebugEnabled()) {
            logger.debug("SM2Decrypt>>>>>>sm2EncryptData=" + SADKDebugger.dump(sm2EncryptData));
        }
        byte[] jniEncryptData = this.convertRAWC1C3C2ToRAWC1C2C3(sm2EncryptData);
        if (logger.isDebugEnabled()) {
            logger.debug("SM2Decrypt>>>>>>jniEncryptData=" + SADKDebugger.dump(jniEncryptData));
        }
        SM2PrivateKey cardKey = DummySM2Card.convertPrivateKey(privateKey);
        byte[] decryptData = new byte[jniEncryptData.length - 96];
        try {
            operationResult = JNISM2.decrypt(jniEncryptData, cardKey.getDByBytes(), decryptData);
        }
        catch (Exception e) {
            if (logger.isErrorEnabled()) {
                logger.error("SM2Decrypt<<<<<<Failure: operation failure", (Throwable)e);
            }
            throw new CardOperationException("SM2Decrypt<<<<<<Failure: operation failure", e);
        }
        catch (Throwable e) {
            if (logger.isErrorEnabled()) {
                logger.error("SM2Decrypt<<<<<<Failure: operation failure", e);
            }
            throw new CardOperationException("SM2Decrypt<<<<<<Failure: operation failure", e);
        }
        if (!operationResult) {
            if (logger.isDebugEnabled()) {
                logger.debug("SM2Decrypt<<<<<<Failure: operationResult=" + operationResult);
            }
            throw new CardException("SM2Decrypt<<<<<<Failure: operationResult=" + operationResult);
        }
        if (logger.isDebugEnabled()) {
            logger.debug("SM2Decrypt<<<<<<Finished: decryptData=" + SADKDebugger.dump(decryptData));
        }
        return decryptData;
    }

    private static final SM2PrivateKey convertPrivateKey(PrivateKey privateKey) throws CardException {
        if (privateKey == null) {
            throw new CardParameterException("missing privateKey");
        }
        SM2PrivateKey outputPrivateKey = null;
        if (!(privateKey instanceof SM2PrivateKey)) {
            throw new CardParameterException("invalid privateKey: required SM2PrivateKey");
        }
        outputPrivateKey = (SM2PrivateKey)privateKey;
        return outputPrivateKey;
    }

    private final SM2PublicKey convertPublicKey(PublicKey publicKey) throws CardException {
        if (publicKey == null) {
            throw new CardParameterException("missing publicKey");
        }
        SM2PublicKey outputPublicKey = null;
        if (!(publicKey instanceof SM2PublicKey)) {
            throw new CardParameterException("invalid publicKey: required SM2PublicKey");
        }
        outputPublicKey = (SM2PublicKey)publicKey;
        return outputPublicKey;
    }

    private final byte[] convertRAWC1C2C3ToRAWC1C3C2(byte[] jniEncryptData) {
        int C1Length = 64;
        int C2Length = jniEncryptData.length - 96;
        byte[] sm2EncryptData = new byte[jniEncryptData.length];
        System.arraycopy(jniEncryptData, 0, sm2EncryptData, 0, 64);
        System.arraycopy(jniEncryptData, jniEncryptData.length - 32, sm2EncryptData, 64, 32);
        System.arraycopy(jniEncryptData, 64, sm2EncryptData, 96, C2Length);
        return sm2EncryptData;
    }

    private final byte[] convertRAWC1C3C2ToRAWC1C2C3(byte[] sm2EncryptData) {
        int C1Length = 64;
        int C2Length = sm2EncryptData.length - 96;
        byte[] jniEncryptData = new byte[sm2EncryptData.length];
        System.arraycopy(sm2EncryptData, 0, jniEncryptData, 0, 64);
        System.arraycopy(sm2EncryptData, 96, jniEncryptData, 64, C2Length);
        System.arraycopy(sm2EncryptData, 64, jniEncryptData, jniEncryptData.length - 32, 32);
        return jniEncryptData;
    }

    public void unInitLib(Object param) {
    }

    public long loginSM2Card(String password) throws CardException {
        return 0L;
    }

    public PublicKey expoertEncPublicKey() throws CardException {
        throw new CardException("exportEncPublicKey failure: DummySM2Card not supported!");
    }

    public boolean importSM2KeyPair(byte[] encryptKeyData, int CKID) throws CardException {
        throw new CardException("importSM2KeyPair failure: DummySM2Card not supported!");
    }
}

