/*
 * Decompiled with CFR 0.152.
 */
package cfca.sadk.lib.crypto.card.dummy;

import cfca.org.slf4j.Logger;
import cfca.org.slf4j.LoggerFactory;
import cfca.sadk.algorithm.util.PKCS8ToPKCS1Util;
import cfca.sadk.lib.crypto.card.CardException;
import cfca.sadk.lib.crypto.card.CardParameterException;
import cfca.sadk.org.bouncycastle.util.encoders.Hex;
import java.math.BigInteger;
import java.security.interfaces.RSAPublicKey;
import java.util.Arrays;
import java.util.Formatter;

final class DummyRSAPublicKey
implements RSAPublicKey {
    static final Logger logger = LoggerFactory.getLogger(DummyRSAPublicKey.class);
    private static final long serialVersionUID = 4067087213271390746L;
    private final RSAPublicKey publicKeyRef;
    private final byte[] x509EncodedBytes;
    final byte[] jniEncodedBytes;
    final int moduleBytesLength;

    public DummyRSAPublicKey(RSAPublicKey publicKeyRef) throws CardException {
        if (publicKeyRef == null) {
            throw new CardParameterException("missing publicKeyRef");
        }
        this.publicKeyRef = publicKeyRef;
        this.jniEncodedBytes = this.buildEncodedBytes(publicKeyRef);
        this.moduleBytesLength = (7 + publicKeyRef.getModulus().bitLength()) / 8;
        try {
            this.x509EncodedBytes = publicKeyRef.getEncoded();
        }
        catch (Exception e) {
            throw new CardParameterException("invalid publicKeyRef with x509EncodedBytes", e);
        }
    }

    public String getAlgorithm() {
        return this.publicKeyRef.getAlgorithm();
    }

    public String getFormat() {
        return this.publicKeyRef.getFormat();
    }

    public byte[] getEncoded() {
        return this.x509EncodedBytes;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + Arrays.hashCode(this.jniEncodedBytes);
        result = 31 * result + this.moduleBytesLength;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        DummyRSAPublicKey other = (DummyRSAPublicKey)obj;
        if (!Arrays.equals(this.jniEncodedBytes, other.jniEncodedBytes)) {
            return false;
        }
        return this.moduleBytesLength == other.moduleBytesLength;
    }

    public String toString() {
        Formatter builder = new Formatter();
        builder.format("DummyRSAPublicKey ", new Object[0]);
        try {
            builder.format("\n%8s%20s=0x%s", "", "Modulus", this.publicKeyRef.getModulus().toString(16));
            builder.format("\n%8s%20s=0x%s", "", "PublicExponent", this.publicKeyRef.getPublicExponent().toString(16));
        }
        catch (Exception e) {
            logger.error("DummyRSAPublicKey dump detail invalid", (Throwable)e);
            builder.format("\n%8s%20s=0x%s", "", "k", "failure");
        }
        builder.format("\n%4s%20s=0x%s", "", "jniEncodedBytes", Hex.toHexString(this.jniEncodedBytes));
        builder.format("\n%4s%20s=%s", "", "moduleBytesLength", this.moduleBytesLength);
        String output = builder.toString();
        builder.close();
        return output;
    }

    private final byte[] buildEncodedBytes(RSAPublicKey publicKey) throws CardException {
        byte[] jniEncodedBytes = null;
        try {
            jniEncodedBytes = PKCS8ToPKCS1Util.RSAP8ToP1PubKey(publicKey);
        }
        catch (Exception e) {
            throw new CardParameterException("buildEncodedBytes failure", e);
        }
        return jniEncodedBytes;
    }

    public BigInteger getModulus() {
        return this.publicKeyRef.getModulus();
    }

    public BigInteger getPublicExponent() {
        return this.publicKeyRef.getPublicExponent();
    }
}

