/*
 * Decompiled with CFR 0.152.
 */
package cfca.sadk.lib.crypto.card.c200;

import cfca.org.slf4j.Logger;
import cfca.org.slf4j.LoggerFactory;
import cfca.sadk.algorithm.common.GenKeyAttribute;
import cfca.sadk.lib.crypto.card.CardException;
import cfca.sadk.lib.crypto.card.c200.C200CardP11;
import cfca.sadk.lib.crypto.card.c200.ECCCardPrivateKey;
import cfca.sadk.lib.crypto.card.c200.ECCCardPublicKey;
import cfca.sadk.lib.crypto.card.c200.SM2CardInfo;
import cfca.sadk.org.bouncycastle.jcajce.provider.asymmetric.ec.BCECPublicKey;
import cfca.sadk.system.SADKDebugger;
import java.io.IOException;
import java.security.KeyPair;
import java.security.PrivateKey;
import java.security.PublicKey;

final class ECCCardP11 {
    static final Logger logger = LoggerFactory.getLogger(ECCCardP11.class);
    private C200CardP11 p11;

    public ECCCardP11(SM2CardInfo info) throws CardException {
        this.p11 = C200CardP11.getInstance(info);
    }

    final byte[] ECCCardSign(ECCCardPrivateKey cardKey, byte[] hashValue) throws CardException {
        if (logger.isDebugEnabled()) {
            StringBuffer buffer = new StringBuffer();
            buffer.append("SM2CardSign>>>>>>Running");
            buffer.append("\n cardKey: ");
            buffer.append(SADKDebugger.dump(cardKey));
            buffer.append("\n hashValue: ");
            buffer.append(SADKDebugger.dump(hashValue));
            logger.debug(buffer.toString());
        }
        if (cardKey == null || !(cardKey instanceof ECCCardPrivateKey)) {
            throw new CardException("SM2CardSign<<<<<<Failure with invalid ECCardPrivateKey");
        }
        if (hashValue == null || hashValue.length != 32) {
            throw new CardException("SM2CardSign<<<<<<Failure with invalid hashValue(Required 32)");
        }
        return this.p11.cardSign(cardKey, hashValue);
    }

    final boolean ECCCardVerify(ECCCardPublicKey cardKey, byte[] hashValue, byte[] signValue) throws CardException {
        if (logger.isDebugEnabled()) {
            StringBuffer buffer = new StringBuffer();
            buffer.append("SM2CardVerify>>>>>>Running");
            buffer.append("\n cardKey: ");
            buffer.append(SADKDebugger.dump(cardKey));
            buffer.append("\n hashValue: ");
            buffer.append(SADKDebugger.dump(hashValue));
            buffer.append("\n signValue: ");
            buffer.append(SADKDebugger.dump(signValue));
            logger.debug(buffer.toString());
        }
        if (cardKey == null || !(cardKey instanceof ECCCardPublicKey)) {
            throw new CardException("SM2CardVerify<<<<<<Failure with invalid SM2CardPublicKey");
        }
        if (hashValue == null || hashValue.length != 32) {
            throw new CardException("SM2CardVerify<<<<<<Failure with invalid hashValue(Required 32)!");
        }
        if (signValue == null) {
            throw new CardException("SM2CardVerify<<<<<<Failure with invalid signValue!");
        }
        return this.p11.cardVerify(cardKey, hashValue, signValue);
    }

    final byte[] ECCCardEncrypt(ECCCardPublicKey cardKey, byte[] sourceData) throws CardException {
        if (logger.isDebugEnabled()) {
            StringBuffer buffer = new StringBuffer();
            buffer.append("SM2CardEncrypt>>>>>>Running");
            buffer.append("\n cardKey: ");
            buffer.append(SADKDebugger.dump(cardKey));
            buffer.append("\n sourceData: ");
            buffer.append(SADKDebugger.dump(sourceData));
            logger.debug(buffer.toString());
        }
        if (cardKey == null || !(cardKey instanceof ECCCardPublicKey)) {
            throw new CardException("SM2CardEncrypt<<<<<<Failure with invalid SM2CardPublicKey");
        }
        if (sourceData == null || sourceData.length == 0) {
            throw new CardException("SM2CardEncrypt Failure with invalid sourceData(Required > 0)!");
        }
        return this.p11.cardEncrypt(cardKey, sourceData);
    }

    final byte[] ECCCardDecrypt(ECCCardPrivateKey cardKey, byte[] encryptData) throws CardException {
        if (logger.isDebugEnabled()) {
            StringBuffer buffer = new StringBuffer();
            buffer.append("CardDecrypt>>>>>>Running");
            buffer.append("\n cardKey: ");
            buffer.append(SADKDebugger.dump(cardKey));
            buffer.append("\n encryptData: ");
            buffer.append(SADKDebugger.dump(encryptData));
            logger.debug(buffer.toString());
        }
        if (cardKey == null || !(cardKey instanceof ECCCardPrivateKey)) {
            throw new CardException("CardDecrypt<<<<<<Failure with invalid SM2CardPrivateKey");
        }
        if (encryptData == null || encryptData.length <= 96) {
            throw new CardException("CardDecrypt<<<<<<Failure with invalid encryptData(Required > 96)!");
        }
        return this.p11.cardDecrypt(cardKey, encryptData);
    }

    final ECCCardPublicKey ECCardPublicKey(PublicKey pubKey) throws CardException, IOException {
        if (pubKey == null) {
            throw new CardException("ECCardPublicKey<<<<<<Required PublicKey");
        }
        ECCCardPublicKey cardKey = null;
        if (pubKey instanceof ECCCardPublicKey) {
            cardKey = (ECCCardPublicKey)pubKey;
        } else {
            BCECPublicKey eccKey = null;
            if (!(pubKey instanceof BCECPublicKey)) {
                throw new CardException("ECCardPublicKey<<<<<<Required BCECPublicKey");
            }
            eccKey = (BCECPublicKey)pubKey;
            KeyPair keypair = this.p11.getKeyPair(eccKey);
            cardKey = keypair == null ? new ECCCardPublicKey(eccKey) : (ECCCardPublicKey)keypair.getPublic();
        }
        return cardKey;
    }

    final ECCCardPrivateKey ECCardPrivateKey(PrivateKey privKey) throws CardException {
        if (privKey == null) {
            throw new CardException("ECCardPrivateKey<<<<<<Failure: required PrivateKey");
        }
        ECCCardPrivateKey cardKey = null;
        if (!(privKey instanceof ECCCardPrivateKey)) {
            throw new CardException("ECCardPrivateKey<<<<<<Required ECCardPrivateKey");
        }
        cardKey = (ECCCardPrivateKey)privKey;
        return cardKey;
    }

    public KeyPair generateKeyPair(GenKeyAttribute genKeyAttribute) throws CardException {
        return this.p11.generateKeyPair(genKeyAttribute);
    }

    public long loginSM2Card(String p11Password) throws CardException {
        return this.p11.loginSM2Card(p11Password);
    }

    public final boolean isECCKey(int intCKID) {
        return this.p11.isECCKey(intCKID);
    }
}

