/*
 * Decompiled with CFR 0.152.
 */
package cfca.sadk.lib.crypto.card.c200;

import cfca.org.slf4j.Logger;
import cfca.org.slf4j.LoggerFactory;
import cfca.sadk.algorithm.common.GenKeyAttribute;
import cfca.sadk.algorithm.common.PKIException;
import cfca.sadk.lib.crypto.card.CardException;
import cfca.sadk.lib.crypto.card.CardOperationException;
import cfca.sadk.lib.crypto.card.CardParameterException;
import cfca.sadk.lib.crypto.card.IECCCard;
import cfca.sadk.lib.crypto.card.c200.C200SM2Card;
import cfca.sadk.lib.crypto.card.c200.ECCCardP11;
import cfca.sadk.lib.crypto.card.c200.ECCCardPrivateKey;
import cfca.sadk.lib.crypto.card.c200.ECCCardPublicKey;
import cfca.sadk.lib.crypto.card.c200.SM2CardInfo;
import cfca.sadk.system.SADKDebugger;
import java.io.IOException;
import java.security.KeyPair;
import java.security.PrivateKey;
import java.security.PublicKey;

public final class C200ECCCard
implements IECCCard {
    static final Logger logger = LoggerFactory.getLogger(C200SM2Card.class);
    private ECCCardP11 control;

    public void initLib(Object param) throws CardException {
        if (param == null) {
            throw new CardException("missing SM2CardInfo");
        }
        if (!(param instanceof SM2CardInfo)) {
            throw new CardException("required SM2CardInfo");
        }
        this.control = new ECCCardP11((SM2CardInfo)param);
    }

    public KeyPair generateKeyPair(boolean isExport, int keyIndex, int keyUsage) throws CardException {
        if (logger.isDebugEnabled()) {
            logger.debug(String.format("ECCGenerateKeyPair>>>>>>Running: isExport=%s,keyIndex=%s,keyUsage=%s", isExport, keyIndex, keyUsage));
        }
        if (this.control == null) {
            throw new CardException("C200CardP11 not initLib");
        }
        try {
            if (!this.control.isECCKey(keyIndex)) {
                throw new CardException("generateKeyPair failure: keyIndex=" + keyIndex + " is not ecc key!");
            }
            KeyPair keypair = this.control.generateKeyPair(new GenKeyAttribute(isExport, keyIndex, keyUsage));
            if (logger.isDebugEnabled()) {
                logger.debug("ECCGenerateKeyPair<<<<<<Finished: keypair=" + SADKDebugger.dump(keypair));
            }
            return keypair;
        }
        catch (CardException e) {
            if (logger.isErrorEnabled()) {
                logger.error("ECCGenerateKeyPair<<<<<<Failure", (Throwable)e);
            }
            throw new CardException("ECCGenerateKeyPair<<<<<<Failure", e);
        }
        catch (Throwable e) {
            if (logger.isErrorEnabled()) {
                logger.error("ECCGenerateKeyPair<<<<<<Failure", e);
            }
            throw new CardException("ECCGenerateKeyPair<<<<<<Failure", e);
        }
    }

    public byte[] signByHash(PrivateKey privateKey, byte[] hashValue) throws CardException {
        if (logger.isDebugEnabled()) {
            StringBuffer buffer = new StringBuffer();
            buffer.append("ECCSignByHash>>>>>>Running");
            buffer.append("\n privateKey: ");
            buffer.append(SADKDebugger.dump(privateKey));
            buffer.append("\n sm3HashValue: ");
            buffer.append(SADKDebugger.dump(hashValue));
            logger.debug(buffer.toString());
        }
        if (this.control == null) {
            throw new CardException("C200CardP11 not initLib");
        }
        if (hashValue == null || hashValue.length == 0) {
            throw new CardParameterException("ECCSignByHash<<<<<<missing hashValue");
        }
        if (hashValue.length != 32) {
            throw new CardParameterException("ECCSignByHash<<<<<<invalid hashValue: " + SADKDebugger.dump(hashValue));
        }
        ECCCardPrivateKey cardKey = this.control.ECCardPrivateKey(privateKey);
        byte[] signData = null;
        if (cardKey.internal) {
            try {
                signData = this.control.ECCCardSign(cardKey, hashValue);
            }
            catch (Exception e) {
                if (logger.isErrorEnabled()) {
                    logger.error("ECCSignByHash<<<<<<operation failure", (Throwable)e);
                }
                throw new CardOperationException("ECCSignByHash<<<<<<operation failure", e);
            }
            catch (Throwable e) {
                if (logger.isErrorEnabled()) {
                    logger.error("ECCSignByHash<<<<<<operation failure", e);
                }
                throw new CardOperationException("ECCSignByHash<<<<<<operation failure", e);
            }
        } else {
            throw new CardOperationException("ECCSignByHash<<<<<<operation failure,cardkey is not internal");
        }
        if (logger.isDebugEnabled()) {
            logger.debug("ECCSignByHash<<<<<<Finished: signData=" + SADKDebugger.dump(signData));
        }
        return signData;
    }

    public boolean verifyByHash(PublicKey publicKey, byte[] hashValue, byte[] signData) throws CardException {
        boolean verifyResult;
        if (logger.isDebugEnabled()) {
            StringBuffer buffer = new StringBuffer();
            buffer.append("ECCVerifyByHash>>>>>>Running");
            buffer.append("\n publicKey: ");
            buffer.append(SADKDebugger.dump(publicKey));
            buffer.append("\n sm3HashValue: ");
            buffer.append(SADKDebugger.dump(hashValue));
            buffer.append("\n signData: ");
            buffer.append(SADKDebugger.dump(signData));
            logger.debug(buffer.toString());
        }
        if (this.control == null) {
            throw new CardException("C200CardP11 not initLib");
        }
        ECCCardPublicKey cardKey = null;
        try {
            cardKey = this.control.ECCardPublicKey(publicKey);
        }
        catch (IOException e1) {
            throw new CardException("verifyByHash ECCardPublicKey failure", e1);
        }
        if (cardKey.internal) {
            try {
                verifyResult = this.control.ECCCardVerify(cardKey, hashValue, signData);
            }
            catch (Exception e) {
                if (logger.isErrorEnabled()) {
                    logger.error("ECCVerifyByHash<<<<<<operation failure", (Throwable)e);
                }
                throw new CardOperationException("ECCVerifyByHash<<<<<<operation failure", e);
            }
            catch (Throwable e) {
                if (logger.isErrorEnabled()) {
                    logger.error("ECCVerifyByHash<<<<<<operation failure", e);
                }
                throw new CardOperationException("ECCVerifyByHash<<<<<<operation failure", e);
            }
        } else {
            throw new CardOperationException("ECCVerifyByHash<<<<<<operation failure,cardkey is not internal");
        }
        if (logger.isDebugEnabled()) {
            logger.debug("ECCVerifyByHash<<<<<<Finished: verifyResult=" + verifyResult);
        }
        return verifyResult;
    }

    public byte[] encrypt(PublicKey publicKey, byte[] sourceData) throws CardException {
        if (logger.isDebugEnabled()) {
            StringBuffer buffer = new StringBuffer();
            buffer.append("ECCEncrypt>>>>>>Running");
            buffer.append("\n publicKey: ");
            buffer.append(SADKDebugger.dump(publicKey));
            buffer.append("\n sourceData: ");
            buffer.append(SADKDebugger.dump(sourceData));
            logger.debug(buffer.toString());
        }
        if (this.control == null) {
            throw new CardException("C200CardP11 not initLib");
        }
        ECCCardPublicKey cardKey = null;
        try {
            cardKey = this.control.ECCardPublicKey(publicKey);
        }
        catch (IOException e1) {
            throw new CardException("encrypt ECCardPublicKey failure", e1);
        }
        byte[] encryptData = null;
        if (cardKey.internal && cardKey.keyUsage == 1) {
            try {
                encryptData = this.control.ECCCardEncrypt(cardKey, sourceData);
            }
            catch (Exception e) {
                if (logger.isErrorEnabled()) {
                    logger.error("ECCEncrypt<<<<<<operation failure", (Throwable)e);
                }
                throw new CardOperationException("ECCEncrypt<<<<<<operation failure", e);
            }
            catch (Throwable e) {
                if (logger.isErrorEnabled()) {
                    logger.error("ECCEncrypt<<<<<<operation failure", e);
                }
                throw new CardOperationException("ECCEncrypt<<<<<<operation failure", e);
            }
        } else {
            throw new CardOperationException("ECCEncrypt<<<<<<operation failure,cardkey is not internal");
        }
        if (logger.isDebugEnabled()) {
            logger.debug("ECCEncrypt<<<<<<Finished: encryptData=" + SADKDebugger.dump(encryptData));
        }
        return encryptData;
    }

    public byte[] decrypt(PrivateKey privateKey, byte[] encryptData) throws CardException {
        if (logger.isDebugEnabled()) {
            StringBuffer buffer = new StringBuffer();
            buffer.append("ECCDecrypt>>>>>>Running");
            buffer.append("\n privateKey: ");
            buffer.append(SADKDebugger.dump(privateKey));
            buffer.append("\n encryptData: ");
            buffer.append(SADKDebugger.dump(encryptData));
            logger.debug(buffer.toString());
        }
        if (this.control == null) {
            throw new CardException("C200CardP11 not initLib");
        }
        ECCCardPrivateKey cardKey = this.control.ECCardPrivateKey(privateKey);
        byte[] decryptData = null;
        if (cardKey.internal) {
            try {
                decryptData = this.control.ECCCardDecrypt(cardKey, encryptData);
            }
            catch (Exception e) {
                if (logger.isErrorEnabled()) {
                    logger.error("ECCDecrypt<<<<<< operation failure", (Throwable)e);
                }
                throw new CardOperationException("ECCDecrypt<<<<<< operation failure", e);
            }
            catch (Throwable e) {
                if (logger.isErrorEnabled()) {
                    logger.error("ECCDecrypt<<<<<< operation failure", e);
                }
                throw new CardOperationException("ECCDecrypt<<<<<< operation failure", e);
            }
        } else {
            throw new CardOperationException("ECCDecrypt<<<<<<operation failure,cardkey is not internal");
        }
        if (logger.isDebugEnabled()) {
            logger.debug("ECCDecrypt<<<<<<Finished: decryptData=" + SADKDebugger.dump(decryptData));
        }
        return decryptData;
    }

    public void unInitLib(Object param) {
    }

    public long loginSM2Card(String p11Password) throws CardException {
        return this.control.loginSM2Card(p11Password);
    }
}

