/*
 * Decompiled with CFR 0.152.
 */
package cfca.sadk.lib.crypto.card.c200;

import cfca.org.slf4j.Logger;
import cfca.org.slf4j.LoggerFactory;
import cfca.sadk.algorithm.common.GenKeyAttribute;
import cfca.sadk.algorithm.sm2.SM2PublicKey;
import cfca.sadk.lib.crypto.card.CardException;
import cfca.sadk.lib.crypto.card.c200.CardKey;
import cfca.sadk.lib.crypto.card.c200.ECCCardPrivateKey;
import cfca.sadk.lib.crypto.card.c200.ECCCardPublicKey;
import cfca.sadk.lib.crypto.card.c200.SM2CardInfo;
import cfca.sadk.lib.crypto.card.c200.SM2CardPrivateKey;
import cfca.sadk.lib.crypto.card.c200.SM2CardPublicKey;
import cfca.sadk.lib.crypto.card.dummy.DummySM2Card;
import cfca.sadk.org.bouncycastle.asn1.sm2.ASN1SM2Signature;
import cfca.sadk.org.bouncycastle.jcajce.provider.asymmetric.ec.BCECPublicKey;
import cfca.sadk.org.bouncycastle.jcajce.provider.asymmetric.sm.SM2Params;
import cfca.sadk.org.bouncycastle.util.encoders.Hex;
import cfca.sadk.system.CompatibleConfig;
import cfca.sadk.system.SADKDebugger;
import cryptokit.jni.JNIP11;
import java.io.File;
import java.security.KeyPair;
import java.security.PublicKey;
import java.util.Arrays;
import java.util.StringTokenizer;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantLock;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class C200CardP11 {
    static final Logger logger = LoggerFactory.getLogger(C200CardP11.class);
    static final int CKM_SM2_WITH_Z = 1;
    static final int CKM_SM2_SIGN_VERIFY = 65538;
    static final int CKM_SM2_EXTERNAL_VERIFY = 65548;
    static final int CKM_SM2_EXTERNAL_ENCRYPT = 65549;
    static final long INTERNAL_ENC_KEYHANDLE = -1040183278L;
    static final int CKM_SM2_isDecrypt = 1;
    private JNIP11 sm2JNIP11;
    private int[] tokens;
    private long sessionHandle;
    private long sessionHandleTimeout;
    private String CKIDList;
    final ReentrantLock cardLock = new ReentrantLock();
    private LinkedBlockingQueue<Long> sessionHandles;
    private ConcurrentMap<HashKey, KeyPair> cardKeys;
    private final Object lock;
    private static C200CardP11 instance = null;
    private final int minECCIndex;
    private final int maxECCIndex;

    public static synchronized C200CardP11 getInstance(SM2CardInfo info) throws CardException {
        if (instance == null) {
            instance = new C200CardP11(info);
        }
        return instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    C200CardP11(SM2CardInfo info) throws CardException {
        Object object = this.lock = new Object();
        synchronized (object) {
            JNIP11 sm2JNIP11;
            block28: {
                if (logger.isDebugEnabled()) {
                    logger.debug("C200CardP11>>>>>>Running: info=" + info);
                }
                sm2JNIP11 = new JNIP11();
                try {
                    File p11File = new File(info.p11LibPath);
                    if (!p11File.exists()) {
                        throw new CardException("C200CardP11<<<<<<loadLib Failure: " + info.p11LibPath + " is not exists!");
                    }
                }
                catch (Exception e) {
                    if (!logger.isErrorEnabled()) break block28;
                    logger.error("C200CardP11<<<<<<loadLib Failure: " + e.getMessage(), (Throwable)e);
                }
            }
            try {
                sm2JNIP11.loadLib(info.p11LibPath);
                if (logger.isDebugEnabled()) {
                    logger.debug("C200CardP11::::::loadLib successfully");
                }
            }
            catch (Exception e) {
                if (logger.isErrorEnabled()) {
                    logger.error("C200CardP11<<<<<<loadLib Failure: " + e.getMessage(), (Throwable)e);
                }
                throw new CardException("C200CardP11 loadLib failure: " + e.getMessage(), e);
            }
            catch (Throwable e) {
                if (logger.isErrorEnabled()) {
                    logger.error("C200CardP11<<<<<<loadLib Failure: " + e.getMessage(), e);
                }
                throw new CardException("C200CardP11 loadLib failure: " + e.getMessage(), e);
            }
            try {
                sm2JNIP11.init();
                if (logger.isDebugEnabled()) {
                    logger.debug("C200CardP11::::::init successfully");
                }
            }
            catch (Exception e) {
                if (logger.isErrorEnabled()) {
                    logger.error("C200CardP11<<<<<<init Failure: " + e.getMessage(), (Throwable)e);
                }
                throw new CardException("C200CardP11 init failure: " + e.getMessage(), e);
            }
            catch (Throwable e) {
                if (logger.isErrorEnabled()) {
                    logger.error("C200CardP11<<<<<<init Failure: " + e.getMessage(), e);
                }
                throw new CardException("C200CardP11 init failure: " + e.getMessage(), e);
            }
            this.tokens = this.cardInitGetTokens(sm2JNIP11);
            int token = info.cardToken;
            this.sessionHandles = this.cardInitOpenSession(sm2JNIP11, token, info.cardSessionNumb);
            Long sessionHandle = this.sessionHandles.poll();
            if (sessionHandle == null) {
                throw new CardException("C200CardP11 init failure with invalid sessionHandle");
            }
            if (logger.isDebugEnabled()) {
                logger.debug("C200CardP11<<<<<<sessionHandle: " + sessionHandle);
            }
            if (CompatibleConfig.C200CARDLOGIN) {
                if (logger.isInfoEnabled()) {
                    logger.info("C200CardP11<<<<<< Login: " + sessionHandle);
                }
                try {
                    this.cardInitLogin(sm2JNIP11, sessionHandle, info.p11Password);
                }
                catch (Exception e) {
                    logger.error("C200CardP11<<<<<<cardInitLogin failed: ", (Throwable)e);
                }
            } else if (logger.isInfoEnabled()) {
                logger.info("C200CardP11<<<<<< not Login: " + sessionHandle);
            }
            this.sessionHandle = sessionHandle;
            this.sessionHandleTimeout = info.cardSessionTimeout < 0 ? 120L : (long)info.cardSessionTimeout;
            this.minECCIndex = info.getMinECCIndex();
            this.maxECCIndex = info.getMaxECCIndex();
            this.CKIDList = this.cardInitGetCKIDList(sm2JNIP11, sessionHandle);
            this.cardKeys = this.cardInitAllKeyPairs(sm2JNIP11, sessionHandle);
            this.sm2JNIP11 = sm2JNIP11;
            if (logger.isDebugEnabled()) {
                logger.debug("C200CardP11<<<<<<Successfully");
            }
        }
    }

    protected void finalize() throws Throwable {
        super.finalize();
        this.cardUninitFinalize();
    }

    final void cardUninitFinalize() {
        block12: {
            if (logger.isDebugEnabled()) {
                logger.debug("cardUninitFinalize>>>>>>Running");
            }
            if (this.sm2JNIP11 != null) {
                block11: {
                    try {
                        this.sm2JNIP11.uninit();
                    }
                    catch (Exception e) {
                        if (logger.isErrorEnabled()) {
                            logger.error("cardUninitFinalize<<<<<<uninit Failure: " + e.getMessage(), (Throwable)e);
                        }
                    }
                    catch (Throwable e) {
                        if (!logger.isErrorEnabled()) break block11;
                        logger.error("cardUninitFinalize<<<<<<uninit Failure: " + e.getMessage(), e);
                    }
                }
                try {
                    this.sm2JNIP11.unloadLib();
                }
                catch (Exception e) {
                    if (logger.isErrorEnabled()) {
                        logger.error("cardUninitFinalize<<<<<<unloadLib Failure: " + e.getMessage(), (Throwable)e);
                    }
                }
                catch (Throwable e) {
                    if (!logger.isErrorEnabled()) break block12;
                    logger.error("cardUninitFinalize<<<<<<unloadLib Failure: " + e.getMessage(), e);
                }
            }
        }
        if (logger.isDebugEnabled()) {
            logger.debug("cardInitGetTokens<<<<<<Successfully");
        }
    }

    private final int[] cardInitGetTokens(JNIP11 sm2JNIP11) throws CardException {
        int retrunValue;
        if (logger.isDebugEnabled()) {
            logger.debug("cardInitGetTokens::>>>>>>Running");
        }
        int[] buffer = new int[16];
        try {
            retrunValue = sm2JNIP11.getTokenList(buffer);
        }
        catch (Exception e) {
            if (logger.isErrorEnabled()) {
                logger.error("cardInitGetTokens::<<<<<<Failure: " + e.getMessage(), (Throwable)e);
            }
            throw new CardException("cardInitGetTokens::<<<<<<Failure: " + e.getMessage(), e);
        }
        catch (Throwable e) {
            if (logger.isErrorEnabled()) {
                logger.error("cardInitGetTokens::<<<<<<Failure: " + e.getMessage(), e);
            }
            throw new CardException("cardInitGetTokens::<<<<<<Failure: " + e.getMessage(), e);
        }
        if (retrunValue <= 0) {
            throw new CardException("cardInitGetTokens::<<<<<<Failure with retrunValue=" + retrunValue);
        }
        int[] tokens = new int[retrunValue];
        System.arraycopy(buffer, 0, tokens, 0, tokens.length);
        for (int i = 0; i < tokens.length; ++i) {
            String tokenInfo = null;
            try {
                tokenInfo = sm2JNIP11.getTokenInfo(tokens[i]);
            }
            catch (Throwable e) {
                String message = "cardInitGetTokens::<<<<<<getTokenInfo(" + tokens[i] + ") Failure: " + e.getMessage();
                if (logger.isErrorEnabled()) {
                    logger.error(message, e);
                }
                throw new CardException(message, e);
            }
            if (!logger.isDebugEnabled()) continue;
            logger.debug("cardInitGetTokens::<<<<<<getTokenInfo(" + tokens[i] + ") : " + tokenInfo);
        }
        if (logger.isDebugEnabled()) {
            logger.debug("cardInitGetTokens::<<<<<<Successfully");
        }
        return tokens;
    }

    private final LinkedBlockingQueue<Long> cardInitOpenSession(JNIP11 sm2JNIP11, int token, int numSessionHandles) throws CardException {
        if (logger.isDebugEnabled()) {
            logger.debug("cardInitOpenSession::>>>>>>Running");
        }
        LinkedBlockingQueue<Long> sessionHandles = new LinkedBlockingQueue<Long>();
        try {
            int i = 0;
            while (i < numSessionHandles) {
                ++i;
                long session = sm2JNIP11.openSession(token);
                if (logger.isDebugEnabled()) {
                    logger.debug("cardInitOpenSession::<<<<<<session#" + i + "=" + session);
                }
                sessionHandles.add(session);
            }
        }
        catch (Exception e) {
            if (logger.isErrorEnabled()) {
                logger.error("cardInitOpenSession::<<<<<<openSession Failure: " + e.getMessage(), (Throwable)e);
            }
            throw new CardException("cardInitOpenSession openSession failure: " + e.getMessage(), e);
        }
        catch (Throwable e) {
            if (logger.isErrorEnabled()) {
                logger.error("cardInitOpenSession::<<<<<<openSession Failure: " + e.getMessage(), e);
            }
            throw new CardException("cardInitOpenSession openSession failure: " + e.getMessage(), e);
        }
        if (logger.isDebugEnabled()) {
            logger.debug("cardInitOpenSession::<<<<<<Successfully!");
        }
        return sessionHandles;
    }

    private final void cardInitLogin(JNIP11 sm2JNIP11, long sessionHandle, String password) throws CardException {
        if (logger.isDebugEnabled()) {
            logger.debug("cardInitLogin::>>>>>>Running");
        }
        try {
            byte[] pinBytes = password.getBytes("UTF8");
            long returnValue = sm2JNIP11.login(sessionHandle, (int)sm2JNIP11.CKU_USER, pinBytes, pinBytes.length);
            if (logger.isDebugEnabled()) {
                logger.debug("cardInitLogin::<<<<<<returnValue=" + returnValue);
            }
            if (returnValue != 0L) {
                throw new CardException("cardInitLogin::<<<<<<Failure: returnValue=" + returnValue);
            }
        }
        catch (Exception e) {
            if (logger.isErrorEnabled()) {
                logger.error("cardInitLogin::<<<<<<Failure: " + e.getMessage(), (Throwable)e);
            }
            throw new CardException("cardInitLogin failure: " + e.getMessage(), e);
        }
        catch (Throwable e) {
            if (logger.isErrorEnabled()) {
                logger.error("cardInitLogin::<<<<<<Failure: " + e.getMessage(), e);
            }
            throw new CardException("cardInitLogin failure: " + e.getMessage(), e);
        }
        if (logger.isDebugEnabled()) {
            logger.debug("cardInitLogin::<<<<<<Successfully!");
        }
    }

    private final String cardInitGetCKIDList(JNIP11 sm2JNIP11, long sessionHandle) throws CardException {
        if (logger.isDebugEnabled()) {
            logger.debug("cardInitGetCKIDList::>>>>>>Running");
        }
        String CKIDText = null;
        try {
            CKIDText = sm2JNIP11.getCKIDList(sessionHandle);
        }
        catch (Exception e) {
            if (logger.isErrorEnabled()) {
                logger.error("cardInitGetCKIDList::<<<<<< Failure: " + e.getMessage(), (Throwable)e);
            }
            throw new CardException("cardInitGetCKIDList failure: " + e.getMessage(), e);
        }
        catch (Throwable e) {
            if (logger.isErrorEnabled()) {
                logger.error("cardInitGetCKIDList<<<<<<Failure: " + e.getMessage(), e);
            }
            throw new CardException("cardInitGetCKIDList failure: " + e.getMessage(), e);
        }
        if (logger.isDebugEnabled()) {
            logger.debug("cardInitGetCKIDList::::::Successfully: CKIDText=" + CKIDText);
        }
        return CKIDText;
    }

    protected final ConcurrentMap<HashKey, KeyPair> cardInitAllKeyPairs(JNIP11 sm2JNIP11, long sessionHandle) throws CardException {
        if (logger.isDebugEnabled()) {
            logger.debug("cardInitCacheKeyPairs::>>>>>>Running");
        }
        String CKIDText = this.cardInitGetCKIDList(sm2JNIP11, sessionHandle);
        ConcurrentHashMap<HashKey, KeyPair> cardKeys = new ConcurrentHashMap<HashKey, KeyPair>();
        if (CKIDText != null) {
            StringTokenizer tokenizer = new StringTokenizer(CKIDText, "|");
            KeyPair keypair = null;
            HashKey hashKey = null;
            String CKIDLast = null;
            while (tokenizer.hasMoreTokens()) {
                String CKID;
                block13: {
                    CKID = tokenizer.nextToken().trim();
                    if (CKID.length() == 0) continue;
                    if (CKIDLast != null && CKID.equals(CKIDLast)) {
                        try {
                            if (logger.isDebugEnabled()) {
                                logger.debug("cardInitAllKeyPairs::::>>>>>>Running: addEncryptKey-->CKID=" + CKID);
                            }
                            if ((keypair = this.cardInitKeyPair(sm2JNIP11, sessionHandle, CKID, 1)) == null) continue;
                            hashKey = this.isECCKey(CKID) ? new HashKey((ECCCardPublicKey)keypair.getPublic()) : new HashKey((SM2CardPublicKey)keypair.getPublic());
                            cardKeys.put(hashKey, keypair);
                            if (!logger.isDebugEnabled()) continue;
                            logger.debug("cardInitAllKeyPairs::::<<<<<<Finished: addEncryptKey--> " + hashKey);
                            logger.debug("cardInitAllKeyPairs::::<<<<<<" + keypair.getPublic());
                            logger.debug("cardInitAllKeyPairs::::<<<<<<" + keypair.getPrivate());
                        }
                        catch (Exception e) {
                            if (!logger.isErrorEnabled()) continue;
                            logger.error("cardInitAllKeyPairs::::<<<<<<Failure: addEncryptKey-->CKID=" + CKID, (Throwable)e);
                        }
                        continue;
                    }
                    try {
                        if (logger.isDebugEnabled()) {
                            logger.debug("cardInitAllKeyPairs::::>>>>>>Running: addSignatureKey--> CKID=" + CKID);
                        }
                        if ((keypair = this.cardInitKeyPair(sm2JNIP11, sessionHandle, CKID, 2)) != null) {
                            hashKey = this.isECCKey(CKID) ? new HashKey((ECCCardPublicKey)keypair.getPublic()) : new HashKey((SM2CardPublicKey)keypair.getPublic());
                            cardKeys.put(hashKey, keypair);
                            if (logger.isDebugEnabled()) {
                                logger.debug("cardInitAllKeyPairs::::<<<<<<Finished: addSignatureKey--> " + hashKey);
                                logger.debug("cardInitAllKeyPairs::::<<<<<<" + keypair.getPublic());
                                logger.debug("cardInitAllKeyPairs::::<<<<<<" + keypair.getPrivate());
                            }
                        }
                    }
                    catch (Exception e) {
                        if (!logger.isErrorEnabled()) break block13;
                        logger.error("cardInitAllKeyPairs::::<<<<<<Failure: addSignatureKey-->CKID=" + CKID, (Throwable)e);
                    }
                }
                CKIDLast = CKID;
            }
        }
        if (logger.isDebugEnabled()) {
            logger.debug("cardInitCacheKeyPairs::<<<<<<Successfully: cardKeys=" + cardKeys.size());
        }
        return cardKeys;
    }

    protected final KeyPair cardInitKeyPair(JNIP11 sm2JNIP11, long sessionHandle, String CKIDText, int keyUsage) throws CardException {
        int returnValue;
        long privateKeyHandle;
        long publicKeyHandle;
        byte[] CKID;
        if (logger.isDebugEnabled()) {
            logger.debug("cardInitKeyPair::>>>>>>Running: CKID=" + CKIDText + ",keyUsage=" + keyUsage);
        }
        byte[] pubKeyX = new byte[32];
        byte[] pubKeyY = new byte[32];
        try {
            CKID = CKIDText.getBytes("UTF8");
        }
        catch (Exception e) {
            throw new CardException("cardInitKeyPair::<<<<<<failure with invalid CKID: " + e.getMessage(), e);
        }
        try {
            this.cardLock.lock();
            publicKeyHandle = sm2JNIP11.getKeyHandle(sessionHandle, CKID, keyUsage, true, true);
            privateKeyHandle = sm2JNIP11.getKeyHandle(sessionHandle, CKID, keyUsage, false, true);
            returnValue = sm2JNIP11.exportSM2PublicKey(sessionHandle, publicKeyHandle, pubKeyX, pubKeyY);
        }
        catch (Exception e) {
            if (logger.isErrorEnabled()) {
                logger.error("cardInitKeyPair::<<<<<<Failure", (Throwable)e);
            }
            throw new CardException("cardInitKeyPair::<<<<<<failure: " + e.getMessage(), e);
        }
        catch (Throwable e) {
            if (logger.isErrorEnabled()) {
                logger.error("cardInitKeyPair::<<<<<<Failure", e);
            }
            throw new CardException("cardInitKeyPair::<<<<<<failure: " + e.getMessage(), e);
        }
        finally {
            this.cardLock.unlock();
        }
        if (returnValue != 0) {
            throw new CardException("cardInitKeyPair::<<<<<<failure when export PublicKey withreturnValue=" + returnValue);
        }
        byte[] defaultZ = SM2Params.calcZ(pubKeyX, pubKeyY);
        KeyPair keypair = null;
        if (this.isECCKey(CKIDText)) {
            ECCCardPublicKey publicKey = new ECCCardPublicKey(defaultZ, publicKeyHandle, pubKeyX, pubKeyY, CKIDText, keyUsage);
            ECCCardPrivateKey privateKey = new ECCCardPrivateKey(defaultZ, privateKeyHandle, pubKeyX, pubKeyY, CKIDText, keyUsage);
            keypair = new KeyPair(publicKey, privateKey);
        } else {
            SM2CardPublicKey publicKey = new SM2CardPublicKey(defaultZ, publicKeyHandle, pubKeyX, pubKeyY, CKIDText, keyUsage);
            SM2CardPrivateKey privateKey = new SM2CardPrivateKey(defaultZ, privateKeyHandle, pubKeyX, pubKeyY, CKIDText, keyUsage);
            keypair = new KeyPair(publicKey, privateKey);
        }
        if (logger.isDebugEnabled()) {
            logger.debug("cardInitKeyPair::<<<<<<Successfully");
        }
        return keypair;
    }

    protected final Long takeSessionHandle() throws InterruptedException, CardException {
        Long sessionHandle = this.sessionHandles.poll(this.sessionHandleTimeout, TimeUnit.SECONDS);
        if (sessionHandle == null) {
            throw new CardException("TakeSessionHandle timeout in " + this.sessionHandleTimeout + " seconds");
        }
        return sessionHandle;
    }

    public long loginSM2Card(String password) throws CardException {
        long returnValue;
        try {
            int cku_user = (int)this.sm2JNIP11.CKU_USER;
            byte[] pinBytes = password.getBytes("UTF8");
            returnValue = this.sm2JNIP11.login(this.sessionHandle, (int)this.sm2JNIP11.CKU_USER, pinBytes, pinBytes.length);
            if (logger.isInfoEnabled()) {
                logger.info("SM2CardLogin::<<<<<<cku_user=" + cku_user + " +returnValue=" + returnValue);
            }
        }
        catch (Exception e) {
            if (logger.isErrorEnabled()) {
                logger.error("SM2CardLogin::<<<<<<Failure: ", (Throwable)e);
            }
            throw new CardException("SM2CardLogin failure: ", e);
        }
        catch (Throwable e) {
            if (logger.isErrorEnabled()) {
                logger.error("SM2CardLogin::<<<<<<Failure: ", e);
            }
            throw new CardException("SM2CardLogin failure: ", e);
        }
        return returnValue;
    }

    final KeyPair generateKeyPair(GenKeyAttribute attr) throws CardException {
        if (logger.isDebugEnabled()) {
            logger.debug("GenerateKeyPair>>>>>>running: " + attr);
        }
        KeyPair keypair = null;
        if (attr.isExport) {
            keypair = DummySM2Card.dummy.generateKeyPair(true, 0, 0);
        } else {
            String CKID;
            int keyIndex = attr.keyNum;
            int keyUsage = attr.keyUsage;
            try {
                CKID = Integer.toString(keyIndex);
            }
            catch (Exception e) {
                throw new CardException("GenerateKeyPair failure with invalid keyIndex=" + keyIndex, e);
            }
            keypair = this.cardInitKeyPair(this.sm2JNIP11, this.sessionHandle, CKID, keyUsage);
            if (logger.isDebugEnabled()) {
                logger.debug("GenerateKeyPair<<<<<<Successfully");
                logger.debug("GenerateKeyPair<<<<<<" + keypair.getPublic());
                logger.debug("GenerateKeyPair<<<<<<" + keypair.getPrivate());
            }
            HashKey hashKey = null;
            hashKey = this.isECCKey(CKID) ? new HashKey((ECCCardPublicKey)keypair.getPublic()) : new HashKey((SM2CardPublicKey)keypair.getPublic());
            if (this.cardKeys.containsKey(hashKey)) {
                if (logger.isDebugEnabled()) {
                    logger.debug("GenerateKeyPair<<<<<<HashKey: contains-->" + hashKey);
                }
            } else {
                this.cardKeys.put(hashKey, keypair);
                if (logger.isDebugEnabled()) {
                    logger.debug("GenerateKeyPair<<<<<<HashKey: add--> " + hashKey);
                }
            }
        }
        if (logger.isDebugEnabled()) {
            logger.debug("GenerateKeyPair<<<<<<Finished: cardKeys=" + this.cardKeys.size());
        }
        return keypair;
    }

    final byte[] cardSign(CardKey cardKey, byte[] hashValue) throws CardException {
        byte[] cardSignData = new byte[64];
        long keyHandle = cardKey.getKeyHandle();
        Long sessionHandle = null;
        try {
            sessionHandle = this.takeSessionHandle();
            if (logger.isDebugEnabled()) {
                logger.debug("C200CardSign<<<<<<sessionHandle: " + sessionHandle + ",keyHandle=" + keyHandle);
            }
            int returnValue = this.sm2JNIP11.signInit(sessionHandle.longValue(), keyHandle, 65538, 1);
            if (logger.isDebugEnabled()) {
                logger.debug("C200CardSign::::::signInit: retrunValue=" + returnValue);
            }
            if (returnValue != 0) {
                throw new CardException("C200CardSign<<<<<<Failure with signInit returnValue=" + returnValue);
            }
            returnValue = this.sm2JNIP11.signHash(sessionHandle.longValue(), hashValue, cardSignData);
            if (returnValue != cardSignData.length) {
                throw new CardException("C200CardSign<<<<<<Failure with signHash returnValue=" + returnValue);
            }
        }
        catch (CardException e) {
            if (logger.isErrorEnabled()) {
                logger.error("C200CardSign#1<<<<<<sessionHandle=" + sessionHandle + "hashValue=0x" + new String(Hex.encode(hashValue)), (Throwable)e);
            }
            throw e;
        }
        catch (Exception e) {
            if (logger.isErrorEnabled()) {
                logger.error("C200CardSign#2<<<<<<sessionHandle=" + sessionHandle + "hashValue=0x" + new String(Hex.encode(hashValue)), (Throwable)e);
            }
            throw new CardException("C200CardSign<<<<<<Failure: " + e.getMessage(), e);
        }
        catch (Throwable e) {
            if (logger.isErrorEnabled()) {
                logger.error("C200CardSign#3<<<<<<sessionHandle=" + sessionHandle + "hashValue=0x" + new String(Hex.encode(hashValue)), e);
            }
            throw new CardException("C200CardSign<<<<<<Failure: " + e.getMessage(), e);
        }
        finally {
            if (sessionHandle != null) {
                this.sessionHandles.add(sessionHandle);
            }
        }
        if (logger.isDebugEnabled()) {
            logger.debug("C200CardSign::<<<<<<Finished: cardSignData=" + SADKDebugger.dump(cardSignData));
        }
        return cardSignData;
    }

    final boolean cardVerify(CardKey cardKey, byte[] hashValue, byte[] signValue) throws CardException {
        byte[] cardSignValue;
        block25: {
            cardSignValue = null;
            try {
                if (signValue.length == 64) {
                    cardSignValue = signValue;
                    break block25;
                }
                if (ASN1SM2Signature.isASN1SignType(signValue)) {
                    cardSignValue = new ASN1SM2Signature(signValue).getRSRaw64Bytes();
                    break block25;
                }
                throw new CardException("C200CardVerify<<<<<<Failure with invalid signValue(Required 64 or asn1)!!!");
            }
            catch (CardException e) {
                throw e;
            }
            catch (Exception e) {
                throw new CardException("C200CardVerify<<<<<<Failure with invalid signValue: " + e.getMessage(), e);
            }
            catch (Throwable e) {
                throw new CardException("C200CardVerify<<<<<<Failure  with invalid signValue: " + e.getMessage(), e);
            }
        }
        if (logger.isDebugEnabled()) {
            logger.debug("C200CardVerify::::::cardSignValue=" + SADKDebugger.dump(cardSignValue));
        }
        long keyHandle = cardKey.getKeyHandle();
        boolean verifyResult = false;
        Long sessionHandle = null;
        try {
            sessionHandle = this.takeSessionHandle();
            if (logger.isDebugEnabled()) {
                logger.debug("C200CardVerify<<<<<<sessionHandle: " + sessionHandle + ",keyHandle=" + keyHandle);
            }
            int returnValue = this.sm2JNIP11.verifyInit(sessionHandle.longValue(), keyHandle, 65538, 1);
            if (logger.isDebugEnabled()) {
                logger.debug("C200CardVerify::::::verifyInit: retrunValue=" + returnValue);
            }
            if (returnValue != 0) {
                throw new CardException("C200CardVerify<<<<<<Failure with verifyInit returnValue=" + returnValue);
            }
            returnValue = this.sm2JNIP11.verify(sessionHandle.longValue(), hashValue, cardSignValue);
            if (returnValue == 0) {
                verifyResult = true;
            } else {
                if (logger.isDebugEnabled()) {
                    logger.debug("C200CardVerify<<<<<<Failure with verifyHash returnValue: " + returnValue);
                }
                verifyResult = false;
            }
        }
        catch (CardException e) {
            if (logger.isErrorEnabled()) {
                logger.error("C200CardVerify<<<<<<Failure: " + e.getMessage(), (Throwable)e);
            }
            throw e;
        }
        catch (Exception e) {
            if (logger.isErrorEnabled()) {
                logger.error("C200CardVerify<<<<<<Failure: " + e.getMessage(), (Throwable)e);
            }
            throw new CardException("C200CardVerify<<<<<<Failure: " + e.getMessage(), e);
        }
        catch (Throwable e) {
            if (logger.isErrorEnabled()) {
                logger.error("C200CardVerify<<<<<<Failure: " + e.getMessage(), e);
            }
            throw new CardException("C200CardVerify<<<<<<Failure: " + e.getMessage(), e);
        }
        finally {
            if (sessionHandle != null) {
                this.sessionHandles.add(sessionHandle);
            }
        }
        if (logger.isDebugEnabled()) {
            logger.debug("C200CardVerify<<<<<<Finished: verifyResult=" + verifyResult);
        }
        return verifyResult;
    }

    final byte[] cardEncrypt(CardKey cardKey, byte[] sourceData) throws CardException {
        byte[] cardEncryptData;
        if (sourceData == null || sourceData.length == 0) {
            throw new CardException("C200CardEncrypt Failure with invalid sourceData(Required > 0)!");
        }
        byte[] encryptData = new byte[sourceData.length + 96];
        long keyHandle = cardKey.getKeyHandle();
        int encLength = 0;
        Long sessionHandle = null;
        try {
            int returnValue;
            sessionHandle = this.takeSessionHandle();
            if (logger.isDebugEnabled()) {
                logger.debug("C200CardEncrypt<<<<<<sessionHandle: " + sessionHandle + ",keyHandle=" + keyHandle);
            }
            if ((returnValue = this.sm2JNIP11.encryptInit(sessionHandle.longValue(), keyHandle, 0)) != 0) {
                throw new CardException("C200CardEncrypt<<<<<<Failure with decryptInit returnValue=" + returnValue);
            }
            if (logger.isDebugEnabled()) {
                logger.debug("C200CardEncrypt::::::encryptInit: retrunValue=" + returnValue);
            }
            if (encryptData.length != (encLength = this.sm2JNIP11.encryptMsg(sessionHandle.longValue(), sourceData, encryptData))) {
                throw new CardException("C200CardEncrypt<<<<<<Failure with encryptMsg returnValue=" + returnValue + ", requiredLength=" + encryptData.length);
            }
        }
        catch (CardException e) {
            if (logger.isErrorEnabled()) {
                logger.error("C200CardEncrypt<<<<<<Failure: " + e.getMessage(), (Throwable)e);
            }
            throw e;
        }
        catch (Exception e) {
            if (logger.isErrorEnabled()) {
                logger.error("C200CardEncrypt<<<<<<Failure: " + e.getMessage(), (Throwable)e);
            }
            throw new CardException("C200CardEncrypt<<<<<<Failure: " + e.getMessage(), e);
        }
        catch (Throwable e) {
            if (logger.isErrorEnabled()) {
                logger.error("C200CardEncrypt<<<<<<Failure: " + e.getMessage(), e);
            }
            throw new CardException("C200CardEncrypt<<<<<<Failure: " + e.getMessage(), e);
        }
        finally {
            if (sessionHandle != null) {
                this.sessionHandles.add(sessionHandle);
            }
        }
        if (encLength < encryptData.length) {
            cardEncryptData = new byte[encLength];
            System.arraycopy(encryptData, 0, cardEncryptData, 0, cardEncryptData.length);
        } else {
            cardEncryptData = encryptData;
        }
        if (logger.isDebugEnabled()) {
            logger.debug("C200CardEncrypt<<<<<<Finished: cardEncryptData=" + SADKDebugger.dump(cardEncryptData));
        }
        return cardEncryptData;
    }

    final byte[] cardDecrypt(CardKey cardKey, byte[] encryptData) throws CardException {
        byte[] cardDecryptData;
        if (encryptData == null || encryptData.length <= 96) {
            throw new CardException("CardDecrypt<<<<<<Failure with invalid encryptData(Required > 96)!");
        }
        byte[] decryptData = new byte[encryptData.length - 96];
        long keyHandle = cardKey.getKeyHandle();
        int decLength = 0;
        Long sessionHandle = null;
        try {
            int returnValue;
            sessionHandle = this.takeSessionHandle();
            if (logger.isDebugEnabled()) {
                logger.debug("CardDecrypt<<<<<<sessionHandle: " + sessionHandle + ",keyHandle=" + keyHandle);
            }
            if ((returnValue = this.sm2JNIP11.decryptInit(sessionHandle.longValue(), keyHandle)) != 0) {
                throw new CardException("CardDecrypt<<<<<<Failure with decryptInit returnValue=" + returnValue);
            }
            if (logger.isDebugEnabled()) {
                logger.debug("CardDecrypt::::::decryptInit: retrunValue=" + returnValue);
            }
            if (decryptData.length != (decLength = this.sm2JNIP11.decryptMsg(sessionHandle.longValue(), encryptData, decryptData))) {
                throw new CardException("CardDecrypt<<<<<<Failure with encryptMsg returnValue=" + returnValue + ", requiredLength=" + decryptData.length);
            }
        }
        catch (CardException e) {
            if (logger.isErrorEnabled()) {
                logger.error("CardDecrypt<<<<<<Failure: " + e.getMessage(), (Throwable)e);
            }
            throw e;
        }
        catch (Exception e) {
            if (logger.isErrorEnabled()) {
                logger.error("C200CardEncrypt<<<<<<Failure: " + e.getMessage(), (Throwable)e);
            }
            throw new CardException("CardDecrypt<<<<<<Failure: " + e.getMessage(), e);
        }
        catch (Throwable e) {
            if (logger.isErrorEnabled()) {
                logger.error("CardDecrypt<<<<<<Failure: " + e.getMessage(), e);
            }
            throw new CardException("CardDecrypt<<<<<<Failure: " + e.getMessage(), e);
        }
        finally {
            if (sessionHandle != null) {
                this.sessionHandles.add(sessionHandle);
            }
        }
        if (decLength < decryptData.length) {
            cardDecryptData = new byte[decLength];
            System.arraycopy(decryptData, 0, cardDecryptData, 0, cardDecryptData.length);
        } else {
            cardDecryptData = decryptData;
        }
        if (logger.isDebugEnabled()) {
            logger.debug("CardDecrypt::<<<<<<Finished: cardDecryptData=" + SADKDebugger.dump(cardDecryptData));
        }
        return cardDecryptData;
    }

    final boolean SM2CardExternalVerify(SM2CardPublicKey cardKey, byte[] hashValue, byte[] signValue) throws CardException {
        byte[] cardSignValue;
        block29: {
            if (logger.isDebugEnabled()) {
                StringBuffer buffer = new StringBuffer();
                buffer.append("SM2CardExternalVerify>>>>>>Running");
                buffer.append("\n cardKey: ");
                buffer.append(SADKDebugger.dump(cardKey));
                buffer.append("\n hashValue: ");
                buffer.append(SADKDebugger.dump(hashValue));
                buffer.append("\n signValue: ");
                buffer.append(SADKDebugger.dump(signValue));
                logger.debug(buffer.toString());
            }
            if (cardKey == null) {
                throw new CardException("SM2CardExternalVerify<<<<<<Failure with invalid SM2CardPublicKey");
            }
            if (hashValue == null || hashValue.length != 32) {
                throw new CardException("SM2CardExternalVerify<<<<<<Failure with invalid hashValue(Required 32)!");
            }
            if (signValue == null) {
                throw new CardException("SM2CardExternalVerify<<<<<<Failure with invalid signValue!");
            }
            cardSignValue = null;
            try {
                if (signValue.length == 64) {
                    cardSignValue = signValue;
                    break block29;
                }
                if (ASN1SM2Signature.isASN1SignType(signValue)) {
                    cardSignValue = new ASN1SM2Signature(signValue).getRSRaw64Bytes();
                    break block29;
                }
                throw new CardException("SM2CardExternalVerify<<<<<<Failure with invalid signValue(Required 64 or asn1)!!!");
            }
            catch (CardException e) {
                throw e;
            }
            catch (Exception e) {
                throw new CardException("SM2CardExternalVerify<<<<<<Failure with invalid signValue: " + e.getMessage(), e);
            }
            catch (Throwable e) {
                throw new CardException("SM2CardExternalVerify<<<<<<Failure  with invalid signValue: " + e.getMessage(), e);
            }
        }
        if (logger.isDebugEnabled()) {
            logger.debug("SM2CardExternalVerify::::::cardSignValue=" + SADKDebugger.dump(cardSignValue));
        }
        byte[] sourceExternaData = cardKey.buildExternalData(hashValue);
        long keyHandle = cardKey.getKeyHandle();
        boolean verifyResult = false;
        Long sessionHandle = null;
        try {
            sessionHandle = this.takeSessionHandle();
            if (logger.isDebugEnabled()) {
                logger.debug("SM2CardExternalVerify<<<<<<sessionHandle: " + sessionHandle + ",keyHandle=" + keyHandle);
            }
            int returnValue = this.sm2JNIP11.verifyInit(sessionHandle.longValue(), keyHandle, 65548, 1);
            if (logger.isDebugEnabled()) {
                logger.debug("SM2CardExternalVerify::::::verifyInit: retrunValue=" + returnValue);
            }
            if (returnValue != 0) {
                throw new CardException("SM2CardExternalVerify<<<<<<Failure with verifyInit returnValue=" + returnValue);
            }
            returnValue = this.sm2JNIP11.verify(sessionHandle.longValue(), sourceExternaData, cardSignValue);
            if (returnValue == 0) {
                verifyResult = true;
            } else {
                if (logger.isDebugEnabled()) {
                    logger.debug("SM2CardExternalVerify<<<<<<Failure with verifyHash returnValue: " + returnValue);
                }
                verifyResult = false;
            }
        }
        catch (CardException e) {
            if (logger.isErrorEnabled()) {
                logger.error("SM2CardExternalVerify<<<<<<Failure: " + e.getMessage(), (Throwable)e);
            }
            throw e;
        }
        catch (Exception e) {
            if (logger.isErrorEnabled()) {
                logger.error("SM2CardExternalVerify<<<<<<Failure: " + e.getMessage(), (Throwable)e);
            }
            throw new CardException("SM2CardExternalVerify<<<<<<Failure: " + e.getMessage(), e);
        }
        catch (Throwable e) {
            if (logger.isErrorEnabled()) {
                logger.error("SM2CardExternalVerify<<<<<<Failure: " + e.getMessage(), e);
            }
            throw new CardException("SM2CardExternalVerify<<<<<<Failure: " + e.getMessage(), e);
        }
        finally {
            if (sessionHandle != null) {
                this.sessionHandles.add(sessionHandle);
            }
        }
        if (logger.isDebugEnabled()) {
            logger.debug("SM2CardExternalVerify<<<<<<Finished: verifyResult=" + verifyResult);
        }
        return verifyResult;
    }

    final byte[] SM2CardExternalEncrypt(SM2CardPublicKey cardKey, byte[] sourceData) throws CardException {
        byte[] cardEncryptData;
        if (logger.isDebugEnabled()) {
            StringBuffer buffer = new StringBuffer();
            buffer.append("SM2CardExternalEncrypt>>>>>>Running");
            buffer.append("\n cardKey: ");
            buffer.append(SADKDebugger.dump(cardKey));
            buffer.append("\n sourceData: ");
            buffer.append(SADKDebugger.dump(sourceData));
            logger.debug(buffer.toString());
        }
        if (cardKey == null) {
            throw new CardException("SM2CardExternalEncrypt<<<<<<Failure with invalid SM2CardPublicKey");
        }
        if (sourceData == null || sourceData.length == 0) {
            throw new CardException("SM2CardExternalEncrypt Failure with invalid sourceData(Required > 0)!");
        }
        byte[] encryptData = new byte[sourceData.length + 96];
        byte[] sourceExternaData = cardKey.buildExternalData(sourceData);
        long keyHandle = cardKey.getKeyHandle();
        int encLength = 0;
        Long sessionHandle = null;
        try {
            int returnValue;
            sessionHandle = this.takeSessionHandle();
            if (logger.isDebugEnabled()) {
                logger.debug("SM2CardExternalEncrypt<<<<<<sessionHandle: " + sessionHandle + ",keyHandle=" + keyHandle);
            }
            if ((returnValue = this.sm2JNIP11.encryptInit(sessionHandle.longValue(), keyHandle, 65549)) != 0) {
                throw new CardException("SM2CardExternalEncrypt<<<<<<Failure with decryptInit returnValue=" + returnValue);
            }
            if (logger.isDebugEnabled()) {
                logger.debug("SM2CardExternalEncrypt::::::encryptInit: retrunValue=" + returnValue);
            }
            if (encryptData.length != (encLength = this.sm2JNIP11.encryptMsg(sessionHandle.longValue(), sourceExternaData, encryptData))) {
                throw new CardException("SM2CardExternalEncrypt<<<<<<Failure with encryptMsg returnValue=" + returnValue + ", requiredLength=" + encryptData.length);
            }
        }
        catch (CardException e) {
            if (logger.isErrorEnabled()) {
                logger.error("SM2CardExternalEncrypt<<<<<<Failure: " + e.getMessage(), (Throwable)e);
            }
            throw e;
        }
        catch (Exception e) {
            if (logger.isErrorEnabled()) {
                logger.error("SM2CardExternalEncrypt<<<<<<Failure: " + e.getMessage(), (Throwable)e);
            }
            throw new CardException("SM2CardExternalEncrypt<<<<<<Failure: " + e.getMessage(), e);
        }
        catch (Throwable e) {
            if (logger.isErrorEnabled()) {
                logger.error("SM2CardExternalEncrypt<<<<<<Failure: " + e.getMessage(), e);
            }
            throw new CardException("SM2CardExternalEncrypt<<<<<<Failure: " + e.getMessage(), e);
        }
        finally {
            if (sessionHandle != null) {
                this.sessionHandles.add(sessionHandle);
            }
        }
        if (encLength < encryptData.length) {
            cardEncryptData = new byte[encLength];
            System.arraycopy(encryptData, 0, cardEncryptData, 0, cardEncryptData.length);
        } else {
            cardEncryptData = encryptData;
        }
        if (logger.isDebugEnabled()) {
            logger.debug("SM2CardExternalEncrypt<<<<<<Finished: cardEncryptData=" + SADKDebugger.dump(cardEncryptData));
        }
        return cardEncryptData;
    }

    final KeyPair getKeyPair(BCECPublicKey pubKey) {
        return (KeyPair)this.cardKeys.get(new HashKey(pubKey));
    }

    final KeyPair getKeyPair(SM2PublicKey pubKey) {
        return (KeyPair)this.cardKeys.get(new HashKey(pubKey));
    }

    final PublicKey expoertEncPublicKey() throws CardException {
        if (logger.isDebugEnabled()) {
            logger.debug("expoertEncPublicKey>>>>>>Running");
        }
        byte[] keyData = new byte[64];
        SM2PublicKey pubKey = null;
        try {
            int returnValue = this.sm2JNIP11.exportProtectKey(this.sessionHandle, -1040183278L, keyData);
            if (returnValue != 0) {
                throw new CardException("expoertEncPublicKey<<<<<<Failure with returnValue=" + returnValue);
            }
            byte[] tempPublicKeyX = new byte[32];
            byte[] tempPublicKeyY = new byte[32];
            System.arraycopy(keyData, 0, tempPublicKeyX, 0, 32);
            System.arraycopy(keyData, 32, tempPublicKeyY, 0, 32);
            pubKey = new SM2PublicKey(tempPublicKeyX, tempPublicKeyY);
        }
        catch (Exception e) {
            throw new CardException("expoertEncPublicKey<<<<<<Failure: " + e.getMessage(), e);
        }
        if (logger.isDebugEnabled()) {
            logger.debug("expoertEncPublicKey<<<<<<Finished: SM2PublicKey=" + SADKDebugger.dump(pubKey));
        }
        return pubKey;
    }

    final boolean importSM2KeyPair(byte[] encryptKeyData, int CKID) throws CardException {
        if (logger.isDebugEnabled()) {
            StringBuffer buffer = new StringBuffer();
            buffer.append("importSM2KeyPair>>>>>>Running");
            buffer.append("\n encryptKeyData: ");
            buffer.append(SADKDebugger.dump(encryptKeyData));
            buffer.append("\n CKID: ");
            buffer.append(SADKDebugger.dump(String.valueOf(CKID)));
            logger.debug(buffer.toString());
        }
        String CKIDString = String.valueOf(CKID);
        try {
            KeyPair keypair;
            if (this.isECCKey(CKIDString)) {
                throw new CardException("importSM2KeyPair<<<<<<Failure ECC key is not support");
            }
            int returnValue = this.sm2JNIP11.ImportSM2KeyPair(this.sessionHandle, 1, CKIDString, encryptKeyData);
            if (logger.isInfoEnabled()) {
                logger.info("importSM2KeyPair::::<<<<<<Finished: returnValue--> " + returnValue);
            }
            if ((keypair = this.cardInitKeyPair(this.sm2JNIP11, this.sessionHandle, CKIDString, 1)) != null) {
                HashKey hashKey = null;
                hashKey = this.isECCKey(CKIDString) ? new HashKey((ECCCardPublicKey)keypair.getPublic()) : new HashKey((SM2CardPublicKey)keypair.getPublic());
                this.cardKeys.put(hashKey, keypair);
                if (logger.isDebugEnabled()) {
                    logger.debug("importSM2KeyPair::::<<<<<<Finished: updateEncryptKey--> " + hashKey);
                }
            }
            return true;
        }
        catch (Exception e) {
            StringBuffer buffer = new StringBuffer();
            buffer.append("C200 importSM2KeyPair failed: ");
            buffer.append("\n encryptKeyData: ");
            buffer.append(SADKDebugger.dump(encryptKeyData));
            buffer.append("\n CKID: ");
            buffer.append(SADKDebugger.dump(CKIDString));
            logger.error(buffer.toString());
            throw new CardException("importSM2KeyPair<<<<<<Failure: " + e.getMessage(), e);
        }
    }

    private boolean isECCKey(String CKID) {
        boolean isecc = false;
        int intCKID = Integer.parseInt(CKID);
        if (intCKID >= this.minECCIndex && intCKID <= this.maxECCIndex) {
            isecc = true;
        }
        return isecc;
    }

    protected boolean isECCKey(int intCKID) {
        boolean isecc = false;
        if (intCKID >= this.minECCIndex && intCKID <= this.maxECCIndex) {
            isecc = true;
        }
        return isecc;
    }

    public final class HashKey {
        final byte[] defaultZ;

        public HashKey(SM2PublicKey sm2Key) {
            this.defaultZ = sm2Key.getDefaultZ();
        }

        public HashKey(SM2CardPublicKey sm2Key) {
            this.defaultZ = sm2Key.getDefaultZ();
        }

        public HashKey(ECCCardPublicKey eccKey) {
            this.defaultZ = eccKey.getDefaultZ();
        }

        public HashKey(BCECPublicKey eccKey) {
            this.defaultZ = SM2Params.calcZ(eccKey.getQ().getX().getEncoded(), eccKey.getQ().getY().getEncoded());
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + this.getOuterType().hashCode();
            result = 31 * result + Arrays.hashCode(this.defaultZ);
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            HashKey other = (HashKey)obj;
            if (!this.getOuterType().equals(other.getOuterType())) {
                return false;
            }
            return Arrays.equals(this.defaultZ, other.defaultZ);
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append("HashKey [defaultZ=");
            builder.append(Hex.toHexString(this.defaultZ));
            builder.append("]");
            return builder.toString();
        }

        private C200CardP11 getOuterType() {
            return C200CardP11.this;
        }
    }
}

