/*
 * Decompiled with CFR 0.152.
 */
package cfca.sadk.lib.crypto;

import cfca.sadk.algorithm.common.PKIException;
import cfca.sadk.lib.crypto.Session;
import cfca.sadk.lib.crypto.bcsoft.BCSoftLib;
import cfca.sadk.lib.crypto.card.CardLib;
import cfca.sadk.lib.crypto.hard.HardLib;
import cfca.sadk.lib.crypto.jni.JNIInit;
import cfca.sadk.lib.crypto.jni.JNISoftLib;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public class JCrypto {
    public static final String JSOFT_LIB = "JSOFT_LIB";
    public static final String JNI_LIB = "JNISOFT_LIB";
    public static final String JHARD_LIB = "JHARD_LIB";
    public static final String JCARD_LIB = "JCARD_LIB";
    private ConcurrentMap htable = new ConcurrentHashMap();
    private static volatile JCrypto jCrypto = null;

    private JCrypto() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static JCrypto getInstance() {
        if (jCrypto != null) return jCrypto;
        Class<JCrypto> clazz = JCrypto.class;
        synchronized (JCrypto.class) {
            if (jCrypto != null) return jCrypto;
            jCrypto = new JCrypto();
            // ** MonitorExit[var0] (shouldn't be in output)
            return jCrypto;
        }
    }

    public Session openSession(String deviceName) throws PKIException {
        Session session = (Session)this.htable.get(deviceName);
        if (session == null) {
            throw new PKIException(PKIException.OPSESSION, PKIException.OPSESSION_DES + " " + deviceName);
        }
        return session;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public synchronized boolean initialize(String deviceName, Object param) throws PKIException {
        try {
            if (this.htable.containsKey(deviceName)) {
                return true;
            }
            if (deviceName.equals(JSOFT_LIB)) {
                this.htable.put(deviceName, BCSoftLib.INSTANCE());
                return true;
            } else if (deviceName.equals(JHARD_LIB)) {
                if (param == null) {
                    this.htable.put(deviceName, new HardLib(null));
                    return true;
                } else {
                    if (!(param instanceof String)) throw new PKIException("initialize failure with invalid param-type: " + param);
                    this.htable.put(deviceName, new HardLib((String)param));
                }
                return true;
            } else if (deviceName.equals(JNI_LIB)) {
                JNIInit.initOpenSSL();
                this.htable.put(deviceName, JNISoftLib.INSTANCE());
                return true;
            } else {
                if (!deviceName.equals(JCARD_LIB)) return true;
                JNIInit.initOpenSSL();
                this.htable.put(deviceName, new CardLib(param));
            }
            return true;
        }
        catch (Exception ex) {
            throw new PKIException(PKIException.INIT, PKIException.INIT_DES + " " + deviceName, ex);
        }
    }

    public long formateLocalTime(String localTime) throws ParseException {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        Date date = null;
        date = simpleDateFormat.parse(localTime);
        return date.getTime();
    }

    public synchronized boolean finalize(String deviceName, Object param) throws PKIException {
        try {
            if (!this.htable.containsKey(deviceName)) {
                return true;
            }
            if (deviceName.equals(JNI_LIB)) {
                JNIInit.unInitOpenSSL();
            } else if (!deviceName.equals(JHARD_LIB) && deviceName.equals(JCARD_LIB)) {
                CardLib hardlib = (CardLib)this.htable.get(JCARD_LIB);
                if (hardlib != null) {
                    hardlib.unloadLib();
                }
                JNIInit.unInitOpenSSL();
            }
            this.htable.remove(deviceName);
            return true;
        }
        catch (Exception ex) {
            throw new PKIException(PKIException.FINI, PKIException.FINI_DES + " " + deviceName, ex);
        }
    }
}

