/*
 * Decompiled with CFR 0.152.
 */
package cfca.sadk.lib.crypto;

import cfca.org.slf4j.Logger;
import cfca.org.slf4j.LoggerFactory;
import cfca.sadk.algorithm.common.Mechanism;
import cfca.sadk.algorithm.common.PKIException;
import cfca.sadk.algorithm.sm2.SM2PrivateKey;
import cfca.sadk.algorithm.sm2.SM2PublicKey;
import cfca.sadk.algorithm.util.HashEncoderUtil;
import cfca.sadk.algorithm.util.SymmetricHelper;
import cfca.sadk.lib.crypto.Session;
import cfca.sadk.org.bouncycastle.jce.interfaces.ECPrivateKey;
import cfca.sadk.org.bouncycastle.jce.interfaces.ECPublicKey;
import cfca.sadk.system.CompatibleAlgorithm;
import cfca.sadk.system.Mechanisms;
import cfca.sadk.system.SADKDebugger;
import cfca.sadk.system.global.SM2ContextConfig;
import cfca.sadk.util.KeyUtil;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.Key;
import java.security.KeyPair;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.PublicKey;
import java.security.SecureRandom;
import javax.crypto.spec.SecretKeySpec;

public abstract class BaseLib
implements Session {
    static final Logger logger = LoggerFactory.getLogger(BaseLib.class);

    public final KeyPair generateKeyPair(Mechanism mechanism, int bitLength) throws PKIException {
        if (logger.isDebugEnabled()) {
            StringBuffer buffer = new StringBuffer();
            buffer.append("GenerateKeyPair>>>>>>Running");
            buffer.append("\n mechanism: ");
            buffer.append(SADKDebugger.dump(mechanism));
            buffer.append("\n bitLength: " + bitLength);
            logger.debug(buffer.toString());
        }
        try {
            if (mechanism == null) {
                throw new PKIException("GenerateKeyPair failure with missing mechanism");
            }
            KeyPair keypair = null;
            if (Mechanisms.isSM2Type(mechanism)) {
                keypair = this.SM2GenerateKeyPair();
            } else if (Mechanisms.isRSAType(mechanism)) {
                keypair = this.RSAGenerateKeyPair(bitLength);
            } else if (Mechanisms.isECDSA(mechanism)) {
                keypair = this.ECCGenerateKeyPair(mechanism);
            } else {
                throw new PKIException("GenerateKeyPair failure with invalid keyType=" + mechanism.getMechanismType());
            }
            if (logger.isDebugEnabled()) {
                logger.debug("GenerateKeyPai<<<<<<Finished: keypair=" + SADKDebugger.dump(keypair));
            }
            return keypair;
        }
        catch (PKIException e) {
            if (logger.isErrorEnabled()) {
                logger.error("GenerateKeyPair<<<<<<Failure", (Throwable)e);
            }
            throw new PKIException("GenerateKeyPair failure with exception: " + e.getMessage(), e);
        }
        catch (Exception e) {
            if (logger.isErrorEnabled()) {
                logger.error("GenerateKeyPair<<<<<<Failure", (Throwable)e);
            }
            throw new PKIException("GenerateKeyPair failure with exception: " + e.getMessage(), e);
        }
        catch (Throwable e) {
            if (logger.isErrorEnabled()) {
                logger.error("GenerateKeyPair<<<<<<Failure", e);
            }
            throw new PKIException("GenerateKeyPair failure with throwable: " + e.getMessage(), e);
        }
    }

    public final Key generateKey(Mechanism mechanism) throws PKIException {
        if (logger.isDebugEnabled()) {
            StringBuffer buffer = new StringBuffer();
            buffer.append("GenerateKey>>>>>>Running");
            buffer.append("\n mechanism: ");
            buffer.append(SADKDebugger.dump(mechanism));
            logger.debug(buffer.toString());
        }
        try {
            if (mechanism == null) {
                throw new PKIException("GenerateKey failure with missing mechanism");
            }
            String type = mechanism.getMechanismType();
            SecureRandom random = new SecureRandom();
            SecretKeySpec key = null;
            if ("SM4".equals(type)) {
                byte[] keyData = new byte[16];
                random.nextBytes(keyData);
                key = new SecretKeySpec(keyData, type);
            } else if ("DESede".equals(type)) {
                byte[] keyData = new byte[24];
                random.nextBytes(keyData);
                key = new SecretKeySpec(keyData, type);
            } else if ("RC4".equals(type)) {
                byte[] keyData = new byte[16];
                random.nextBytes(keyData);
                key = new SecretKeySpec(keyData, type);
            } else {
                throw new PKIException("GenerateKey failure with invalid keyType=" + mechanism.getMechanismType());
            }
            if (logger.isDebugEnabled()) {
                logger.debug("GenerateKey<<<<<<Finished: key=" + SADKDebugger.dump(key));
            }
            return key;
        }
        catch (PKIException e) {
            if (logger.isErrorEnabled()) {
                logger.error("GenerateKey<<<<<<Failure", (Throwable)e);
            }
            throw new PKIException("GenerateKey failure with exception: " + e.getMessage(), e);
        }
        catch (Exception e) {
            if (logger.isErrorEnabled()) {
                logger.error("GenerateKey<<<<<<Failure", (Throwable)e);
            }
            throw new PKIException("GenerateKey failure with exception: " + e.getMessage(), e);
        }
        catch (Throwable e) {
            if (logger.isErrorEnabled()) {
                logger.error("GenerateKey<<<<<<Failure", e);
            }
            throw new PKIException("GenerateKey failure with throwable: " + e.getMessage(), e);
        }
    }

    public final Key generateKey(Mechanism mechanism, byte[] keyData) throws PKIException {
        if (logger.isDebugEnabled()) {
            StringBuffer buffer = new StringBuffer();
            buffer.append("generateKeyPair>>>>>>Running");
            buffer.append("\n mechanism: ");
            buffer.append(SADKDebugger.dump(mechanism));
            buffer.append("\n keyData: ");
            buffer.append(SADKDebugger.dump(keyData));
            logger.debug(buffer.toString());
        }
        try {
            if (mechanism == null) {
                throw new PKIException("GenerateKey failure with missing mechanism");
            }
            Key key = KeyUtil.generateKey(mechanism, keyData);
            if (logger.isDebugEnabled()) {
                logger.debug("GenerateKey<<<<<<Finished: key=" + SADKDebugger.dump(key));
            }
            return key;
        }
        catch (PKIException e) {
            if (logger.isErrorEnabled()) {
                logger.error("GenerateKey<<<<<<Failure", (Throwable)e);
            }
            throw new PKIException("GenerateKey failure with exception: " + e.getMessage(), e);
        }
        catch (Exception e) {
            if (logger.isErrorEnabled()) {
                logger.error("GenerateKey<<<<<<Failure", (Throwable)e);
            }
            throw new PKIException("GenerateKey failure with exception: " + e.getMessage(), e);
        }
        catch (Throwable e) {
            if (logger.isErrorEnabled()) {
                logger.error("GenerateKey<<<<<<Failure", e);
            }
            throw new PKIException("GenerateKey failure with throwable: " + e.getMessage(), e);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final byte[] sign(Mechanism mechanism, PrivateKey priKey, byte[] sourceData) throws PKIException {
        if (logger.isDebugEnabled()) {
            StringBuffer buffer = new StringBuffer();
            buffer.append("sign>>>>>>Running");
            buffer.append("\n mechanism: ");
            buffer.append(SADKDebugger.dump(mechanism));
            buffer.append("\n PrivateKey: ");
            buffer.append(SADKDebugger.dump(priKey));
            buffer.append("\n sourceData: ");
            buffer.append(SADKDebugger.dump(sourceData));
            logger.debug(buffer.toString());
        }
        try {
            if (mechanism == null) {
                throw new PKIException("sign failure with missing mechanism");
            }
            if (priKey == null) {
                throw new PKIException("sign failure with missing PrivateKey");
            }
            if (sourceData == null) {
                throw new PKIException("sign failure with missing sourceData");
            }
            if (!Mechanisms.isValid(mechanism)) {
                throw new PKIException("sign failure with invalid mechanism=" + mechanism);
            }
            byte[] signValue = null;
            if (Mechanisms.isSM2WithSM3(mechanism)) {
                SM2PublicKey sm2PubKey = null;
                SM2PrivateKey sm2priKey = this.SM2PrivateKeyFrom(priKey);
                byte[] hash = null;
                if (SM2ContextConfig.getUseZValue()) {
                    sm2PubKey = sm2priKey.getSM2PublicKey();
                    hash = this.SM2HashMessage(sm2PubKey, sourceData, true);
                } else {
                    hash = this.SM2HashMessage(sm2PubKey, sourceData, false);
                }
                signValue = this.SM2SignHash(sm2priKey, hash);
            } else if (Mechanisms.isECDSA(mechanism)) {
                if (!(priKey instanceof ECPrivateKey)) throw new PKIException("sign failure priKey is not supported: " + priKey.getClass());
                byte[] hash = this.RSAHashMessage(mechanism, sourceData, false);
                signValue = this.ECDSASignHash(priKey, hash, mechanism);
            } else {
                byte[] hashWithAlgorithm = this.RSAHashMessage(mechanism, sourceData);
                signValue = this.RSASignHash(priKey, hashWithAlgorithm);
            }
            if (!logger.isDebugEnabled()) return signValue;
            logger.debug("sign<<<<<<Finished: signValue=" + SADKDebugger.dump(signValue));
            return signValue;
        }
        catch (PKIException e) {
            if (!logger.isErrorEnabled()) throw new PKIException("sign failure with exception: " + e.getMessage(), e);
            logger.error("sign<<<<<<Failure", (Throwable)e);
            throw new PKIException("sign failure with exception: " + e.getMessage(), e);
        }
        catch (Exception e) {
            if (!logger.isErrorEnabled()) throw new PKIException("sign failure with exception: " + e.getMessage(), e);
            logger.error("sign<<<<<<Failure", (Throwable)e);
            throw new PKIException("sign failure with exception: " + e.getMessage(), e);
        }
        catch (Throwable e) {
            if (!logger.isErrorEnabled()) throw new PKIException("sign failure with throwable: " + e.getMessage(), e);
            logger.error("sign<<<<<<Failure", e);
            throw new PKIException("sign failure with throwable: " + e.getMessage(), e);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final byte[] sign(Mechanism mechanism, PrivateKey priKey, InputStream sourceStream) throws PKIException {
        if (logger.isDebugEnabled()) {
            StringBuffer buffer = new StringBuffer();
            buffer.append("sign>>>>>>Running");
            buffer.append("\n mechanism: ");
            buffer.append(SADKDebugger.dump(mechanism));
            buffer.append("\n PrivateKey: ");
            buffer.append(SADKDebugger.dump(priKey));
            buffer.append("\n sourceStream: ");
            buffer.append(SADKDebugger.dump(sourceStream));
            logger.debug(buffer.toString());
        }
        try {
            if (mechanism == null) {
                throw new PKIException("sign failure with missing mechanism");
            }
            if (priKey == null) {
                throw new PKIException("sign failure with missing PrivateKey");
            }
            if (sourceStream == null) {
                throw new PKIException("sign failure with missing sourceStream");
            }
            if (!Mechanisms.isValid(mechanism)) {
                throw new PKIException("sign failure with invalid mechanism=" + mechanism);
            }
            byte[] signValue = null;
            if (Mechanisms.isSM2WithSM3(mechanism)) {
                SM2PublicKey sm2PubKey = null;
                SM2PrivateKey sm2priKey = this.SM2PrivateKeyFrom(priKey);
                byte[] hash = null;
                if (SM2ContextConfig.getUseZValue()) {
                    sm2PubKey = sm2priKey.getSM2PublicKey();
                    hash = this.SM2HashFile(sm2PubKey, sourceStream, true);
                } else {
                    hash = this.SM2HashFile(sm2PubKey, sourceStream, false);
                }
                signValue = this.SM2SignHash(sm2priKey, hash);
            } else if (Mechanisms.isECDSA(mechanism)) {
                if (!(priKey instanceof ECPrivateKey)) throw new PKIException("sign failure priKey is not supported: " + priKey.getClass());
                byte[] hashWithoutAlgorithm = this.RSAHashFile(mechanism, sourceStream, false);
                signValue = this.ECDSASignHash(priKey, hashWithoutAlgorithm, mechanism);
            } else {
                byte[] hashWithAlgorithm = this.RSAHashFile(mechanism, sourceStream);
                signValue = this.RSASignHash(priKey, hashWithAlgorithm);
            }
            if (!logger.isDebugEnabled()) return signValue;
            logger.debug("sign<<<<<<Finished: signValue=" + SADKDebugger.dump(signValue));
            return signValue;
        }
        catch (PKIException e) {
            if (!logger.isErrorEnabled()) throw new PKIException("sign failure with exception: " + e.getMessage(), e);
            logger.error("sign<<<<<<Failure", (Throwable)e);
            throw new PKIException("sign failure with exception: " + e.getMessage(), e);
        }
        catch (Exception e) {
            if (!logger.isErrorEnabled()) throw new PKIException("sign failure with exception: " + e.getMessage(), e);
            logger.error("sign<<<<<<Failure", (Throwable)e);
            throw new PKIException("sign failure with exception: " + e.getMessage(), e);
        }
        catch (Throwable e) {
            if (!logger.isErrorEnabled()) throw new PKIException("sign failure with throwable: " + e.getMessage(), e);
            logger.error("sign<<<<<<Failure", e);
            throw new PKIException("sign failure with throwable: " + e.getMessage(), e);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final byte[] signByHash(Mechanism mechanism, PrivateKey priKey, byte[] hashValue) throws PKIException {
        if (logger.isDebugEnabled()) {
            StringBuffer buffer = new StringBuffer();
            buffer.append("signByHash>>>>>>Running");
            buffer.append("\n mechanism: ");
            buffer.append(SADKDebugger.dump(mechanism));
            buffer.append("\n PrivateKey: ");
            buffer.append(SADKDebugger.dump(priKey));
            buffer.append("\n hashValue: ");
            buffer.append(SADKDebugger.dump(hashValue));
            logger.debug(buffer.toString());
        }
        try {
            if (mechanism == null) {
                throw new PKIException("signByHash failure with missing mechanism");
            }
            if (priKey == null) {
                throw new PKIException("signByHash failure with missing PrivateKey");
            }
            if (hashValue == null) {
                throw new PKIException("signByHash failure with missing hashValue");
            }
            if (!Mechanisms.isValid(mechanism)) {
                throw new PKIException("signByHash failure with invalid mechanism=" + mechanism);
            }
            byte[] signValue = null;
            if (Mechanisms.isSM2WithSM3(mechanism)) {
                SM2PrivateKey sm2priKey = this.SM2PrivateKeyFrom(priKey);
                signValue = this.SM2SignHash(sm2priKey, hashValue);
            } else if (Mechanisms.isECDSA(mechanism)) {
                if (!(priKey instanceof ECPrivateKey)) throw new PKIException("signByHash failure priKey is not supported: " + priKey.getClass());
                signValue = this.ECDSASignHash(priKey, hashValue, mechanism);
            } else {
                byte[] hashWithAlgorithm = HashEncoderUtil.derEncoder(mechanism, hashValue);
                signValue = this.RSASignHash(priKey, hashWithAlgorithm);
            }
            if (!logger.isDebugEnabled()) return signValue;
            logger.debug("signByHash<<<<<<Finished: signValue=" + SADKDebugger.dump(signValue));
            return signValue;
        }
        catch (PKIException e) {
            if (!logger.isErrorEnabled()) throw new PKIException("signByHash failure with exception: " + e.getMessage(), e);
            logger.error("signByHash<<<<<<Failure", (Throwable)e);
            throw new PKIException("signByHash failure with exception: " + e.getMessage(), e);
        }
        catch (Exception e) {
            if (!logger.isErrorEnabled()) throw new PKIException("signByHash failure with exception: " + e.getMessage(), e);
            logger.error("signByHash<<<<<<Failure", (Throwable)e);
            throw new PKIException("signByHash failure with exception: " + e.getMessage(), e);
        }
        catch (Throwable e) {
            if (!logger.isErrorEnabled()) throw new PKIException("signByHash failure with throwable: " + e.getMessage(), e);
            logger.error("signByHash<<<<<<Failure", e);
            throw new PKIException("signByHash failure with throwable: " + e.getMessage(), e);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean verify(Mechanism mechanism, PublicKey pubKey, byte[] sourceData, byte[] signData) throws PKIException {
        if (logger.isDebugEnabled()) {
            StringBuffer buffer = new StringBuffer();
            buffer.append("verify>>>>>>Running");
            buffer.append("\n mechanism: ");
            buffer.append(SADKDebugger.dump(mechanism));
            buffer.append("\n PublicKey: ");
            buffer.append(SADKDebugger.dump(pubKey));
            buffer.append("\n sourceData: ");
            buffer.append(SADKDebugger.dump(sourceData));
            buffer.append("\n signData: ");
            buffer.append(SADKDebugger.dump(signData));
            logger.debug(buffer.toString());
        }
        try {
            if (mechanism == null) {
                throw new PKIException("verify failure with missing mechanism");
            }
            if (pubKey == null) {
                throw new PKIException("verify failure with missing PublicKey");
            }
            if (sourceData == null) {
                throw new PKIException("verify failure with missing sourceData");
            }
            if (signData == null) {
                throw new PKIException("verify failure with missing signData");
            }
            if (!Mechanisms.isValid(mechanism)) {
                throw new PKIException("verify failure with invalid mechanism=" + mechanism);
            }
            boolean verifyResult = false;
            if (Mechanisms.isSM2WithSM3(mechanism)) {
                SM2PublicKey sm2PubKey = this.SM2PublicKeyFrom(pubKey);
                byte[] hash = this.SM2HashMessage(sm2PubKey, sourceData, true);
                verifyResult = this.SM2VerifyHash(sm2PubKey, hash, signData);
                boolean compatibleWithoutZ = CompatibleAlgorithm.isCompatibleSM2WithoutZ();
                if (compatibleWithoutZ && !verifyResult) {
                    hash = this.SM2HashMessage(sm2PubKey, sourceData, false);
                    verifyResult = this.SM2VerifyHash(sm2PubKey, hash, signData);
                }
            } else if (Mechanisms.isECDSA(mechanism)) {
                if (!(pubKey instanceof ECPublicKey)) throw new PKIException("verify failure pubKey is not supported: " + pubKey.getClass());
                byte[] hash = this.RSAHashMessage(mechanism, sourceData, false);
                verifyResult = this.ECDSAVerifyHash(pubKey, hash, signData, mechanism);
            } else {
                byte[] hashWithAlgorithm = this.RSAHashMessage(mechanism, sourceData);
                verifyResult = this.RSAVerifyHash(pubKey, hashWithAlgorithm, signData);
            }
            if (!logger.isDebugEnabled()) return verifyResult;
            logger.debug("verify<<<<<<Finished: verifyResult=" + verifyResult);
            return verifyResult;
        }
        catch (PKIException e) {
            if (!logger.isErrorEnabled()) throw new PKIException("verify failure with exception: " + e.getMessage(), e);
            logger.error("verify<<<<<<Failure", (Throwable)e);
            throw new PKIException("verify failure with exception: " + e.getMessage(), e);
        }
        catch (Exception e) {
            if (!logger.isErrorEnabled()) throw new PKIException("sign failure with exception: " + e.getMessage(), e);
            logger.error("verify<<<<<<Failure", (Throwable)e);
            throw new PKIException("sign failure with exception: " + e.getMessage(), e);
        }
        catch (Throwable e) {
            if (!logger.isErrorEnabled()) throw new PKIException("verify failure with throwable: " + e.getMessage(), e);
            logger.error("verify<<<<<<Failure", e);
            throw new PKIException("verify failure with throwable: " + e.getMessage(), e);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean verify(Mechanism mechanism, PublicKey pubKey, InputStream sourceStream, byte[] signData) throws PKIException {
        if (logger.isDebugEnabled()) {
            StringBuffer buffer = new StringBuffer();
            buffer.append("verify>>>>>>Running");
            buffer.append("\n mechanism: ");
            buffer.append(SADKDebugger.dump(mechanism));
            buffer.append("\n PublicKey: ");
            buffer.append(SADKDebugger.dump(pubKey));
            buffer.append("\n sourceStream: ");
            buffer.append(SADKDebugger.dump(sourceStream));
            buffer.append("\n signData: ");
            buffer.append(SADKDebugger.dump(signData));
            logger.debug(buffer.toString());
        }
        try {
            if (mechanism == null) {
                throw new PKIException("verify failure with missing mechanism");
            }
            if (pubKey == null) {
                throw new PKIException("verify failure with missing PublicKey");
            }
            if (sourceStream == null) {
                throw new PKIException("verify failure with missing sourceStream");
            }
            if (signData == null) {
                throw new PKIException("verify failure with missing signData");
            }
            if (!Mechanisms.isValid(mechanism)) {
                throw new PKIException("verify failure with invalid mechanism=" + mechanism);
            }
            boolean verifyResult = false;
            if (Mechanisms.isSM2WithSM3(mechanism)) {
                SM2PublicKey sm2PubKey = this.SM2PublicKeyFrom(pubKey);
                boolean compatibleWithoutZ = CompatibleAlgorithm.isCompatibleSM2WithoutZ();
                byte[] hashWithZ = new byte[32];
                byte[] hashWithoutZ = new byte[32];
                this.SM2HashFile(sm2PubKey, compatibleWithoutZ, sourceStream, hashWithZ, hashWithoutZ);
                verifyResult = this.SM2VerifyHash(sm2PubKey, hashWithZ, signData);
                hashWithZ = null;
                if (compatibleWithoutZ && !verifyResult) {
                    verifyResult = this.SM2VerifyHash(sm2PubKey, hashWithoutZ, signData);
                }
            } else if (Mechanisms.isECDSA(mechanism)) {
                if (!(pubKey instanceof ECPublicKey)) throw new PKIException("verify failure pubKey is not supported: " + pubKey.getClass());
                byte[] hashWithoutAlgorithm = this.RSAHashFile(mechanism, sourceStream, false);
                verifyResult = this.ECDSAVerifyHash(pubKey, hashWithoutAlgorithm, signData, mechanism);
            } else {
                byte[] hashWithAlgorithm = this.RSAHashFile(mechanism, sourceStream);
                verifyResult = this.RSAVerifyHash(pubKey, hashWithAlgorithm, signData);
            }
            if (!logger.isDebugEnabled()) return verifyResult;
            logger.debug("verify<<<<<<Finished: verifyResult=" + verifyResult);
            return verifyResult;
        }
        catch (PKIException e) {
            if (!logger.isErrorEnabled()) throw new PKIException("verify failure with exception: " + e.getMessage(), e);
            logger.error("verify<<<<<<Failure", (Throwable)e);
            throw new PKIException("verify failure with exception: " + e.getMessage(), e);
        }
        catch (Exception e) {
            if (!logger.isErrorEnabled()) throw new PKIException("sign failure with exception: " + e.getMessage(), e);
            logger.error("verify<<<<<<Failure", (Throwable)e);
            throw new PKIException("sign failure with exception: " + e.getMessage(), e);
        }
        catch (Throwable e) {
            if (!logger.isErrorEnabled()) throw new PKIException("verify failure with throwable: " + e.getMessage(), e);
            logger.error("verify<<<<<<Failure", e);
            throw new PKIException("verify failure with throwable: " + e.getMessage(), e);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean verifyByHash(Mechanism mechanism, PublicKey pubKey, byte[] hashValue, byte[] signValue) throws PKIException {
        if (logger.isDebugEnabled()) {
            StringBuffer buffer = new StringBuffer();
            buffer.append("verifyByHash>>>>>>Running");
            buffer.append("\n mechanism: ");
            buffer.append(SADKDebugger.dump(mechanism));
            buffer.append("\n PublicKey: ");
            buffer.append(SADKDebugger.dump(pubKey));
            buffer.append("\n hashValue: ");
            buffer.append(SADKDebugger.dump(hashValue));
            buffer.append("\n signValue: ");
            buffer.append(SADKDebugger.dump(signValue));
            logger.debug(buffer.toString());
        }
        try {
            if (mechanism == null) {
                throw new PKIException("verifyByHash failure with missing mechanism");
            }
            if (pubKey == null) {
                throw new PKIException("verifyByHash failure with missing PublicKey");
            }
            if (hashValue == null) {
                throw new PKIException("verifyByHash failure with missing hashValue");
            }
            if (signValue == null) {
                throw new PKIException("verifyByHash failure with missing signValue");
            }
            if (!Mechanisms.isValid(mechanism)) {
                throw new PKIException("verifyByHash failure with invalid mechanism=" + mechanism);
            }
            boolean verifyResult = false;
            if (Mechanisms.isSM2WithSM3(mechanism)) {
                SM2PublicKey sm2PubKey = this.SM2PublicKeyFrom(pubKey);
                verifyResult = this.SM2VerifyHash(sm2PubKey, hashValue, signValue);
            } else if (Mechanisms.isECDSA(mechanism)) {
                if (!(pubKey instanceof ECPublicKey)) throw new PKIException("verifyByHash failure pubKey is not supported: " + pubKey.getClass());
                verifyResult = this.ECDSAVerifyHash(pubKey, hashValue, signValue, mechanism);
            } else {
                byte[] hashWithAlgorithm = HashEncoderUtil.derEncoder(mechanism, hashValue);
                verifyResult = this.RSAVerifyHash(pubKey, hashWithAlgorithm, signValue);
            }
            if (!logger.isDebugEnabled()) return verifyResult;
            logger.debug("verifyByHash<<<<<<Finished: verifyResult=" + verifyResult);
            return verifyResult;
        }
        catch (PKIException e) {
            if (!logger.isErrorEnabled()) throw new PKIException("verifyByHash failure with exception: " + e.getMessage(), e);
            logger.error("verifyByHash<<<<<<Failure", (Throwable)e);
            throw new PKIException("verifyByHash failure with exception: " + e.getMessage(), e);
        }
        catch (Exception e) {
            if (!logger.isErrorEnabled()) throw new PKIException("verifyByHash failure with exception: " + e.getMessage(), e);
            logger.error("verifyByHash<<<<<<Failure", (Throwable)e);
            throw new PKIException("verifyByHash failure with exception: " + e.getMessage(), e);
        }
        catch (Throwable e) {
            if (!logger.isErrorEnabled()) throw new PKIException("verifyByHash failure with throwable: " + e.getMessage(), e);
            logger.error("verifyByHash<<<<<<Failure", e);
            throw new PKIException("verifyByHash failure with throwable: " + e.getMessage(), e);
        }
    }

    public final byte[] encrypt(Mechanism mechanism, Key key, byte[] sourceData) throws PKIException {
        if (logger.isDebugEnabled()) {
            StringBuffer buffer = new StringBuffer();
            buffer.append("encrypt>>>>>>Running");
            buffer.append("\n mechanism: ");
            buffer.append(SADKDebugger.dump(mechanism));
            buffer.append("\n Key: ");
            buffer.append(SADKDebugger.dump(key));
            buffer.append("\n sourceData: ");
            buffer.append(SADKDebugger.dump(sourceData));
            logger.debug(buffer.toString());
        }
        try {
            if (mechanism == null) {
                throw new PKIException("encrypt failure with missing mechanism");
            }
            if (key == null) {
                throw new PKIException("encrypt failure with missing key");
            }
            if (sourceData == null) {
                throw new PKIException("encrypt failure with missing sourceData");
            }
            byte[] encryptBytes = null;
            String mType = mechanism.getMechanismType();
            if (mType.equals("SM2")) {
                SM2PublicKey sm2PubKey = this.SM2PublicKeyFrom(key);
                encryptBytes = this.SM2EncryptMessage(sm2PubKey, sourceData);
            } else if (mType.equals("SM4/ECB/PKCS7Padding") || mType.equals("SM4/CBC/PKCS7Padding")) {
                encryptBytes = this.SM4EncryptMessage(mechanism, key, sourceData);
            } else if (mType.equals("RSA/ECB/PKCS1PADDING")) {
                encryptBytes = this.RSAEncryptMessage((PublicKey)key, sourceData);
            } else if (mType.equals("DESede/CBC/PKCS7Padding") || mType.equals("DESede/ECB/PKCS7Padding")) {
                encryptBytes = this.DESedeEncryptMessage(mechanism, key, sourceData);
            } else if (mType.equals("AES/CBC/PKCS7Padding") || mType.equals("AES/ECB/PKCS7Padding")) {
                encryptBytes = this.AESEncryptMessage(mechanism, key, sourceData);
            } else if (mType.equals("RC4")) {
                encryptBytes = this.RC4EncryptMessage(mechanism, key, sourceData);
            } else if (mType.equals("ECC")) {
                encryptBytes = this.ECCEncryptMessage((PublicKey)key, sourceData);
            } else {
                throw new PKIException("encrypt failure with invalid mechanism=" + mechanism);
            }
            if (logger.isDebugEnabled()) {
                logger.debug("encrypt<<<<<<Finished: encryptBytes=" + SADKDebugger.dump(encryptBytes));
            }
            return encryptBytes;
        }
        catch (PKIException e) {
            if (logger.isErrorEnabled()) {
                logger.error("encrypt<<<<<<Failure", (Throwable)e);
            }
            throw new PKIException("encrypt failure with exception: " + e.getMessage(), e);
        }
        catch (Exception e) {
            if (logger.isErrorEnabled()) {
                logger.error("encrypt<<<<<<Failure", (Throwable)e);
            }
            throw new PKIException("encrypt failure with exception: " + e.getMessage(), e);
        }
        catch (Throwable e) {
            if (logger.isErrorEnabled()) {
                logger.error("encrypt<<<<<<Failure", e);
            }
            throw new PKIException("encrypt failure with throwable: " + e.getMessage(), e);
        }
    }

    public final byte[] decrypt(Mechanism mechanism, Key key, byte[] encryptData) throws PKIException {
        if (logger.isDebugEnabled()) {
            StringBuffer buffer = new StringBuffer();
            buffer.append("decrypt>>>>>>Running");
            buffer.append("\n mechanism: ");
            buffer.append(SADKDebugger.dump(mechanism));
            buffer.append("\n Key: ");
            buffer.append(SADKDebugger.dump(key));
            buffer.append("\n encryptData: ");
            buffer.append(SADKDebugger.dump(encryptData));
            logger.debug(buffer.toString());
        }
        try {
            if (mechanism == null) {
                throw new PKIException("encrypt failure with missing mechanism");
            }
            if (key == null) {
                throw new PKIException("encrypt failure with missing key");
            }
            if (encryptData == null) {
                throw new PKIException("encrypt failure with missing encryptData");
            }
            byte[] decryptBytes = null;
            String mType = mechanism.getMechanismType();
            if (mType.equals("SM2")) {
                SM2PrivateKey sm2priKey = this.SM2PrivateKeyFrom(key);
                decryptBytes = this.SM2DecryptMessage(sm2priKey, encryptData);
            } else if (mType.equals("SM4/ECB/PKCS7Padding") || mType.equals("SM4/CBC/PKCS7Padding")) {
                decryptBytes = this.SM4DecryptMessage(mechanism, key, encryptData);
            } else if (mType.equals("RSA/ECB/PKCS1PADDING")) {
                decryptBytes = this.RSADecryptMessage((PrivateKey)key, encryptData);
            } else if (mType.equals("DESede/CBC/PKCS7Padding") || mType.equals("DESede/ECB/PKCS7Padding")) {
                decryptBytes = this.DESedeDecryptMessage(mechanism, key, encryptData);
            } else if (mType.equals("AES/CBC/PKCS7Padding") || mType.equals("AES/ECB/PKCS7Padding")) {
                decryptBytes = this.AESDecryptMessage(mechanism, key, encryptData);
            } else if (mType.equals("RC4")) {
                decryptBytes = this.RC4DecryptMessage(mechanism, key, encryptData);
            } else if (mType.equals("ECC")) {
                decryptBytes = this.ECCDecryptMessage((PrivateKey)key, encryptData);
            } else {
                throw new PKIException("decrypt failure with invalid mechanism=" + mechanism);
            }
            if (logger.isDebugEnabled()) {
                logger.debug("decrypt<<<<<<Finished: decryptBytes=" + SADKDebugger.dump(decryptBytes));
            }
            return decryptBytes;
        }
        catch (PKIException e) {
            if (logger.isErrorEnabled()) {
                logger.error("decrypt<<<<<<Failure", (Throwable)e);
            }
            throw new PKIException("decrypt failure with exception: " + e.getMessage(), e);
        }
        catch (Exception e) {
            if (logger.isErrorEnabled()) {
                logger.error("decrypt<<<<<<Failure", (Throwable)e);
            }
            throw new PKIException("decrypt failure with exception: " + e.getMessage(), e);
        }
        catch (Throwable e) {
            if (logger.isErrorEnabled()) {
                logger.error("decrypt<<<<<<Failure", e);
            }
            throw new PKIException("decrypt failure with throwable: " + e.getMessage(), e);
        }
    }

    public final void encrypt(Mechanism mechanism, Key key, InputStream sourceStream, OutputStream encryptStream) throws PKIException {
        if (logger.isDebugEnabled()) {
            StringBuffer buffer = new StringBuffer();
            buffer.append("encrypt>>>>>>Running");
            buffer.append("\n mechanism: ");
            buffer.append(SADKDebugger.dump(mechanism));
            buffer.append("\n Key: ");
            buffer.append(SADKDebugger.dump(key));
            buffer.append("\n sourceStream: ");
            buffer.append(SADKDebugger.dump(sourceStream));
            buffer.append("\n encryptStream: ");
            buffer.append(SADKDebugger.dump(encryptStream));
            logger.debug(buffer.toString());
        }
        try {
            if (mechanism == null) {
                throw new PKIException("encrypt failure with missing mechanism");
            }
            if (key == null) {
                throw new PKIException("encrypt failure with missing key");
            }
            if (sourceStream == null) {
                throw new PKIException("encrypt failure with missing sourceStream");
            }
            if (encryptStream == null) {
                throw new PKIException("encrypt failure with missing encryptStream");
            }
            boolean forJNILib = false;
            SymmetricHelper.fileEncrypt(false, mechanism, key.getEncoded(), sourceStream, encryptStream);
            if (logger.isDebugEnabled()) {
                logger.debug("encrypt<<<<<<Finished");
            }
        }
        catch (PKIException e) {
            if (logger.isErrorEnabled()) {
                logger.error("encrypt<<<<<<Failure", (Throwable)e);
            }
            throw new PKIException("encrypt failure with exception: " + e.getMessage(), e);
        }
        catch (Exception e) {
            if (logger.isErrorEnabled()) {
                logger.error("encrypt<<<<<<Failure", (Throwable)e);
            }
            throw new PKIException("encrypt failure with exception: " + e.getMessage(), e);
        }
        catch (Throwable e) {
            if (logger.isErrorEnabled()) {
                logger.error("encrypt<<<<<<Failure", e);
            }
            throw new PKIException("encrypt failure with throwable: " + e.getMessage(), e);
        }
    }

    public final void decrypt(Mechanism mechanism, Key key, InputStream encryptStream, OutputStream plainTextStream) throws PKIException {
        if (logger.isDebugEnabled()) {
            StringBuffer buffer = new StringBuffer();
            buffer.append("decrypt>>>>>>Running");
            buffer.append("\n mechanism: ");
            buffer.append(SADKDebugger.dump(mechanism));
            buffer.append("\n Key: ");
            buffer.append(SADKDebugger.dump(key));
            buffer.append("\n encryptStream: ");
            buffer.append(SADKDebugger.dump(encryptStream));
            buffer.append("\n plainTextStream: ");
            buffer.append(SADKDebugger.dump(plainTextStream));
            logger.debug(buffer.toString());
        }
        try {
            if (mechanism == null) {
                throw new PKIException("encrypt failure with missing mechanism");
            }
            if (key == null) {
                throw new PKIException("encrypt failure with missing key");
            }
            if (encryptStream == null) {
                throw new PKIException("encrypt failure with missing encryptStream");
            }
            if (plainTextStream == null) {
                throw new PKIException("encrypt failure with missing plainTextStream");
            }
            boolean forJNILib = false;
            SymmetricHelper.fileDecrypt(false, mechanism, key.getEncoded(), encryptStream, plainTextStream);
            if (logger.isDebugEnabled()) {
                logger.debug("decryp<<<<<<Finished");
            }
        }
        catch (PKIException e) {
            if (logger.isErrorEnabled()) {
                logger.error("decryp<<<<<<Failure", (Throwable)e);
            }
            throw new PKIException("decrypt failure with exception: " + e.getMessage(), e);
        }
        catch (Exception e) {
            if (logger.isErrorEnabled()) {
                logger.error("decryp<<<<<<Failure", (Throwable)e);
            }
            throw new PKIException("decrypt failure with exception: " + e.getMessage(), e);
        }
        catch (Throwable e) {
            if (logger.isErrorEnabled()) {
                logger.error("decryp<<<<<<Failure", e);
            }
            throw new PKIException("decrypt failure with throwable: " + e.getMessage(), e);
        }
    }

    public final Provider getProvider() {
        return null;
    }

    public final String getProviderName() {
        return "CFCA";
    }

    protected final SM2PublicKey SM2PublicKeyFrom(Key key) {
        if (logger.isDebugEnabled()) {
            StringBuffer buffer = new StringBuffer();
            buffer.append("SM2PublicKeyFrom::>>>>>>Running");
            buffer.append("\n key: ");
            buffer.append(SADKDebugger.dump(key));
            logger.debug(buffer.toString());
        }
        SM2PublicKey sm2PublicKey = null;
        sm2PublicKey = key instanceof SM2PublicKey ? (SM2PublicKey)key : new SM2PublicKey(key.getEncoded());
        if (logger.isDebugEnabled()) {
            logger.debug("SM2PublicKeyFrom::<<<<<<Finished: sm2PublicKey=" + SADKDebugger.dump(sm2PublicKey));
        }
        return sm2PublicKey;
    }

    protected final SM2PrivateKey SM2PrivateKeyFrom(Key key) {
        if (logger.isDebugEnabled()) {
            StringBuffer buffer = new StringBuffer();
            buffer.append("SM2PrivateKeyFrom::>>>>>>Running");
            buffer.append("\n key: ");
            buffer.append(SADKDebugger.dump(key));
            logger.debug(buffer.toString());
        }
        SM2PrivateKey sm2PrivateKey = null;
        sm2PrivateKey = key instanceof SM2PrivateKey ? (SM2PrivateKey)key : new SM2PrivateKey(key.getEncoded());
        if (logger.isDebugEnabled()) {
            logger.debug("SM2PrivateKeyFrom::<<<<<<Finished: sm2PrivateKey=" + SADKDebugger.dump(sm2PrivateKey));
        }
        return sm2PrivateKey;
    }

    protected abstract KeyPair SM2GenerateKeyPair() throws PKIException;

    protected abstract KeyPair RSAGenerateKeyPair(int var1) throws PKIException;

    protected abstract KeyPair ECCGenerateKeyPair(Mechanism var1) throws PKIException;

    protected abstract byte[] SM2EncryptMessage(SM2PublicKey var1, byte[] var2) throws PKIException;

    protected abstract byte[] SM2DecryptMessage(SM2PrivateKey var1, byte[] var2) throws PKIException;

    protected abstract byte[] SM2SignHash(SM2PrivateKey var1, byte[] var2) throws PKIException;

    protected abstract boolean SM2VerifyHash(SM2PublicKey var1, byte[] var2, byte[] var3) throws PKIException;

    protected abstract byte[] SM2HashMessage(SM2PublicKey var1, byte[] var2, boolean var3) throws PKIException;

    protected abstract byte[] SM2HashFile(SM2PublicKey var1, InputStream var2, boolean var3) throws PKIException;

    protected abstract byte[] RSAEncryptMessage(PublicKey var1, byte[] var2) throws PKIException;

    protected abstract byte[] RSADecryptMessage(PrivateKey var1, byte[] var2) throws PKIException;

    protected abstract byte[] RSASignHash(PrivateKey var1, byte[] var2) throws PKIException;

    protected abstract boolean RSAVerifyHash(PublicKey var1, byte[] var2, byte[] var3) throws PKIException;

    protected abstract byte[] RSAHashMessage(Mechanism var1, byte[] var2) throws PKIException;

    protected abstract byte[] RSAHashMessage(Mechanism var1, byte[] var2, boolean var3) throws PKIException;

    protected abstract byte[] RSAHashFile(Mechanism var1, InputStream var2) throws PKIException;

    protected abstract byte[] RSAHashFile(Mechanism var1, InputStream var2, boolean var3) throws PKIException;

    protected abstract byte[] SM4EncryptMessage(Mechanism var1, Key var2, byte[] var3) throws PKIException;

    protected abstract byte[] SM4DecryptMessage(Mechanism var1, Key var2, byte[] var3) throws PKIException;

    protected abstract byte[] RC4EncryptMessage(Mechanism var1, Key var2, byte[] var3) throws PKIException;

    protected abstract byte[] RC4DecryptMessage(Mechanism var1, Key var2, byte[] var3) throws PKIException;

    protected abstract byte[] DESedeEncryptMessage(Mechanism var1, Key var2, byte[] var3) throws PKIException;

    protected abstract byte[] DESedeDecryptMessage(Mechanism var1, Key var2, byte[] var3) throws PKIException;

    protected abstract byte[] AESEncryptMessage(Mechanism var1, Key var2, byte[] var3) throws PKIException;

    protected abstract byte[] AESDecryptMessage(Mechanism var1, Key var2, byte[] var3) throws PKIException;

    protected abstract void SM2HashFile(SM2PublicKey var1, boolean var2, InputStream var3, byte[] var4, byte[] var5) throws PKIException;

    protected abstract byte[] ECDSASignHash(PrivateKey var1, byte[] var2, Mechanism var3) throws PKIException;

    protected abstract boolean ECDSAVerifyHash(PublicKey var1, byte[] var2, byte[] var3, Mechanism var4) throws PKIException;

    protected abstract byte[] ECCEncryptMessage(PublicKey var1, byte[] var2) throws PKIException;

    protected abstract byte[] ECCDecryptMessage(PrivateKey var1, byte[] var2) throws PKIException;
}

