/*
 * Decompiled with CFR 0.152.
 */
package cfca.sadk.envelope;

import cfca.sadk.algorithm.common.CBCParam;
import cfca.sadk.algorithm.common.Mechanism;
import cfca.sadk.algorithm.common.PKCS7EnvelopedData;
import cfca.sadk.algorithm.common.PKIException;
import cfca.sadk.org.bouncycastle.asn1.ASN1ObjectIdentifier;
import cfca.sadk.org.bouncycastle.asn1.DERNull;
import cfca.sadk.org.bouncycastle.asn1.DEROctetString;
import cfca.sadk.org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import cfca.sadk.system.SecureRandoms;
import java.security.SecureRandom;

public final class EnvelopeKit {
    public static final KeyParameters generateSecretKey(String symmetricAlgorithm) throws PKIException {
        AlgorithmIdentifier algorithmIdentifier;
        Mechanism mechanism;
        if (symmetricAlgorithm == null) {
            throw new PKIException("required symmetricAlgorithm");
        }
        ASN1ObjectIdentifier tOID = (ASN1ObjectIdentifier)PKCS7EnvelopedData.MECH_OID.get(symmetricAlgorithm);
        if (tOID == null) {
            throw new PKIException("invalid [PKCS7Enveloped]symmetricAlgorithm: " + symmetricAlgorithm);
        }
        String contentEncryptionAlg = symmetricAlgorithm.toUpperCase();
        int ivLength = 0;
        int keyLength = 0;
        if (contentEncryptionAlg.indexOf("RC4") != -1) {
            ivLength = 0;
            keyLength = 16;
        } else if (contentEncryptionAlg.indexOf("SM4") != -1) {
            ivLength = contentEncryptionAlg.indexOf("CBC") == -1 ? 0 : 16;
            keyLength = 16;
        } else if (contentEncryptionAlg.indexOf("DESEDE") != -1) {
            ivLength = contentEncryptionAlg.indexOf("CBC") == -1 ? 0 : 8;
            keyLength = 24;
        } else {
            throw new PKIException("invalid symmetricAlgorithm: " + symmetricAlgorithm);
        }
        byte[] buffer = new byte[ivLength + keyLength];
        SecureRandom random = SecureRandoms.getInstance().newSecureRandom();
        random.nextBytes(buffer);
        byte[] key = new byte[keyLength];
        System.arraycopy(buffer, 0, key, 0, key.length);
        byte[] iv = new byte[ivLength];
        if (ivLength > 0) {
            System.arraycopy(buffer, key.length, iv, 0, iv.length);
            mechanism = new Mechanism(symmetricAlgorithm, new CBCParam(iv));
            algorithmIdentifier = new AlgorithmIdentifier(tOID, new DEROctetString(iv));
        } else {
            mechanism = new Mechanism(symmetricAlgorithm);
            algorithmIdentifier = new AlgorithmIdentifier(tOID, DERNull.INSTANCE);
        }
        return new KeyParameters(mechanism, algorithmIdentifier, key, iv);
    }

    public static final class KeyParameters {
        public final byte[] key;
        public final byte[] iv;
        public final Mechanism mechanism;
        public final AlgorithmIdentifier algorithmId;

        KeyParameters(Mechanism mechanism, AlgorithmIdentifier algorithmIdentifier, byte[] key, byte[] iv) {
            this.mechanism = mechanism;
            this.algorithmId = algorithmIdentifier;
            this.key = key;
            this.iv = iv;
        }
    }
}

