/*
 * Decompiled with CFR 0.152.
 */
package cfca.sadk.asn1.pkcs;

import cfca.org.slf4j.Logger;
import cfca.org.slf4j.LoggerFactory;
import cfca.sadk.algorithm.common.Mechanism;
import cfca.sadk.algorithm.common.PKCSObjectIdentifiers;
import cfca.sadk.algorithm.common.PKIException;
import cfca.sadk.algorithm.sm2.SM2PublicKey;
import cfca.sadk.asn1.parser.ASN1Parser;
import cfca.sadk.lib.crypto.Session;
import cfca.sadk.lib.crypto.bcsoft.BCSoftLib;
import cfca.sadk.lib.crypto.card.CardLib;
import cfca.sadk.lib.crypto.hard.HardLib;
import cfca.sadk.org.bouncycastle.asn1.ASN1EncodableVector;
import cfca.sadk.org.bouncycastle.asn1.ASN1Integer;
import cfca.sadk.org.bouncycastle.asn1.ASN1ObjectIdentifier;
import cfca.sadk.org.bouncycastle.asn1.ASN1OctetString;
import cfca.sadk.org.bouncycastle.asn1.ASN1Sequence;
import cfca.sadk.org.bouncycastle.asn1.ASN1Set;
import cfca.sadk.org.bouncycastle.asn1.DERBitString;
import cfca.sadk.org.bouncycastle.asn1.DERNull;
import cfca.sadk.org.bouncycastle.asn1.DEROctetString;
import cfca.sadk.org.bouncycastle.asn1.DERPrintableString;
import cfca.sadk.org.bouncycastle.asn1.DERSequence;
import cfca.sadk.org.bouncycastle.asn1.DERSet;
import cfca.sadk.org.bouncycastle.asn1.pkcs.CertificationRequest;
import cfca.sadk.org.bouncycastle.asn1.pkcs.CertificationRequestInfo;
import cfca.sadk.org.bouncycastle.asn1.pkcs.RSAPublicKey;
import cfca.sadk.org.bouncycastle.asn1.x500.X500Name;
import cfca.sadk.org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import cfca.sadk.org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import cfca.sadk.org.bouncycastle.crypto.params.ECDomainParameters;
import cfca.sadk.org.bouncycastle.crypto.params.ECNamedDomainParameters;
import cfca.sadk.org.bouncycastle.crypto.params.ECPublicKeyParameters;
import cfca.sadk.org.bouncycastle.crypto.params.RSAKeyParameters;
import cfca.sadk.org.bouncycastle.crypto.util.PublicKeyFactory;
import cfca.sadk.org.bouncycastle.jcajce.provider.asymmetric.ec.BCECPublicKey;
import cfca.sadk.org.bouncycastle.jcajce.provider.asymmetric.ec.ECCSuportedCurves;
import cfca.sadk.org.bouncycastle.jcajce.provider.asymmetric.rsa.BCRSAPublicKey;
import cfca.sadk.org.bouncycastle.jce.spec.ECNamedCurveParameterSpec;
import cfca.sadk.org.bouncycastle.jce.spec.ECParameterSpec;
import cfca.sadk.org.bouncycastle.pkcs.PKCS10CertificationRequest;
import cfca.sadk.system.CompatibleConfig;
import cfca.sadk.system.Mechanisms;
import cfca.sadk.system.SADKDebugger;
import cfca.sadk.system.SM2OutputFormat;
import cfca.sadk.system.global.P10RequestContextConfig;
import cfca.sadk.util.Base64;
import cfca.sadk.util.KeyUtil;
import cfca.sadk.util.Signature;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.math.BigInteger;
import java.security.KeyPair;
import java.security.PrivateKey;
import java.security.PublicKey;

public class PKCS10 {
    static final Logger logger = LoggerFactory.getLogger(PKCS10.class);
    private String subject = null;
    private PublicKey publicKey = null;
    private PublicKey tempPublicKey = null;
    private ASN1Set attributes = null;
    private KeyPair keyPair = null;
    private KeyPair tempKeyPair;
    private final Session session;
    private boolean needVerify = false;
    private boolean p10RequestVerifyState = false;
    private int certReqType = 0;
    Mechanism mechanism = null;
    byte[] signature = null;
    byte[] source = null;
    private int formatSignedBytes = CompatibleConfig.P10RequestFormatSignedBytes;
    private static final String defaultX500Name = "CN=certRequisition,O=CFCA TEST CA,C=CN";
    private static final String challengePassword = "111111";

    public PKCS10() {
        this(BCSoftLib.INSTANCE());
    }

    public PKCS10(Session session) {
        this.session = session;
        if (logger.isDebugEnabled()) {
            logger.debug("PKCS10>>>>>>: session=" + SADKDebugger.dump(session) + ",formatSignedBytes=" + this.formatSignedBytes);
        }
    }

    public void load(byte[] data) throws PKIException {
        if (logger.isDebugEnabled()) {
            logger.debug("loadP10Bytes>>>>>>Running: data=" + SADKDebugger.dump(data));
        }
        try {
            ASN1Sequence sequence;
            if (data == null) {
                throw new PKIException("loadP10Bytes Failure: P10File data should not be null");
            }
            if (!ASN1Parser.isDERSequence(data)) {
                if (logger.isDebugEnabled()) {
                    logger.debug("loadP10Bytes::::::Running: data=" + SADKDebugger.dumpBase64(data));
                }
                BufferedReader bufferReader = new BufferedReader(new InputStreamReader(new ByteArrayInputStream(data)));
                try {
                    String line = bufferReader.readLine();
                    if (line != null && line.toUpperCase().indexOf("BEGIN NEW CERTIFICATE REQUEST") != -1) {
                        StringBuffer strBuffer = new StringBuffer();
                        while ((line = bufferReader.readLine()) != null && line.toUpperCase().indexOf("END NEW CERTIFICATE REQUEST") == -1) {
                            strBuffer.append(line);
                        }
                        data = strBuffer.toString().getBytes();
                    }
                }
                catch (Exception e) {
                    throw new PKIException(PKIException.PARSE_P10_ERR, "P10 Text ReadLine decoding failure", e);
                }
            }
            try {
                sequence = ASN1Parser.getDERSequenceFrom(data);
            }
            catch (Exception e) {
                throw new PKIException(PKIException.PARSE_P10_ERR, "P10 DERSequence decoding failure", e);
            }
            CertificationRequest certificationRequest = null;
            try {
                certificationRequest = new CertificationRequest(sequence);
            }
            catch (Exception e) {
                throw new PKIException(PKIException.PARSE_P10_ERR, "P10 CertificationRequest decoding failure", e);
            }
            this.load(certificationRequest);
            if (logger.isDebugEnabled()) {
                logger.debug("loadP10Bytes<<<<<<Finished");
            }
        }
        catch (PKIException e) {
            if (logger.isErrorEnabled()) {
                logger.error("loadP10Bytes<<<<<<Failure", (Throwable)e);
            }
            throw e;
        }
        catch (Throwable e) {
            if (logger.isErrorEnabled()) {
                logger.error("loadP10Bytes<<<<<<Failure: " + e.getMessage(), e);
            }
            throw new PKIException("loadP10Bytes Failure: " + e.getMessage(), e);
        }
    }

    public void load(CertificationRequest certficationRequest) throws PKIException {
        if (logger.isDebugEnabled()) {
            logger.debug("loadP10CertificationRequest>>>>>>Running: certficationRequest=" + SADKDebugger.dump(certficationRequest));
        }
        try {
            String signAlg = Mechanism.getSignatureAlgName(certficationRequest.getSignatureAlgorithm());
            if (!Mechanisms.isValid(signAlg)) {
                throw new PKIException(PKIException.GEN_P10_ERR, PKIException.GEN_P10_ERR_DES + " " + PKIException.NONSUPPORT_SIGALG_DES + " " + signAlg);
            }
            this.mechanism = new Mechanism(signAlg);
            boolean smFlag = Mechanisms.isSM2WithSM3(this.mechanism);
            boolean ecFlag = Mechanisms.isECDSA(this.mechanism);
            this.signature = certficationRequest.getSignature().getBytes();
            if (smFlag || ecFlag) {
                try {
                    this.signature = SM2OutputFormat.sm2FormatSigned64Bytes(this.signature);
                }
                catch (Exception e) {
                    throw new PKIException("loadP10CertificationRequest Failure: Build FormatSigned64Bytes Failure", e);
                }
            }
            CertificationRequestInfo crqInfo = certficationRequest.getCertificationRequestInfo();
            this.source = ASN1Parser.parseDERObj2Bytes(crqInfo.toASN1Primitive());
            SubjectPublicKeyInfo spkInfo = crqInfo.getSubjectPublicKeyInfo();
            this.needVerify = P10RequestContextConfig.getP10RequestVerifyState();
            this.subject = crqInfo.getSubject().toString();
            this.attributes = crqInfo.getAttributes();
            if (this.attributes != null && this.attributes.size() > 1) {
                this.prepareTemporaryPublicKey();
            }
            try {
                if (smFlag) {
                    this.publicKey = new SM2PublicKey(spkInfo.getPublicKeyData().getBytes());
                } else if (ecFlag) {
                    ECPublicKeyParameters params = (ECPublicKeyParameters)PublicKeyFactory.createKey(spkInfo);
                    if (params.getParameters() instanceof ECNamedDomainParameters) {
                        ECNamedDomainParameters domainParams = (ECNamedDomainParameters)params.getParameters();
                        ECNamedCurveParameterSpec spec = new ECNamedCurveParameterSpec(domainParams.getName().getId(), domainParams.getCurve(), domainParams.getG(), domainParams.getN(), domainParams.getH(), domainParams.getSeed());
                        this.publicKey = new BCECPublicKey("EC", params, spec);
                    } else if (params.getParameters() instanceof ECDomainParameters) {
                        ECDomainParameters domainParams = params.getParameters();
                        ECParameterSpec spec = new ECParameterSpec(domainParams.getCurve(), domainParams.getG(), domainParams.getN(), domainParams.getH(), domainParams.getSeed());
                        this.publicKey = new BCECPublicKey("EC", params, spec);
                    }
                } else {
                    RSAKeyParameters param = null;
                    param = (RSAKeyParameters)PublicKeyFactory.createKey(spkInfo);
                    this.publicKey = new BCRSAPublicKey(param);
                }
            }
            catch (IOException e) {
                throw new PKIException("loadP10CertificationRequest Failure: Build PublicKey Failure", e);
            }
            if (this.needVerify) {
                this.p10RequestVerifyState = this.session.verify(this.mechanism, this.publicKey, this.source, this.signature);
                if (!this.p10RequestVerifyState) {
                    throw new PKIException(PKIException.PARSE_P10_ERR, PKIException.PARSE_P10_ERR_DES + " " + PKIException.PARSE_P10_ERR_VERIFY_SIG_DES);
                }
            }
            if (logger.isDebugEnabled()) {
                StringBuffer buffer = new StringBuffer();
                buffer.append("loadP10CertificationRequest<<<<<<Finished");
                buffer.append("\n needVerify: " + this.needVerify);
                buffer.append("\n p10RequestVerifyState: " + this.p10RequestVerifyState);
                buffer.append("\n publicKey: ");
                buffer.append(SADKDebugger.dump(this.publicKey));
                buffer.append("\n mechanism: ");
                buffer.append(SADKDebugger.dump(this.mechanism));
                buffer.append("\n session: ");
                buffer.append(SADKDebugger.dump(this.session));
                logger.debug(buffer.toString());
            }
        }
        catch (PKIException e) {
            if (logger.isErrorEnabled()) {
                logger.error("loadP10CertificationRequest<<<<<<Failure", (Throwable)e);
            }
            throw e;
        }
        catch (Throwable e) {
            if (logger.isErrorEnabled()) {
                logger.error("loadP10CertificationRequest<<<<<<Failure: " + e.getMessage(), e);
            }
            throw new PKIException("loadP10CertificationRequest Failure: " + e.getMessage(), e);
        }
    }

    public byte[] generateDoublePKCS10Request(Mechanism mechanism, int keyLength) throws PKIException {
        return this.generateDoublePKCS10Request(mechanism, keyLength, BCSoftLib.INSTANCE());
    }

    public byte[] generateDoublePKCS10Request(Mechanism mechanism, int keyLength, Session session) throws PKIException {
        X500Name subject = new X500Name(defaultX500Name);
        return this.generateDoublePKCS10Request(mechanism, keyLength, subject, challengePassword, session);
    }

    public byte[] generateDoublePKCS10Request(Mechanism mechanism, int keyLength, Session session, boolean isSoftKey) throws PKIException {
        X500Name subject = new X500Name(defaultX500Name);
        return this.generateDoublePKCS10Request(mechanism, keyLength, subject, challengePassword, session, isSoftKey);
    }

    public byte[] generateDoublePKCS10Request(Mechanism mechanism, int keyLength, X500Name x500NameSubject, String challengePassword, Session session) throws PKIException {
        return this.generateDoublePKCS10Request(mechanism, keyLength, x500NameSubject, challengePassword, session, true);
    }

    public byte[] generateDoublePKCS10Request(Mechanism mechanism, int keyLength, X500Name x500NameSubject, String challengePassword, Session session, boolean isEncSoftKey) throws PKIException {
        if (logger.isDebugEnabled()) {
            StringBuffer buffer = new StringBuffer();
            buffer.append("generateDoublePKCS10Request>>>>>>Running");
            buffer.append("\n mechanism: ");
            buffer.append(SADKDebugger.dump(mechanism));
            buffer.append("\n keyLength: " + keyLength);
            buffer.append("\n session: ");
            buffer.append(SADKDebugger.dump(session));
            logger.debug(buffer.toString());
        }
        try {
            String signAlgValue = mechanism.getMechanismType();
            Mechanism enMechanism = Mechanisms.encryptMechanismFrom(mechanism);
            if (null == enMechanism) {
                throw new PKIException("generateDoublePKCS10Request Failure: unsupported algorithm: " + mechanism.getMechanismType());
            }
            enMechanism.setParam(mechanism.getParam());
            if (null == session) {
                throw new PKIException("generateDoublePKCS10Request Failure: encryption session uninitialized!");
            }
            this.keyPair = KeyUtil.generateKeyPair(enMechanism, keyLength, session);
            if (isEncSoftKey) {
                this.tempKeyPair = KeyUtil.generateKeyPair(enMechanism, keyLength, BCSoftLib.INSTANCE());
                this.tempPublicKey = this.tempKeyPair.getPublic();
            } else {
                this.tempPublicKey = this.getInternalEncPublicKey(enMechanism, keyLength, session, isEncSoftKey);
            }
            SubjectPublicKeyInfo publicKeyInfo = SubjectPublicKeyInfo.getInstance(this.keyPair.getPublic().getEncoded());
            SubjectPublicKeyInfo temporaryPublicKeyInfo = SubjectPublicKeyInfo.getInstance(this.tempPublicKey.getEncoded());
            ASN1EncodableVector challengePasswordVector = new ASN1EncodableVector();
            DERPrintableString challengePasswordValue = new DERPrintableString(challengePassword);
            challengePasswordVector.add(PKCSObjectIdentifiers.pkcs_9_at_challengePassword);
            challengePasswordVector.add(challengePasswordValue);
            DERSequence challengePasswordSeq = new DERSequence(challengePasswordVector);
            ASN1EncodableVector tempPublicKeyVector = new ASN1EncodableVector();
            tempPublicKeyVector.add(PKCSObjectIdentifiers.pkcs_9_at_tempPublicKey);
            ASN1Integer derInt = new ASN1Integer(1L);
            DEROctetString tempOctetString = null;
            if (Mechanisms.isRSAType(enMechanism)) {
                try {
                    tempOctetString = new DEROctetString(temporaryPublicKeyInfo.parsePublicKey());
                }
                catch (IOException e) {
                    throw new PKIException("generateDoublePKCS10Request Failure: " + e.getMessage(), e);
                }
            } else if (Mechanisms.isSM2Type(enMechanism)) {
                byte[] tempPublicKeyData = new byte[136];
                byte[] temporaryPublicKeyData = temporaryPublicKeyInfo.getPublicKeyData().getBytes();
                byte[] temporaryPublicKeyX = new byte[32];
                byte[] temporaryPublicKeyY = new byte[32];
                System.arraycopy(temporaryPublicKeyData, 1, temporaryPublicKeyX, 0, 32);
                System.arraycopy(temporaryPublicKeyData, 33, temporaryPublicKeyY, 0, 32);
                byte[] CONST1 = new byte[]{0, -76, 0, 0};
                byte[] CONST2 = new byte[]{0, 1, 0, 0};
                System.arraycopy(CONST1, 0, tempPublicKeyData, 0, 4);
                System.arraycopy(CONST2, 0, tempPublicKeyData, 4, 4);
                System.arraycopy(temporaryPublicKeyX, 0, tempPublicKeyData, 8, 32);
                System.arraycopy(temporaryPublicKeyY, 0, tempPublicKeyData, 72, 32);
                tempOctetString = new DEROctetString(tempPublicKeyData);
            }
            ASN1EncodableVector intAndPublicKeyVector = new ASN1EncodableVector();
            intAndPublicKeyVector.add(derInt);
            intAndPublicKeyVector.add(tempOctetString);
            DERSequence tempPublicKeyInfoSeq = new DERSequence(intAndPublicKeyVector);
            DEROctetString intAndPublicKeyOctetString = null;
            try {
                intAndPublicKeyOctetString = new DEROctetString(tempPublicKeyInfoSeq);
            }
            catch (IOException e) {
                throw new PKIException("generateDoublePKCS10Request Failure: " + e.getMessage(), e);
            }
            tempPublicKeyVector.add(intAndPublicKeyOctetString);
            DERSequence tempPubKeySeq = new DERSequence(tempPublicKeyVector);
            ASN1EncodableVector chaPasswordAndPubKeyVector = new ASN1EncodableVector();
            chaPasswordAndPubKeyVector.add(challengePasswordSeq);
            chaPasswordAndPubKeyVector.add(tempPubKeySeq);
            this.attributes = new DERSet(chaPasswordAndPubKeyVector);
            CertificationRequestInfo certRequestInfo = new CertificationRequestInfo(x500NameSubject, publicKeyInfo, this.attributes);
            ASN1ObjectIdentifier obj = Mechanism.getObjectIdentifier(signAlgValue);
            AlgorithmIdentifier signAlg = new AlgorithmIdentifier(ASN1ObjectIdentifier.getInstance(obj), DERNull.INSTANCE);
            try {
                byte[] sourceData = certRequestInfo.getEncoded("DER");
                byte[] signature = session.sign(mechanism, this.keyPair.getPrivate(), sourceData);
                if (Mechanisms.isSM2WithSM3(signAlgValue) || Mechanisms.isECDSA(signAlgValue)) {
                    signature = this.sm2FormatSignedBytes(signature);
                }
                CertificationRequest certRequest = new CertificationRequest(certRequestInfo, signAlg, new DERBitString(signature));
                PKCS10CertificationRequest p10 = new PKCS10CertificationRequest(certRequest);
                byte[] base64P10Bytes = Base64.encode(p10.getEncoded());
                if (logger.isDebugEnabled()) {
                    logger.debug("generateDoublePKCS10Request<<<<<<Finished: base64P10Bytes=" + SADKDebugger.dump(base64P10Bytes));
                }
                return base64P10Bytes;
            }
            catch (PKIException e) {
                throw e;
            }
            catch (Exception e) {
                throw new PKIException("generateDoublePKCS10Request Failure: Generated P10 Failure", e);
            }
        }
        catch (PKIException e) {
            if (logger.isErrorEnabled()) {
                logger.error("generateDoublePKCS10Request<<<<<<Failure", (Throwable)e);
            }
            throw e;
        }
        catch (Throwable e) {
            if (logger.isErrorEnabled()) {
                logger.error("generateDoublePKCS10Request<<<<<<Failure: " + e.getMessage(), e);
            }
            throw new PKIException("generateDoublePKCS10Request Failure: " + e.getMessage(), e);
        }
    }

    public byte[] generatePKCS10Request(Mechanism mechanism, int keyLength) throws PKIException {
        return this.generatePKCS10Request(mechanism, keyLength, BCSoftLib.INSTANCE());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public byte[] generatePKCS10Request(Mechanism mechanism, int keyLength, Session session) throws PKIException {
        if (logger.isDebugEnabled()) {
            StringBuffer buffer = new StringBuffer();
            buffer.append("generatePKCS10Request>>>>>>Running");
            buffer.append("\n mechanism: ");
            buffer.append(SADKDebugger.dump(mechanism));
            buffer.append("\n keyLength: " + keyLength);
            buffer.append("\n session: ");
            buffer.append(SADKDebugger.dump(session));
            logger.debug(buffer.toString());
        }
        try {
            String signAlgValue = mechanism.getMechanismType();
            Mechanism enMechanism = Mechanisms.encryptMechanismFrom(mechanism);
            if (null == enMechanism) {
                throw new PKIException("generatePKCS10Request Failure: unsupported algorithm: " + mechanism.getMechanismType());
            }
            enMechanism.setParam(mechanism.getParam());
            if (null == session) {
                throw new PKIException("generatePKCS10Request Failure: encryption session uninitialized!");
            }
            if (Mechanisms.isECDSA(mechanism)) {
                String curveName = mechanism.getCurveName();
                if (curveName != null) {
                    if (!ECCSuportedCurves.isSupportedCurve(curveName)) throw new PKIException("generatePKCS10Request Failure: unsupported curveName: " + curveName);
                    enMechanism.setCurveName(mechanism.getCurveName());
                } else {
                    enMechanism.setCurveName("prime256v1");
                }
            }
            this.keyPair = KeyUtil.generateKeyPair(enMechanism, keyLength, session);
            SubjectPublicKeyInfo pubInfo = SubjectPublicKeyInfo.getInstance(this.keyPair.getPublic().getEncoded());
            X500Name subject = new X500Name(defaultX500Name);
            CertificationRequestInfo certRequestInfo = new CertificationRequestInfo(subject, pubInfo, null);
            AlgorithmIdentifier signAlgID = Mechanism.getAlgorithmIdentifier(signAlgValue);
            try {
                byte[] sourceData = certRequestInfo.getEncoded("DER");
                byte[] signature = session.sign(mechanism, this.keyPair.getPrivate(), sourceData);
                if (Mechanisms.isSM2WithSM3(signAlgValue) || Mechanisms.isECDSA(signAlgValue)) {
                    signature = this.sm2FormatSignedBytes(signature);
                }
                CertificationRequest certRequest = new CertificationRequest(certRequestInfo, signAlgID, new DERBitString(signature));
                PKCS10CertificationRequest p10 = new PKCS10CertificationRequest(certRequest);
                byte[] base64P10Bytes = Base64.encode(p10.getEncoded());
                if (!logger.isDebugEnabled()) return base64P10Bytes;
                logger.debug("generatePKCS10Request<<<<<<Finished: base64P10Bytes=" + SADKDebugger.dump(base64P10Bytes));
                return base64P10Bytes;
            }
            catch (PKIException e) {
                throw e;
            }
            catch (Exception e) {
                throw new PKIException("generatePKCS10Request Failure: Generated P10 Failure", e);
            }
        }
        catch (PKIException e) {
            if (!logger.isErrorEnabled()) throw e;
            logger.error("generatePKCS10Request<<<<<<Failure", (Throwable)e);
            throw e;
        }
        catch (Throwable e) {
            if (!logger.isErrorEnabled()) throw new PKIException("generatePKCS10Request Failure: " + e.getMessage(), e);
            logger.error("generatePKCS10Request<<<<<<Failure: " + e.getMessage(), e);
            throw new PKIException("generatePKCS10Request Failure: " + e.getMessage(), e);
        }
    }

    public byte[] generatePKCS10Request(Mechanism mechanism, X500Name x500NameSubject, ASN1Set attributes, PublicKey publicKey, PrivateKey privateKey) throws PKIException {
        return this.generatePKCS10Request(mechanism, x500NameSubject, attributes, publicKey, privateKey, BCSoftLib.INSTANCE());
    }

    public byte[] generatePKCS10Request(Mechanism mechanism, X500Name x500NameSubject, ASN1Set attributes, PublicKey publicKey, PrivateKey privateKey, Session session) throws PKIException {
        if (logger.isDebugEnabled()) {
            StringBuffer buffer = new StringBuffer();
            buffer.append("generatePKCS10Request>>>>>>Running");
            buffer.append("\n mechanism: ");
            buffer.append(SADKDebugger.dump(mechanism));
            buffer.append("\n X500Name: ");
            buffer.append(SADKDebugger.dump(x500NameSubject));
            buffer.append("\n attributes: ");
            buffer.append(SADKDebugger.dump(attributes));
            buffer.append("\n publicKey: ");
            buffer.append(SADKDebugger.dump(publicKey));
            buffer.append("\n privateKey: ");
            buffer.append(SADKDebugger.dump(privateKey));
            buffer.append("\n session: ");
            buffer.append(SADKDebugger.dump(session));
            logger.debug(buffer.toString());
        }
        try {
            SubjectPublicKeyInfo pubInfo = SubjectPublicKeyInfo.getInstance(publicKey.getEncoded());
            CertificationRequestInfo certRequestInfo = new CertificationRequestInfo(x500NameSubject, pubInfo, attributes);
            AlgorithmIdentifier signAlgID = Mechanism.getAlgorithmIdentifier(mechanism.getMechanismType());
            if (null == session) {
                throw new PKIException("generatePKCS10Request Failure: encryption session uninitialized!");
            }
            try {
                byte[] sourceData = certRequestInfo.getEncoded("DER");
                byte[] signature = session.sign(mechanism, privateKey, sourceData);
                if (Mechanisms.isSM2WithSM3(mechanism) || Mechanisms.isECDSA(mechanism)) {
                    signature = this.sm2FormatSignedBytes(signature);
                }
                CertificationRequest certRequest = new CertificationRequest(certRequestInfo, signAlgID, new DERBitString(signature));
                PKCS10CertificationRequest p10 = new PKCS10CertificationRequest(certRequest);
                byte[] base64P10Bytes = Base64.encode(p10.getEncoded());
                if (logger.isDebugEnabled()) {
                    logger.debug("generatePKCS10Request<<<<<<Finished: base64P10Bytes=" + SADKDebugger.dump(base64P10Bytes));
                }
                return base64P10Bytes;
            }
            catch (PKIException e) {
                throw e;
            }
            catch (Exception e) {
                throw new PKIException("generatePKCS10Request Failure: Generated P10 Failure", e);
            }
        }
        catch (PKIException e) {
            if (logger.isErrorEnabled()) {
                logger.error("generatePKCS10Request<<<<<<Failure", (Throwable)e);
            }
            throw e;
        }
        catch (Throwable e) {
            if (logger.isErrorEnabled()) {
                logger.error("generatePKCS10Request<<<<<<Failure: " + e.getMessage(), e);
            }
            throw new PKIException("generatePKCS10Request Failure: " + e.getMessage(), e);
        }
    }

    public byte[] generatePKCS10Request(Mechanism mechanism, X500Name x500NameSubject, ASN1Set attributes, PublicKey publicKey, byte[] signature) throws PKIException {
        if (logger.isDebugEnabled()) {
            StringBuffer buffer = new StringBuffer();
            buffer.append("generatePKCS10Request>>>>>>Running");
            buffer.append("\n mechanism: ");
            buffer.append(SADKDebugger.dump(mechanism));
            buffer.append("\n X500Name: ");
            buffer.append(SADKDebugger.dump(x500NameSubject));
            buffer.append("\n attributes: ");
            buffer.append(SADKDebugger.dump(attributes));
            buffer.append("\n publicKey: ");
            buffer.append(SADKDebugger.dump(publicKey));
            buffer.append("\n signature: ");
            buffer.append(SADKDebugger.dump(signature));
            logger.debug(buffer.toString());
        }
        try {
            SubjectPublicKeyInfo pubInfo = SubjectPublicKeyInfo.getInstance(publicKey.getEncoded());
            CertificationRequestInfo certRequestInfo = new CertificationRequestInfo(x500NameSubject, pubInfo, attributes);
            AlgorithmIdentifier signAlgID = Mechanism.getAlgorithmIdentifier(mechanism.getMechanismType());
            try {
                CertificationRequest certRequest = new CertificationRequest(certRequestInfo, signAlgID, new DERBitString(signature));
                PKCS10CertificationRequest p10 = new PKCS10CertificationRequest(certRequest);
                byte[] base64P10Bytes = Base64.encode(p10.getEncoded());
                if (logger.isDebugEnabled()) {
                    logger.debug("generatePKCS10Request<<<<<<Finished: base64P10Bytes=" + SADKDebugger.dump(base64P10Bytes));
                }
                return base64P10Bytes;
            }
            catch (Exception e) {
                throw new PKIException("generatePKCS10Request Failure: Generated P10 Failure", e);
            }
        }
        catch (PKIException e) {
            if (logger.isErrorEnabled()) {
                logger.error("generatePKCS10Request<<<<<<Failure", (Throwable)e);
            }
            throw e;
        }
        catch (Throwable e) {
            if (logger.isErrorEnabled()) {
                logger.error("generatePKCS10Request<<<<<<Failure: " + e.getMessage(), e);
            }
            throw new PKIException("generatePKCS10Request Failure: " + e.getMessage(), e);
        }
    }

    public byte[] generatePKCS10Request(Mechanism mechanism, CertificationRequestInfo certRequestInfo, byte[] signature) throws PKIException {
        if (logger.isDebugEnabled()) {
            StringBuffer buffer = new StringBuffer();
            buffer.append("generatePKCS10Request>>>>>>Running");
            buffer.append("\n mechanism: ");
            buffer.append(SADKDebugger.dump(mechanism));
            buffer.append("\n certRequestInfo: ");
            buffer.append(SADKDebugger.dump(certRequestInfo));
            buffer.append("\n signature: ");
            buffer.append(SADKDebugger.dump(signature));
            logger.debug(buffer.toString());
        }
        try {
            AlgorithmIdentifier signAlgID = Mechanism.getAlgorithmIdentifier(mechanism.getMechanismType());
            CertificationRequest certRequest = new CertificationRequest(certRequestInfo, signAlgID, new DERBitString(signature));
            PKCS10CertificationRequest p10 = new PKCS10CertificationRequest(certRequest);
            byte[] base64P10Bytes = Base64.encode(p10.getEncoded());
            if (logger.isDebugEnabled()) {
                logger.debug("generatePKCS10Request<<<<<<Finished: base64P10Bytes=" + SADKDebugger.dump(base64P10Bytes));
            }
            return base64P10Bytes;
        }
        catch (Throwable e) {
            if (logger.isErrorEnabled()) {
                logger.error("generatePKCS10Request<<<<<<Failure: " + e.getMessage(), e);
            }
            throw new PKIException("generatePKCS10Request Failure: " + e.getMessage(), e);
        }
    }

    public CertificationRequestInfo generateCertificationRequestInfo(X500Name x500NameSubject, ASN1Set attributes, PublicKey publicKey) {
        if (logger.isDebugEnabled()) {
            StringBuffer buffer = new StringBuffer();
            buffer.append("generateCertificationRequestInfo>>>>>>Running");
            buffer.append("\n X500Name: ");
            buffer.append(SADKDebugger.dump(x500NameSubject));
            buffer.append("\n attributes: ");
            buffer.append(SADKDebugger.dump(attributes));
            buffer.append("\n publicKey: ");
            buffer.append(SADKDebugger.dump(publicKey));
            logger.debug(buffer.toString());
        }
        try {
            SubjectPublicKeyInfo pubInfo = SubjectPublicKeyInfo.getInstance(publicKey.getEncoded());
            CertificationRequestInfo certRequestInfo = new CertificationRequestInfo(x500NameSubject, pubInfo, attributes);
            if (logger.isDebugEnabled()) {
                logger.debug("generatePKCS10Request<<<<<<Finished: certRequestInfo=" + SADKDebugger.dump(certRequestInfo));
            }
            return certRequestInfo;
        }
        catch (Throwable e) {
            if (logger.isErrorEnabled()) {
                logger.error("generatePKCS10Request<<<<<<Failure: " + e.getMessage(), e);
            }
            throw new SecurityException("generatePKCS10Request Failure: " + e.getMessage(), e);
        }
    }

    public String generateCertificationRequest(Mechanism mechanism, X500Name x500NameSubject, ASN1Set attributes, PublicKey publicKey, PrivateKey privateKey) throws PKIException {
        if (logger.isDebugEnabled()) {
            StringBuffer buffer = new StringBuffer();
            buffer.append("generateCertificationRequest>>>>>>Running");
            buffer.append("\n mechanism: ");
            buffer.append(SADKDebugger.dump(mechanism));
            buffer.append("\n X500Name: ");
            buffer.append(SADKDebugger.dump(x500NameSubject));
            buffer.append("\n attributes: ");
            buffer.append(SADKDebugger.dump(attributes));
            buffer.append("\n publicKey: ");
            buffer.append(SADKDebugger.dump(publicKey));
            buffer.append("\n privateKey: ");
            buffer.append(SADKDebugger.dump(privateKey));
            logger.debug(buffer.toString());
        }
        try {
            String base64P10Text = new String(this.generatePKCS10Request(mechanism, x500NameSubject, attributes, publicKey, privateKey), "UTF-8");
            if (logger.isDebugEnabled()) {
                logger.debug("generateCertificationRequest<<<<<<Finished: base64P10Text=" + SADKDebugger.dump(base64P10Text));
            }
            return base64P10Text;
        }
        catch (PKIException e) {
            if (logger.isErrorEnabled()) {
                logger.error("generateCertificationRequest<<<<<<Failure", (Throwable)e);
            }
            throw e;
        }
        catch (Throwable e) {
            if (logger.isErrorEnabled()) {
                logger.error("generateCertificationRequest<<<<<<Failure: " + e.getMessage(), e);
            }
            throw new PKIException("generateCertificationRequest Failure: " + e.getMessage(), e);
        }
    }

    public byte[] parseCertificationRequestInfoToBytes(CertificationRequestInfo certRequestInfo) throws PKIException {
        if (logger.isDebugEnabled()) {
            logger.debug("parseCertificationRequestInfoToBytes>>>>>>Running: CertificationRequestInfo=" + SADKDebugger.dump(certRequestInfo));
        }
        try {
            byte[] P10Bytes = certRequestInfo.getEncoded("DER");
            if (logger.isDebugEnabled()) {
                logger.debug("parseCertificationRequestInfoToBytes<<<<<<Finished: P10Bytes=" + SADKDebugger.dump(P10Bytes));
            }
            return P10Bytes;
        }
        catch (Throwable e) {
            if (logger.isErrorEnabled()) {
                logger.error("parseCertificationRequestInfoToBytes<<<<<<Failure: " + e.getMessage(), e);
            }
            throw new PKIException("parseCertificationRequestInfoToBytes Failure: " + e.getMessage(), e);
        }
    }

    public byte[] getTemporaryPublicKeyDataFromAttributes(ASN1Set attributes) throws PKIException {
        if (logger.isDebugEnabled()) {
            logger.debug("getTemporaryPublicKeyDataFromAttributes>>>>>>Running: attributes=" + SADKDebugger.dump(attributes));
        }
        try {
            byte[] base64TmpPublicKeyBytes = null;
            if (attributes != null && attributes.size() > 1) {
                ASN1Sequence sequence = (ASN1Sequence)attributes.getObjectAt(1);
                ASN1ObjectIdentifier oid = ASN1ObjectIdentifier.getInstance(sequence.getObjectAt(0));
                if (!oid.equals(PKCSObjectIdentifiers.pkcs_9_at_tempPublicKey)) {
                    throw new PKIException(PKIException.PARSE_P10_ERR, PKIException.PARSE_P10_ERR_ATTRI_ID, new Exception("Not support the Attributes[1] Type ID:" + oid.getId()));
                }
                ASN1OctetString asn1oct = ASN1OctetString.getInstance(sequence.getObjectAt(1));
                sequence = ASN1Parser.parseOCT2SEQ(asn1oct);
                byte[] data = ((ASN1OctetString)sequence.getObjectAt(1)).getOctets();
                if (!Mechanisms.isSM2WithSM3(this.mechanism)) {
                    RSAPublicKey rsaPubKey = RSAPublicKey.getInstance(data);
                    try {
                        base64TmpPublicKeyBytes = Base64.encode(rsaPubKey.getEncoded());
                    }
                    catch (IOException e) {
                        throw new PKIException("TemporaryPublicKeyDataFromAttributes Failure", e);
                    }
                } else {
                    base64TmpPublicKeyBytes = Base64.encode(data);
                }
            }
            if (logger.isDebugEnabled()) {
                logger.debug("getTemporaryPublicKeyDataFromAttributes<<<<<<Finished: base64TmpPublicKeyBytes=" + SADKDebugger.dumpBase64(base64TmpPublicKeyBytes));
            }
            return base64TmpPublicKeyBytes;
        }
        catch (PKIException e) {
            if (logger.isErrorEnabled()) {
                logger.error("getTemporaryPublicKeyDataFromAttributes<<<<<<Failure", (Throwable)e);
            }
            throw e;
        }
        catch (Throwable e) {
            if (logger.isErrorEnabled()) {
                logger.error("getTemporaryPublicKeyDataFromAttributes<<<<<<Failure: " + e.getMessage(), e);
            }
            throw new PKIException("getTemporaryPublicKeyDataFromAttributes Failure: " + e.getMessage(), e);
        }
    }

    public String getTemporaryPublicKeyFromAttributes(ASN1Set attributes) throws PKIException {
        if (logger.isDebugEnabled()) {
            logger.debug("getTemporaryPublicKeyFromAttributes>>>>>>Running: attributes=" + SADKDebugger.dump(attributes));
        }
        try {
            String base64TmpPublicKeyText = null;
            byte[] temporaryPublicKeyData = this.getTemporaryPublicKeyDataFromAttributes(attributes);
            if (temporaryPublicKeyData != null) {
                try {
                    base64TmpPublicKeyText = new String(temporaryPublicKeyData, "UTF-8");
                }
                catch (UnsupportedEncodingException e) {
                    throw new PKIException("codeing Exception", e);
                }
            }
            if (logger.isDebugEnabled()) {
                logger.debug("getTemporaryPublicKeyFromAttributes<<<<<<Finished: base64TmpPublicKeyText=" + SADKDebugger.dump(base64TmpPublicKeyText));
            }
            return base64TmpPublicKeyText;
        }
        catch (PKIException e) {
            if (logger.isErrorEnabled()) {
                logger.error("getTemporaryPublicKeyFromAttributes<<<<<<Failure", (Throwable)e);
            }
            throw e;
        }
        catch (Throwable e) {
            if (logger.isErrorEnabled()) {
                logger.error("getTemporaryPublicKeyFromAttributes<<<<<<Failure: " + e.getMessage(), e);
            }
            throw new PKIException("getTemporaryPublicKeyFromAttributes Failure: " + e.getMessage(), e);
        }
    }

    private void prepareTemporaryPublicKey() throws PKIException {
        if (logger.isDebugEnabled()) {
            logger.debug("prepareTemporaryPublicKey::>>>>>>Running: ");
        }
        try {
            ASN1Sequence sequence = (ASN1Sequence)this.attributes.getObjectAt(1);
            ASN1ObjectIdentifier oid = ASN1ObjectIdentifier.getInstance(sequence.getObjectAt(0));
            if (!oid.equals(PKCSObjectIdentifiers.pkcs_9_at_tempPublicKey)) {
                return;
            }
            this.certReqType = 1;
            ASN1OctetString asn1oct = ASN1OctetString.getInstance(sequence.getObjectAt(1));
            sequence = ASN1Parser.parseOCT2SEQ(asn1oct);
            byte[] data = ((ASN1OctetString)sequence.getObjectAt(1)).getOctets();
            if (!Mechanisms.isSM2WithSM3(this.mechanism)) {
                RSAPublicKey rsaPubKey = RSAPublicKey.getInstance(data);
                RSAKeyParameters rsaKeyParams = new RSAKeyParameters(false, rsaPubKey.getModulus(), rsaPubKey.getPublicExponent());
                this.tempPublicKey = new BCRSAPublicKey(rsaKeyParams);
            } else {
                byte[] tempPublicKeyX = new byte[32];
                byte[] tempPublicKeyY = new byte[32];
                System.arraycopy(data, 8, tempPublicKeyX, 0, 32);
                System.arraycopy(data, 72, tempPublicKeyY, 0, 32);
                this.tempPublicKey = new SM2PublicKey(tempPublicKeyX, tempPublicKeyY);
            }
            if (logger.isDebugEnabled()) {
                StringBuffer buffer = new StringBuffer();
                buffer.append("prepareTemporaryPublicKey<<<<<<Finished");
                buffer.append("\n tempPublicKey: ");
                buffer.append(SADKDebugger.dump(this.tempPublicKey));
                buffer.append("\n certReqType: " + this.certReqType);
                logger.debug(buffer.toString());
            }
        }
        catch (PKIException e) {
            if (logger.isErrorEnabled()) {
                logger.error("prepareTemporaryPublicKey<<<<<<Failure", (Throwable)e);
            }
            throw e;
        }
        catch (Throwable e) {
            if (logger.isErrorEnabled()) {
                logger.error("prepareTemporaryPublicKey<<<<<<Failure: " + e.getMessage(), e);
            }
            throw new PKIException("prepareTemporaryPublicKey Failure: " + e.getMessage(), e);
        }
    }

    private PublicKey getInternalEncPublicKey(Mechanism enMechanism, int keyLength, Session session, boolean isSoftKey) throws PKIException {
        PublicKey pubKey = null;
        if (session instanceof CardLib && !isSoftKey) {
            try {
                pubKey = session.exportEncPublicKey();
            }
            catch (Exception e) {
                StringBuffer buffer = new StringBuffer();
                buffer.append("getInternalEncPublicKey>>>>>>Running");
                buffer.append("\n mechanism: ");
                buffer.append(SADKDebugger.dump(enMechanism));
                buffer.append("\n keyLength: " + keyLength);
                buffer.append("\n Session: ");
                buffer.append(SADKDebugger.dump(session));
                buffer.append("\n isSoftKey: " + isSoftKey);
                logger.error(buffer.toString());
                throw new PKIException("getInternalEncPublicKey Failure: " + e.getMessage(), e);
            }
        } else {
            KeyPair keypair = BCSoftLib.INSTANCE().generateKeyPair(enMechanism, keyLength);
            pubKey = keypair.getPublic();
        }
        return pubKey;
    }

    public void setFormatSignedBytes(int formatSignedBytes) {
        this.formatSignedBytes = formatSignedBytes;
        if (logger.isDebugEnabled()) {
            logger.debug("setFormatSignedBytes>>>>>>: formatSignedBytes=" + formatSignedBytes);
        }
    }

    private final byte[] sm2FormatSignedBytes(byte[] signedBytes) throws IOException {
        if (logger.isDebugEnabled()) {
            logger.debug("sm2FormatSignedBytes>>>>>>Running: signedBytes=" + SADKDebugger.dump(signedBytes));
        }
        byte[] returnSignedBytes = null;
        returnSignedBytes = this.formatSignedBytes == 2 ? SM2OutputFormat.sm2FormatSigned64Bytes(signedBytes) : SM2OutputFormat.sm2FormatSignedBytes(signedBytes);
        return returnSignedBytes;
    }

    public int getKeySize() {
        if (logger.isDebugEnabled()) {
            logger.debug("getKeySize>>>>>>Running: ");
        }
        int bitLength = 0;
        if (Mechanisms.isSM2WithSM3(this.mechanism)) {
            bitLength = 256;
        } else {
            BCRSAPublicKey bcPublicKey = (BCRSAPublicKey)this.publicKey;
            BigInteger n = bcPublicKey.getModulus();
            bitLength = n.bitLength();
        }
        if (logger.isDebugEnabled()) {
            logger.debug("getKeySize<<<<<<Finished: bitLength=" + bitLength);
        }
        return bitLength;
    }

    public ASN1Set getAttributes() {
        if (logger.isDebugEnabled()) {
            logger.debug("getAttributes<<<<<<: attributes=" + SADKDebugger.dump(this.attributes));
        }
        return this.attributes;
    }

    public PublicKey getPublicKey() {
        if (logger.isDebugEnabled()) {
            logger.debug("getPublicKey<<<<<<: publicKey=" + SADKDebugger.dump(this.publicKey));
        }
        return this.publicKey;
    }

    public PublicKey getTemporaryPublicKey() {
        if (logger.isDebugEnabled()) {
            logger.debug("getTemporaryPublicKey<<<<<<: tempPublicKey=" + SADKDebugger.dump(this.tempPublicKey));
        }
        return this.tempPublicKey;
    }

    public String getSubject() {
        if (logger.isDebugEnabled()) {
            logger.debug("getSubject<<<<<<: subject=" + SADKDebugger.dump(this.subject));
        }
        return this.subject;
    }

    public KeyPair getKeyPair() {
        if (logger.isDebugEnabled()) {
            logger.debug("getKeyPair<<<<<<: keyPair=" + SADKDebugger.dump(this.keyPair));
        }
        return this.keyPair;
    }

    public KeyPair getTemporaryKeyPair() {
        if (logger.isDebugEnabled()) {
            logger.debug("getTemporaryKeyPair<<<<<<: tempKeyPair=" + SADKDebugger.dump(this.tempKeyPair));
        }
        return this.tempKeyPair;
    }

    public PrivateKey getTemporaryPrivateKey() {
        PrivateKey privateKey = null;
        if (this.tempKeyPair != null) {
            privateKey = this.tempKeyPair.getPrivate();
        }
        if (logger.isDebugEnabled()) {
            logger.debug("getTemporaryPrivateKey<<<<<<: PrivateKey=" + SADKDebugger.dump(privateKey));
        }
        return privateKey;
    }

    public PrivateKey getPrivateKey() {
        PrivateKey privateKey = null;
        if (this.keyPair != null) {
            privateKey = this.keyPair.getPrivate();
        }
        if (logger.isDebugEnabled()) {
            logger.debug("getPrivateKey<<<<<<: PrivateKey=" + SADKDebugger.dump(privateKey));
        }
        return privateKey;
    }

    public String getSignatureAlgorithm() {
        String signatureAlgorithm = null;
        if (this.mechanism != null) {
            signatureAlgorithm = this.mechanism.getMechanismType();
        }
        if (logger.isDebugEnabled()) {
            logger.debug("getSignatureAlgorithm<<<<<<: signatureAlgorithm=" + SADKDebugger.dump(signatureAlgorithm));
        }
        return signatureAlgorithm;
    }

    public byte[] getSignature() {
        if (logger.isDebugEnabled()) {
            logger.debug("getSignature<<<<<<: signature=" + SADKDebugger.dump(this.signature));
        }
        return this.signature;
    }

    public boolean getP10RequestVerifyState() {
        if (logger.isDebugEnabled()) {
            logger.debug("getP10RequestVerifyState<<<<<<: p10RequestVerifyState=" + this.p10RequestVerifyState);
        }
        return this.p10RequestVerifyState;
    }

    public int getCertReqType() {
        if (logger.isDebugEnabled()) {
            logger.debug("getCertReqType<<<<<<: [0:singleP10, 1: doubleP10.]certReqType=" + this.certReqType);
        }
        return this.certReqType;
    }

    private static final String getValidSignatureAlgName(AlgorithmIdentifier signatureAlgorithm) throws PKIException {
        if (logger.isDebugEnabled()) {
            logger.debug("getValidSignatureAlgName>>>>>>Running: signatureAlgorithm=" + SADKDebugger.dump(signatureAlgorithm));
        }
        try {
            if (!Mechanism.isValid(signatureAlgorithm)) {
                throw new PKIException("getValidSignatureAlgName: can not support such sign Alg:" + signatureAlgorithm);
            }
            String signatureAlgName = Mechanism.getSignatureAlgName(signatureAlgorithm);
            if (logger.isDebugEnabled()) {
                logger.debug("getValidSignatureAlgName<<<<<<Finished: signatureAlgName=" + SADKDebugger.dump(signatureAlgName));
            }
            return signatureAlgName;
        }
        catch (PKIException e) {
            if (logger.isErrorEnabled()) {
                logger.error("getValidSignatureAlgName<<<<<<Failure", (Throwable)e);
            }
            throw e;
        }
        catch (Throwable e) {
            if (logger.isErrorEnabled()) {
                logger.error("getValidSignatureAlgName<<<<<<Failure: " + e.getMessage(), e);
            }
            throw new PKIException("getValidSignatureAlgName Failure: " + e.getMessage(), e);
        }
    }

    public PublicKey getPubKeyFromSubPubKeyInfo(SubjectPublicKeyInfo spki) throws PKIException {
        return PKCS10.getPubKeyFromSubPubKeyInfo(spki, this.session);
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final PublicKey getPubKeyFromSubPubKeyInfo(SubjectPublicKeyInfo spki, Session session) throws PKIException {
        if (logger.isDebugEnabled()) {
            logger.debug("getPubKeyFromSubPubKeyInfo::>>>>>>SubjectPublicKeyInfo=" + SADKDebugger.dump(spki));
        }
        try {
            void var2_8;
            Object var2_2 = null;
            if (spki == null) {
                Object var2_3 = null;
            } else if (Mechanisms.isSM2PublicKey(spki.getAlgorithm())) {
                byte[] pubData = spki.getPublicKeyData().getBytes();
                int len = pubData.length;
                if (len != 65) throw new PKIException(PKIException.SPKI_KEY, PKIException.SPKI_KEY_DES);
                byte[] pubX = new byte[32];
                byte[] pubY = new byte[32];
                System.arraycopy(pubData, 1, pubX, 0, 32);
                System.arraycopy(pubData, 33, pubY, 0, 32);
                SM2PublicKey sM2PublicKey = KeyUtil.getSM2PublicKey(pubX, pubY);
                if (session != null && session instanceof HardLib) {
                    PublicKey publicKey = ((HardLib)session).SM2HardPublicKey(new Mechanism("SM2"), sM2PublicKey);
                }
            } else {
                if (!spki.getAlgorithm().getAlgorithm().toString().equals(PKCSObjectIdentifiers.rsaEncryption.toString())) throw new PKIException("getPubKeyFromSubPubKeyInfo Failure: can not support this key type:" + spki.getAlgorithm().getAlgorithm());
                RSAKeyParameters param = (RSAKeyParameters)PublicKeyFactory.createKey(spki);
                BCRSAPublicKey bCRSAPublicKey = new BCRSAPublicKey(param);
            }
            if (!logger.isDebugEnabled()) return var2_8;
            logger.debug("getPubKeyFromSubPubKeyInfo::<<<<<<Finished: publicKey=" + SADKDebugger.dump((PublicKey)var2_8));
            return var2_8;
        }
        catch (PKIException pKIException) {
            if (!logger.isErrorEnabled()) throw pKIException;
            logger.error("getPubKeyFromSubPubKeyInfo::<<<<<<Failure", (Throwable)pKIException);
            throw pKIException;
        }
        catch (Throwable throwable) {
            if (!logger.isErrorEnabled()) throw new PKIException("getPubKeyFromSubPubKeyInfo Failure: " + throwable.getMessage(), throwable);
            logger.error("getPubKeyFromSubPubKeyInfo::<<<<<<Failure: " + throwable.getMessage(), throwable);
            throw new PKIException("getPubKeyFromSubPubKeyInfo Failure: " + throwable.getMessage(), throwable);
        }
    }

    public static final boolean isP10RequestSignatureValid(byte[] base64P10Request) throws PKIException {
        if (logger.isDebugEnabled()) {
            logger.debug("isP10RequestSignatureValid>>>>>>Running: base64P10Request=" + SADKDebugger.dump(base64P10Request));
        }
        try {
            PKCS10CertificationRequest p10 = PKCS10.decodedP10(base64P10Request);
            byte[] sign = p10.getSignature();
            byte[] src = p10.toASN1Structure().getCertificationRequestInfo().getEncoded("DER");
            String sigAlgName = PKCS10.getValidSignatureAlgName(p10.getSignatureAlgorithm());
            Session session = BCSoftLib.INSTANCE();
            boolean isValid = new Signature().p1VerifyMessage(sigAlgName, src, sign, PKCS10.getPubKeyFromSubPubKeyInfo(p10.getSubjectPublicKeyInfo(), session), session);
            if (logger.isDebugEnabled()) {
                logger.debug("isP10RequestSignatureValid<<<<<<Finished: isValid=" + isValid);
            }
            return isValid;
        }
        catch (PKIException e) {
            if (logger.isErrorEnabled()) {
                logger.error("isP10RequestSignatureValid<<<<<<Failure", (Throwable)e);
            }
            throw e;
        }
        catch (Throwable e) {
            if (logger.isErrorEnabled()) {
                logger.error("isP10RequestSignatureValid<<<<<<Failure: " + e.getMessage(), e);
            }
            throw new PKIException("isP10RequestSignatureValid Failure: " + e.getMessage(), e);
        }
    }

    public static final PKCS10CertificationRequest decodedP10(byte[] base64P10Request) throws PKIException {
        if (logger.isDebugEnabled()) {
            logger.debug("decodedP10>>>>>>Running: base64P10Request=" + SADKDebugger.dump(base64P10Request));
        }
        try {
            byte[] p10Bytes;
            try {
                p10Bytes = Base64.decode(base64P10Request);
            }
            catch (Exception e) {
                throw new PKIException("decodedP10 Failure with invalid base64P10Request: " + e.getMessage(), e);
            }
            PKCS10CertificationRequest request = new PKCS10CertificationRequest(p10Bytes);
            if (logger.isDebugEnabled()) {
                logger.debug("decodedP10<<<<<<Finished: PKCS10CertificationRequest=" + request);
            }
            return request;
        }
        catch (PKIException e) {
            if (logger.isErrorEnabled()) {
                logger.error("decodedP10<<<<<<Failure", (Throwable)e);
            }
            throw e;
        }
        catch (Throwable e) {
            if (logger.isErrorEnabled()) {
                logger.error("decodedP10<<<<<<Failure: " + e.getMessage(), e);
            }
            throw new PKIException("decodedP10 Failure: " + e.getMessage(), e);
        }
    }

    public static final String getSubjectFromP10Request(byte[] base64P10Request) throws PKIException {
        if (logger.isDebugEnabled()) {
            logger.debug("getSubjectFromP10Request>>>>>>Running: base64P10Request=" + SADKDebugger.dump(base64P10Request));
        }
        try {
            PKCS10CertificationRequest p10 = PKCS10.decodedP10(base64P10Request);
            String subject = p10.getSubject().toString();
            if (logger.isDebugEnabled()) {
                logger.debug("getSubjectFromP10Request<<<<<<Finished: subject=" + subject);
            }
            return subject;
        }
        catch (PKIException e) {
            if (logger.isErrorEnabled()) {
                logger.error("getSubjectFromP10Request<<<<<<Failure", (Throwable)e);
            }
            throw e;
        }
        catch (Throwable e) {
            if (logger.isErrorEnabled()) {
                logger.error("getSubjectFromP10Request<<<<<<Failure: " + e.getMessage(), e);
            }
            throw new PKIException("getSubjectFromP10Request Failure: " + e.getMessage(), e);
        }
    }

    public static final String getSignatureAlgorithmFromP10Request(byte[] base64P10Request) throws PKIException {
        if (logger.isDebugEnabled()) {
            logger.debug("getSignatureAlgorithmFromP10Request>>>>>>Running: base64P10Request=" + SADKDebugger.dump(base64P10Request));
        }
        try {
            PKCS10CertificationRequest p10 = PKCS10.decodedP10(base64P10Request);
            String signatureAlgorithm = PKCS10.getValidSignatureAlgName(p10.getSignatureAlgorithm());
            if (logger.isDebugEnabled()) {
                logger.debug("getSignatureAlgorithmFromP10Request<<<<<<Finished: signatureAlgorithm=" + signatureAlgorithm);
            }
            return signatureAlgorithm;
        }
        catch (PKIException e) {
            if (logger.isErrorEnabled()) {
                logger.error("getSignatureAlgorithmFromP10Request<<<<<<Failure", (Throwable)e);
            }
            throw e;
        }
        catch (Throwable e) {
            if (logger.isErrorEnabled()) {
                logger.error("getSignatureAlgorithmFromP10Request<<<<<<Failure: " + e.getMessage(), e);
            }
            throw new PKIException("getSignatureAlgorithmFromP10Request Failure: " + e.getMessage(), e);
        }
    }

    public static final byte[] getSignatureFromP10Request(byte[] base64P10Request) throws PKIException {
        if (logger.isDebugEnabled()) {
            logger.debug("getSignatureFromP10Request>>>>>>Running: base64P10Request=" + SADKDebugger.dump(base64P10Request));
        }
        try {
            PKCS10CertificationRequest p10 = PKCS10.decodedP10(base64P10Request);
            byte[] siganture = p10.getSignature();
            if (logger.isDebugEnabled()) {
                logger.debug("getSignatureFromP10Request<<<<<<Finished: siganture=" + SADKDebugger.dump(siganture));
            }
            return siganture;
        }
        catch (PKIException e) {
            if (logger.isErrorEnabled()) {
                logger.error("getSignatureFromP10Request<<<<<<Failure", (Throwable)e);
            }
            throw e;
        }
        catch (Throwable e) {
            if (logger.isErrorEnabled()) {
                logger.error("getSignatureFromP10Request<<<<<<Failure: " + e.getMessage(), e);
            }
            throw new PKIException("getSignatureFromP10Request Failure: " + e.getMessage(), e);
        }
    }
}

