/*
 * Decompiled with CFR 0.152.
 */
package cfca.sadk.algorithm.common;

import cfca.sadk.algorithm.common.Mechanism;
import cfca.sadk.algorithm.common.PKCSObjectIdentifiers;
import cfca.sadk.algorithm.common.PKIException;
import cfca.sadk.algorithm.sm2.SM2PublicKey;
import cfca.sadk.algorithm.util.BigIntegerUtil;
import cfca.sadk.asn1.parser.ASN1Node;
import cfca.sadk.asn1.parser.PKCS7SignFileParser;
import cfca.sadk.lib.crypto.Session;
import cfca.sadk.lib.crypto.jni.JNISoftLib;
import cfca.sadk.org.bouncycastle.asn1.ASN1ObjectIdentifier;
import cfca.sadk.org.bouncycastle.asn1.ASN1Set;
import cfca.sadk.org.bouncycastle.asn1.DERTaggedObject;
import cfca.sadk.org.bouncycastle.asn1.pkcs.IssuerAndSerialNumber;
import cfca.sadk.org.bouncycastle.asn1.pkcs.SignerInfo;
import cfca.sadk.org.bouncycastle.asn1.x500.X500Name;
import cfca.sadk.org.bouncycastle.asn1.x509.Certificate;
import cfca.sadk.signature.PKCS7PackageFacade;
import cfca.sadk.signature.rsa.RSASignUtil;
import cfca.sadk.signature.sm2.SM2HashUtil;
import cfca.sadk.signature.sm2.SM2PackageUtil;
import cfca.sadk.signature.sm2.SM2SignerInfo;
import cfca.sadk.system.Mechanisms;
import cfca.sadk.x509.certificate.X509Cert;
import java.io.File;
import java.math.BigInteger;
import java.security.PublicKey;
import java.util.Enumeration;

public class PKCS7SignedFile {
    private String digestAlgorithm;
    private byte[] signature;
    private byte[] sourceData;
    private X509Cert signerCert;
    private Session session = null;

    public PKCS7SignedFile(Session session) {
        this.session = session;
    }

    public String getDigestAlgorithm() {
        return this.digestAlgorithm;
    }

    public byte[] getSignature() {
        return this.signature;
    }

    public byte[] getSourceData() {
        return this.sourceData;
    }

    public X509Cert getSignerX509Cert() {
        return this.signerCert;
    }

    private X509Cert getSignerCert(X509Cert[] certs, IssuerAndSerialNumber issuerAndSN) throws PKIException {
        String issuer = issuerAndSN.getName().toString();
        BigInteger sn = issuerAndSN.getCertificateSerialNumber().getValue();
        for (int i = 0; i < certs.length; ++i) {
            X500Name tmpIssuer = certs[i].getIssuerX500Name();
            BigInteger tmpSN = certs[i].getSerialNumber();
            if (!tmpIssuer.toString().equals(issuer) || tmpSN.compareTo(sn) != 0) continue;
            return certs[i];
        }
        return null;
    }

    public boolean verifyP7SignedFile(String signFile, String saveSrcFilePath) throws Exception {
        PKCS7SignFileParser parser = new PKCS7SignFileParser(new File(signFile));
        parser.parser();
        ASN1Node certificate_node = parser.getCertificate_node();
        ASN1Set certSet = ASN1Set.getInstance(DERTaggedObject.getInstance(certificate_node.getData()), false);
        X509Cert cert = new X509Cert(Certificate.getInstance(certSet.getObjectAt(0)));
        if (cert.isSM2Cert()) {
            return this.verifySM2P7SignedFile(signFile, saveSrcFilePath, true, null, parser);
        }
        return this.verifyRSAP7SignedFile(signFile, saveSrcFilePath, parser);
    }

    private boolean verifySM2P7SignedFile(String signFile, String saveSrcFilePath, boolean ifZValue, byte[] userId, PKCS7SignFileParser parser) throws Exception {
        try {
            ASN1Node sourceData_node = (ASN1Node)((ASN1Node)parser.getSourceData_node().childNodes.get((int)1)).childNodes.get(0);
            if (sourceData_node.childNodes.size() == 1) {
                sourceData_node = (ASN1Node)sourceData_node.childNodes.get(0);
            }
            ASN1Node certificate_node = parser.getCertificate_node();
            ASN1Node singerinfo_node = parser.getSingerinfo_node();
            ASN1Set signerInfos = ASN1Set.getInstance(singerinfo_node.getData());
            ASN1Set certSet = ASN1Set.getInstance(DERTaggedObject.getInstance(certificate_node.getData()), false);
            X509Cert[] certs = new X509Cert[certSet.size()];
            for (int i = 0; i < certSet.size(); ++i) {
                Certificate certStru = Certificate.getInstance(certSet.getObjectAt(i));
                certs[i] = new X509Cert(certStru);
            }
            Enumeration signerEnumer = signerInfos.getObjects();
            if (signerEnumer.hasMoreElements()) {
                X509Cert signerCert;
                SM2SignerInfo signerInfo = SM2SignerInfo.getInstance(signerEnumer.nextElement());
                IssuerAndSerialNumber issuerAndSN = signerInfo.getIssuerAndSerialNumber();
                this.signerCert = signerCert = this.getSignerCert(certs, issuerAndSN);
                if (signerCert == null) {
                    throw new PKIException(PKIException.VERIFY_P7_SIGNEDDATA_CERT_NOTFUND_ERR, PKIException.VERIFY_P7_SIGNEDDATA_CERT_NOTFUND_ERR_DES);
                }
                PublicKey pubKey = signerCert.getPublicKey();
                byte[] r = BigIntegerUtil.asUnsigned32ByteArray(signerInfo.getEncryptedDigestR().getPositiveValue());
                byte[] s = BigIntegerUtil.asUnsigned32ByteArray(signerInfo.getEncryptedDigestS().getPositiveValue());
                byte[] signature = new byte[64];
                System.arraycopy(r, 0, signature, 0, 32);
                System.arraycopy(s, 0, signature, 32, 32);
                this.digestAlgorithm = "SM3";
                this.signature = signature;
                this.sourceData = "source file is too big, will not display,please see the sourceFilePath attribute".getBytes("UTF8");
                byte[] hash = null;
                long valueStartPos = sourceData_node.valueStartPos;
                long valueLength = sourceData_node.valueLength;
                hash = ifZValue ? SM2HashUtil.hashFile(true, userId, sourceData_node.f.getAbsolutePath(), valueStartPos, valueLength, pubKey, saveSrcFilePath, this.session) : SM2HashUtil.hashFile(false, null, sourceData_node.f.getAbsolutePath(), valueStartPos, valueLength, null, saveSrcFilePath, this.session);
                if (this.session instanceof JNISoftLib) {
                    SM2PublicKey sm2PubKey = (SM2PublicKey)pubKey;
                    byte[] pubX = sm2PubKey.getPubXByBytes();
                    byte[] pubY = sm2PubKey.getPubYByBytes();
                    return SM2PackageUtil.verifyByJNI(hash, signature, pubX, pubY);
                }
                return SM2PackageUtil.verifyByBC(hash, signature, pubKey);
            }
            return false;
        }
        catch (Exception ex) {
            throw new PKIException(PKIException.PARSE_P7_SIGNEDDATA_ERR, PKIException.VERIFY_P7_SIGNEDDATA_ERR_DES, ex);
        }
    }

    private boolean verifyRSAP7SignedFile(String signFile, String saveSrcFilePath, PKCS7SignFileParser parser) throws Exception {
        try {
            ASN1Node sourceData_node = (ASN1Node)((ASN1Node)parser.getSourceData_node().childNodes.get((int)1)).childNodes.get(0);
            if (sourceData_node.childNodes.size() == 1) {
                sourceData_node = (ASN1Node)sourceData_node.childNodes.get(0);
            }
            ASN1Node certificate_node = parser.getCertificate_node();
            ASN1Node singerinfo_node = parser.getSingerinfo_node();
            ASN1Set signerInfos = ASN1Set.getInstance(singerinfo_node.getData());
            ASN1Set certSet = ASN1Set.getInstance(DERTaggedObject.getInstance(certificate_node.getData()), false);
            X509Cert[] certs = new X509Cert[certSet.size()];
            for (int i = 0; i < certSet.size(); ++i) {
                Certificate certStru = Certificate.getInstance(certSet.getObjectAt(i));
                certs[i] = new X509Cert(certStru);
            }
            Enumeration signerEnumer = signerInfos.getObjects();
            if (signerEnumer.hasMoreElements()) {
                SignerInfo signerInfo = SignerInfo.getInstance(signerEnumer.nextElement());
                IssuerAndSerialNumber issuerAndSN = signerInfo.getIssuerAndSerialNumber();
                X509Cert signerCert = this.getSignerCert(certs, issuerAndSN);
                if (signerCert == null) {
                    throw new PKIException(PKIException.VERIFY_P7_SIGNEDDATA_CERT_NOTFUND_ERR, PKIException.VERIFY_P7_SIGNEDDATA_CERT_NOTFUND_ERR_DES);
                }
                this.signerCert = signerCert;
                ASN1ObjectIdentifier encryptionId = signerInfo.getDigestEncryptionAlgorithm().getAlgorithm();
                if (!(encryptionId.equals(PKCSObjectIdentifiers.rsaEncryption) || encryptionId.equals(PKCSObjectIdentifiers.md5WithRSAEncryption) || encryptionId.equals(PKCSObjectIdentifiers.sha1WithRSAEncryption) || encryptionId.equals(PKCSObjectIdentifiers.sha256WithRSAEncryption) || encryptionId.equals(PKCSObjectIdentifiers.sha512WithRSAEncryption))) {
                    throw new PKIException(PKIException.UNSUPPORT_ENCRYPT_ALG_SIGNANDENVELOP_ERR, PKIException.UNSUPPORT_SIGNED_ALG_SIGNANDENVELOP_ERR_DES);
                }
                ASN1ObjectIdentifier digestId = signerInfo.getDigestAlgorithm().getAlgorithm();
                String signM = Mechanisms.getDigestAlgorithmName(digestId);
                if (signM == null) {
                    throw new PKIException(PKIException.UNSUPPORT_ENCRYPT_ALG_SIGNANDENVELOP_ERR, PKIException.UNSUPPORT_SIGNED_ALG_SIGNANDENVELOP_ERR_DES);
                }
                this.digestAlgorithm = signM;
                PublicKey pubKey = signerCert.getPublicKey();
                byte[] signature = signerInfo.getEncryptedDigest().getOctets();
                this.signature = signature;
                this.sourceData = "source file is too big, will not display".getBytes("UTF8");
                ASN1Set authAttributes = signerInfo.getAuthenticatedAttributes();
                return RSASignUtil.verifySignFile(new Mechanism(signM), pubKey, sourceData_node.f.getAbsolutePath(), sourceData_node.valueStartPos, sourceData_node.valueLength, signature, saveSrcFilePath, authAttributes, this.session);
            }
            return false;
        }
        catch (Exception ex) {
            throw new PKIException(PKIException.PARSE_P7_SIGNEDDATA_ERR, PKIException.VERIFY_P7_SIGNEDDATA_ERR_DES, ex);
        }
    }

    public void packageSignedFile(String sourceFilePath, String signFile, byte[] signture, Mechanism mechanism, X509Cert[] receiverCerts) throws PKIException {
        PKCS7PackageFacade.packageSignedFile(sourceFilePath, signFile, signture, mechanism, receiverCerts);
    }
}

