/*
 * Decompiled with CFR 0.152.
 */
package cn.unitid.cip.sdk.utils;

import cn.unitid.easypki.crypto.CipherException;
import cn.unitid.easypki.crypto.SM4SymmetricCipher;
import java.nio.charset.Charset;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.Base64;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;

public class SM4Utils {
    private static final String KEY_ALGORITHM = "AES";
    public static final String ECB = "ECB";
    static Charset charset = Charset.forName("UTF-8");

    public static String encrypt(String data, SecretKey secretKey) throws NoSuchAlgorithmException, InvalidKeyException, CipherException {
        byte[] result = SM4Utils.sm4(data.getBytes(), 1, secretKey);
        return Base64.getEncoder().encodeToString(result);
    }

    public static String decrypt(String data, SecretKey secretKey) throws InvalidKeyException, CipherException, NoSuchAlgorithmException {
        byte[] result = SM4Utils.sm4(Base64.getDecoder().decode(data), 2, secretKey);
        return new String(result, charset);
    }

    public static SecretKey generateKey(String password) throws NoSuchAlgorithmException {
        KeyGenerator secretGenerator = KeyGenerator.getInstance(KEY_ALGORITHM);
        secretGenerator.init(128, new SecureRandom(password.getBytes()));
        SecretKey secretKey = secretGenerator.generateKey();
        return secretKey;
    }

    private static byte[] sm4(byte[] contentArray, int mode, SecretKey secretKey) throws NoSuchAlgorithmException, InvalidKeyException, CipherException {
        SM4SymmetricCipher cipher = new SM4SymmetricCipher(ECB);
        cipher.init(mode, secretKey.getEncoded());
        cipher.update(contentArray);
        byte[] bytes = cipher.doFinal();
        return bytes;
    }
}

