/*
 * Decompiled with CFR 0.152.
 */
package cn.unitid.cip.sdk.request.sop.cip;

import cn.unitid.cip.sdk.ApiRuleException;
import cn.unitid.cip.sdk.BaseApiRequest;
import cn.unitid.cip.sdk.internal.util.ApiHashMap;
import cn.unitid.cip.sdk.internal.util.RequestCheckUtils;
import cn.unitid.cip.sdk.response.sop.cip.P10GenResponse;
import java.util.Map;

public class P10GenRequest
extends BaseApiRequest<P10GenResponse> {
    private String subject;
    private String algorithm;
    private Integer cipIndex;

    @Override
    public String getApiMethodName() {
        return "p10.gen";
    }

    @Override
    public String getApiModel() {
        return "cip";
    }

    @Override
    public Map<String, String> getTextParams() {
        ApiHashMap txtParams = new ApiHashMap();
        txtParams.put("subject", this.subject);
        txtParams.put("algorithm", "SM2");
        txtParams.put("cipIndex", (Object)this.cipIndex);
        return txtParams;
    }

    @Override
    public Class<P10GenResponse> getResponseClass() {
        return P10GenResponse.class;
    }

    @Override
    public void check() throws ApiRuleException {
        RequestCheckUtils.checkNotEmpty(this.cipIndex, "cipIndex");
        RequestCheckUtils.checkNotEmpty(this.subject, "subject");
    }

    @Override
    public String getExecuteMethod() {
        return "POST";
    }

    public String getSubject() {
        return this.subject;
    }

    public void setSubject(String subject) {
        this.subject = subject;
    }

    public String getAlgorithm() {
        return this.algorithm;
    }

    public void setAlgorithm(String algorithm) {
        this.algorithm = algorithm;
    }

    public Integer getCipIndex() {
        return this.cipIndex;
    }

    public void setCipIndex(Integer cipIndex) {
        this.cipIndex = cipIndex;
    }
}

