/*
 * Decompiled with CFR 0.152.
 */
package cn.unitid.cip.sdk.request.sop.cip;

import cn.unitid.cip.sdk.ApiRuleException;
import cn.unitid.cip.sdk.BaseApiRequest;
import cn.unitid.cip.sdk.internal.util.ApiHashMap;
import cn.unitid.cip.sdk.internal.util.RequestCheckUtils;
import cn.unitid.cip.sdk.request.sop.cip.KeyUsageType;
import cn.unitid.cip.sdk.response.sop.cip.KeyPairImportResponse;
import java.util.Map;
import org.apache.commons.codec.binary.Hex;

public class KeyPairImportRequest
extends BaseApiRequest<KeyPairImportResponse> {
    private Integer cipIndex;
    private KeyUsageType keyUsageType;
    private byte[] privateKey;
    private byte[] pubX;
    private byte[] pubY;

    @Override
    public String getApiMethodName() {
        return "key.pair.import";
    }

    @Override
    public String getApiModel() {
        return "cip";
    }

    @Override
    public Map<String, String> getTextParams() {
        ApiHashMap txtParams = new ApiHashMap();
        txtParams.put("cipIndex", this.cipIndex == null ? null : String.valueOf(this.cipIndex));
        txtParams.put("keyUsageType", this.keyUsageType == null ? null : String.valueOf((Object)this.keyUsageType));
        txtParams.put("privateKey", Hex.encodeHexString((byte[])this.privateKey));
        txtParams.put("pubX", Hex.encodeHexString((byte[])this.pubX));
        txtParams.put("pubY", Hex.encodeHexString((byte[])this.pubY));
        return txtParams;
    }

    @Override
    public Class<KeyPairImportResponse> getResponseClass() {
        return KeyPairImportResponse.class;
    }

    @Override
    public void check() throws ApiRuleException {
        RequestCheckUtils.checkNotEmpty(this.cipIndex, "cipIndex");
        RequestCheckUtils.checkNotEmpty((Object)this.keyUsageType, "keyUsageType");
        RequestCheckUtils.checkNotEmpty(Hex.encodeHexString((byte[])this.privateKey), "privateKey");
        RequestCheckUtils.checkNotEmpty(Hex.encodeHexString((byte[])this.pubX), "pubX");
        RequestCheckUtils.checkNotEmpty(Hex.encodeHexString((byte[])this.pubY), "pubY");
        if (this.privateKey.length != 32) {
            throw new ApiRuleException(10006, "client-error:'privateKey' length must be 32");
        }
        if (this.pubX.length != 32) {
            throw new ApiRuleException(10006, "client-error:'pubX' length must be 32");
        }
        if (this.pubY.length != 32) {
            throw new ApiRuleException(10006, "client-error:'pubY' length must be 32");
        }
    }

    @Override
    public String getExecuteMethod() {
        return "POST";
    }

    public Integer getCipIndex() {
        return this.cipIndex;
    }

    public void setCipIndex(Integer cipIndex) {
        this.cipIndex = cipIndex;
    }

    public KeyUsageType getKeyUsageType() {
        return this.keyUsageType;
    }

    public void setKeyUsageType(KeyUsageType keyUsageType) {
        this.keyUsageType = keyUsageType;
    }

    public byte[] getPrivateKey() {
        return this.privateKey;
    }

    public void setPrivateKey(byte[] privateKey) {
        this.privateKey = privateKey;
    }

    public byte[] getPubX() {
        return this.pubX;
    }

    public void setPubX(byte[] pubX) {
        this.pubX = pubX;
    }

    public byte[] getPubY() {
        return this.pubY;
    }

    public void setPubY(byte[] pubY) {
        this.pubY = pubY;
    }
}

