/*
 * Decompiled with CFR 0.152.
 */
package cn.unitid.cip.sdk.request.sop.cip;

import cn.unitid.cip.sdk.ApiRuleException;
import cn.unitid.cip.sdk.BaseApiRequest;
import cn.unitid.cip.sdk.internal.util.ApiHashMap;
import cn.unitid.cip.sdk.internal.util.RequestCheckUtils;
import cn.unitid.cip.sdk.response.sop.cip.ApiByteCipVerifySm2Response;
import java.util.Map;
import org.apache.commons.codec.binary.Hex;

public class ApiByteCipVerifySm2Request
extends BaseApiRequest<ApiByteCipVerifySm2Response> {
    private Integer cipIndex;
    private byte[] signData;
    private byte[] signedData;

    @Override
    public String getApiMethodName() {
        return "verify.sm2";
    }

    @Override
    public String getApiModel() {
        return "cip";
    }

    @Override
    public Map<String, String> getTextParams() {
        ApiHashMap txtParams = new ApiHashMap();
        txtParams.put("cipIndex", (Object)this.cipIndex);
        txtParams.put("signData", Hex.encodeHexString((byte[])this.signData));
        txtParams.put("signedData", Hex.encodeHexString((byte[])this.signedData));
        return txtParams;
    }

    @Override
    public Class<ApiByteCipVerifySm2Response> getResponseClass() {
        return ApiByteCipVerifySm2Response.class;
    }

    @Override
    public void check() throws ApiRuleException {
        RequestCheckUtils.checkNotEmpty(this.cipIndex, "cipIndex");
        RequestCheckUtils.checkNotEmpty(Hex.encodeHexString((byte[])this.signData), "signData");
        RequestCheckUtils.checkNotEmpty(Hex.encodeHexString((byte[])this.signedData), "signedData");
        if (this.signData.length != 32) {
            throw new ApiRuleException(10006, "client-error:'signData' length must be 32");
        }
    }

    @Override
    public String getExecuteMethod() {
        return "POST";
    }

    public Integer getCipIndex() {
        return this.cipIndex;
    }

    public void setCipIndex(Integer cipIndex) {
        this.cipIndex = cipIndex;
    }

    public byte[] getSignData() {
        return this.signData;
    }

    public void setSignData(byte[] signData) {
        this.signData = signData;
    }

    public byte[] getSignedData() {
        return this.signedData;
    }

    public void setSignedData(byte[] signedData) {
        this.signedData = signedData;
    }
}

