/*
 * Decompiled with CFR 0.152.
 */
package cn.unitid.cip.sdk.internal.util;

import cn.unitid.cip.sdk.internal.util.StringUtils;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.Proxy;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.zip.GZIPInputStream;
import javax.net.ssl.X509TrustManager;
import okhttp3.Call;
import okhttp3.FormBody;
import okhttp3.Headers;
import okhttp3.MediaType;
import okhttp3.MultipartBody;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;

public abstract class WebUtils {
    private static final String DEFAULT_CHARSET = "UTF-8";
    private static boolean ignoreSSLCheck = true;
    private static boolean ignoreHostCheck = true;

    private WebUtils() {
    }

    public static void setIgnoreSSLCheck(boolean ignoreSSLCheck) {
        WebUtils.ignoreSSLCheck = ignoreSSLCheck;
    }

    public static void setIgnoreHostCheck(boolean ignoreHostCheck) {
        WebUtils.ignoreHostCheck = ignoreHostCheck;
    }

    public static String doPost(OkHttpClient client, String url, Map<String, String> bodyParams, Map<String, String> headerMap, File file, Proxy proxy) throws IOException {
        Headers.Builder headersBuilder = new Headers.Builder();
        ((Map)Optional.ofNullable(headerMap).orElse(new HashMap())).entrySet().stream().forEach(entry -> headersBuilder.add((String)entry.getKey(), (String)entry.getValue()));
        Headers headers = headersBuilder.build();
        FormBody body = null;
        if (null == file) {
            FormBody.Builder formBodyBuilder = new FormBody.Builder();
            ((Map)Optional.ofNullable(bodyParams).orElse(new HashMap())).entrySet().stream().forEach(entry -> formBodyBuilder.add((String)entry.getKey(), (String)entry.getValue()));
            body = formBodyBuilder.build();
        } else {
            MultipartBody.Builder multipartBodyBuilder = new MultipartBody.Builder();
            multipartBodyBuilder.setType(MultipartBody.FORM);
            ((Map)Optional.ofNullable(bodyParams).orElse(new HashMap())).entrySet().stream().forEach(entry -> multipartBodyBuilder.addFormDataPart((String)entry.getKey(), (String)entry.getValue()));
            if (null != file) {
                multipartBodyBuilder.addFormDataPart("file", file.getName(), RequestBody.create((MediaType)MediaType.parse((String)"application/octet-stream"), (File)file));
            }
        }
        Request request = new Request.Builder().url(url).headers(headers).post((RequestBody)body).build();
        Call call = client.newCall(request);
        try (Response response = call.execute();){
            String string = response.body().string();
            return string;
        }
    }

    public static String doGet(OkHttpClient client, String url, Map<String, String> params, String charset, Map<String, String> headerMap) throws IOException {
        String query = WebUtils.buildQuery(params, charset);
        String getUrl = WebUtils.buildRequestUrl(url, query);
        Headers.Builder headersBuilder = new Headers.Builder();
        ((Map)Optional.ofNullable(headerMap).orElse(new HashMap())).entrySet().stream().forEach(entry -> headersBuilder.add((String)entry.getKey(), (String)entry.getValue()));
        Headers headers = headersBuilder.build();
        Request request = new Request.Builder().url(getUrl).headers(headers).get().build();
        Call call = client.newCall(request);
        try (Response response = call.execute();){
            String string = response.body().string();
            return string;
        }
    }

    public static String buildRequestUrl(String url, String ... queries) {
        if (queries == null || queries.length == 0) {
            return url;
        }
        StringBuilder newUrl = new StringBuilder(url);
        boolean hasQuery = url.contains("?");
        boolean hasPrepend = url.endsWith("?") || url.endsWith("&");
        for (String query : queries) {
            if (StringUtils.isEmpty(query)) continue;
            if (!hasPrepend) {
                if (hasQuery) {
                    newUrl.append("&");
                } else {
                    newUrl.append("?");
                    hasQuery = true;
                }
            }
            newUrl.append(query);
            hasPrepend = false;
        }
        return newUrl.toString();
    }

    public static String buildQuery(Map<String, String> params, String charset) throws IOException {
        if (params == null || params.isEmpty()) {
            return null;
        }
        StringBuilder query = new StringBuilder();
        Set<Map.Entry<String, String>> entries = params.entrySet();
        boolean hasParam = false;
        for (Map.Entry<String, String> entry : entries) {
            String value;
            String name = entry.getKey();
            if (!StringUtils.areNotEmpty(name, value = entry.getValue())) continue;
            if (hasParam) {
                query.append("&");
            } else {
                hasParam = true;
            }
            query.append(name).append("=").append(URLEncoder.encode(value, charset));
        }
        return query.toString();
    }

    protected static String getResponseAsString(HttpURLConnection conn) throws IOException {
        InputStream error;
        String charset = WebUtils.getResponseCharset(conn.getContentType());
        if (conn.getResponseCode() < 400) {
            String contentEncoding = conn.getContentEncoding();
            if ("gzip".equalsIgnoreCase(contentEncoding)) {
                return WebUtils.getStreamAsString(new GZIPInputStream(conn.getInputStream()), charset);
            }
            return WebUtils.getStreamAsString(conn.getInputStream(), charset);
        }
        if (conn.getResponseCode() == 400 && (error = conn.getErrorStream()) != null) {
            return WebUtils.getStreamAsString(error, charset);
        }
        throw new IOException(conn.getResponseCode() + " " + conn.getResponseMessage());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getStreamAsString(InputStream stream, String charset) throws IOException {
        try {
            InputStreamReader reader = new InputStreamReader(stream, charset);
            StringBuilder response = new StringBuilder();
            char[] buff = new char[1024];
            int read = 0;
            while ((read = reader.read(buff)) > 0) {
                response.append(buff, 0, read);
            }
            String string = response.toString();
            return string;
        }
        finally {
            if (stream != null) {
                stream.close();
            }
        }
    }

    public static String getResponseCharset(String ctype) {
        String charset = DEFAULT_CHARSET;
        if (!StringUtils.isEmpty(ctype)) {
            String[] params;
            for (String param : params = ctype.split(";")) {
                if (!(param = param.trim()).startsWith("charset")) continue;
                String[] pair = param.split("=", 2);
                if (pair.length != 2 || StringUtils.isEmpty(pair[1])) break;
                charset = pair[1].trim();
                break;
            }
        }
        return charset;
    }

    public static String decode(String value, String charset) {
        String result = null;
        if (!StringUtils.isEmpty(value)) {
            try {
                result = URLDecoder.decode(value, charset);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        return result;
    }

    public static String encode(String value, String charset) {
        String result = null;
        if (!StringUtils.isEmpty(value)) {
            try {
                result = URLEncoder.encode(value, charset);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        return result;
    }

    public static Map<String, String> splitUrlQuery(String query) {
        HashMap<String, String> result = new HashMap<String, String>();
        String[] pairs = query.split("&");
        if (pairs != null && pairs.length > 0) {
            for (String pair : pairs) {
                String[] param = pair.split("=", 2);
                if (param == null || param.length != 2) continue;
                result.put(param[0], param[1]);
            }
        }
        return result;
    }

    public static class TrustAllTrustManager
    implements X509TrustManager {
        @Override
        public X509Certificate[] getAcceptedIssuers() {
            return null;
        }

        @Override
        public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        }

        @Override
        public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        }
    }
}

