/*
 * Decompiled with CFR 0.152.
 */
package cn.unitid.cip.sdk.internal.parser.json;

import cn.unitid.cip.sdk.ApiException;
import cn.unitid.cip.sdk.internal.mapping.Converter;
import cn.unitid.cip.sdk.internal.mapping.Converters;
import cn.unitid.cip.sdk.internal.mapping.Reader;
import cn.unitid.cip.sdk.internal.util.json.ExceptionErrorListener;
import cn.unitid.cip.sdk.internal.util.json.JSONReader;
import cn.unitid.cip.sdk.internal.util.json.JSONValidatingReader;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class JsonConverter
implements Converter {
    @Override
    public <T> T toResponse(String rsp, Class<T> clazz) throws ApiException {
        JSONValidatingReader reader = new JSONValidatingReader(new ExceptionErrorListener());
        Object rootObj = ((JSONReader)reader).read(rsp);
        if (rootObj instanceof Map) {
            Map rootJson = (Map)rootObj;
            return this.fromJson(rootJson, clazz);
        }
        return null;
    }

    public <T> T fromJson(final Map<?, ?> json, Class<T> clazz) throws ApiException {
        return Converters.convert(clazz, new Reader(){

            @Override
            public boolean hasReturnField(Object name) {
                return json.containsKey(name);
            }

            @Override
            public Object getPrimitiveObject(Object name) {
                return json.get(name);
            }

            @Override
            public Object getObject(Object name, Class<?> type) throws ApiException {
                Object tmp = json.get(name);
                if (tmp instanceof Map) {
                    Map map = (Map)tmp;
                    return JsonConverter.this.fromJson(map, type);
                }
                return tmp;
            }

            @Override
            public List<?> getListObjects(Object listName, Object itemName, Class<?> subType) throws ApiException {
                ArrayList<Object> listObjs;
                block7: {
                    Object listTmp;
                    block6: {
                        listObjs = null;
                        listTmp = json.get(listName);
                        if (!(listTmp instanceof Map)) break block6;
                        Map jsonMap = (Map)listTmp;
                        Object itemTmp = jsonMap.get(itemName);
                        if (itemTmp == null && listName != null) {
                            String listNameStr = listName.toString();
                            itemTmp = jsonMap.get(listNameStr.substring(0, listNameStr.length() - 1));
                        }
                        if (!(itemTmp instanceof List)) break block7;
                        listObjs = new ArrayList();
                        List tmpList = (List)itemTmp;
                        for (Object subTmp : tmpList) {
                            if (subTmp instanceof Map) {
                                Map subMap = (Map)subTmp;
                                Object subObj = JsonConverter.this.fromJson(subMap, subType);
                                if (subObj == null) continue;
                                listObjs.add(subObj);
                                continue;
                            }
                            if (subTmp instanceof List) continue;
                            listObjs.add(subTmp);
                        }
                        break block7;
                    }
                    if (listTmp instanceof List) {
                        listObjs = new ArrayList<Object>();
                        List jsonList = (List)listTmp;
                        if (jsonList != null && jsonList.size() > 0) {
                            for (Object subTmp : jsonList) {
                                listObjs.add(JsonConverter.this.toObject(subType, subTmp));
                            }
                        }
                    }
                }
                return listObjs;
            }
        });
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Object toObject(Class<?> subType, Object subTmp) throws ApiException {
        Object subObj = null;
        if (subTmp instanceof Map) {
            Map subMap = (Map)subTmp;
            subObj = this.fromJson(subMap, subType);
            if (subObj == null) return subObj == null ? subTmp : subObj;
        }
        if (!(subTmp instanceof List)) return subObj == null ? subTmp : subObj;
        return subObj == null ? subTmp : subObj;
    }
}

